/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.LinkedList;
import java.util.List;

public class ReentrantWriterPriorityReadersWriterLock {
    private static final TraceComponent tc = SibTr.register(ReentrantWriterPriorityReadersWriterLock.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private int nr = 0;
    private int nw = 0;
    private int nrtotal = 0;
    private int nwtotal = 0;
    private List readerThreads = new LinkedList();
    private Thread writerThread = null;

    public synchronized void startReading() throws InterruptedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startReading", this);
        }
        ++this.nrtotal;
        while (this.nwtotal != 0 && this.writerThread != Thread.currentThread()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Have to wait for a writer");
            }
            this.wait();
        }
        ++this.nr;
        this.readerThreads.add(Thread.currentThread());
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startReading");
        }
    }

    public synchronized void startWriting() throws InterruptedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startWriting", this);
        }
        ++this.nwtotal;
        while (this.nw != 0 && this.writerThread != Thread.currentThread() || this.nr > 0 && !this.readerThreads.contains(Thread.currentThread())) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Have to wait for a reader or another writer");
            }
            this.wait();
        }
        this.nw = 1;
        this.writerThread = Thread.currentThread();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startWriting");
        }
    }

    public synchronized void stopReading() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "stopReading", this);
        }
        --this.nr;
        --this.nrtotal;
        this.readerThreads.remove(Thread.currentThread());
        if (this.nr == 0) {
            this.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "stopReading");
        }
    }

    public synchronized void stopWriting() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "stopWriting", this);
        }
        this.nw = 0;
        --this.nwtotal;
        this.writerThread = null;
        this.notifyAll();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "stopWriting");
        }
    }
}

