/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.impl.BufferPoolManagerReference;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.util.Map;

public class JFapDiscriminator
implements Discriminator {
    private static final TraceComponent tc = SibTr.register(JFapDiscriminator.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static byte[] EYECATCHER = new byte[]{-66, -17};
    private Channel channel = null;

    public JFapDiscriminator(Channel channel) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", channel);
        }
        this.channel = channel;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public int discriminate(VirtualConnection virtualConnection, Object object) {
        int n;
        WsByteBuffer[] wsByteBufferArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "discriminate", new Object[]{virtualConnection, object});
        }
        if ((wsByteBufferArray = (WsByteBuffer[])object) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "timeout prior to discrimination.");
            }
            n = -1;
        } else {
            int n2;
            WsByteBuffer wsByteBuffer = null;
            int n3 = 0;
            int n4 = 0;
            switch (wsByteBufferArray.length) {
                case 0: {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "discriminate", "MAYBE");
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit(this, tc, "discriminate");
                    }
                    return -1;
                }
                case 1: {
                    n3 = wsByteBufferArray[0].position();
                    n4 = wsByteBufferArray[0].limit();
                    wsByteBuffer = wsByteBufferArray[0].flip();
                    break;
                }
                default: {
                    int n5;
                    n2 = 0;
                    for (n5 = 0; n5 < wsByteBufferArray.length; ++n5) {
                        n2 += wsByteBufferArray[n5].position();
                    }
                    wsByteBuffer = BufferPoolManagerReference.getInstance().allocate(n2);
                    for (n5 = 0; n5 < wsByteBufferArray.length; ++n5) {
                        n3 = wsByteBufferArray[n5].position();
                        n4 = wsByteBufferArray[n5].limit();
                        wsByteBufferArray[n5].flip();
                        wsByteBuffer.put(wsByteBufferArray[n5]);
                        wsByteBufferArray[n5].position(n3);
                        wsByteBufferArray[n5].limit(n4);
                    }
                    wsByteBuffer.flip();
                }
            }
            if (tc.isDebugEnabled()) {
                JFapUtils.debugTraceWsByteBuffer(this, tc, wsByteBuffer, 32, "Discrimination data");
            }
            if (wsByteBuffer.remaining() < EYECATCHER.length) {
                n = -1;
                n2 = 0;
                while (wsByteBuffer.remaining() > 0 && n == -1) {
                    if (wsByteBuffer.get() != EYECATCHER[n2]) {
                        n = 0;
                    }
                    ++n2;
                }
            } else {
                n = 1;
                for (n2 = 0; n2 < EYECATCHER.length && n == 1; ++n2) {
                    if (wsByteBuffer.get() == EYECATCHER[n2]) continue;
                    n = 0;
                }
            }
            wsByteBuffer.position(n3);
            wsByteBuffer.limit(n4);
        }
        if (tc.isDebugEnabled()) {
            switch (n) {
                case 1: {
                    SibTr.debug(this, tc, "discriminate", "YES");
                    break;
                }
                case 0: {
                    SibTr.debug(this, tc, "discriminate", "NO");
                    break;
                }
                case -1: {
                    SibTr.debug(this, tc, "discriminate", "MAYBE");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "discriminate");
        }
        return n;
    }

    public Class getDiscriminatoryDataType() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getDiscriminatorDataType");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getDiscriminatorDataType");
        }
        return WsByteBuffer.class;
    }

    public Channel getChannel() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getChannel");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getChannel", this.channel);
        }
        return this.channel;
    }

    public Map getProperties() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getProperties");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getProperties");
        }
        return null;
    }

    public int getWeight() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getWeight");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getWeight");
        }
        return 0;
    }

    public void cleanUpState(VirtualConnection virtualConnection) {
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/JFapDiscriminator.java, SIB.comms, WAS602.SIB, o0610.11 1.13");
        }
    }
}

