/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.JFapConnectionBrokenException;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.JFapInboundConnLink;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;

public class InboundConnection
extends Connection {
    private static final TraceComponent tc = SibTr.register(InboundConnection.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private AcceptListener acceptListener = null;

    public InboundConnection(ConnectionLink connectionLink, VirtualConnection virtualConnection, AcceptListener acceptListener, int n, int n2) {
        super(connectionLink, virtualConnection, n, n2);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{connectionLink, virtualConnection, acceptListener, "" + n, "" + n2});
        }
        this.acceptListener = acceptListener;
        TCPConnectionContext tCPConnectionContext = (TCPConnectionContext)connectionLink.getDeviceLink().getChannelAccessor();
        this.description = "IN " + tCPConnectionContext.getLocalAddress().getHostAddress() + ":" + tCPConnectionContext.getLocalPort() + "<-" + tCPConnectionContext.getRemoteAddress().getHostAddress() + ":" + tCPConnectionContext.getRemotePort();
        this.remoteHostAddress = tCPConnectionContext.getRemoteAddress().getHostAddress();
        this.chainName = this.getMetaData().getChainName();
        if (tc.isDebugEnabled()) {
            JFapUtils.debugSummaryMessage(tc, this, null, "New inbound connection established");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    protected ConversationImpl startNewConversation(ConversationImpl conversationImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "startNewServerConversation", conversationImpl);
        }
        ConversationImpl conversationImpl2 = this.startNewConversationGeneric(conversationImpl, false, this.acceptListener);
        this.first = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "startNewServerConversation", conversationImpl2);
        }
        return conversationImpl2;
    }

    public void closeNotification(Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "closeNotification", conversation);
        }
        if (this.conversationTable.contains(conversation.getId())) {
            this.conversationTable.remove(conversation.getId());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "closeNotification");
        }
    }

    public void invalidateImpl(boolean bl, Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "invalidateImpl", new Object[]{"" + bl, throwable});
        }
        if (throwable != null && tc.isEventEnabled()) {
            SibTr.exception(tc, throwable);
        }
        JFapConnectionBrokenException jFapConnectionBrokenException = new JFapConnectionBrokenException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"INBOUNDCONV_INVALIDATE_SICJ0051", null, (String)"INBOUNDCONV_INVALIDATE_SICJ0051"));
        if (throwable != null) {
            jFapConnectionBrokenException.initCause(throwable);
        }
        this.wakeupAllConversationsWithException(jFapConnectionBrokenException, true);
        this.physicalClose(bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "invalidateImpl");
        }
    }

    protected void handshakeComplete() {
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "handshakeComplete invoked on inbound connection");
        }
    }

    protected void handshakeFailed() {
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "handshakeFailed invoked on inbound connection");
        }
    }

    protected Conversation cloneConversation(ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "cloneConnection", conversationReceiveListener);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "attempt to clone inbound conversation!");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "cloneConnection");
        }
        throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"INBOUNDCONV_INTERNAL_SICJ0052", null, (String)"INBOUNDCONV_INTERNAL_SICJ0052"));
    }

    protected ConversationMetaData getMetaData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getMetaData");
        }
        ConversationMetaData conversationMetaData = ((JFapInboundConnLink)this.connChannel).getMetaData();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getMetaData", conversationMetaData);
        }
        return conversationMetaData;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/InboundConnection.java, SIB.comms, WAS602.SIB, o0610.11 1.26");
        }
    }
}

