/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ReceiveListener;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.jfapchannel.impl.WsByteBufferDumpHelper;
import com.ibm.ws.sib.utils.Semaphore;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class ExchangeReceiveListener
implements ReceiveListener {
    private static final TraceComponent tc = SibTr.register(ExchangeReceiveListener.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private ReceivedDataImpl receivedData = null;
    private SIConnectionLostException exception = null;
    private Semaphore semaphore = null;
    private int expectedRequestNumber;

    public ExchangeReceiveListener(int n, Semaphore semaphore) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{"" + n, semaphore});
        }
        this.semaphore = semaphore;
        this.expectedRequestNumber = n;
        this.exception = null;
        this.receivedData = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public void dataReceived(WsByteBuffer wsByteBuffer, int n, int n2, int n3, boolean bl, boolean bl2, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "dataReceived", new Object[]{wsByteBuffer, "" + n, "" + n2, "" + n3, "" + bl, conversation});
        }
        if (tc.isDumpEnabled()) {
            WsByteBufferDumpHelper.dump(wsByteBuffer);
        }
        if (n2 != this.expectedRequestNumber) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "detaReceived", "reqNum != expected");
            }
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"EXCHANGERL_INTERNAL_SICJ0049", null, (String)"EXCHANGERL_INTERNAL_SICJ0049"));
        }
        this.receivedData = new ReceivedDataImpl(wsByteBuffer, n, n2, n3, bl, bl2);
        this.exception = null;
        this.semaphore.post();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "dataReceived");
        }
    }

    public void errorOccurred(SIConnectionLostException sIConnectionLostException, int n, int n2, int n3, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "errorOccurred", new Object[]{sIConnectionLostException, "" + n, "" + n2, "" + n3, conversation});
        }
        if (n2 != this.expectedRequestNumber) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "requestNumber (" + n2 + ") != expectedRequestNumber (" + this.expectedRequestNumber + ")");
            }
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"EXCHANGERL_INTERNAL_SICJ0049", null, (String)"EXCHANGERL_INTERNAL_SICJ0049"));
        }
        this.receivedData = null;
        this.exception = sIConnectionLostException;
        this.semaphore.post();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "errorOccurred");
        }
    }

    public boolean successful() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "successful");
        }
        boolean bl2 = bl = this.exception == null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "successful", "" + bl);
        }
        return bl;
    }

    public ReceivedData getReceivedData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getReceivedData");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getReceivedData", this.receivedData);
        }
        return this.receivedData;
    }

    public SIConnectionLostException getException() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getException");
        }
        if (tc.isEventEnabled() && this.exception != null) {
            SibTr.exception((Object)this, tc, this.exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getException", this.exception);
        }
        return this.exception;
    }

    public void closeRecieved(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "closeRecieved", "" + bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "closeRecieved");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/ExchangeReceiveListener.java, SIB.comms, WAS602.SIB, o0610.11 1.17");
        }
    }

    private class ReceivedDataImpl
    implements ReceivedData {
        private WsByteBuffer data = null;
        int segmentType;
        int requestId;
        int priority;
        boolean allocatedFromBufferPool;
        boolean partOfExchange;

        protected ReceivedDataImpl(WsByteBuffer wsByteBuffer, int n, int n2, int n3, boolean bl, boolean bl2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "ReceivedDataImpl.<init>", new Object[]{wsByteBuffer, "" + n, "" + n2, "" + n3, "" + bl, "" + bl2});
            }
            this.data = wsByteBuffer;
            this.segmentType = n;
            this.requestId = n2;
            this.priority = n3;
            this.allocatedFromBufferPool = bl;
            this.partOfExchange = bl2;
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "ReceivedDataImpl.<init>");
            }
        }

        public WsByteBuffer getBuffer() {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "ReceivedDataImpl.getBuffer");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "ReceivedDataImpl.getBuffer", this.data);
            }
            return this.data;
        }

        public int getSegmentType() {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "ReceivedDataImpl.getSegmentType");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "ReceivedDataImpl.getSegmentType", "" + this.segmentType);
            }
            return this.segmentType;
        }

        public int getRequestId() {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "ReceivedDataImpl.getRequestId");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "ReceivedDataImpl.getRequestId", "" + this.requestId);
            }
            return this.requestId;
        }

        public int getPriority() {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "ReceivedDataImpl.getPriority");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "ReceivedDataImpl.getPriority", "" + this.priority);
            }
            return this.priority;
        }

        public boolean getAllocatedFromBufferPool() {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "ReceivedDataImpl.getAllocatedFromBufferPool");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "ReceivedDataImpl.getAllocatedFromBufferPool", "" + this.allocatedFromBufferPool);
            }
            return this.allocatedFromBufferPool;
        }
    }
}

