/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.IdTableFullException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.Iterator;

public class ConversationTable {
    private static final TraceComponent tc = SibTr.register(ConversationTable.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private HashMap idToConvTable;
    private short lastAllocatedId = 0;
    private Object reservedObject = new Object();

    private void debugTraceTable() {
        Iterator iterator = this.idToConvTable.keySet().iterator();
        SibTr.debug(this, tc, this.getClass().toString() + "@" + this.hashCode());
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            SibTr.debug(this, tc, "[key: " + n + "] -> [value:" + this.idToConvTable.get(n) + "]");
        }
    }

    public ConversationTable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        this.idToConvTable = new HashMap();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public synchronized boolean contains(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "contains", "" + n);
        }
        boolean bl = this.idToConvTable.containsKey(new Integer(n));
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "contains", "" + bl);
        }
        return bl;
    }

    public synchronized void add(ConversationImpl conversationImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "add", conversationImpl);
        }
        if (this.contains(conversationImpl.getId())) {
            if (this.idToConvTable.get(new Integer(conversationImpl.getId())) == this.reservedObject) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "entry present but reserved: " + conversationImpl.getId());
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "table already contains key of " + conversationImpl.getId());
                    this.debugTraceTable();
                }
                throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"CONVERSATIONTABLE_INTERNAL_SICJ0048", null, (String)"CONVERSATIONTABLE_INTERNAL_SICJ0048"));
            }
        }
        this.idToConvTable.put(new Integer(conversationImpl.getId()), conversationImpl);
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "add", "[key: " + conversationImpl.getId() + "] -> [value: " + conversationImpl + "]");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "add");
        }
    }

    public synchronized ConversationImpl get(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "get", "" + n);
        }
        ConversationImpl conversationImpl = (ConversationImpl)this.idToConvTable.get(new Integer(n));
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "get", conversationImpl);
        }
        return conversationImpl;
    }

    public synchronized void remove(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "remove", "" + n);
        }
        if (!this.contains(n)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "table does not contain id " + n);
                this.debugTraceTable();
            }
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"CONVERSATIONTABLE_INTERNAL_SICJ0048", null, (String)"CONVERSATIONTABLE_INTERNAL_SICJ0048"));
        }
        this.idToConvTable.remove(new Integer(n));
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "remove");
        }
    }

    public synchronized Iterator iterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "iterator");
        }
        Iterator iterator = this.idToConvTable.values().iterator();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "iterator", iterator);
        }
        return iterator;
    }

    public synchronized void clear() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "clear");
        }
        this.idToConvTable.clear();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "clear");
        }
    }

    public synchronized int reserveId() throws IdTableFullException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "reserveId");
        }
        boolean bl = false;
        boolean bl2 = false;
        short s = (short)(this.lastAllocatedId + 1);
        while (!bl && !bl2) {
            if (s == 0) {
                s = 1;
            }
            bl2 = s == this.lastAllocatedId;
            bl = !this.contains(s);
            if (bl) continue;
            s = (short)(s + 1);
        }
        if (!bl) {
            throw new IdTableFullException();
        }
        this.idToConvTable.put(new Integer(s), this.reservedObject);
        this.lastAllocatedId = s;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "reserveId", "" + s);
        }
        return s;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/ConversationTable.java, SIB.comms, WAS602.SIB, o0610.11 1.13");
        }
    }
}

