/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.impl.BaseConnectionLink;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.net.InetAddress;

public class ConversationMetaDataImpl
implements ConversationMetaData {
    private static final TraceComponent tc;
    private String chainName;
    private boolean containsSSLChannel;
    private boolean containsHTTPTunnelChannel;
    private boolean isInbound;
    private static Class sslChannelFactoryClass;
    private static Class httptChannelFactoryClass;
    private static Class jfapChannelFactoryClass;
    private static Class tcpProxyChannelFactoryClass;
    private boolean isTrusted = false;
    private BaseConnectionLink baseLink;

    protected ConversationMetaDataImpl(ChainData chainData, BaseConnectionLink baseConnectionLink) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{chainData, baseConnectionLink});
        }
        this.isTrusted = false;
        this.chainName = chainData.getName();
        this.isInbound = chainData.getType() == FlowType.INBOUND;
        this.baseLink = baseConnectionLink;
        ChannelData[] channelDataArray = chainData.getChannelList();
        this.containsSSLChannel = false;
        this.containsHTTPTunnelChannel = false;
        for (int i = 0; i < channelDataArray.length; ++i) {
            if (sslChannelFactoryClass != null) {
                this.containsSSLChannel |= channelDataArray[i].getFactoryType().equals(sslChannelFactoryClass);
            }
            if (httptChannelFactoryClass != null) {
                this.containsHTTPTunnelChannel |= channelDataArray[i].getFactoryType().equals(httptChannelFactoryClass);
            }
            if (tcpProxyChannelFactoryClass == null) continue;
            this.isTrusted |= channelDataArray[i].getFactoryType().equals(tcpProxyChannelFactoryClass);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "chainName=" + this.chainName + "\nisInbound=" + this.isInbound + "\ncontainsSSLChannel=" + this.containsSSLChannel + "\ncontainsHTTPTunnelChannel=" + this.containsHTTPTunnelChannel + "\nisTrusted=" + this.isTrusted);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public String getChainName() {
        return this.chainName;
    }

    public boolean containsSSLChannel() {
        return this.containsSSLChannel;
    }

    public boolean containsHTTPTunnelChannel() {
        return this.containsHTTPTunnelChannel;
    }

    public boolean isInbound() {
        return this.isInbound;
    }

    public boolean isTrusted() {
        return this.isTrusted;
    }

    public InetAddress getRemoteAddress() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getRemoteAddress");
        }
        InetAddress inetAddress = null;
        TCPConnectionContext tCPConnectionContext = null;
        ConnectionLink connectionLink = this.baseLink.getDeviceLink();
        if (connectionLink != null && (tCPConnectionContext = (TCPConnectionContext)connectionLink.getChannelAccessor()) != null) {
            inetAddress = tCPConnectionContext.getRemoteAddress();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getRemoteAddress", inetAddress);
        }
        return inetAddress;
    }

    static {
        block16: {
            block15: {
                block14: {
                    block13: {
                        tc = SibTr.register(ConversationMetaData.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/ConversationMetaDataImpl.java, SIB.comms, WAS602.SIB, o0610.11 1.9");
                        }
                        try {
                            sslChannelFactoryClass = Class.forName("com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(tc, "Could not find SSL Channel class");
                            }
                            if (!tc.isEventEnabled()) break block13;
                            SibTr.exception(tc, classNotFoundException);
                        }
                    }
                    try {
                        httptChannelFactoryClass = Class.forName("com.ibm.ws.httptunnel.channel.WSHttpTunnelOutboundChannelFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Could not find HTTP Tunnel Channel class");
                        }
                        if (!tc.isEventEnabled()) break block14;
                        SibTr.exception(tc, classNotFoundException);
                    }
                }
                try {
                    tcpProxyChannelFactoryClass = Class.forName("com.ibm.ws.tcpchannelproxy.jfap.impl.TCPProxyChannelFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Could not find TCP Proxy Bridge Service Channel class");
                    }
                    if (!tc.isEventEnabled()) break block15;
                    SibTr.exception(tc, classNotFoundException);
                }
            }
            try {
                jfapChannelFactoryClass = Class.forName("com.ibm.ws.sib.jfapchannel.impl.WSJFapChannelFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Could not find JFAP Channel class");
                }
                if (!tc.isEventEnabled()) break block16;
                SibTr.exception(tc, classNotFoundException);
            }
        }
    }
}

