/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.CapacityListener;
import com.ibm.ws.sib.jfapchannel.ConnectionClosedListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.DispatchQueue;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.NoCapacityException;
import com.ibm.ws.sib.jfapchannel.ReceiveListener;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.jfapchannel.impl.BufferPoolManagerReference;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ExchangeReceiveListener;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.jfapchannel.impl.RequestIdTable;
import com.ibm.ws.sib.jfapchannel.impl.WsByteBufferDumpHelper;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.AbstractInvocation;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDispatcher;
import com.ibm.ws.sib.utils.Semaphore;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConversationImpl
implements Conversation,
Dispatchable {
    private static final TraceComponent tc = SibTr.register(ConversationImpl.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private short id = 0;
    private boolean first = false;
    private Connection connection = null;
    private RequestIdTable reqIdTable = null;
    private Object attachment = null;
    private ConversationReceiveListener defaultReceiveListener = null;
    private CapacityListener registeredCapListener = null;
    private Object defaultReceiveListenerLock = new Object();
    private Semaphore waitForDefaultReceiveListenerSemaphore = new Semaphore();
    private static int instanceCounter = 0;
    private int thisInstanceCounter = 0;
    private Object dispatchLockObject = new Object();
    private DispatchQueue dispatchQueue = null;
    private int dispatchQueueReferenceCount = 0;
    private boolean onClientSide = false;
    private int totalOutstandingRequests = 0;
    private Object totalOutstandingRequestsLock = new Object();
    private AbstractInvocation errorOccurredInvocation = null;
    protected String description = "";
    private Object sendMonitor = new Object();
    private boolean inSend = false;
    private boolean invalidateOutstanding = false;
    private Throwable invalidateOutstandingThrowable = null;
    private static final StateEnum OPEN = new StateEnum("open");
    private static final StateEnum NOTIFY_PEER = new StateEnum("notify peer");
    private static final StateEnum AWAITING_PEER1 = new StateEnum("awaiting peer 1");
    private static final StateEnum PARALLEL_CLOSE1 = new StateEnum("parallel close 1");
    private static final StateEnum AWAITING_PEER2 = new StateEnum("awaiting peer 2");
    private static final StateEnum PARALLEL_CLOSE2 = new StateEnum("parallel close 2");
    private static final StateEnum AWAITING_PEER3 = new StateEnum("awaiting peer 3");
    private static final StateEnum CLOSED = new StateEnum("closed");
    private final Object stateChangeMonitor = new Object();
    private StateEnum state = OPEN;
    private EventRecorder eventRecorder = new EventRecorder();

    public String toString() {
        return this.getClass() + "@" + this.hashCode() + " id: " + this.id + " first: " + this.first + " " + this.state + " connection: " + this.connection;
    }

    protected ConversationImpl(short s, boolean bl, Connection connection, ConversationReceiveListener conversationReceiveListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{"" + s, "" + bl, connection, conversationReceiveListener});
        }
        this.id = s;
        this.first = bl;
        this.connection = connection;
        this.reqIdTable = new RequestIdTable();
        this.defaultReceiveListener = conversationReceiveListener;
        this.thisInstanceCounter = instanceCounter++;
        if (instanceCounter < 0) {
            instanceCounter = 0;
        }
        this.description = "ConvId:" + s;
        if (tc.isDebugEnabled()) {
            JFapUtils.debugSummaryMessage(tc, connection, this, "New conversation started");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public void setDefaultRecevieListner(ConversationReceiveListener conversationReceiveListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setDefaultRecevieListner", conversationReceiveListener);
        }
        this.defaultReceiveListener = conversationReceiveListener;
        this.waitForDefaultReceiveListenerSemaphore.post();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setDefaultReceiveListener");
        }
    }

    protected RequestIdTable getRequestIdTable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getRequestIdTable");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getRequestIdTable", this.reqIdTable);
        }
        return this.reqIdTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationReceiveListener getDefaultReceiveListener() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getDefaultReceiveListener");
        }
        Object object = this.defaultReceiveListenerLock;
        synchronized (object) {
            if (this.defaultReceiveListener == null) {
                this.waitForDefaultReceiveListenerSemaphore.waitOnIgnoringInterruptions();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getDefaultReceiveListener", this.defaultReceiveListener);
        }
        return this.defaultReceiveListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SIConnectionLostException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "close");
        }
        this.eventRecorder.logEntry("close");
        boolean bl = false;
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            if (this.state == OPEN) {
                bl = true;
                this.state = NOTIFY_PEER;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "state transition: open -> notify peer");
                }
                this.eventRecorder.logDebug("state transition: open -> notify peer");
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "close invoked in state " + this.state + " - ignoring");
                }
                this.eventRecorder.logDebug("close invoked in state " + this.state + " - ignoring");
            }
        }
        if (bl) {
            if (this.registeredCapListener != null) {
                this.connection.removeCapacityListener(this.registeredCapListener);
                this.registeredCapListener = null;
            }
            this.sendLogicalClose(true);
        }
        this.eventRecorder.logExit("close");
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "invalidate", throwable);
        }
        this.eventRecorder.logEntry("invalidate");
        Object object = this.sendMonitor;
        synchronized (object) {
            if (this.inSend) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "send currently in progress - delaying");
                }
                this.eventRecorder.logDebug("send in progress - delaying invalidation");
                this.invalidateOutstanding = true;
                this.invalidateOutstandingThrowable = throwable;
            } else {
                boolean bl = false;
                Object object2 = this.stateChangeMonitor;
                synchronized (object2) {
                    if (this.state != CLOSED) {
                        if (tc.isDebugEnabled()) {
                            JFapUtils.debugSummaryMessage(tc, this.connection, this, "Conversation invalidated!");
                        }
                        this.eventRecorder.logDebug("conversation invalidated!");
                        if (this.registeredCapListener != null) {
                            this.connection.removeCapacityListener(this.registeredCapListener);
                            this.registeredCapListener = null;
                        }
                        this.connection.removeConversationById(this.id);
                    }
                    bl = true;
                    this.state = CLOSED;
                }
                if (bl) {
                    object2 = null;
                    object2 = throwable instanceof SIConnectionLostException ? (SIConnectionLostException)throwable : new SIConnectionLostException(nls.getFormattedMessage("CONVERSATIONIMPL_INVALIDATE_SICJ0045", null, "CONVERSATIONIMPL_INVALIDATE_SICJ0045"), throwable);
                    this.wakeupAllWithException((SIConnectionLostException)object2, true);
                }
            }
        }
        this.eventRecorder.logExit("invalidate");
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "invalidate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLogicalCloseRequest() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "processLogicalCloseRequest");
        }
        this.eventRecorder.logEntry("processLogicalCloseRequest");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            if (this.state == OPEN) {
                this.state = CLOSED;
                bl2 = true;
                bl3 = true;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "state transition: open -> closed");
                }
                this.eventRecorder.logDebug("state transition: open -> closed");
            } else if (this.state == NOTIFY_PEER) {
                this.state = AWAITING_PEER2;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "state transition: notify peer -> awaiting peer 2");
                }
                this.eventRecorder.logDebug("state transition: notify peer -> awaiting peer 2");
            } else if (this.state == AWAITING_PEER1) {
                this.state = PARALLEL_CLOSE1;
                bl2 = true;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "state transition: awaiting peer 1 -> parallel close 1");
                }
                this.eventRecorder.logDebug("state transition: awaiting peer 1 -> parallel close 1");
            } else {
                SibTr.debug(this, tc, "Invalid state transition.  Received processLogicalClose whilst in state " + this.state);
                this.eventRecorder.logError("invalid state transition.  state=" + this.state + " transition=logical close request");
                FFDCFilter.processException((Throwable)new Exception(), (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070012", (Object[])new Object[]{this.state, this.eventRecorder.toString()});
                bl = true;
            }
        }
        if (bl2) {
            this.sendLogicalClose(false);
        }
        if (bl3) {
            this.wakeupAllWithException(new SIConnectionLostException("Connection lost after peer responded to a logical close request before all conversations were closed"), false);
            if (tc.isDebugEnabled()) {
                JFapUtils.debugSummaryMessage(tc, this.connection, this, "Conversation closed (processLogicalCloseResponse)");
            }
            this.connection.removeConversationById(this.id);
            this.connection.closeNotification(this);
        }
        if (bl) {
            this.connection.invalidate(false, new SIConnectionLostException("Connection closed as part of processing a logical close request"), "error during logical close");
        }
        this.eventRecorder.logExit("processLogicalCloseRequest");
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "processLogicalCloseRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLogicalCloseResponse() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "processLogicalCloseResponse");
        }
        this.eventRecorder.logEntry("processLogicalCloseResponse");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            if (this.state == AWAITING_PEER2) {
                this.state = PARALLEL_CLOSE2;
                bl3 = true;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "state transition: awaiting peer 2 -> parallel close 2");
                }
                this.eventRecorder.logDebug("state transition: awaiting peer 2 -> parallel close 2");
            } else if (this.state == PARALLEL_CLOSE1) {
                bl = true;
                if (tc.isDebugEnabled()) {
                    JFapUtils.debugSummaryMessage(tc, this.connection, this, "Conversation closed (processLogicalCloseResponse)");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "state transition: parallel close 1 -> closed");
                }
                this.eventRecorder.logDebug("state transition: parallel close 1 -> closed");
                this.connection.removeConversationById(this.id);
                this.state = CLOSED;
                this.connection.closeNotification(this);
            } else if (this.state == NOTIFY_PEER) {
                this.state = AWAITING_PEER3;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "state transition: notify peer -> awaiting peer 3");
                }
                this.eventRecorder.logDebug("state transition: notify peer -> awaiting peer 3");
            } else if (this.state == AWAITING_PEER1) {
                bl = true;
                if (tc.isDebugEnabled()) {
                    JFapUtils.debugSummaryMessage(tc, this.connection, this, "Conversation closed (processLogicalCloseResponse)");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "state transition: awaiting peer 1 -> closed");
                }
                this.eventRecorder.logDebug("state transition: awaiting peer 1 -> closed");
                this.connection.removeConversationById(this.id);
                this.state = CLOSED;
                this.connection.closeNotification(this);
            } else {
                bl2 = true;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "processLogicalCloseResponse invoked when in state: " + this.state);
                }
                this.eventRecorder.logError("invalid state transition.  state=" + this.state + " transition=logical close response");
                FFDCFilter.processException((Throwable)new Exception(), (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070013", (Object[])new Object[]{this.state, this.eventRecorder.toString()});
            }
        }
        if (bl3) {
            this.sendLogicalClose(false);
        }
        if (bl) {
            this.wakeupAllWithException(new SIConnectionLostException("Connection lost after peer responded to a logical close request before all conversations were closed"), false);
        }
        if (bl2) {
            this.connection.invalidate(false, new SIConnectionLostException("Connection invalidated after peer responded to a logical close request " + this.state), "received unexpected logical close response");
        }
        this.eventRecorder.logExit("processLogicalCloseResponse");
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "processLogicalCloseResponse");
        }
    }

    private void sendLogicalClose(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "sendLogicalClose", "" + bl);
        }
        this.eventRecorder.logEntry("sendLogicalClose");
        WsByteBuffer wsByteBuffer = BufferPoolManagerReference.getInstance().allocate(1);
        if (bl) {
            wsByteBuffer.put((byte)0);
        } else {
            wsByteBuffer.put((byte)1);
        }
        wsByteBuffer.flip();
        ArrayList<WsByteBuffer> arrayList = new ArrayList<WsByteBuffer>(1);
        arrayList.add(wsByteBuffer);
        LogicalCloseSendListener logicalCloseSendListener = null;
        if (bl) {
            logicalCloseSendListener = new LogicalCloseSendListener();
            this.eventRecorder.logDebug("LogicalCloseSendListener hashcode: " + Integer.toHexString(System.identityHashCode(logicalCloseSendListener)));
        }
        try {
            this.connection.send(arrayList, 10, this.id, 0, -1, true, false, null, logicalCloseSendListener, this, false, false);
        }
        catch (NoCapacityException noCapacityException) {
            FFDCFilter.processException((Throwable)noCapacityException, (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070002", (Object)this.eventRecorder.toString());
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, noCapacityException);
            }
            this.connection.invalidate(false, noCapacityException, "NoCapacityException thrown from system send");
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070001", (Object)this.eventRecorder.toString());
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, sIException);
            }
            this.connection.invalidate(false, sIException, "SIException thrown from system send");
        }
        this.eventRecorder.logExit("sendLogicalClose");
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "sendLogicalClose");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCompletes() {
        if (tc.isDebugEnabled()) {
            SibTr.entry(this, tc, "sendCompletes");
        }
        boolean bl = false;
        boolean bl2 = false;
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            if (this.state == NOTIFY_PEER) {
                this.state = AWAITING_PEER1;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "state transition: notify peer -> awaiting peer 1");
                }
                this.eventRecorder.logDebug("state transition: notify peer -> awaiting peer 1");
            } else if (this.state == AWAITING_PEER2) {
                this.state = PARALLEL_CLOSE1;
                bl = true;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "state transition: awaiting peer 2 -> parallel close 1");
                }
                this.eventRecorder.logDebug("state transition: awaiting peer 2 -> parallel close 1");
            } else if (this.state == PARALLEL_CLOSE2) {
                bl2 = true;
                if (tc.isDebugEnabled()) {
                    JFapUtils.debugSummaryMessage(tc, this.connection, this, "Conversation closed (processLogicalCloseResponse)");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "state transition: parallel close 2 -> closed");
                }
                this.eventRecorder.logDebug("state transition: parallel close 2 -> closed");
                this.connection.removeConversationById(this.id);
                this.state = CLOSED;
                this.connection.closeNotification(this);
            } else if (this.state == AWAITING_PEER3) {
                bl2 = true;
                if (tc.isDebugEnabled()) {
                    JFapUtils.debugSummaryMessage(tc, this.connection, this, "Conversation closed (processLogicalCloseResponse)");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "state transition: awaiting peer 3 -> closed");
                }
                this.eventRecorder.logDebug("state transition: awaiting peer 3 -> closed");
                this.connection.removeConversationById(this.id);
                this.state = CLOSED;
                this.connection.closeNotification(this);
            } else {
                this.eventRecorder.logError("invalid state transition.  state=" + this.state + " transition=sendCompletes");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Invalid state transition.  State=" + this.state + ".  Transition=sendCompletes");
                }
                FFDCFilter.processException((Throwable)new Exception(), (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"NEW_FFDC_PROBE_NEEDED_03", (Object[])new Object[]{this.state, this.eventRecorder.toString()});
            }
        }
        if (bl) {
            this.sendLogicalClose(false);
        }
        if (bl2) {
            this.wakeupAllWithException(new SIConnectionLostException("Peer initiated connection close while conversations still active"), false);
        }
        if (tc.isDebugEnabled()) {
            SibTr.exit(this, tc, "sendCompletes");
        }
    }

    private void removeCapacityListener() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "removeCapacityListener");
        }
        if (this.registeredCapListener != null) {
            this.connection.removeCapacityListener(this.registeredCapListener);
        }
        this.registeredCapListener = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "removeCapacityListener");
        }
    }

    protected void wakeupAllWithException(SIConnectionLostException sIConnectionLostException, boolean bl) {
        block18: {
            Object object;
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "wakeupAllWithException", new Object[]{sIConnectionLostException, "" + bl});
            }
            boolean bl2 = false;
            Iterator iterator = this.reqIdTable.idIterator();
            while (iterator.hasNext()) {
                SendListener sendListener;
                block17: {
                    object = (Integer)iterator.next();
                    ReceiveListener receiveListener = this.reqIdTable.getListener((Integer)object);
                    if (receiveListener != null) {
                        bl2 = true;
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "waking " + receiveListener);
                        }
                        try {
                            ReceiveListenerDispatcher.getInstance(this.connection.getConversationType(), this.onClientSide).queueErrorOccurredInvocation(this.connection, receiveListener, sIConnectionLostException, -1, ((Integer)object).intValue(), -1, (Conversation)this);
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070003", (Object[])new Object[]{this.state, this.eventRecorder.toString()});
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(this, tc, "exception thrown in receive listener error occurred method");
                            }
                            if (!tc.isEventEnabled()) break block17;
                            SibTr.exception((Object)this, tc, throwable);
                        }
                    }
                }
                if ((sendListener = this.reqIdTable.getSendListener((Integer)object)) == null) continue;
                bl2 = true;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "waking " + sendListener);
                }
                try {
                    sendListener.errorOccurred(sIConnectionLostException, this);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070003", (Object)this.eventRecorder.toString());
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "exception thrown in send listener error occurred method");
                    }
                    if (!tc.isEventEnabled()) continue;
                    SibTr.exception((Object)this, tc, throwable);
                }
            }
            this.reqIdTable.clear();
            if (bl2 || bl) {
                object = this.getDefaultReceiveListener();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "notifying conversation receive listener " + object);
                }
                try {
                    ReceiveListenerDispatcher.getInstance(this.connection.getConversationType(), this.onClientSide).queueErrorOccurredInvocation(this.connection, (ConversationReceiveListener)object, sIConnectionLostException, -1, -1, -1, (Conversation)this);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070003", (Object)this.eventRecorder.toString());
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "exception thrown in connection receive listener error occurred method");
                    }
                    if (!tc.isEventEnabled()) break block18;
                    SibTr.exception((Object)this, tc, throwable);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "wakeupAllWithException");
        }
    }

    public ReceivedData exchange(List list, int n, int n2, int n3, boolean bl) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "exchange", new Object[]{list, "" + n, "" + n2, "" + n3, "" + bl});
        }
        if (this.getDefaultReceiveListener() == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "exchange", "conversation disabled");
            }
            throw new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
        }
        Semaphore semaphore = new Semaphore();
        ExchangeReceiveListener exchangeReceiveListener = new ExchangeReceiveListener(n2, semaphore);
        this.send(list, n, n2, n3, bl, true, exchangeReceiveListener, null);
        semaphore.waitOnIgnoringInterruptions();
        if (!exchangeReceiveListener.successful()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "exchange", "operation unsuccessful");
            }
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, exchangeReceiveListener.getException());
            }
            throw exchangeReceiveListener.getException();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "exchange", exchangeReceiveListener.getReceivedData());
        }
        return exchangeReceiveListener.getReceivedData();
    }

    public synchronized long send(List list, int n, int n2, int n3, boolean bl, ReceiveListener receiveListener, SendListener sendListener) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "send", new Object[]{list, "" + n, "" + n2, "" + n3, "" + bl, receiveListener, sendListener});
        }
        long l = 0L;
        l = this.send(list, n, n2, n3, bl, false, receiveListener, sendListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "send", "" + l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long send(List list, int n, int n2, int n3, boolean bl, boolean bl2, ReceiveListener receiveListener, SendListener sendListener) throws SIConnectionDroppedException, SIConnectionLostException, NoCapacityException {
        Object object;
        long l;
        Iterator iterator;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "send");
        }
        if (tc.isDumpEnabled()) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                WsByteBufferDumpHelper.dump((WsByteBuffer)iterator.next());
            }
        } else if (tc.isDebugEnabled()) {
            iterator = list.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                JFapUtils.debugTraceWsByteBuffer(this, tc, (WsByteBuffer)iterator.next(), 16, "send buffer" + n4);
                ++n4;
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "send", "segment type:" + n + " request num:" + n2 + " segment priority:" + n3 + " receive listener:" + receiveListener + " send listener:" + sendListener);
        }
        if (this.getDefaultReceiveListener() == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "send", "conversation disabled");
            }
            throw new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
        }
        if (this.reqIdTable.containsId(n2)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "send", "duplicate request");
            }
            throw new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
        }
        if (n2 == 0 && receiveListener != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "send", "reqid == 0 && recvListener != null");
            }
            throw new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
        }
        Object object2 = this.sendMonitor;
        synchronized (object2) {
            Object object3 = this.stateChangeMonitor;
            synchronized (object3) {
                if (this.state != OPEN) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "send", "connection closed");
                    }
                    throw new SIConnectionDroppedException(nls.getFormattedMessage("CONVERSATIONIMPL_CLOSED_SICJ0047", null, "CONVERSATIONIMPL_CLOSED_SICJ0047"));
                }
                this.inSend = true;
            }
        }
        try {
            if (n2 != 0 && receiveListener != null) {
                this.reqIdTable.add(n2, receiveListener, sendListener);
            }
            l = this.connection.send(list, n, this.id, n2, n3, bl, bl2, receiveListener, sendListener, this, true, false);
            Object var16_16 = null;
            object = this.sendMonitor;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            Object object4 = this.sendMonitor;
            synchronized (object4) {
                this.inSend = false;
                if (this.invalidateOutstanding) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "invalidate delayed - performing now");
                    }
                    this.eventRecorder.logDebug("performing delayed invalidation");
                    this.invalidateOutstanding = false;
                    this.invalidate(this.invalidateOutstandingThrowable);
                    this.invalidateOutstandingThrowable = null;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            this.inSend = false;
            if (this.invalidateOutstanding) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "invalidate delayed - performing now");
                }
                this.eventRecorder.logDebug("performing delayed invalidation");
                this.invalidateOutstanding = false;
                this.invalidate(this.invalidateOutstandingThrowable);
                this.invalidateOutstandingThrowable = null;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "send", "" + l);
        }
        return l;
    }

    public boolean isFirst() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "isFirst");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "isFirst", "" + this.first);
        }
        return this.first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshakeComplete() throws SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "handshakeComplete");
        }
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            if (this.state != OPEN) {
                throw new SIConnectionDroppedException(nls.getFormattedMessage("CONVERSATIONIMPL_CLOSED_SICJ0047", null, "CONVERSATIONIMPL_CLOSED_SICJ0047"));
            }
            this.connection.handshakeComplete();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "handshakeComplete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshakeFailed() throws SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "handshakeFailed");
        }
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            if (this.state != OPEN) {
                throw new SIConnectionDroppedException(nls.getFormattedMessage("CONVERSATIONIMPL_CLOSED_SICJ0047", null, "CONVERSATIONIMPL_CLOSED_SICJ0047"));
            }
            this.connection.handshakeFailed();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "handshakeFailed");
        }
    }

    public int getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getId");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getId", "" + this.id);
        }
        return this.id;
    }

    public void setAttachment(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setAttachment", object);
        }
        this.attachment = object;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setAttachment");
        }
    }

    public Object getAttachment() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getAttachment");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getAttachment", this.attachment);
        }
        return this.attachment;
    }

    public void setLinkLevelAttachment(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setLinkLevelAttachment", object);
        }
        this.connection.setAttachment(object);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setLinkLevelAttachment");
        }
    }

    public Object getLinkLevelAttachment() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getLinkLevelAttachment");
        }
        Object object = this.connection.getAttachment();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getLinkLevelAttachment", object);
        }
        return object;
    }

    public boolean sharesSameLinkAs(Conversation conversation) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "sharesSameLinkAs", conversation);
        }
        boolean bl2 = bl = ((ConversationImpl)conversation).connection == this.connection;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "sharesSameLinkAs", "" + bl);
        }
        return bl;
    }

    public Conversation cloneConversation(ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "cloneConversation", conversationReceiveListener);
        }
        Conversation conversation = this.connection.cloneConversation(conversationReceiveListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "cloneConversation", conversation);
        }
        return conversation;
    }

    public boolean hasCapacity(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "hasCapacity", "" + n);
        }
        boolean bl = true;
        if (this.registeredCapListener != null) {
            bl = this.connection.hasCapacity(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "hasCapacity", "" + bl);
        }
        return bl;
    }

    public synchronized void setCapacityListener(CapacityListener capacityListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setCapacityListener", capacityListener);
        }
        if (this.registeredCapListener != null) {
            this.connection.removeCapacityListener(this.registeredCapListener);
        }
        this.registeredCapListener = capacityListener;
        if (this.registeredCapListener != null) {
            this.connection.addCapacityListener(this.registeredCapListener);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setCapacityListener");
        }
    }

    public Conversation[] getConversationsSharingSameLink() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getConversationsSharingSameLink");
        }
        Conversation[] conversationArray = this.connection.getConversations();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getConversationsSharingSameLink", conversationArray);
        }
        return conversationArray;
    }

    protected byte getNextRequestNumber() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getNextRequestNumber");
        }
        byte by = this.connection.getNextRequestNumber();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getNextRequestNumber", "" + by);
        }
        return by;
    }

    protected boolean hasOutstandingRequests() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "hasOutstandingRequests");
        }
        boolean bl = this.reqIdTable.hasReceiveListeners();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "hasOutstandingRequests", "" + bl);
        }
        return bl;
    }

    public void setHeartbeatInterval(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setHeartbeatInterval", "" + n);
        }
        if (n < 1) {
            throw new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
        }
        this.connection.setHeartbeatInterval(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setHeartbeatInterval");
        }
    }

    public int getHeartbeatInterval() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getHeartbeatInterval");
        }
        int n = this.connection.getHeartbeatInterval();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getHeartbeatInterval", "" + n);
        }
        return n;
    }

    public void setHeartbeatTimeout(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setHeartbeatTimeout", "" + n);
        }
        if (n < 1) {
            throw new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
        }
        this.connection.setHeartbeatTimeout(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setHeartbeatTimeout");
        }
    }

    public int getHeartbeatTimeout() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getHeartbeatTimeout");
        }
        int n = this.connection.getHeartbeatTimeout();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getHeartbeatTimeout", "" + n);
        }
        return n;
    }

    public Object getDispatchLockObject() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getDispatchLockObject");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getDispatchLockObject", this.dispatchLockObject);
        }
        return this.dispatchLockObject;
    }

    public void decrementDispatchQueueRefCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "decrementDispatchQueueRefCount");
        }
        --this.dispatchQueueReferenceCount;
        if (this.dispatchQueueReferenceCount < 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "dispatchQueueReferneceCount=" + this.dispatchQueueReferenceCount);
            }
            throw new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "decrementDispatchQueueRefCount", "" + this.dispatchQueueReferenceCount);
        }
    }

    public int getDispatchQueueRefCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getDispatchQueueRefCount");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getDispatchQueueRefCount", "" + this.dispatchQueueReferenceCount);
        }
        return this.dispatchQueueReferenceCount;
    }

    public void setDispatchQueue(DispatchQueue dispatchQueue) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setDispatchQueue", dispatchQueue);
        }
        this.dispatchQueue = dispatchQueue;
        this.dispatchQueueReferenceCount = 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setDispatchQueue");
        }
    }

    public DispatchQueue getDispatchQueue() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getDispatchQueue");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getDispatchQueue", this.dispatchQueue);
        }
        return this.dispatchQueue;
    }

    public void incrementDispatchQueueRefCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "decrementDispatchQueueRefCount");
        }
        ++this.dispatchQueueReferenceCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "decrementDispatchQueueRefCount", "" + this.dispatchQueueReferenceCount);
        }
    }

    public int getInstanceCounterValue() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getInstanceCounterValue");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getInstanceCounterValue", "" + this.thisInstanceCounter);
        }
        return this.thisInstanceCounter;
    }

    protected void processLogicalClose(WsByteBuffer wsByteBuffer) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "_processLogicalClose");
        }
        wsByteBuffer.flip();
        byte by = wsByteBuffer.get();
        boolean bl2 = bl = (by & 1) != 0;
        if ((by & 0xFE) != 0 && tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Bad flags", "" + by);
        }
        if (bl) {
            this.processLogicalCloseResponse();
        } else {
            this.processLogicalCloseRequest();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "_processLogicalClose");
        }
    }

    protected void processPing(int n, int n2, WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "processPing", wsByteBuffer);
        }
        long l = wsByteBuffer.getLong();
        int n3 = wsByteBuffer.getInt();
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "ping time=" + l + " ping length=" + n3);
        }
        int n4 = wsByteBuffer.limit();
        wsByteBuffer.limit(wsByteBuffer.position() + n3);
        wsByteBuffer.position(wsByteBuffer.position() - 12);
        ArrayList<WsByteBuffer> arrayList = new ArrayList<WsByteBuffer>(1);
        arrayList.add(wsByteBuffer);
        try {
            this.connection.send(arrayList, 15, this.id, n, n2, true, false, null, null, this, false, true);
        }
        catch (NoCapacityException noCapacityException) {
            FFDCFilter.processException((Throwable)noCapacityException, (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070010", (Object)this.eventRecorder.toString());
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, noCapacityException);
            }
            this.connection.invalidate(true, noCapacityException, "NoCapacityException from system send");
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070010", (Object)this.eventRecorder.toString());
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, sIException);
            }
            this.connection.invalidate(true, sIException, "SIException thrown from system send");
        }
        wsByteBuffer.limit(n4);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "processPing");
        }
    }

    protected void processPingResponse(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "processPingResponse");
        }
        if (tc.isDebugEnabled()) {
            long l = System.currentTimeMillis();
            long l2 = wsByteBuffer.getLong();
            int n = wsByteBuffer.getInt();
            StringBuffer stringBuffer = new StringBuffer("receieved ping response - which should not have originated from me:\n");
            stringBuffer.append("ping time: ");
            stringBuffer.append(l2);
            stringBuffer.append("\nping data length: ");
            stringBuffer.append(n);
            if (l > l2) {
                stringBuffer.append("\nround trip time: ");
                stringBuffer.append(l - l2);
            } else {
                stringBuffer.append("\nping time incorrect, current system time is: ");
                stringBuffer.append(l);
            }
            stringBuffer.append("\ndump of ping data follows:");
            SibTr.debug(this, tc, stringBuffer.toString());
            JFapUtils.debugTraceWsByteBuffer(this, tc, wsByteBuffer, n, "Ping data");
        }
        wsByteBuffer.release();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "processPingResponse");
        }
    }

    public void setMaxTransmissionSize(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setMaxTransmissionSize", "" + n);
        }
        this.connection.setMaxTransmissionSize(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setMaxTransmissionSize");
        }
    }

    public int getMaxTransmissionSize() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getMaxTransmissionSize");
        }
        int n = this.connection.getMaxTransmissionSize();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getMaxTransmissionSize", "" + n);
        }
        return n;
    }

    public void setOnClientSide() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setOnClientSide");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setOnClientSide");
        }
        this.onClientSide = true;
    }

    public boolean isOnClientSide() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "isOnClientSide");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "isOnClientSide", "" + this.onClientSide);
        }
        return this.onClientSide;
    }

    public Object getTotalOutstandingRequestCountLock() {
        return this.totalOutstandingRequestsLock;
    }

    public int getTotalOutstandingRequestCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getTotalOutstandingRequestCount");
            SibTr.exit(this, tc, "getTotalOutstandingRequestCount", "" + this.totalOutstandingRequests);
        }
        return this.totalOutstandingRequests;
    }

    public void incrementTotalOutstandingCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "incrementTotalOutstandingRequestCount");
        }
        ++this.totalOutstandingRequests;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "incrementTotalOutstandingRequestCount", "" + this.totalOutstandingRequests);
        }
    }

    public void decrementTotalOutstandingCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "decrementTotalOutstandingRequestCount");
        }
        --this.totalOutstandingRequests;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "decrementTotalOutstandingRequestCount", "" + this.totalOutstandingRequests);
        }
    }

    public void setErrorOccurredInvocation(AbstractInvocation abstractInvocation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setErrorOccurredInvocation", abstractInvocation);
        }
        if (this.errorOccurredInvocation == null) {
            this.errorOccurredInvocation = abstractInvocation;
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Already received an errorOccurred", abstractInvocation);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setErrorOccurredInvocation");
        }
    }

    public AbstractInvocation getErrorOccurredInvocation() {
        return this.errorOccurredInvocation;
    }

    public ConversationMetaData getMetaData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getMetaData");
        }
        ConversationMetaData conversationMetaData = this.connection.getMetaData();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getMetaData", conversationMetaData);
        }
        return conversationMetaData;
    }

    public void setConversationType(Conversation.ConversationType conversationType) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setConversationType", conversationType);
        }
        this.connection.setConversationType(conversationType);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setConversationType");
        }
    }

    public Conversation.ConversationType getConversationType() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setConversationType");
        }
        Conversation.ConversationType conversationType = this.connection.getConversationType();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setConversationType", conversationType);
        }
        return conversationType;
    }

    public boolean isClosed() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "isClosed");
        }
        boolean bl2 = bl = this.state != OPEN;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "isClosed", "" + bl);
        }
        return bl;
    }

    public void setConnectionClosedListener(ConnectionClosedListener connectionClosedListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setConnectionClosedListener", connectionClosedListener);
        }
        this.connection.setConnectionClosedListener(connectionClosedListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setConnectionClosedListener");
        }
    }

    public int getLowestPriorityWithCapacity() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getLowesPriorityWithCapacity");
        }
        int n = this.connection.getLowestPriorityWithCapacity();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getLowesPriorityWithCapacity", "" + n);
        }
        return n;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/ConversationImpl.java, SIB.comms, WAS602.SIB, o0610.11 1.57.1.1");
        }
    }

    private class EventRecorder {
        private int maxEvents;
        private Event[] events;
        private int currentEvent = 0;
        private int recordedEvents = 0;
        private boolean errorTrappedInRecorder = false;

        public EventRecorder() {
            this(100);
        }

        public EventRecorder(int n) {
            this.maxEvents = n;
            this.events = new Event[n];
        }

        private void fillInNextEvent(char c, String string) {
            try {
                Event event;
                if (this.recordedEvents < this.maxEvents) {
                    if (this.events[this.currentEvent] == null) {
                        this.events[this.currentEvent] = new Event();
                    }
                    event = this.events[this.currentEvent];
                    this.currentEvent = (this.currentEvent + 1) % this.maxEvents;
                    ++this.recordedEvents;
                } else {
                    event = this.events[this.currentEvent];
                    this.currentEvent = (this.currentEvent + 1) % this.maxEvents;
                }
                event.event = string;
                event.threadHashcode = System.identityHashCode(Thread.currentThread());
                event.type = c;
            }
            catch (Throwable throwable) {
                this.errorTrappedInRecorder = true;
            }
        }

        public synchronized void logEntry(String string) {
            this.fillInNextEvent('>', string);
        }

        public synchronized void logExit(String string) {
            this.fillInNextEvent('<', string);
        }

        public synchronized void logDebug(String string) {
            this.fillInNextEvent('D', string);
        }

        public synchronized void logError(String string) {
            this.fillInNextEvent('E', string);
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = null;
            try {
                stringBuffer = new StringBuffer("\nRecorded ");
                stringBuffer.append(this.recordedEvents);
                stringBuffer.append(" events for recorder ");
                stringBuffer.append(Integer.toHexString(System.identityHashCode(this)));
                stringBuffer.append(" (thread/type/description):\n");
                int n = this.currentEvent - this.recordedEvents;
                if (n < 0) {
                    n += this.maxEvents;
                }
                int n2 = n;
                for (int i = 0; i < this.maxEvents; ++i) {
                    Event event = this.events[n2];
                    stringBuffer.append(Integer.toHexString(event.threadHashcode));
                    stringBuffer.append("\t");
                    stringBuffer.append(event.type);
                    stringBuffer.append("\t");
                    stringBuffer.append(event.event);
                    stringBuffer.append("\n");
                    n2 = (n2 + 1) % this.maxEvents;
                }
            }
            catch (Throwable throwable) {
                stringBuffer = new StringBuffer("\nCaught exception during processing recorder: ");
                stringBuffer.append(throwable.toString());
                stringBuffer.append("\n");
            }
            if (this.errorTrappedInRecorder) {
                stringBuffer.append("Note: internal errors trapped in recorder\n");
            }
            return stringBuffer.toString();
        }

        private class Event {
            private int threadHashcode;
            private char type;
            private String event;

            private Event() {
            }
        }
    }

    private class LogicalCloseSendListener
    implements SendListener {
        private LogicalCloseSendListener() {
        }

        public void dataSent(Conversation conversation) {
            ConversationImpl.this.eventRecorder.logEntry("LogicalCloseSendListener.dataSent");
            ConversationImpl.this.eventRecorder.logDebug("LogicalCloseSendListener hashcode: " + Integer.toHexString(System.identityHashCode(this)));
            ConversationImpl.this.sendCompletes();
            ConversationImpl.this.eventRecorder.logExit("LogicalCloseSendListener.dataSent");
        }

        public void errorOccurred(SIConnectionLostException sIConnectionLostException, Conversation conversation) {
            ConversationImpl.this.eventRecorder.logEntry("LogicalCloseSendListener.errorOccurred");
            ConversationImpl.this.eventRecorder.logDebug("LogicalCloseSendListener hashcode: " + Integer.toHexString(System.identityHashCode(this)));
            ConversationImpl.this.sendCompletes();
            ConversationImpl.this.eventRecorder.logExit("LogicalCloseSendListener.errorOccurred");
        }
    }

    private static class StateEnum {
        private String toStringName;

        private StateEnum(String string) {
            this.toStringName = "STATE: " + string;
        }

        public String toString() {
            return this.toStringName;
        }
    }
}

