/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.CapacityListener;
import com.ibm.ws.sib.jfapchannel.ConnectionClosedListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.NoCapacityException;
import com.ibm.ws.sib.jfapchannel.ReceiveListener;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.jfapchannel.impl.BufferPoolManagerReference;
import com.ibm.ws.sib.jfapchannel.impl.ConnectionReadCompletedCallback;
import com.ibm.ws.sib.jfapchannel.impl.ConnectionWriteCompletedCallback;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.ConversationTable;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.jfapchannel.impl.PriorityQueue;
import com.ibm.ws.sib.jfapchannel.impl.ReentrantWriterPriorityReadersWriterLock;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Connection {
    private static final TraceComponent tc = SibTr.register(Connection.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls;
    public static final short FIRST_CONVERSATION_ID = 1;
    protected boolean first = true;
    private PriorityQueue priorityQueue = null;
    private TCPConnectionContext tcpCtx = null;
    private TCPReadRequestContext tcpReadCtx = null;
    private TCPWriteRequestContext tcpWriteCtx = null;
    protected ConversationTable conversationTable = null;
    private ConnectionWriteCompletedCallback writeCompletedCallback = null;
    private ConnectionReadCompletedCallback readCompletedCallback = null;
    private Object userAttachment = null;
    private boolean blocking = true;
    private byte nextRequestNumber = 0;
    private VirtualConnection vc = null;
    protected ConnectionLink connChannel = null;
    private int heartbeatInterval;
    private int heartbeatTimeout;
    private Object attachmentModificationLock = new Object();
    private Object capacityRelatedLock = new Object();
    private Object heartbeatLock = new Object();
    private Object requestNumberLock = new Object();
    private Conversation.ConversationType conversationType = Conversation.UNKNOWN;
    private ConnectionClosedListener closeListener = null;
    private static final StateEnum OPEN;
    private static final StateEnum INVALIDATING;
    private static final StateEnum CLOSED;
    private StateEnum state = OPEN;
    private ReentrantWriterPriorityReadersWriterLock stateChangeLock = new ReentrantWriterPriorityReadersWriterLock();
    private int maxTransmissionSize = 0x100000;
    protected String description = "";
    protected String remoteHostAddress;
    protected String chainName;

    public Connection(ConnectionLink connectionLink, VirtualConnection virtualConnection, int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{connectionLink, virtualConnection, "" + n, "" + n2});
        }
        this.first = true;
        this.priorityQueue = new PriorityQueue();
        this.conversationTable = new ConversationTable();
        if (n < 0 || n2 < 1) {
            throw new SIErrorException(nls.getFormattedMessage("CONNECTION_INTERNAL_SICJ0043", null, "CONNECTION_INTERNAL_SICJ0043"));
        }
        this.heartbeatInterval = n;
        this.heartbeatTimeout = n2;
        this.tcpCtx = (TCPConnectionContext)connectionLink.getDeviceLink().getChannelAccessor();
        this.tcpReadCtx = this.tcpCtx.getReadInterface();
        this.tcpWriteCtx = this.tcpCtx.getWriteInterface();
        this.connChannel = connectionLink;
        this.vc = virtualConnection;
        this.writeCompletedCallback = new ConnectionWriteCompletedCallback(this.priorityQueue, this.tcpWriteCtx, this);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    protected ConversationImpl startNewConversationGeneric(ConversationImpl conversationImpl, boolean bl, AcceptListener acceptListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "startNewConversationGeneric", new Object[]{conversationImpl, "" + bl, acceptListener});
        }
        if (bl) {
            conversationImpl.setOnClientSide();
        }
        this.conversationTable.add(conversationImpl);
        if (this.first) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "first conversation for connection");
            }
            this.readCompletedCallback = new ConnectionReadCompletedCallback(this, bl, acceptListener, this.conversationTable, conversationImpl, this.tcpCtx);
            if (this.tcpReadCtx.getBuffer() == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "needs new buffer");
                }
                WsByteBuffer wsByteBuffer = BufferPoolManagerReference.getInstance().wrap(new byte[1024]);
                this.tcpReadCtx.setBuffer(wsByteBuffer);
            }
            this.first = false;
            int n = 0;
            if (this.heartbeatInterval > 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "setting timeout hint to: " + this.heartbeatInterval * 1000 + " milliseconds");
                }
                n = this.heartbeatInterval * 1000;
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "not setting timeout - heartbeating disabled");
                }
                n = -1;
            }
            if (this.tcpReadCtx.getBuffer().remaining() < this.tcpReadCtx.getBuffer().capacity()) {
                this.readCompletedCallback.complete(this.vc, this.tcpReadCtx);
            } else {
                WsByteBuffer wsByteBuffer;
                WsByteBuffer wsByteBuffer2 = this.tcpReadCtx.getBuffer();
                if (!wsByteBuffer2.isDirect()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "replacing read buffer with direct version (read buffer = " + wsByteBuffer2 + ")");
                    }
                    wsByteBuffer = BufferPoolManagerReference.getInstance().allocateDirect(wsByteBuffer2.capacity());
                    int n2 = wsByteBuffer2.position();
                    int n3 = wsByteBuffer2.limit();
                    wsByteBuffer.position(0);
                    wsByteBuffer.limit(n2);
                    wsByteBuffer2.position(0);
                    wsByteBuffer2.limit(n2);
                    wsByteBuffer.put(wsByteBuffer2);
                    wsByteBuffer.position(n2);
                    wsByteBuffer.limit(n3);
                    this.tcpReadCtx.setBuffer(wsByteBuffer);
                }
                if ((wsByteBuffer = this.tcpReadCtx.read(1L, (TCPReadCompletedCallback)this.readCompletedCallback, false, n)) != null) {
                    this.readCompletedCallback.complete((VirtualConnection)wsByteBuffer, this.tcpReadCtx);
                } else if (this.conversationType == Conversation.ME) {
                    CommsPMI.getMEStats().onWriteBlocked();
                } else if (this.conversationType == Conversation.CLIENT) {
                    CommsPMI.getClientStats().onWriteBlocked();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "startNewConversationGeneric", conversationImpl);
        }
        return conversationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long send(List list, int n, int n2, int n3, int n4, boolean bl, boolean bl2, ReceiveListener receiveListener, SendListener sendListener, Conversation conversation, boolean bl3, boolean bl4) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException {
        boolean bl5;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "send", new Object[]{list, "" + n, "" + n2, "" + n3, "" + n4, "" + bl, receiveListener, sendListener, "" + bl3, "" + bl4});
        }
        if (tc.isDebugEnabled()) {
            String string = null;
            string = !bl3 ? (bl2 ? "System exchange " : "System send ") : (bl2 ? "Exchange " : "Send ");
            string = string + Integer.toHexString(n) + " (" + JFapChannelConstants.getSegmentName(n) + ")";
            JFapUtils.debugSummaryMessage(tc, this, (ConversationImpl)conversation, string);
        }
        long l = 0L;
        do {
            bl5 = false;
            try {
                this.stateChangeLock.startReading();
            }
            catch (InterruptedException interruptedException) {
                bl5 = true;
            }
        } while (bl5);
        try {
            boolean bl6;
            if (this.state != OPEN) {
                throw new SIConnectionDroppedException(nls.getFormattedMessage("CONNECTION_CLOSED_SICJ0044", null, "CONNECTION_CLOSED_SICJ0044"));
            }
            WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[list.size()];
            for (bl6 = false; bl6 < wsByteBufferArray.length; bl6 += 1) {
                wsByteBufferArray[bl6] = (WsByteBuffer)list.get(bl6 ? 1 : 0);
                l += (long)wsByteBufferArray[bl6].remaining();
            }
            bl6 = this.priorityQueue.queue(wsByteBufferArray, n, n3, n4, sendListener, conversation, this, n2, bl, bl2, l, bl4, bl3);
            this.writeCompletedCallback.proddle(bl6);
        }
        finally {
            this.stateChangeLock.stopReading();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "send", "" + l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long send(List list, int n, int n2, boolean bl, boolean bl2, ReceiveListener receiveListener, SendListener sendListener, boolean bl3) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException {
        boolean bl4;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "send", new Object[]{list, "" + n, "" + n2, "" + bl, receiveListener, sendListener, "" + bl3});
        }
        if (tc.isDebugEnabled()) {
            String string = null;
            string = bl2 ? "System connection level exchange " : "System connection level send ";
            string = string + Integer.toHexString(n) + " (" + JFapChannelConstants.getSegmentName(n) + ")";
            JFapUtils.debugSummaryMessage(tc, this, null, string);
        }
        long l = 0L;
        do {
            bl4 = false;
            try {
                this.stateChangeLock.startReading();
            }
            catch (InterruptedException interruptedException) {
                bl4 = true;
            }
        } while (bl4);
        try {
            boolean bl5;
            if (!bl3 && this.state == CLOSED) {
                throw new SIConnectionDroppedException(nls.getFormattedMessage("CONNECTION_CLOSED_SICJ0044", null, "CONNECTION_CLOSED_SICJ0044"));
            }
            WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[list.size()];
            for (bl5 = false; bl5 < wsByteBufferArray.length; bl5 += 1) {
                wsByteBufferArray[bl5] = (WsByteBuffer)list.get(bl5 ? 1 : 0);
                l += (long)wsByteBufferArray[bl5].remaining();
            }
            bl5 = this.priorityQueue.queue(wsByteBufferArray, n, n2, receiveListener, sendListener, this, bl, bl2, l, bl3, false);
            this.writeCompletedCallback.proddle(bl5);
            Object var15_15 = null;
            this.stateChangeLock.stopReading();
            if (bl3) {
                this.priorityQueue.waitForCloseToComplete();
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.stateChangeLock.stopReading();
            if (bl3) {
                this.priorityQueue.waitForCloseToComplete();
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "send", "" + l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttachment(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setAttachment", object);
        }
        Object object2 = this.attachmentModificationLock;
        synchronized (object2) {
            this.userAttachment = object;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setAttachment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttachment() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getAttachment");
        }
        Object object2 = this.attachmentModificationLock;
        synchronized (object2) {
            object = this.userAttachment;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getAttachment", object);
        }
        return object;
    }

    public abstract void closeNotification(Conversation var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasCapacity(int n) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "hasCapacity", "" + n);
        }
        Object object = this.capacityRelatedLock;
        synchronized (object) {
            if (this.blocking) {
                this.priorityQueue.setMode(PriorityQueue.REJECT);
                this.blocking = false;
            }
            bl = this.priorityQueue.hasCapacity(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "hasCapacity", "" + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCapacityListener(CapacityListener capacityListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "addCapacityListener", capacityListener);
        }
        Object object = this.capacityRelatedLock;
        synchronized (object) {
            if (this.blocking) {
                this.priorityQueue.setMode(PriorityQueue.REJECT);
                this.blocking = false;
            }
            this.priorityQueue.addCapacityListener(capacityListener);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "addCapacityListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCapacityListener(CapacityListener capacityListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "removeCapacityListener", capacityListener);
        }
        Object object = this.capacityRelatedLock;
        synchronized (object) {
            if (this.blocking) {
                throw new SIErrorException(nls.getFormattedMessage("CONNECTION_INTERNAL_SICJ0043", null, "CONNECTION_INTERNAL_SICJ0043"));
            }
            this.priorityQueue.removeCapacityListener(capacityListener);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "removeCapacityListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Conversation[] getConversations() {
        Conversation[] conversationArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getConversations");
        }
        ConversationTable conversationTable = this.conversationTable;
        synchronized (conversationTable) {
            Iterator iterator = this.conversationTable.iterator();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            conversationArray = new Conversation[arrayList.size()];
            for (int i = 0; i < conversationArray.length; ++i) {
                conversationArray[i] = (Conversation)arrayList.get(i);
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug(tc, "conversation " + i, conversationArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getConversations", conversationArray);
        }
        return conversationArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte getNextRequestNumber() {
        byte by;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getNextRequestNumber");
        }
        Object object = this.requestNumberLock;
        synchronized (object) {
            byte by2 = this.nextRequestNumber;
            this.nextRequestNumber = (byte)(by2 + 1);
            by = by2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getNextRequestNumber", "" + by);
        }
        return by;
    }

    public void physicalClose(boolean bl) {
        boolean bl2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "physicalClose", "" + bl);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugSummaryMessage(tc, this, null, "Connection close requested (notifyPeer=" + bl + ")");
        }
        do {
            bl2 = false;
            try {
                this.stateChangeLock.startWriting();
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
            }
        } while (bl2);
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "transition " + this.state + " -> " + CLOSED);
        }
        boolean bl3 = this.state != CLOSED;
        this.state = CLOSED;
        this.stateChangeLock.stopWriting();
        if (bl3) {
            if (this.conversationType == Conversation.CLIENT) {
                CommsPMI.getMEStats().onClientDetach();
            } else if (this.conversationType == Conversation.ME) {
                CommsPMI.getClientStats().onClientDetach();
            }
            if (bl) {
                WsByteBuffer wsByteBuffer = BufferPoolManagerReference.getInstance().allocate(1);
                wsByteBuffer.put((byte)1);
                wsByteBuffer.flip();
                ArrayList<WsByteBuffer> arrayList = new ArrayList<WsByteBuffer>();
                arrayList.add(wsByteBuffer);
                try {
                    this.send(arrayList, 255, 11, true, false, null, null, true);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.jfapchannel.impl.Connection", (String)"00040001");
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, tc, sIException);
                    }
                }
            } else {
                this.priorityQueue.close(true);
            }
            this.priorityQueue.waitForCloseToComplete();
            this.readCompletedCallback.physicalCloseNotification();
            this.writeCompletedCallback.physicalCloseNotification();
            if (this.vc.requestPermissionToClose((long)(this.heartbeatInterval + this.heartbeatTimeout))) {
                this.connChannel.close(this.vc, new Exception());
            }
            if (this.closeListener != null) {
                block20: {
                    try {
                        this.closeListener.connectionClosed(this.userAttachment);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.Connection", (String)"00040004", (Object)this);
                        if (!tc.isDebugEnabled()) break block20;
                        SibTr.debug(this, tc, "Exception invoking close listener", throwable);
                    }
                }
                this.closeListener = null;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "physicalClose");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHeartbeatInterval(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setHeartbeatInterval", "" + n);
        }
        Object object = this.heartbeatLock;
        synchronized (object) {
            if (n < 0) {
                throw new SIErrorException(nls.getFormattedMessage("CONNECTION_INTERNAL_SICJ0043", null, "CONNECTION_INTERNAL_SICJ0043"));
            }
            this.heartbeatInterval = n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setHeartbeatInterval");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getHeartbeatInterval() {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getHeartbeatInterval");
        }
        Object object = this.heartbeatLock;
        synchronized (object) {
            n = this.heartbeatInterval;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getHeartbeatInterval", "" + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHeartbeatTimeout(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setHeartbeatTimeout", "" + n);
        }
        Object object = this.heartbeatLock;
        synchronized (object) {
            if (n < 1) {
                throw new SIErrorException(nls.getFormattedMessage("CONNECTION_INERNAL_SICJ0043", null, "CONNECTION_INERNAL_SICJ0043"));
            }
            this.heartbeatTimeout = n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setHeartbeatTimeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getHeartbeatTimeout() {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getHeartbeatTimeout");
        }
        Object object = this.heartbeatLock;
        synchronized (object) {
            n = this.heartbeatTimeout;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getHeartbeatTimeout", "" + n);
        }
        return n;
    }

    public void invalidate(boolean bl, Throwable throwable, String string) {
        boolean bl2;
        boolean bl3;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "invalidate", new Object[]{"" + bl, throwable});
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugSummaryMessage(tc, this, null, "Connection invalidated (reason: " + string + ")");
        }
        do {
            bl3 = false;
            try {
                this.stateChangeLock.startWriting();
            }
            catch (InterruptedException interruptedException) {
                bl3 = true;
            }
        } while (bl3);
        boolean bl4 = bl2 = this.state == OPEN;
        if (bl2) {
            this.state = INVALIDATING;
        }
        this.stateChangeLock.stopWriting();
        if (bl2) {
            this.invalidateImpl(bl, throwable);
        }
        if (this.closeListener != null) {
            block11: {
                try {
                    this.closeListener.connectionClosed(this.userAttachment);
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.sib.jfapchannel.impl.Connection", (String)"00040005", (Object)this);
                    if (!tc.isDebugEnabled()) break block11;
                    SibTr.debug(this, tc, "Exception invoking close listener", throwable2);
                }
            }
            this.closeListener = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "invalidate");
        }
    }

    public abstract void invalidateImpl(boolean var1, Throwable var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeupAllConversationsWithException(SIException sIException, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "wakeupAllConversationsWithException", new Object[]{sIException, "" + bl});
        }
        ConversationTable conversationTable = this.conversationTable;
        synchronized (conversationTable) {
            Iterator iterator = this.conversationTable.iterator();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                ConversationImpl conversationImpl = (ConversationImpl)arrayList.get(i);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "conversation: " + conversationImpl);
                }
                conversationImpl.invalidate(sIException);
            }
            this.conversationTable.clear();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "wakeupAllConversationsWithException");
        }
    }

    protected void processData(int n, int n2, boolean bl, boolean bl2, WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "processData", new Object[]{"" + n, "" + n2, "" + bl, "" + bl2, wsByteBuffer});
        }
        switch (n) {
            case 1: {
                this.processHeartbeat();
                break;
            }
            case 2: {
                this.readCompletedCallback.heartbeatReceived();
                break;
            }
            case 255: {
                this.processPhysicalClose();
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "unexpected segment type: " + n);
                }
                this.invalidate(false, new RuntimeException(), "received unexpected segment for a connection based transmission");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "processData");
        }
    }

    private void processHeartbeat() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "processHeartbeat");
        }
        ArrayList arrayList = new ArrayList(1);
        try {
            this.send(arrayList, 2, 0, 0, 15, true, false, null, null, null, false, false);
        }
        catch (NoCapacityException noCapacityException) {
            FFDCFilter.processException((Throwable)noCapacityException, (String)"com.ibm.ws.sib.jfapchannel.impl.Connection", (String)"00040003");
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, noCapacityException);
            }
            this.invalidate(false, noCapacityException, "No capacity exception thrown from an system send operation");
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.jfapchannel.impl.Connection", (String)"00040002");
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, sIException);
            }
            this.invalidate(false, sIException, "SIException thrown from a system send operation");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "processHeartbeat");
        }
    }

    private void processPhysicalClose() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "processPhysicalClose");
        }
        this.readCompletedCallback.stopReceiving();
        SIConnectionLostException sIConnectionLostException = new SIConnectionLostException("Physical close method invoked upon underlying connection");
        Iterator iterator = this.conversationTable.iterator();
        while (iterator.hasNext()) {
            ConversationImpl conversationImpl = (ConversationImpl)iterator.next();
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "invoking wakeupAllWithException on conversation " + conversationImpl);
            }
            conversationImpl.invalidate(sIConnectionLostException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "processPhysicalClose");
        }
    }

    protected int getMaxTransmissionSize() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getMaxTransmissionSize");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getMaxTransmissionSize", "" + this.maxTransmissionSize);
        }
        return this.maxTransmissionSize;
    }

    protected void setMaxTransmissionSize(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setMaxTransmissionSize", "" + n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getMaxTransmissionSize");
        }
        this.maxTransmissionSize = n;
    }

    protected abstract void handshakeComplete();

    protected abstract void handshakeFailed();

    protected abstract Conversation cloneConversation(ConversationReceiveListener var1) throws SIResourceException;

    public ConversationImpl getConversationById(int n) {
        return this.conversationTable.get(n);
    }

    protected void removeConversationById(int n) {
        this.conversationTable.remove(n);
    }

    protected abstract ConversationMetaData getMetaData();

    public Conversation.ConversationType getConversationType() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getConversationType");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getConversationType", this.conversationType);
        }
        return this.conversationType;
    }

    protected void setConversationType(Conversation.ConversationType conversationType) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setConversationType", conversationType);
        }
        if (this.conversationType == Conversation.UNKNOWN && conversationType != Conversation.UNKNOWN) {
            this.conversationType = conversationType;
            if (this.conversationType == Conversation.CLIENT) {
                CommsPMI.getClientStats().onClientAttach();
                this.description = "CLIENT-ME " + this.description;
            } else if (this.conversationType == Conversation.ME) {
                CommsPMI.getMEStats().onClientAttach();
                this.description = "ME-ME " + this.description;
            }
            this.priorityQueue.setType(conversationType);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setConversationType");
        }
    }

    public void setConnectionClosedListener(ConnectionClosedListener connectionClosedListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setConnectionClosedListener", connectionClosedListener);
        }
        this.closeListener = connectionClosedListener;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setConnectionClosedListener");
        }
    }

    protected int getLowestPriorityWithCapacity() {
        return this.priorityQueue.getLowestPrioityWithCapacity();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/Connection.java, SIB.comms, WAS602.SIB, o0610.11 1.52.2.1");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
        OPEN = new StateEnum("OPEN");
        INVALIDATING = new StateEnum("INVALIDATING");
        CLOSED = new StateEnum("CLOSED");
    }

    private static class StateEnum {
        private String description;

        private StateEnum(String string) {
            this.description = "Connection state: " + string;
        }

        public String toString() {
            return this.description;
        }
    }
}

