/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.jfapchannel.ClientConnectionManager;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.impl.BufferPoolManagerReference;
import com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import java.net.InetSocketAddress;

public class ClientConnectionManagerImpl
extends ClientConnectionManager {
    private static final TraceComponent tc = SibTr.register(ClientConnectionManagerImpl.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static OutboundConnectionTracker tracker;
    private static boolean initialisationFailed;
    private static volatile int defaultHeartbeatInterval;
    private static volatile int defaultHeartbeatTimeout;

    public ClientConnectionManagerImpl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public Conversation connect(InetSocketAddress inetSocketAddress, ConversationReceiveListener conversationReceiveListener, String string) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connect", new Object[]{inetSocketAddress, conversationReceiveListener, string});
        }
        if (initialisationFailed) {
            String string2 = nls.getFormattedMessage("EXCP_CONN_FAIL_NO_CF_SICJ0007", null, null);
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "connection failed because comms failed to initialise");
            }
            throw new SIResourceException(string2);
        }
        Conversation conversation = tracker.connect(inetSocketAddress, conversationReceiveListener, string);
        if (conversation != null) {
            conversation.setConversationType(Conversation.CLIENT);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connect", conversation);
        }
        return conversation;
    }

    public Conversation connect(CFEndPoint cFEndPoint, ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connect", new Object[]{cFEndPoint, conversationReceiveListener});
        }
        if (initialisationFailed) {
            String string = nls.getFormattedMessage("EXCP_CONN_FAIL_NO_CF_SICJ0007", null, null);
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "connection failed because comms failed to initialise");
            }
            throw new SIResourceException(string);
        }
        Conversation conversation = tracker.connect(cFEndPoint, conversationReceiveListener);
        if (conversation != null) {
            conversation.setConversationType(Conversation.CLIENT);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connect", conversation);
        }
        return conversation;
    }

    public Conversation connect(ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connect", conversationReceiveListener);
        }
        if (initialisationFailed) {
            String string = nls.getFormattedMessage("EXCP_CONN_FAIL_NO_CF_SICJ0007", null, null);
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "connection failed because comms failed to initialise");
            }
            throw new SIResourceException(string);
        }
        Conversation conversation = tracker.connect(conversationReceiveListener);
        if (conversation != null) {
            conversation.setConversationType(Conversation.CLIENT);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connect", conversation);
        }
        return conversation;
    }

    public static void initialise() throws SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "initialise");
        }
        initialisationFailed = true;
        ChannelFramework channelFramework = ChannelFrameworkReference.getInstance();
        if (channelFramework != null) {
            tracker = new OutboundConnectionTracker(channelFramework);
            initialisationFailed = false;
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "initialisation failed");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "initialise");
        }
    }

    public WsByteBufferPoolManager getBufferPoolManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getBufferPoolManager");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getBufferPoolManager");
        }
        return BufferPoolManagerReference.getInstance();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/ClientConnectionManagerImpl.java, SIB.comms, WAS602.SIB, o0610.11 1.34");
        }
        tracker = null;
        initialisationFailed = false;
        defaultHeartbeatInterval = 300;
        defaultHeartbeatTimeout = 7;
    }
}

