/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainStartMode;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.ssl.SSLConfig;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFrameworkException;
import com.ibm.wsspi.channel.framework.exception.DuplicatePoolException;
import com.ibm.wsspi.channel.framework.exception.RetryableChannelException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ChannelFrameworkReference {
    private static final TraceComponent tc = SibTr.register(ChannelFrameworkReference.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static ChannelFramework framework;
    private static boolean cached;

    private static ChannelFramework lookupFromServicesNamespace() {
        JsAdminService jsAdminService;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "lookupFromServicesNamespace");
        }
        if ((jsAdminService = JsAdminService.getInstance()) != null) {
            framework = (ChannelFramework)jsAdminService.getService(ChannelFrameworkService.class);
        }
        if (framework == null) {
            SibTr.error(tc, "CF_NOT_AVAILABLE_SICJ0005");
            try {
                boolean bl;
                boolean bl2 = bl = System.getProperty("com.ibm.ws.sib.jfapchannel.forceNewCf") != null || Class.forName("com.ibm.ws.sib.jfapchannel.ForceNewChannelFramework") != null;
                if (bl) {
                    SibTr.info(tc, "CREATING_CF_SICJ0006");
                    framework = ChannelFrameworkReference.findInStandAloneEnvironment();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "lookupFromServicesNamespace", framework);
        }
        return framework;
    }

    private static ChannelFramework findInAppserverEnvironment() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "findInAppserverEnvironment");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "findInAppserverEnvironment");
        }
        return ChannelFrameworkReference.lookupFromServicesNamespace();
    }

    private static ChannelFramework findInClientContaininerEnvironment() {
        InitialContext initialContext;
        NamingException namingException;
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "findInClientContainerEnvironment");
            }
            namingException = null;
            initialContext = null;
            try {
                initialContext = new InitialContext();
                framework = (ChannelFramework)initialContext.lookup("services:websphere/ChannelFrameworkService");
            }
            catch (NamingException namingException2) {
                namingException = namingException2;
                if (!tc.isDebugEnabled()) break block11;
                SibTr.debug(tc, "lookup in global namespace failed");
            }
        }
        if (framework == null) {
            try {
                initialContext = new InitialContext();
                framework = (ChannelFramework)initialContext.lookup("websphere/ChannelFrameworkService");
            }
            catch (NamingException namingException3) {
                FFDCFilter.processException((Throwable)namingException3, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference.findInClientContainerEnvironment", (String)"00020009");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "lookup in local namespace failed");
                }
                if (tc.isEventEnabled()) {
                    SibTr.exception(tc, namingException3);
                }
                if (namingException != null) {
                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.sib.jfapchannel.impl.BufferPoolManagerReference.findInClientContainerEnvironment", (String)"00020009");
                    if (tc.isEventEnabled()) {
                        SibTr.exception(tc, namingException);
                    }
                }
                SibTr.error(tc, "CF_NOT_AVAILABLE_SICJ0005", null);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "findInClientContainerEnvironment", framework);
        }
        return framework;
    }

    private static ChannelFramework findInStandAloneEnvironment() {
        ChannelFramework channelFramework;
        block5: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "findInStandAloneEnvironment");
            }
            channelFramework = null;
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl");
                Constructor<?>[] constructorArray = clazz.getConstructors();
                for (int i = 0; i < constructorArray.length; ++i) {
                    if (constructorArray[i].getParameterTypes().length != 4) continue;
                    Object[] objectArray = new Object[]{null, null, null, null};
                    channelFramework = (ChannelFramework)constructorArray[i].newInstance(objectArray);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference", (String)"00020002");
                if (!tc.isEventEnabled()) break block5;
                SibTr.exception(tc, exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "findInStandAloneEnvironment", channelFramework);
        }
        return channelFramework;
    }

    public static synchronized ChannelFramework getInstance() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getInstance");
        }
        if (!cached) {
            cached = true;
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (platformHelper.isZOS()) {
                if (platformHelper.isCRAJvm()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Environment appears to be a z/OS CRA");
                    }
                    framework = ChannelFrameworkReference.findInAppserverEnvironment();
                    ChannelFrameworkReference.defineInboundTCPProxyBridgeChain();
                    ChannelFrameworkReference.verifyOutboundChains();
                    ChannelFrameworkReference.performCRAStartup();
                } else if (platformHelper.isServantJvm()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Environment appears to be a z/OS SR");
                    }
                    framework = ChannelFrameworkReference.findInAppserverEnvironment();
                    ChannelFrameworkReference.defineOutboundTCPProxyBridgeChain();
                    ChannelFrameworkReference.verifyOutboundChains();
                } else if (platformHelper.isClientJvm()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Environment appears to be a z/OS client");
                    }
                    framework = ChannelFrameworkReference.findInClientContaininerEnvironment();
                    ChannelFrameworkReference.createOutboundChains();
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Cannot determine current environment (z/OS)");
                }
            } else if (RuntimeInfo.isServer() || RuntimeInfo.isClusteredServer()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Environment appears to be a distributed appserver");
                }
                framework = ChannelFrameworkReference.findInAppserverEnvironment();
                ChannelFrameworkReference.verifyOutboundChains();
                ChannelFrameworkReference.startInboundChains();
            } else if (RuntimeInfo.isClientContainer()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Environment appears to be a distributed client container");
                }
                framework = ChannelFrameworkReference.findInClientContaininerEnvironment();
                ChannelFrameworkReference.createOutboundChains();
            } else if (RuntimeInfo.isThinClient()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Environment appears to be a distributed thin client");
                }
                framework = ChannelFrameworkReference.findInStandAloneEnvironment();
                ChannelFrameworkReference.createOutboundChains();
            } else if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Cannot determine current environment");
            }
            if (framework != null) {
                int n = 0;
                int n2 = 0;
                String string = RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.MIN_CF_THREADPOOL_SIZE");
                String string2 = RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.MAX_CF_THREADPOOL_SIZE");
                if (string != null && string2 != null) {
                    try {
                        n = Integer.parseInt(string);
                        n2 = Integer.parseInt(string2);
                        if (n > 0 && n2 >= n) {
                            framework.setDefaultThreadPool(n, n2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getInstance", framework);
        }
        return framework;
    }

    private static void verifyOutboundChains() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "verifyOutboundChains");
        }
        if (framework != null) {
            if (framework.getChain("BootstrapBasicMessaging") == null) {
                SibTr.warning(tc, "NO_DEFAULT_OUTBOUND_SICJ0008", new Object[]{"BootstrapBasicMessaging"});
            }
            if (framework.getChain("BootstrapSecureMessaging") == null) {
                SibTr.warning(tc, "NO_DEFAULT_SECURE_OUTBOUND_SICJ0009", new Object[]{"BootstrapSecureMessaging"});
            }
            if (framework.getChain("BootstrapTunneledMessaging") == null) {
                SibTr.warning(tc, "NO_DEFAULT_TUNNELED_OUTBOUND_SICJ0010", new Object[]{"BootstrapTunneledMessaging"});
            }
            if (framework.getChain("BootstrapTunneledSecureMessaging") == null) {
                SibTr.warning(tc, "NO_DEFAULT_TUNNELED_SECURE_OUTBOUND_SICJ0011", new Object[]{"BootstrapTunneledSecureMessaging"});
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "verifyOutboundChains");
        }
    }

    private static Class getClassForName(String string) {
        Class<?> clazz;
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getClassForName", (Object)string);
            }
            clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference", (String)"00020008");
                if (!tc.isEventEnabled()) break block4;
                SibTr.exception(tc, classNotFoundException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getClassForName", clazz);
        }
        return clazz;
    }

    public static Properties loadSSLProperties() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "loadSSLProperties");
        }
        final Properties properties = new Properties();
        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL uRL = classLoader.getResource("sib.client.ssl.properties");
                if (uRL != null) {
                    try {
                        properties.load(uRL.openStream());
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference", (String)"00020003");
                        SibTr.exception(tc, iOException);
                    }
                } else {
                    SibTr.warning(tc, "NO_SSL_PROPERTIES_FILE_SICJ0012", new Object[]{"sib.client.ssl.properties"});
                }
                for (int i = 0; i < SSLConfig.PROP_NAMES.length; ++i) {
                    String string = SSLConfig.PROP_NAMES[i];
                    String string2 = System.getProperty(string);
                    if (string2 == null) continue;
                    properties.setProperty(string, string2);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "loadSSLProperties", properties);
        }
        return properties;
    }

    private static ChannelException addChannel(String string, Class clazz, Map map) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "addChannel", new Object[]{string, clazz, map});
        }
        ChannelException channelException = null;
        try {
            framework.addChannel(string, clazz, map);
        }
        catch (ChannelException channelException2) {
            channelException = channelException2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "addChannel", (Object)channelException);
        }
        return channelException;
    }

    private static void createOutboundChains() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createOutboundChains");
        }
        if (framework != null) {
            Class clazz = ChannelFrameworkReference.getClassForName("com.ibm.ws.sib.jfapchannel.impl.WSJFapChannelFactory");
            Class clazz2 = ChannelFrameworkReference.getClassForName("com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory");
            if (clazz != null && clazz2 != null) {
                ChannelException channelException;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "creating JFAP -> TCP default outbound chain");
                }
                int n = 0;
                int n2 = 0;
                try {
                    n = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.impl.MinimumClientTCPThreadPoolSize", "1"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    n2 = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.impl.MaximumClientTCPThreadPoolSize", "15"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                try {
                    if (n < 1) {
                        n = 1;
                    }
                    if (n2 < n) {
                        n2 = 15;
                    }
                    try {
                        framework.addThreadPool("SIBFAPThreadPool", n, n2);
                    }
                    catch (DuplicatePoolException duplicatePoolException) {
                        FFDCFilter.processException((Throwable)duplicatePoolException, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference", (String)"00020011");
                    }
                    channelException = framework.getThreadPool("SIBFAPThreadPool");
                    hashMap.put("threadPoolName", channelException.getName());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                channelException = ChannelFrameworkReference.addChannel("BootstrapMessagingTCPChannel", clazz2, hashMap);
                if (channelException == null) {
                    channelException = ChannelFrameworkReference.addChannel("BootstrapMessagingJFAPChannel", clazz, null);
                    if (channelException == null) {
                        try {
                            framework.addChain("BootstrapBasicMessaging", FlowType.OUTBOUND, new String[]{"BootstrapMessagingJFAPChannel", "BootstrapMessagingTCPChannel"});
                        }
                        catch (ChannelFrameworkException channelFrameworkException) {
                            FFDCFilter.processException((Throwable)channelFrameworkException, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference", (String)"00020004", (Object)framework);
                            if (tc.isEventEnabled()) {
                                SibTr.exception(tc, (Exception)((Object)channelFrameworkException));
                            }
                            SibTr.error(tc, "CANNOT_CREATE_DEFAULT_OUTBOUND_CHANNEL_SICJ0023", new Object[]{"BootstrapBasicMessaging", channelFrameworkException});
                        }
                        Class clazz3 = ChannelFrameworkReference.getClassForName("com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory");
                        if (clazz3 != null) {
                            Properties properties = ChannelFrameworkReference.loadSSLProperties();
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(tc, "creating JFAP -> SSL -> TCP default outbound chain");
                            }
                            if ((channelException = ChannelFrameworkReference.addChannel("BootstrapMessagingSSLChannel", clazz3, properties)) == null) {
                                try {
                                    framework.addChain("BootstrapSecureMessaging", FlowType.OUTBOUND, new String[]{"BootstrapMessagingJFAPChannel", "BootstrapMessagingSSLChannel", "BootstrapMessagingTCPChannel"});
                                }
                                catch (ChannelFrameworkException channelFrameworkException) {
                                    FFDCFilter.processException((Throwable)channelFrameworkException, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference", (String)"00020005", (Object)framework);
                                    if (tc.isEventEnabled()) {
                                        SibTr.exception(tc, (Exception)((Object)channelFrameworkException));
                                    }
                                    SibTr.error(tc, "CANNOT_CREATE_SECURE_OUTBOUND_CHANNEL_SICJ0024", new Object[]{"BootstrapSecureMessaging", channelFrameworkException});
                                }
                                Class clazz4 = ChannelFrameworkReference.getClassForName("com.ibm.ws.httptunnel.channel.WSHttpTunnelOutboundChannelFactory");
                                Class clazz5 = ChannelFrameworkReference.getClassForName("com.ibm.ws.http.channel.outbound.impl.WSHttpOutboundChannelFactory");
                                if (clazz4 != null && clazz5 != null) {
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug(tc, "creating JFAP -> HTTPT -> HTTP -> TCP default outbound chain");
                                    }
                                    if ((channelException = ChannelFrameworkReference.addChannel("BootstrapMessagingHTTPChannel", clazz5, null)) == null) {
                                        channelException = ChannelFrameworkReference.addChannel("BootstrapMessagingHTTPTChannel", clazz4, null);
                                        if (channelException == null) {
                                            try {
                                                framework.addChain("BootstrapTunneledMessaging", FlowType.OUTBOUND, new String[]{"BootstrapMessagingJFAPChannel", "BootstrapMessagingHTTPTChannel", "BootstrapMessagingHTTPChannel", "BootstrapMessagingTCPChannel"});
                                            }
                                            catch (ChannelFrameworkException channelFrameworkException) {
                                                FFDCFilter.processException((Throwable)channelFrameworkException, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference", (String)"00020006", (Object)framework);
                                                if (tc.isEventEnabled()) {
                                                    SibTr.exception(tc, (Exception)((Object)channelFrameworkException));
                                                }
                                                SibTr.error(tc, "CANNOT_CREATE_TUNNELED_OUTBOUND_CHANNEL_SICJ0025", new Object[]{"BootstrapTunneledMessaging", channelFrameworkException});
                                            }
                                            if (tc.isDebugEnabled()) {
                                                SibTr.debug(tc, "creating JFAP -> HTTPT -> HTTP -> SSL -> TCP default outbound chain");
                                            }
                                            try {
                                                framework.addChain("BootstrapTunneledSecureMessaging", FlowType.OUTBOUND, new String[]{"BootstrapMessagingJFAPChannel", "BootstrapMessagingHTTPTChannel", "BootstrapMessagingHTTPChannel", "BootstrapMessagingSSLChannel", "BootstrapMessagingTCPChannel"});
                                            }
                                            catch (ChannelFrameworkException channelFrameworkException) {
                                                FFDCFilter.processException((Throwable)channelFrameworkException, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference", (String)"00020007", (Object)framework);
                                                if (tc.isEventEnabled()) {
                                                    SibTr.exception(tc, (Exception)((Object)channelFrameworkException));
                                                }
                                                SibTr.error(tc, "CANNOT_CREATE_TUNNELED_SECURE_OUTBOUND_CHANNEL_SICJ0026", new Object[]{"BootstrapTunneledSecureMessaging", channelFrameworkException});
                                            }
                                        } else {
                                            if (tc.isEventEnabled()) {
                                                SibTr.exception(tc, (Exception)((Object)channelException));
                                            }
                                            SibTr.error(tc, "CANNOT_CREATE_HTTPT_CHANNEL_SICJ0022", new Object[]{"BootstrapMessagingHTTPTChannel", channelException});
                                        }
                                    } else {
                                        if (tc.isEventEnabled()) {
                                            SibTr.exception(tc, (Exception)((Object)channelException));
                                        }
                                        SibTr.error(tc, "CANNOT_CREATE_HTTP_CHANNEL_SICJ0021", new Object[]{"BootstrapMessagingHTTPChannel", channelException});
                                    }
                                } else if (clazz5 == null) {
                                    SibTr.error(tc, "NO_HTTP_CHANNEL_CLASS_SICJ0016", new Object[]{"com.ibm.ws.http.channel.outbound.impl.WSHttpOutboundChannelFactory"});
                                } else {
                                    SibTr.error(tc, "NO_HTTPT_CHANNEL_CLASS_SICJ0017", new Object[]{"com.ibm.ws.httptunnel.channel.WSHttpTunnelOutboundChannelFactory"});
                                }
                            } else {
                                if (tc.isEventEnabled()) {
                                    SibTr.exception(tc, (Exception)((Object)channelException));
                                }
                                SibTr.error(tc, "CANNOT_CREATE_SSL_CHANNEL_SICJ0020", new Object[]{"BootstrapMessagingSSLChannel", channelException});
                            }
                        } else {
                            if (tc.isEventEnabled()) {
                                SibTr.exception(tc, (Exception)((Object)channelException));
                            }
                            SibTr.error(tc, "NO_SSL_CHANNEL_CLASS_SICJ0015", new Object[]{"com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory"});
                        }
                    } else {
                        if (tc.isEventEnabled()) {
                            SibTr.exception(tc, (Exception)((Object)channelException));
                        }
                        SibTr.error(tc, "CANNOT_CREATE_JFAP_CHANNEL_SICJ0018", new Object[]{"BootstrapMessagingJFAPChannel", channelException});
                    }
                } else {
                    if (tc.isEventEnabled()) {
                        SibTr.exception(tc, (Exception)((Object)channelException));
                    }
                    SibTr.error(tc, "CANNOT_CREATE_TCP_CHANNEL_SICJ0019", new Object[]{"BootstrapMessagingTCPChannel", channelException});
                }
            } else if (clazz == null) {
                SibTr.error(tc, "NO_JFAP_CHANNEL_CLASS_SICJ0013", new Object[]{"com.ibm.ws.sib.jfapchannel.impl.WSJFapChannelFactory"});
            } else {
                SibTr.error(tc, "NO_TCP_CHANNEL_CLASS_SICJ0014", new Object[]{"com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory"});
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createOutboundChains");
        }
    }

    private static void startInboundChains() {
        block5: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "startInboundChains");
            }
            try {
                ((ChannelFrameworkService)framework).startChainsByAcceptorID("JFapChannelAcceptorID", ChainStartMode.RETRY_EACH_ON_FAIL);
            }
            catch (Exception exception) {
                SibTr.warning(tc, "CANNOT_START_INBOUND_CHAINS_SICJ0027");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "No inbound messaging chains are defied to this application server.  This has generated the following exception when attempting to start messaging chains");
                }
                if (!tc.isEventEnabled()) break block5;
                SibTr.exception(tc, exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startInboundChains");
        }
    }

    private static void defineInboundTCPProxyBridgeChain() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "defineInboundTCPProxyBridgeChain");
        }
        if (framework != null) {
            Class clazz = ChannelFrameworkReference.getClassForName("com.ibm.ws.sib.jfapchannel.impl.WSJFapChannelFactory");
            Class clazz2 = ChannelFrameworkReference.getClassForName("com.ibm.ws.tcpchannelproxy.jfap.impl.TCPProxyChannelFactory");
            if (clazz != null && clazz2 != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "creating JFAP -> TCP Proxy default inbound chain");
                }
                ThreadPool threadPool = ChannelFrameworkReference.findOrCreateThreadPool("SIBFAPThreadPool", "com.ibm.ws.sib.jfapchannel.impl.MinimumClientTCPThreadPoolSize", 1, "com.ibm.ws.sib.jfapchannel.impl.MaximumClientTCPThreadPoolSize", 15);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("threadPoolName", threadPool.getName());
                ChannelException channelException = ChannelFrameworkReference.addChannel("InboundTCPProxyChannelTCP", clazz2, hashMap);
                if (channelException != null) {
                    if (tc.isEventEnabled()) {
                        SibTr.exception(tc, (Exception)((Object)channelException));
                    }
                    SibTr.error(tc, "CANNOT_CREATE_TCP_CHANNEL_SICJ0019", new Object[]{"InboundTCPProxyChannelTCP", channelException});
                } else {
                    channelException = ChannelFrameworkReference.addChannel("InboundJFAPChannelTCPProxy", clazz, null);
                }
                if (channelException != null) {
                    SibTr.error(tc, "CANNOT_CREATE_TCP_CHANNEL_SICJ0019", new Object[]{"InboundJFAPChannelTCPProxy", channelException});
                } else {
                    try {
                        framework.addChain("_InboundTCPProxyBridgeService", FlowType.INBOUND, new String[]{"InboundTCPProxyChannelTCP", "InboundJFAPChannelTCPProxy"});
                    }
                    catch (ChannelFrameworkException channelFrameworkException) {
                        FFDCFilter.processException((Throwable)channelFrameworkException, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference", (String)"00020014", (Object)framework);
                        if (tc.isEventEnabled()) {
                            SibTr.exception(tc, (Exception)((Object)channelFrameworkException));
                        }
                        SibTr.error(tc, "TEMPORARY_CWSIJ9999", new Object[]{"An internal error occurred, the channel chain named _InboundTCPProxyBridgeService cannot be started because of exception: " + (Object)((Object)channelFrameworkException)});
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "defineInboundTCPProxyBridgeChain");
        }
    }

    private static void defineOutboundTCPProxyBridgeChain() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "defineOutboundTCPProxyBridgeChain");
        }
        if (framework != null) {
            Class clazz = ChannelFrameworkReference.getClassForName("com.ibm.ws.sib.jfapchannel.impl.WSJFapChannelFactory");
            Class clazz2 = ChannelFrameworkReference.getClassForName("com.ibm.ws.tcpchannelproxy.jfap.impl.TCPProxyChannelFactory");
            if (clazz != null && clazz2 != null) {
                ThreadPool threadPool = ChannelFrameworkReference.findOrCreateThreadPool("SIBFAPThreadPool", "com.ibm.ws.sib.jfapchannel.impl.MinimumClientTCPThreadPoolSize", 1, "com.ibm.ws.sib.jfapchannel.impl.MaximumClientTCPThreadPoolSize", 15);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("threadPoolName", threadPool.getName());
                ChannelException channelException = ChannelFrameworkReference.addChannel("OutboundTCPProxyChannelTCP", clazz2, hashMap);
                if (channelException != null) {
                    if (tc.isEventEnabled()) {
                        SibTr.exception(tc, (Exception)((Object)channelException));
                    }
                    SibTr.error(tc, "CANNOT_CREATE_TCP_CHANNEL_SICJ0019", new Object[]{"OutboundTCPProxyChannelTCP", channelException});
                } else {
                    channelException = ChannelFrameworkReference.addChannel("OutboundJFAPChannelTCPProxy", clazz, null);
                }
                if (channelException != null) {
                    SibTr.error(tc, "CANNOT_CREATE_TCP_CHANNEL_SICJ0019", new Object[]{"OutboundJFAPChannelTCPProxy", channelException});
                } else {
                    try {
                        framework.addChain("_OutboundTCPProxyBridgeService", FlowType.OUTBOUND, new String[]{"OutboundJFAPChannelTCPProxy", "OutboundTCPProxyChannelTCP"});
                    }
                    catch (ChannelFrameworkException channelFrameworkException) {
                        FFDCFilter.processException((Throwable)channelFrameworkException, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference", (String)"00020013", (Object)framework);
                        if (tc.isEventEnabled()) {
                            SibTr.exception(tc, (Exception)((Object)channelFrameworkException));
                        }
                        SibTr.error(tc, "CANNOT_CREATE_DEFAULT_OUTBOUND_CHANNEL_SICJ0023", new Object[]{"BootstrapBasicMessaging", channelFrameworkException});
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "defineOutboundTCPProxyBridgeChain");
        }
    }

    private static ThreadPool findOrCreateThreadPool(String string, String string2, int n, String string3, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "findOrCreateThreadPool", new Object[]{string, string2, "" + n, string3, "" + n2});
        }
        ThreadPool threadPool = null;
        threadPool = framework.getThreadPool(string);
        if (threadPool == null) {
            int n3 = 0;
            int n4 = 0;
            try {
                n3 = Integer.parseInt(RuntimeInfo.getProperty(string2, "" + n));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n4 = Integer.parseInt(RuntimeInfo.getProperty(string3, "" + n2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                if (n3 < 1) {
                    n3 = n;
                }
                if (n4 < n3) {
                    n4 = n2;
                }
                try {
                    framework.addThreadPool(string, n3, n4);
                }
                catch (DuplicatePoolException duplicatePoolException) {
                    FFDCFilter.processException((Throwable)duplicatePoolException, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference", (String)"00020012");
                }
                threadPool = framework.getThreadPool(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "findOrCreateThreadPool", threadPool);
        }
        return threadPool;
    }

    private static void performCRAStartup() {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "performCRAStartup");
            }
            ThreadPool threadPool = framework.getDefaultThreadPool();
            try {
                threadPool.execute((Runnable)new ZosStartupRunnable());
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference.performCRAStartup", (String)"00020016");
                if (!tc.isEventEnabled()) break block4;
                SibTr.exception(tc, interruptedException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "performCRAStartup");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/ChannelFrameworkReference.java, SIB.comms, WAS602.SIB, o0610.11 1.32");
        }
        cached = false;
    }

    private static class ZosStartupRunnable
    implements Runnable {
        private ZosStartupRunnable() {
        }

        public void run() {
            block12: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry(this, tc, ".ZosStartupRunnable.run");
                }
                try {
                    boolean bl = false;
                    while (!bl) {
                        try {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(this, tc, "Attempting to start chain: _InboundTCPProxyBridgeService");
                            }
                            framework.startChain("_InboundTCPProxyBridgeService");
                            bl = true;
                        }
                        catch (RetryableChannelException retryableChannelException) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(this, tc, "Start failed with RetryableChannelException.  Backing off for 10 seconds before retrying operation.");
                            }
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Chain: _InboundTCPProxyBridgeService started.  Proceeding to start other messaging chains");
                    }
                    ChannelFrameworkReference.startInboundChains();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference.ZosStartupRunnable.run", (String)"ZosStartupThread");
                    if (!tc.isEventEnabled()) break block12;
                    SibTr.exception((Object)this, tc, exception);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, ".ZosStartupRunnable.run");
            }
        }
    }
}

