/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.mesupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.comms.CompHandshake;
import com.ibm.ws.sib.comms.ConnectionMetaData;
import com.ibm.ws.sib.comms.ConnectionProperties;
import com.ibm.ws.sib.comms.MEComponentHandshake;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.comms.MEConnectionListener;
import com.ibm.ws.sib.comms.NoCapacityException;
import com.ibm.ws.sib.comms.client.ConnectionMetaDataImpl;
import com.ibm.ws.sib.comms.common.CATHandshakeProperties;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.common.JFAPCommunicator;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.comms.server.mesupport.METransportReceiveListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.mfp.CompHandshakeFactory;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;

public class MEConnectionImpl
extends JFAPCommunicator
implements MEConnection {
    private static String CLASS_NAME = MEConnectionImpl.class.getName();
    private static final TraceComponent tc = SibTr.register(MEConnectionImpl.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    public static final int CLOSE_STATE_OPEN = 1;
    public static final int CLOSE_STATE_AWAITING_RESPONSE = 2;
    public static final int CLOSE_STATE_AWAITING_RESPONSE_PARALLEL_CLOSE = 3;
    public static final int CLOSE_STATE_CLOSED = 4;
    private JsMessagingEngine engine = null;
    private MEConnectionListener listener = null;
    private boolean handshakingComplete = false;
    private int connectionCloseState = 4;
    private String description = "";

    public MEConnectionImpl() {
        super(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(ConnectionProperties connectionProperties, MEComponentHandshake mEComponentHandshake) throws SIResourceException {
        Object object;
        Object object2;
        int n;
        ServerConnectionManager serverConnectionManager = null;
        METransportReceiveListener mETransportReceiveListener = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "connect");
        }
        if (connectionProperties == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NULL_CONNECTION_PROPERTIES_SICO2046", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".connect"), (String)"4-001-0002", (Object)this);
            throw sIErrorException;
        }
        if (mEComponentHandshake == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NULL_MECH_SICO2047", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".connect"), (String)"4-001-0003", (Object)this);
            throw sIErrorException;
        }
        if (this.connectionCloseState != 4) {
            throw new SIResourceException();
        }
        if (tc.isEntryEnabled()) {
            SibTr.debug(tc, "About to Connect to the Remote Messaging Engine");
        }
        serverConnectionManager = ServerConnectionManager.getRef();
        mETransportReceiveListener = new METransportReceiveListener();
        mETransportReceiveListener.outBoundSetup(this, this.engine);
        Conversation conversation = null;
        if (connectionProperties.getMode() == ConnectionProperties.HOSTNAME_PORT) {
            n = connectionProperties.getEndPoint().getPort();
            object2 = connectionProperties.getEndPoint().getHost();
            object = connectionProperties.getChainName();
            this.description = (String)object2 + ":" + n + " - " + (String)object;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Connecting to the Remote Messaging Engine with these connection parameters", new Object[]{object, object2, "" + n});
            }
            conversation = serverConnectionManager.connect(new InetSocketAddress((String)object2, n), mETransportReceiveListener, (String)object);
        } else {
            CFEndPoint cFEndPoint = connectionProperties.getWLMEndPointData();
            this.description = cFEndPoint.toString();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Connecting to remote messaging engine using wlm endpoint:" + cFEndPoint);
            }
            conversation = serverConnectionManager.connect(cFEndPoint, mETransportReceiveListener);
        }
        this.setConversation(conversation);
        this.createConversationState();
        ((ConversationState)conversation.getAttachment()).setCommsConnection(this);
        ((ConversationState)conversation.getAttachment()).setInitialRequestNumber(1);
        if (conversation.isFirst()) {
            n = 0;
            try {
                try {
                    this.initiateCommsHandshaking();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Handshake completed successfully");
                    }
                    n = 1;
                    object2 = (LinkLevelState)this.getConversation().getLinkLevelAttachment();
                    object = ((LinkLevelState)object2).getCatHandshakeProperties();
                    short s = ((CATHandshakeProperties)object).getMajorVersion();
                    try {
                        CompHandshake compHandshake = (CompHandshake)CompHandshakeFactory.getInstance();
                        compHandshake.compStartHandshake(this, s);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".connect"), (String)"4-001-0001", (Object)this);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "MFP unable to create CompHandshake Singleton", exception);
                        }
                        String string = nls.getFormattedMessage("CONNECT_EXCEPTION_SICO1001", new Object[]{exception}, null);
                        throw new SIResourceException(string, exception);
                    }
                    Object var13_17 = null;
                }
                catch (SIConnectionDroppedException sIConnectionDroppedException) {
                    throw new SIResourceException(sIConnectionDroppedException.getMessage(), sIConnectionDroppedException);
                }
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                try {
                    if (n != 0) {
                        conversation.handshakeComplete();
                        throw throwable;
                    }
                    conversation.handshakeFailed();
                    throw throwable;
                }
                catch (SIConnectionDroppedException sIConnectionDroppedException) {
                    if (!tc.isDebugEnabled()) throw new SIResourceException(sIConnectionDroppedException);
                    SibTr.debug(tc, "Connection dropped: ", sIConnectionDroppedException);
                    throw new SIResourceException(sIConnectionDroppedException);
                }
            }
            try {}
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                if (!tc.isDebugEnabled()) throw new SIResourceException(sIConnectionDroppedException);
                SibTr.debug(tc, "Connection dropped: ", sIConnectionDroppedException);
                throw new SIResourceException(sIConnectionDroppedException);
            }
            if (n != 0) {
                conversation.handshakeComplete();
            } else {
                conversation.handshakeFailed();
            }
        }
        mEComponentHandshake.connect(this);
        mETransportReceiveListener.registerCapacityChangeListener(this.getConversation());
        this.connectionCloseState = 1;
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "connect");
    }

    public void setMessagingEngine(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setMessagingEngine");
        }
        this.engine = jsMessagingEngine;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setMessagingEngine");
        }
    }

    public JsMessagingEngine getMessagingEngine() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getMessagingEngine");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMessagingEngine", this.engine);
        }
        return this.engine;
    }

    public String getConnectionInfo() {
        return this.description;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] trmHandshakeExchange(byte[] byArray) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException {
        byte[] byArray2;
        block13: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "trmHandshakeExchange");
            }
            if (this.handshakingComplete) {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("HANDSHAKE_NOT_COMPLETE_SICO2048", null, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".connect"), (String)"4-001-0006", (Object)this);
                throw sIErrorException;
            }
            if (this.connectionCloseState != 4) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Connection is not closed", (Object)("" + this.connectionCloseState));
                }
                throw new SIConnectionUnavailableException("");
            }
            WsByteBuffer wsByteBuffer = this.wrapToWsBuffer(byArray);
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = this.JFAPExchange(linkedList, 8, 7, true);
            WsByteBuffer wsByteBuffer2 = receivedData.getBuffer();
            try {
                try {
                    short s = this.getCommandCompletionCode(receivedData, 8);
                    if (s != 0) {
                        this.checkFor_SIConnectionLostException(receivedData, s);
                        this.checkFor_SIConnectionDroppedException(receivedData, s);
                        this.checkFor_SIConnectionUnavailableException(receivedData, s);
                        this.checkFor_SIErrorException(receivedData, s);
                        this.defaultChecker(receivedData, s);
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "No exception");
                    }
                    wsByteBuffer2.flip();
                    byArray2 = new byte[wsByteBuffer2.remaining()];
                    System.arraycopy(wsByteBuffer2.array(), wsByteBuffer2.arrayOffset(), byArray2, 0, wsByteBuffer2.remaining());
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".trmHandshakeExchange"), (String)"4-001-0005", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Exception", sIException);
                    }
                    throw new SIConnectionLostException(sIException.getMessage(), sIException);
                }
                Object var9_10 = null;
                if (receivedData == null) break block13;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "trmHandshakeExchange");
        }
        return byArray2;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void close() throws SIConnectionLostException {
        if (MEConnectionImpl.tc.isEntryEnabled()) {
            SibTr.entry(MEConnectionImpl.tc, "close");
        }
        if (this.connectionCloseState == 1) {
            var1_1 = (ConversationState)this.getConversation().getAttachment();
            var2_2 = var1_1.getList();
            this.connectionCloseState = 2;
            try {
                var3_3 = this.JFAPExchange(var2_2, 64, 7, true);
                var4_6 = this.getCommandCompletionCode(var3_3, 192);
                if (!MEConnectionImpl.tc.isDebugEnabled()) ** GOTO lbl27
                SibTr.debug(MEConnectionImpl.tc, "Completion code was: " + var4_6);
            }
            catch (NoCapacityException var3_4) {
                if (MEConnectionImpl.tc.isDebugEnabled()) {
                    SibTr.debug(this, MEConnectionImpl.tc, "received NoCapacityException whilst closing connection");
                }
                if (!MEConnectionImpl.tc.isEventEnabled()) ** GOTO lbl27
                SibTr.exception((Object)this, MEConnectionImpl.tc, var3_4);
            }
            catch (SIConnectionDroppedException var3_5) {
                throw new SIConnectionLostException(var3_5.getMessage(), var3_5);
            }
            finally {
                this.connectionCloseState = 4;
                this.getConversation().close();
            }
        } else if (MEConnectionImpl.tc.isDebugEnabled()) {
            SibTr.debug(MEConnectionImpl.tc, "Connection already closed / closing", (Object)("" + this.connectionCloseState));
        }
lbl27:
        // 7 sources

        if (MEConnectionImpl.tc.isEntryEnabled()) {
            SibTr.exit(MEConnectionImpl.tc, "close");
        }
    }

    public boolean hasCapacity(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "hasCapacity");
        }
        boolean bl = this.getConversation().hasCapacity(n);
        if (this.connectionCloseState == 4) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "hasCapacity");
        }
        return bl;
    }

    public void setMEConnectionListener(MEConnectionListener mEConnectionListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setMEConnectionListener", mEConnectionListener);
        }
        if (this.connectionCloseState != 1 || mEConnectionListener != null) {
            this.listener = mEConnectionListener;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setMEConnectionListener");
        }
    }

    public synchronized void send(JsMessage jsMessage, int n) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException, MessageEncodeFailedException, MessageCopyFailedException, IncorrectMessageTypeException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "send", new Object[]{jsMessage, "" + n});
        }
        if (this.connectionCloseState != 1) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Connection is not open", (Object)("" + this.connectionCloseState));
            }
            throw new SIConnectionUnavailableException("");
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        int n2 = 0;
        LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
        try {
            n2 = CommsUtils.encodeMessage(linkedList, this.getConversation(), jsMessage);
        }
        catch (MessageEncodeFailedException messageEncodeFailedException) {
            FFDCFilter.processException((Throwable)messageEncodeFailedException, (String)(CLASS_NAME + ".send"), (String)"4-001-0004", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Failed to Encode outbound JsMessage", messageEncodeFailedException);
            }
            throw messageEncodeFailedException;
        }
        WsByteBuffer wsByteBuffer = this.getWsBuffer(13);
        wsByteBuffer.putShort((short)this.getConnectionObjectID());
        wsByteBuffer.putInt(n2);
        wsByteBuffer.put((byte)0);
        linkedList.add(0, wsByteBuffer);
        wsByteBuffer.flip();
        CommsPMI.getMEStats().onWriteMessage(n2);
        CommsPMI.getMEDetailedStats().onSendMessage(n);
        try {
            this.JFAPSend(linkedList, 75, n, false);
        }
        catch (com.ibm.ws.sib.jfapchannel.NoCapacityException noCapacityException) {
            NoCapacityException noCapacityException2 = new NoCapacityException();
            noCapacityException2.initCause(noCapacityException);
            throw noCapacityException2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "send");
        }
    }

    public String toString() {
        String string = "MEConnection@" + System.identityHashCode(this) + this.description + " connectionCloseState: ";
        string = this.connectionCloseState == 1 ? string + "CLOSE_STATE_OPEN" : (this.connectionCloseState == 2 ? string + "CLOSE_STATE_AWAITING_RESPONSE" : (this.connectionCloseState == 3 ? string + "CLOSE_STATE_AWAITING_RESPONSE_PARALLEL_CLOSE" : string + "CLOSE_STATE_CLOSED"));
        return string;
    }

    public void inboundSetup(Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "inboundSetup", conversation);
        }
        this.setConversation(conversation);
        this.createConversationState();
        this.connectionCloseState = 1;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "inboundSetup");
        }
    }

    public synchronized void send(ControlMessage controlMessage, int n) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException, MessageEncodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "send", new Object[]{controlMessage, "" + n});
        }
        if (this.connectionCloseState != 1) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Connection is not open", (Object)("" + this.connectionCloseState));
            }
            throw new SIConnectionUnavailableException("");
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = null;
        try {
            list = controlMessage.encode(conversationState.getCommsConnection());
        }
        catch (MessageEncodeFailedException messageEncodeFailedException) {
            FFDCFilter.processException((Throwable)messageEncodeFailedException, (String)(CLASS_NAME + ".send"), (String)"4-001-0009", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Failed to Encode outbound JsMessage", messageEncodeFailedException);
            }
            throw messageEncodeFailedException;
        }
        LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            WsByteBuffer wsByteBuffer = this.wrapToWsBuffer((byte[])list.get(i));
            n2 += wsByteBuffer.limit();
            linkedList.add(wsByteBuffer);
        }
        WsByteBuffer wsByteBuffer = this.getWsBuffer(13);
        wsByteBuffer.putShort((short)this.getConnectionObjectID());
        wsByteBuffer.putInt(n2);
        wsByteBuffer.put((byte)1);
        linkedList.add(0, wsByteBuffer);
        wsByteBuffer.flip();
        CommsPMI.getMEStats().onWriteMessage(n2);
        CommsPMI.getMEDetailedStats().onSendMessage(n);
        try {
            this.JFAPSend(linkedList, 75, n, false);
        }
        catch (com.ibm.ws.sib.jfapchannel.NoCapacityException noCapacityException) {
            NoCapacityException noCapacityException2 = new NoCapacityException();
            noCapacityException2.initCause(noCapacityException);
            throw noCapacityException2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "send");
        }
    }

    public boolean isReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isReady");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isReady", new Boolean(this.connectionCloseState == 1));
        }
        return this.connectionCloseState == 1;
    }

    public int getCloseState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getCloseState");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getCloseState", (Object)("" + this.connectionCloseState));
        }
        return this.connectionCloseState;
    }

    public void setCloseState(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setCloseState", (Object)("" + n));
        }
        this.connectionCloseState = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setCloseState");
        }
    }

    public void sendMFPSchema(byte[] byArray) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendMFPSchema");
        }
        WsByteBuffer wsByteBuffer = this.wrapToWsBuffer(byArray);
        LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
        linkedList.add(wsByteBuffer);
        try {
            this.JFAPSend(linkedList, 230, 12, true);
        }
        catch (com.ibm.ws.sib.jfapchannel.NoCapacityException noCapacityException) {
            NoCapacityException noCapacityException2 = new NoCapacityException();
            noCapacityException2.initCause(noCapacityException);
            throw noCapacityException2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendMFPSchema");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] mfpHandshakeExchange(byte[] byArray) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException {
        byte[] byArray2;
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "mfpHandshakeExchange");
            }
            if (this.handshakingComplete) {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("HANDSHAKE_NOT_COMPLETE_SICO2048", null, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".mfpHandshakeExchange"), (String)"4-001-0008", (Object)this);
                throw sIErrorException;
            }
            if (this.connectionCloseState != 4) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Connection is not closed", (Object)("" + this.connectionCloseState));
                }
                throw new SIConnectionUnavailableException("");
            }
            WsByteBuffer wsByteBuffer = this.wrapToWsBuffer(byArray);
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = this.JFAPExchange(linkedList, 9, 7, true);
            WsByteBuffer wsByteBuffer2 = receivedData.getBuffer();
            try {
                try {
                    short s = this.getCommandCompletionCode(receivedData, 9);
                    if (s != 0) {
                        this.checkFor_SIConnectionLostException(receivedData, s);
                        this.checkFor_SIConnectionDroppedException(receivedData, s);
                        this.checkFor_SIConnectionUnavailableException(receivedData, s);
                        this.checkFor_SIErrorException(receivedData, s);
                        this.defaultChecker(receivedData, s);
                    }
                    wsByteBuffer2.flip();
                    byArray2 = new byte[wsByteBuffer2.remaining()];
                    System.arraycopy(wsByteBuffer2.array(), wsByteBuffer2.arrayOffset(), byArray2, 0, wsByteBuffer2.remaining());
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".mfpHandshakeExchange"), (String)"4-001-0007", (Object)this);
                    throw new SIConnectionLostException(sIException.getMessage(), sIException);
                }
                Object var9_10 = null;
                if (receivedData == null) break block11;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "mfpHandshakeExchange");
        }
        return byArray2;
    }

    public Object getUniqueLinkObject() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getUniqueLinkObject");
            SibTr.exit(tc, "getUniqueLinkObject");
        }
        return this.getConversation().getLinkLevelAttachment();
    }

    public ConnectionMetaData getMetaData() {
        LinkLevelState linkLevelState = (LinkLevelState)this.getConversation().getLinkLevelAttachment();
        return new ConnectionMetaDataImpl(this.getConversation().getMetaData(), linkLevelState.getCatHandshakeProperties());
    }

    public synchronized void send(List list, int n, boolean bl) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException, MessageEncodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "send", new Object[]{list, "" + n});
        }
        if (this.connectionCloseState != 1) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Connection is not open", (Object)("" + this.connectionCloseState));
            }
            throw new SIConnectionUnavailableException("");
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            WsByteBuffer wsByteBuffer = this.wrapToWsBuffer((byte[])list.get(i));
            n2 += wsByteBuffer.limit();
            linkedList.add(wsByteBuffer);
        }
        WsByteBuffer wsByteBuffer = this.getWsBuffer(13);
        wsByteBuffer.putShort((short)this.getConnectionObjectID());
        wsByteBuffer.putInt(n2);
        if (bl) {
            wsByteBuffer.put((byte)1);
        } else {
            wsByteBuffer.put((byte)0);
        }
        linkedList.add(0, wsByteBuffer);
        wsByteBuffer.flip();
        CommsPMI.getMEStats().onWriteMessage(n2);
        CommsPMI.getMEDetailedStats().onSendMessage(n);
        try {
            this.JFAPSend(linkedList, 75, n, false);
        }
        catch (com.ibm.ws.sib.jfapchannel.NoCapacityException noCapacityException) {
            NoCapacityException noCapacityException2 = new NoCapacityException();
            noCapacityException2.initCause(noCapacityException);
            throw noCapacityException2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "send");
        }
    }

    public int getLowestPriorityWithCapacity() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getLowestPriorityWithCapacity");
        }
        int n = this.getConversation().getLowestPriorityWithCapacity();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getLowestPriorityWithCapacity", "" + n);
        }
        return n;
    }

    public byte[] requestMFPSchemata(byte[] byArray) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "requestMFPSchemata", byArray);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "requestMFPSchemata", null);
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INVALID_METHOD_ON_SERVER_SICO2057", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".requestMFPSchemata"), (String)"4-001-0010", (Object)this);
        throw sIErrorException;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/mesupport/MEConnectionImpl.java, SIB.comms, WAS602.SIB, o0610.11 1.65");
        }
    }
}

