/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.XidProxy;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class StaticCATXATransaction {
    private static String CLASS_NAME = StaticCATXATransaction.class.getName();
    private static WsByteBufferPoolManager bbPoolManager = null;
    private static final TraceComponent tc = SibTr.register(StaticCATXATransaction.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    public static void rcvXAOpen(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvXAOpen", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        int n2 = wsByteBuffer.getInt();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Connection Object ID", new Short(s));
            SibTr.debug(tc, "Transaction ID", new Integer(n2));
        }
        try {
            conversation.send(list, 176, n, 7, true, null, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvXAOpen"), (String)"3-013-0001");
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2027", sIException);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvXAOpen");
        }
    }

    public static void rcvXAStart(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvXAStart", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        try {
            int n2 = wsByteBuffer.getInt();
            CATConnection cATConnection = (CATConnection)conversationState.getObject(conversationState.getConnectionObjectId());
            SICoreConnection sICoreConnection = cATConnection.getSICoreConnection();
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            SIXAResource sIXAResource = null;
            try {
                sIXAResource = sICoreConnection.getSIXAResource();
            }
            catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                FFDCFilter.processException((Throwable)sIConnectionUnavailableException, (String)(CLASS_NAME + ".rcvXAStart"), (String)"3-013-0030");
                if (tc.isEventEnabled()) {
                    SibTr.exception(tc, sIConnectionUnavailableException);
                }
                throw new SIErrorException(sIConnectionUnavailableException);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)(CLASS_NAME + ".rcvXAStart"), (String)"3-013-0031");
                if (tc.isEventEnabled()) {
                    SibTr.exception(tc, sIResourceException);
                }
                throw new XAException(-3);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAResource Object ID", new Integer(n2));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Getting Xid");
            }
            XidProxy xidProxy = new XidProxy(wsByteBuffer);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Completed:", xidProxy);
            }
            int n3 = wsByteBuffer.getInt();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Flags: ", new Integer(n3));
            }
            sIXAResource.start(xidProxy, n3);
            linkLevelState.getTransactionTable().addGlobalTran(n2, cATConnection, sIXAResource, xidProxy);
            try {
                conversation.send(list, 177, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvXAStart"), (String)"3-013-0003");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2027", sIException);
            }
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)(CLASS_NAME + ".rcvXAStart"), (String)"3-013-0004");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAException - RC: " + xAException.errorCode, xAException);
            }
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0004", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvXAStart");
        }
    }

    public static void rcvXAEnd(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvXAEnd", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        try {
            int n2 = wsByteBuffer.getInt();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAResource Object ID", new Integer(n2));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Getting Xid");
            }
            XidProxy xidProxy = new XidProxy(wsByteBuffer);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Completed:", xidProxy);
            }
            int n3 = wsByteBuffer.getInt();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Flags: ", new Integer(n3));
            }
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            CATTransaction cATTransaction = linkLevelState.getTransactionTable().get(n2, true);
            CATConnection cATConnection = (CATConnection)conversationState.getObject(conversationState.getConnectionObjectId());
            SIXAResource sIXAResource = StaticCATXATransaction.getResourceFromTran(cATTransaction, cATConnection);
            sIXAResource.end(xidProxy, n3);
            try {
                conversation.send(list, 178, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvXAClose"), (String)"3-013-0006");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2027", sIException);
            }
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            FFDCFilter.processException((Throwable)sIIncorrectCallException, (String)(CLASS_NAME + ".rcvXAClose"), (String)"3-013-0008");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transaction already completed", sIIncorrectCallException);
            }
            XAException xAException = new XAException(-3);
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0008", conversation, n);
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)(CLASS_NAME + ".rcvXAClose"), (String)"3-013-0007");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAException - RC: " + xAException.errorCode, xAException);
            }
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0007", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvXAEnd");
        }
    }

    public static void rcvXAPrepare(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvXAPrepare", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        try {
            int n2 = wsByteBuffer.getInt();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAResource Object ID", new Integer(n2));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Getting Xid");
            }
            XidProxy xidProxy = new XidProxy(wsByteBuffer);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Completed:", xidProxy);
            }
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            CATTransaction cATTransaction = linkLevelState.getTransactionTable().get(n2, true);
            CATConnection cATConnection = (CATConnection)conversationState.getObject(conversationState.getConnectionObjectId());
            SIXAResource sIXAResource = StaticCATXATransaction.getResourceFromTran(cATTransaction, cATConnection);
            if (cATTransaction != null && cATTransaction.isMarkedAsError()) {
                sIXAResource.rollback(xidProxy);
                linkLevelState.getTransactionTable().removeGlobalTran(n2, xidProxy);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "The transaction was marked as error due to", cATTransaction.getFirstException());
                }
                XAException xAException = new XAException(nls.getFormattedMessage("TRANSACTION_MARKED_AS_ERROR_SICO2029", new Object[]{cATTransaction.getFirstException()}, null));
                xAException.initCause(cATTransaction.getFirstException());
                xAException.errorCode = 104;
                throw xAException;
            }
            int n3 = sIXAResource.prepare(xidProxy);
            if (cATTransaction != null) {
                linkLevelState.getTransactionTable().removeGlobalTran(n2, xidProxy);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Prepare returned: " + n3);
            }
            WsByteBuffer wsByteBuffer2 = bbPoolManager.allocate(4);
            wsByteBuffer2.putInt(n3);
            wsByteBuffer2.flip();
            list.add(wsByteBuffer2);
            try {
                conversation.send(list, 179, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvXAPrepare"), (String)"3-013-0009");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2027", sIException);
            }
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            FFDCFilter.processException((Throwable)sIIncorrectCallException, (String)(CLASS_NAME + ".rcvXAPrepare"), (String)"3-013-0011");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transaction already completed", sIIncorrectCallException);
            }
            XAException xAException = new XAException(-3);
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0011", conversation, n);
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)(CLASS_NAME + ".rcvXAPrepare"), (String)"3-013-0010");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAException - RC: " + xAException.errorCode, xAException);
            }
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0010", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvXAPrepare");
        }
    }

    public static void rcvXACommit(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvXACommit", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        boolean bl3 = false;
        try {
            byte by;
            int n2 = wsByteBuffer.getInt();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAResource Object ID", new Integer(n2));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Getting Xid");
            }
            XidProxy xidProxy = new XidProxy(wsByteBuffer);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Completed:", xidProxy);
            }
            if ((by = wsByteBuffer.get()) == 1) {
                bl3 = true;
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "One phase:", new Boolean(bl3));
            }
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            CATTransaction cATTransaction = linkLevelState.getTransactionTable().get(n2, true);
            CATConnection cATConnection = (CATConnection)conversationState.getObject(conversationState.getConnectionObjectId());
            SIXAResource sIXAResource = StaticCATXATransaction.getResourceFromTran(cATTransaction, cATConnection);
            if (cATTransaction != null && cATTransaction.isMarkedAsError()) {
                sIXAResource.rollback(xidProxy);
                linkLevelState.getTransactionTable().removeGlobalTran(n2, xidProxy);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "The transaction was marked as error due to", cATTransaction.getFirstException());
                }
                XAException xAException = new XAException(nls.getFormattedMessage("TRANSACTION_MARKED_AS_ERROR_SICO2029", new Object[]{cATTransaction.getFirstException()}, null));
                xAException.initCause(cATTransaction.getFirstException());
                xAException.errorCode = 104;
                throw xAException;
            }
            sIXAResource.commit(xidProxy, bl3);
            if (cATTransaction != null) {
                linkLevelState.getTransactionTable().removeGlobalTran(n2, xidProxy);
            }
            try {
                conversation.send(list, 180, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvXACommit"), (String)"3-013-0012");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2027", sIException);
            }
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            FFDCFilter.processException((Throwable)sIIncorrectCallException, (String)(CLASS_NAME + ".rcvXACommit"), (String)"3-013-0014");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transaction already completed", sIIncorrectCallException);
            }
            XAException xAException = new XAException(-3);
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0014", conversation, n);
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)(CLASS_NAME + ".rcvXACommit"), (String)"3-013-0013");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAException - RC: " + xAException.errorCode, xAException);
            }
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0013", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvXACommit");
        }
    }

    public static void rcvXARollback(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvXARollback", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        try {
            int n2 = wsByteBuffer.getInt();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAResource Object ID", new Integer(n2));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Getting Xid");
            }
            XidProxy xidProxy = new XidProxy(wsByteBuffer);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Completed:", xidProxy);
            }
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            CATTransaction cATTransaction = linkLevelState.getTransactionTable().get(n2, true);
            CATConnection cATConnection = (CATConnection)conversationState.getObject(conversationState.getConnectionObjectId());
            SIXAResource sIXAResource = StaticCATXATransaction.getResourceFromTran(cATTransaction, cATConnection);
            sIXAResource.rollback(xidProxy);
            if (cATTransaction != null) {
                linkLevelState.getTransactionTable().removeGlobalTran(n2, xidProxy);
            }
            try {
                conversation.send(list, 181, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvXARollback"), (String)"3-013-0015");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2027", sIException);
            }
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            FFDCFilter.processException((Throwable)sIIncorrectCallException, (String)(CLASS_NAME + ".rcvXARollback"), (String)"3-013-0017");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transaction already completed", sIIncorrectCallException);
            }
            XAException xAException = new XAException(-3);
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0017", conversation, n);
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)(CLASS_NAME + ".rcvXARollback"), (String)"3-013-0016");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAException - RC: " + xAException.errorCode, xAException);
            }
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0016", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvXARollback");
        }
    }

    public static void rcvXARecover(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvXARecover", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        try {
            CATConnection cATConnection;
            LinkLevelState linkLevelState;
            CATTransaction cATTransaction;
            SIXAResource sIXAResource;
            Xid[] xidArray;
            int n2 = wsByteBuffer.getInt();
            int n3 = wsByteBuffer.getInt();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAResource Object ID", new Integer(n2));
                SibTr.debug(tc, "Flags: ", new Integer(n3));
            }
            if ((xidArray = (sIXAResource = StaticCATXATransaction.getResourceFromTran(cATTransaction = (linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment()).getTransactionTable().get(n2, true), cATConnection = (CATConnection)conversationState.getObject(conversationState.getConnectionObjectId()))).recover(n3)) == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "recover() returned null");
                }
                WsByteBuffer wsByteBuffer2 = bbPoolManager.allocate(2);
                wsByteBuffer2.putShort((short)0);
                wsByteBuffer2.flip();
                list.add(wsByteBuffer2);
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Serializing " + xidArray.length + " Xids");
                }
                WsByteBuffer wsByteBuffer3 = bbPoolManager.allocate(2);
                wsByteBuffer3.putShort((short)xidArray.length);
                wsByteBuffer3.flip();
                list.add(wsByteBuffer3);
                for (int i = 0; i < xidArray.length; ++i) {
                    XidProxy xidProxy = new XidProxy(xidArray[i]);
                    WsByteBuffer wsByteBuffer4 = bbPoolManager.allocate(2 + xidProxy.getSerializableLength());
                    xidProxy.serialize(wsByteBuffer4);
                    wsByteBuffer4.flip();
                    list.add(wsByteBuffer4);
                }
            }
            try {
                conversation.send(list, 182, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvXARecover"), (String)"3-013-0018");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2027", sIException);
            }
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            FFDCFilter.processException((Throwable)sIIncorrectCallException, (String)(CLASS_NAME + ".rcvXARecover"), (String)"3-013-0020");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transaction already completed", sIIncorrectCallException);
            }
            XAException xAException = new XAException(-3);
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0020", conversation, n);
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)(CLASS_NAME + ".rcvXARecover"), (String)"3-013-0019");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAException - RC: " + xAException.errorCode, xAException);
            }
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0019", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvXARecover");
        }
    }

    public static void rcvXAForget(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvXAForget", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        try {
            int n2 = wsByteBuffer.getInt();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAResource Object ID", new Integer(n2));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Getting Xid");
            }
            XidProxy xidProxy = new XidProxy(wsByteBuffer);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Completed:", xidProxy);
            }
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            CATTransaction cATTransaction = linkLevelState.getTransactionTable().get(n2, true);
            CATConnection cATConnection = (CATConnection)conversationState.getObject(conversationState.getConnectionObjectId());
            SIXAResource sIXAResource = StaticCATXATransaction.getResourceFromTran(cATTransaction, cATConnection);
            sIXAResource.forget(xidProxy);
            if (cATTransaction != null) {
                linkLevelState.getTransactionTable().removeGlobalTran(n2, xidProxy);
            }
            try {
                conversation.send(list, 183, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvXAForget"), (String)"3-013-0021");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2027", sIException);
            }
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            FFDCFilter.processException((Throwable)sIIncorrectCallException, (String)(CLASS_NAME + ".rcvXAForget"), (String)"3-013-0023");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transaction already completed", sIIncorrectCallException);
            }
            XAException xAException = new XAException(-3);
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0023", conversation, n);
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)(CLASS_NAME + ".rcvXAForget"), (String)"3-013-0022");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAException - RC: " + xAException.errorCode, xAException);
            }
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0022", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvXAForget");
        }
    }

    public static void rcvXA_getTxTimeout(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvXA_getTxTimeout", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        try {
            int n2 = wsByteBuffer.getInt();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAResource Object ID", new Integer(n2));
            }
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            CATTransaction cATTransaction = linkLevelState.getTransactionTable().get(n2, true);
            int n3 = 0;
            if (cATTransaction != null) {
                SIXAResource sIXAResource = (SIXAResource)cATTransaction.getSITransaction();
                n3 = sIXAResource.getTransactionTimeout();
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Timeout: " + n3);
            }
            WsByteBuffer wsByteBuffer2 = bbPoolManager.allocate(4);
            wsByteBuffer2.putInt(n3);
            wsByteBuffer2.flip();
            list.add(wsByteBuffer2);
            try {
                conversation.send(list, 184, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvXA_getTxTimeout"), (String)"3-013-0024");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2027", sIException);
            }
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            FFDCFilter.processException((Throwable)sIIncorrectCallException, (String)(CLASS_NAME + ".rcvXA_getTxTimeout"), (String)"3-013-0026");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transaction already completed", sIIncorrectCallException);
            }
            XAException xAException = new XAException(-3);
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0026", conversation, n);
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)(CLASS_NAME + ".rcvXA_getTxTimeout"), (String)"3-013-0025");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAException - RC: " + xAException.errorCode, xAException);
            }
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0025", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvXA_getTxTimeout");
        }
    }

    public static void rcvXA_setTxTimeout(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvXA_setTxTimeout", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        try {
            SIXAResource sIXAResource;
            int n2 = wsByteBuffer.getInt();
            int n3 = wsByteBuffer.getInt();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAResource Object ID", new Integer(n2));
                SibTr.debug(tc, "Timeout", new Integer(n3));
            }
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            CATTransaction cATTransaction = linkLevelState.getTransactionTable().get(n2, true);
            boolean bl3 = false;
            if (cATTransaction != null) {
                sIXAResource = (SIXAResource)cATTransaction.getSITransaction();
                bl3 = sIXAResource.setTransactionTimeout(n3);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Result: " + bl3);
            }
            sIXAResource = bbPoolManager.allocate(1);
            if (bl3) {
                sIXAResource.put((byte)1);
            } else {
                sIXAResource.put((byte)0);
            }
            sIXAResource.flip();
            list.add(sIXAResource);
            try {
                conversation.send(list, 185, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvXA_setTxTimeout"), (String)"3-013-0027");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2027", sIException);
            }
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            FFDCFilter.processException((Throwable)sIIncorrectCallException, (String)(CLASS_NAME + ".rcvXA_setTxTimeout"), (String)"3-013-0029");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transaction already completed", sIIncorrectCallException);
            }
            XAException xAException = new XAException(-3);
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0029", conversation, n);
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, (String)(CLASS_NAME + ".rcvXA_setTxTimeout"), (String)"3-013-0028");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "XAException - RC: " + xAException.errorCode, xAException);
            }
            StaticCATHelper.sendExceptionToClient(xAException, "3-013-0028", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvXA_setTxTimeout");
        }
    }

    private static SIXAResource getResourceFromTran(CATTransaction cATTransaction, CATConnection cATConnection) throws SIIncorrectCallException, XAException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getResourceFromTran", new Object[]{cATTransaction, cATConnection});
        }
        SIXAResource sIXAResource = null;
        if (cATTransaction != null) {
            sIXAResource = (SIXAResource)cATTransaction.getSITransaction();
        } else {
            try {
                sIXAResource = cATConnection.getSICoreConnection().getSIXAResource();
            }
            catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                FFDCFilter.processException((Throwable)sIConnectionUnavailableException, (String)(CLASS_NAME + ".getResourceFromTran"), (String)"3-013-0032");
                if (tc.isEventEnabled()) {
                    SibTr.exception(tc, sIConnectionUnavailableException);
                }
                throw new SIErrorException(sIConnectionUnavailableException);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)(CLASS_NAME + ".getResourceFromTran"), (String)"3-013-0033");
                if (tc.isEventEnabled()) {
                    SibTr.exception(tc, sIResourceException);
                }
                throw new XAException(-3);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getResourceFromTran", sIXAResource);
        }
        return sIXAResource;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATXATransaction.java, SIB.comms, WAS602.SIB, o0610.11 1.26");
        }
    }
}

