/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsString;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.ObjectStoreFullException;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import java.util.List;

public class StaticCATSubscription {
    private static String CLASS_NAME = StaticCATSubscription.class.getName();
    private static WsByteBufferPoolManager bbPoolManager = null;
    private static final TraceComponent tc = SibTr.register(StaticCATSubscription.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    public static void rcvCreateDurableSub(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCreateDurableSub", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        CommsString commsString = conversationState.getCommsString();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        short s2 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "ConnectionObjectId:", new Short(s));
            SibTr.debug(tc, "ConsumerFlags:", new Short(s2));
        }
        if (s2 > 7) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Consumer flags (" + s2 + ") > 0x07");
            }
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INVALID_PROP_SICO8014", new Object[]{"" + s2}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".rcvCreateDurableSub"), (String)"3-011-0003");
        }
        boolean bl3 = (s2 & 2) != 0;
        boolean bl4 = (s2 & 4) != 0;
        SIDestinationAddress sIDestinationAddress = CommsUtils.getSIDestinationAddress(wsByteBuffer);
        short s3 = wsByteBuffer.getShort();
        byte[] byArray = new byte[s3];
        wsByteBuffer.get(byArray, 0, new Integer(s3).intValue());
        commsString.setBytes(byArray);
        String string = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Subscription Name:", (Object)string);
        }
        short s4 = wsByteBuffer.getShort();
        byte[] byArray2 = new byte[s4];
        wsByteBuffer.get(byArray2, 0, new Integer(s4).intValue());
        commsString.setBytes(byArray2);
        String string2 = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Subscription Home:", (Object)string2);
        }
        SelectionCriteria selectionCriteria = CommsUtils.getSelectionCriteria(wsByteBuffer);
        SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
        short s5 = wsByteBuffer.getShort();
        byte[] byArray3 = new byte[s5];
        wsByteBuffer.get(byArray3);
        CommsString commsString2 = new CommsString();
        commsString2.setBytes(byArray3);
        String string3 = commsString2.getString();
        try {
            sICoreConnection.createDurableSubscription(string, string2, sIDestinationAddress, selectionCriteria, bl4, bl3, string3);
            try {
                conversation.send(list, 195, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCreateDurableSub"), (String)"3-011-0001");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2025", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCreateDurableSub"), (String)"3-011-0002");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-011-0002", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCreateDurableSub");
        }
    }

    public static void rcvCreateConsumerForDurableSub(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        List list;
        ConversationState conversationState;
        block24: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "rcvCreateConsumerForDurableSub", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
            }
            if (bbPoolManager == null) {
                bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
            }
            conversationState = (ConversationState)conversation.getAttachment();
            CommsString commsString = conversationState.getCommsString();
            list = conversationState.getList();
            wsByteBuffer.flip();
            short s = wsByteBuffer.getShort();
            short s2 = wsByteBuffer.getShort();
            short s3 = wsByteBuffer.getShort();
            short s4 = wsByteBuffer.getShort();
            int n2 = wsByteBuffer.getInt();
            short s5 = wsByteBuffer.getShort();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "ConnectionObjectId:", new Short(s));
                SibTr.debug(tc, "ClientSessionId:", new Short(s2));
                SibTr.debug(tc, "ConsumerFlags:", new Short(s3));
                SibTr.debug(tc, "Reliability:", new Short(s4));
                SibTr.debug(tc, "RequestedBytes:", new Integer(n2));
                SibTr.debug(tc, "UnrecovReliability", new Short(s5));
            }
            try {
                Reliability reliability = null;
                if (s4 != -1) {
                    reliability = Reliability.getReliability(s4);
                }
                if (s3 > 7) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Consumer flags (" + s3 + ") > 0x07");
                    }
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INVALID_PROP_SICO8014", new Object[]{"" + s3}, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".rcvCreateConsumerForDurableSub"), (String)"3-011-0010");
                }
                boolean bl3 = (s3 & 1) != 0;
                boolean bl4 = (s3 & 2) != 0;
                boolean bl5 = (s3 & 4) != 0;
                boolean bl6 = (s3 & 0x40) != 0;
                Reliability reliability2 = null;
                if (s5 != -1) {
                    reliability2 = Reliability.getReliability(s5);
                }
                SIDestinationAddress sIDestinationAddress = CommsUtils.getSIDestinationAddress(wsByteBuffer);
                short s6 = wsByteBuffer.getShort();
                byte[] byArray = new byte[s6];
                wsByteBuffer.get(byArray, 0, new Integer(s6).intValue());
                commsString.setBytes(byArray);
                String string = commsString.getString();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Subscription Name:", (Object)string);
                }
                short s7 = wsByteBuffer.getShort();
                byte[] byArray2 = new byte[s7];
                wsByteBuffer.get(byArray2, 0, new Integer(s7).intValue());
                commsString.setBytes(byArray2);
                String string2 = commsString.getString();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Subscription Home:", (Object)string2);
                }
                SelectionCriteria selectionCriteria = CommsUtils.getSelectionCriteria(wsByteBuffer);
                SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
                short s8 = wsByteBuffer.getShort();
                byte[] byArray3 = new byte[s8];
                wsByteBuffer.get(byArray3);
                CommsString commsString2 = new CommsString();
                commsString2.setBytes(byArray3);
                String string3 = commsString2.getString();
                try {
                    ConsumerSession consumerSession = sICoreConnection.createConsumerSessionForDurableSubscription(string, string2, sIDestinationAddress, selectionCriteria, bl5, bl4, reliability, bl3, reliability2, bl6, string3);
                    CATMainConsumer cATMainConsumer = new CATMainConsumer(conversation, s2, consumerSession, bl3, false, bl4, reliability2);
                    short s9 = (short)conversationState.addObject(cATMainConsumer);
                    cATMainConsumer.setConsumerSessionId(s9);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Durable Subscription Id:", new Short(s9));
                    }
                    StaticCATHelper.sendSessionCreateResponse(231, n, conversation, s9, consumerSession, sIDestinationAddress);
                    if (!bl3) break block24;
                    try {
                        cATMainConsumer.setRequestedBytes(n2);
                        cATMainConsumer.setAsynchConsumerCallback(n, 0, 0L, 1, null);
                        cATMainConsumer.start(n, false);
                    }
                    catch (RuntimeException runtimeException) {
                        FFDCFilter.processException((Throwable)runtimeException, (String)(CLASS_NAME + ".rcvCreateConsumerForDurableSub"), (String)"3-011-0006");
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Unable to create readahead async consumer");
                            SibTr.exception(tc, (Exception)runtimeException.getCause());
                        }
                        throw new SIResourceException(runtimeException.getMessage());
                    }
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCreateConsumerForDurableSub"), (String)"3-011-0007");
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, sIException.getMessage(), sIException);
                    }
                    StaticCATHelper.sendExceptionToClient(sIException, "3-011-0007", conversation, n);
                }
                catch (ObjectStoreFullException objectStoreFullException) {
                    FFDCFilter.processException((Throwable)objectStoreFullException, (String)(CLASS_NAME + ".rcvCreateConsumerForDurableSub"), (String)"3-011-0008");
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, objectStoreFullException.getMessage(), objectStoreFullException);
                    }
                    StaticCATHelper.sendExceptionToClient(objectStoreFullException, "3-011-0008", conversation, n);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".rcvCreateConsumerForDurableSub"), (String)"3-011-0009");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, exception.getMessage(), exception);
                }
                StaticCATHelper.sendExceptionToClient(exception, "3-011-0009", conversation, n);
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCreateConsumerForDurableSub");
        }
    }

    public static void rcvDeleteDurableSub(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvDeleteDurableSub", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        CommsString commsString = conversationState.getCommsString();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "ConnectionObjectId:", new Short(s));
        }
        short s2 = wsByteBuffer.getShort();
        byte[] byArray = new byte[s2];
        wsByteBuffer.get(byArray, 0, new Integer(s2).intValue());
        commsString.setBytes(byArray);
        String string = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Subscription Name:", (Object)string);
        }
        short s3 = wsByteBuffer.getShort();
        byte[] byArray2 = new byte[s3];
        wsByteBuffer.get(byArray2, 0, new Integer(s3).intValue());
        commsString.setBytes(byArray2);
        String string2 = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Subscription Home:", (Object)string2);
        }
        SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
        try {
            sICoreConnection.deleteDurableSubscription(string, string2);
            try {
                conversation.send(list, 196, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvDeleteDurableSub"), (String)"3-011-0004");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2025", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvDeleteDurableSub"), (String)"3-011-0005");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-011-0005", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvDeleteDurableSub");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATSubscription.java, SIB.comms, WAS602.SIB, o0610.11 1.43");
        }
    }
}

