/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CATHandshakeProperties;
import com.ibm.ws.sib.comms.common.CommsString;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.comms.server.ObjectStoreFullException;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATOrderingContext;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.comms.server.clientsupport.CachedSessionProperties;
import com.ibm.ws.sib.comms.server.clientsupport.MulticastConsumerSession;
import com.ibm.ws.sib.comms.server.clientsupport.ServerSICoreConnectionListener;
import com.ibm.ws.sib.comms.server.clientsupport.ServerSideConnection;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import java.util.Iterator;
import java.util.List;

public class StaticCATConnection {
    private static String CLASS_NAME = StaticCATConnection.class.getName();
    private static WsByteBufferPoolManager bbPoolManager = null;
    private static final TraceComponent tc = SibTr.register(StaticCATConnection.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");

    static void rcvReceiveConnMsg(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvReceiveConnMsg", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        int n2 = wsByteBuffer.getInt();
        short s2 = wsByteBuffer.getShort();
        long l = wsByteBuffer.getLong();
        short s3 = wsByteBuffer.getShort();
        short s4 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "consumerObjectId", new Short(s));
            SibTr.debug(tc, "transactionId", new Integer(n2));
            SibTr.debug(tc, "reliability", new Short(s2));
            SibTr.debug(tc, "timeout", new Long(l));
            SibTr.debug(tc, "destinationType", new Short(s3));
            SibTr.debug(tc, "Unrecov Reliability", new Short(s4));
        }
        Reliability reliability = null;
        if (s2 != -1) {
            reliability = Reliability.getReliability(s2);
        }
        DestinationType destinationType = null;
        if (s3 != -1) {
            destinationType = DestinationType.getDestinationType(s3);
        }
        Reliability reliability2 = Reliability.getReliability(s4);
        SIDestinationAddress sIDestinationAddress = CommsUtils.getSIDestinationAddress(wsByteBuffer);
        SelectionCriteria selectionCriteria = CommsUtils.getSelectionCriteria(wsByteBuffer);
        short s5 = wsByteBuffer.getShort();
        byte[] byArray = new byte[s5];
        wsByteBuffer.get(byArray);
        CommsString commsString = new CommsString();
        commsString.setBytes(byArray);
        String string = commsString.getString();
        SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
        CATTransaction cATTransaction = null;
        if (n2 != 0) {
            object = (LinkLevelState)conversation.getLinkLevelAttachment();
            cATTransaction = ((LinkLevelState)object).getTransactionTable().get(n2);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Cached destination is: " + conversationState.getCachedConsumerProps());
        }
        object = new CachedSessionProperties(sIDestinationAddress, selectionCriteria, reliability);
        CATMainConsumer cATMainConsumer = conversationState.getCachedConsumer();
        if (conversationState.getCachedConsumer() == null || !((CachedSessionProperties)object).equals(conversationState.getCachedConsumerProps())) {
            try {
                if (cATMainConsumer != null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Cached consumer was not null. Closing old session");
                    }
                    cATMainConsumer.getConsumerSession().close();
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Creating new session");
                }
                ConsumerSession consumerSession = sICoreConnection.createConsumerSession(sIDestinationAddress, destinationType, selectionCriteria, reliability, false, false, reliability2, false, string);
                cATMainConsumer = new CATMainConsumer(conversation, 0, consumerSession, false, false, false, reliability2);
                cATMainConsumer.setUsingConnectionReceive(true);
                cATMainConsumer.start(n, false);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvReceiveConnMsg"), (String)"3-006-0009");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                StaticCATHelper.sendExceptionToClient(sIException, "3-006-0009", conversation, n);
            }
            conversationState.setCachedConsumerProps((CachedSessionProperties)object);
            conversationState.setCachedConsumer(cATMainConsumer);
        }
        cATMainConsumer.receive(n, cATTransaction, l);
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvReceiveConnMsg");
        }
    }

    static void rcvCloneConnection(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCloneConnection", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "conversationId", new Short(s));
        }
        SICoreConnection sICoreConnection = ((LinkLevelState)conversation.getLinkLevelAttachment()).getSICoreConnectionTable().get(s);
        try {
            ServerSideConnection serverSideConnection = new ServerSideConnection(conversation);
            conversationState.setCommsConnection(serverSideConnection);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Clone the original connection");
            }
            SICoreConnection sICoreConnection2 = sICoreConnection.cloneConnection();
            serverSideConnection.setSICoreConnection(sICoreConnection2);
            CATConnection cATConnection = new CATConnection(sICoreConnection2);
            CommsPMI.getClientStats().onApiConnect();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Add global connection listener");
            }
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            ServerSICoreConnectionListener serverSICoreConnectionListener = linkLevelState.getSICoreConnectionListener();
            serverSICoreConnectionListener.addSICoreConnection(sICoreConnection2, conversation);
            sICoreConnection2.addConnectionListener(serverSICoreConnectionListener);
            short s2 = (short)conversationState.addObject(cATConnection);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "clonedConnectionID", new Short(s2));
            }
            conversationState.setConnectionObjectId(s2);
            WsByteBuffer wsByteBuffer2 = bbPoolManager.allocate(2);
            wsByteBuffer2.putShort(s2);
            wsByteBuffer2.flip();
            list.add(wsByteBuffer2);
            try {
                conversation.send(list, 227, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCloneConnection"), (String)"3-006-0001");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2021", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCloneConnection"), (String)"3-006-0002");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-006-0002", conversation, n);
        }
        catch (ObjectStoreFullException objectStoreFullException) {
            FFDCFilter.processException((Throwable)objectStoreFullException, (String)(CLASS_NAME + ".rcvCloneConnection"), (String)"3-006-0003");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, objectStoreFullException.getMessage(), objectStoreFullException);
            }
            StaticCATHelper.sendExceptionToClient(objectStoreFullException, "3-006-0003", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCloneConnection");
        }
    }

    static void rcvCloseConnection(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCloseConnection", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "connectionObjectID", new Short(s));
        }
        CATConnection cATConnection = (CATConnection)conversationState.getObject(s);
        SICoreConnection sICoreConnection = cATConnection.getSICoreConnection();
        ServerSideConnection serverSideConnection = (ServerSideConnection)conversationState.getCommsConnection();
        try {
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            sICoreConnection.removeConnectionListener(linkLevelState.getSICoreConnectionListener());
            sICoreConnection.close();
            CommsPMI.getClientStats().onApiDisconnect();
            linkLevelState.getSICoreConnectionListener().removeSICoreConnection(sICoreConnection);
            linkLevelState.getSICoreConnectionTable().remove(conversation.getId());
            conversationState.removeObject(s);
            List list2 = conversationState.getMulticastConsumers();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Stopping " + list2.size() + " multicast consumers");
            }
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                MulticastConsumerSession multicastConsumerSession = (MulticastConsumerSession)iterator.next();
                multicastConsumerSession.close();
            }
            linkLevelState.getTransactionTable().removeTransactions(cATConnection.getTransactions());
            try {
                conversation.send(list, 192, n, -1, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCloseConnection"), (String)"3-006-0004");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2021", sIException);
            }
            serverSideConnection.close();
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCloseConnection"), (String)"3-006-0005");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-006-0005", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCloseConnection");
        }
    }

    static void rcvGetUniqueId(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvGetUniqueId", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "connectionObjectID", new Short(s));
        }
        SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
        try {
            byte[] byArray = sICoreConnection.createUniqueId();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "ID Length", new Integer(byArray.length));
                SibTr.debug(tc, "ID: ");
                SibTr.bytes(tc, byArray);
            }
            WsByteBuffer wsByteBuffer2 = bbPoolManager.allocate(2 + byArray.length);
            wsByteBuffer2.putShort((short)byArray.length);
            wsByteBuffer2.put(byArray);
            wsByteBuffer2.flip();
            list.add(wsByteBuffer2);
            try {
                conversation.send(list, 228, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvGetUniqueId"), (String)"3-006-0006");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2021", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvGetUniqueId"), (String)"3-006-0007");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-006-0007", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvGetUniqueId");
        }
    }

    static void rcvCreateOrderContext(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCreateOrderContext", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "SICoreConnection Id:", (Object)("" + s));
        }
        SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
        try {
            CATOrderingContext cATOrderingContext = new CATOrderingContext(sICoreConnection.createOrderingContext());
            int n2 = conversationState.addObject(cATOrderingContext);
            WsByteBuffer wsByteBuffer2 = bbPoolManager.allocate(2);
            wsByteBuffer2.putShort((short)n2);
            wsByteBuffer2.flip();
            list.add(wsByteBuffer2);
            try {
                conversation.send(list, 236, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCreateOrderContext"), (String)"3-006-0010");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2021", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCreateOrderContext"), (String)"3-006-0011");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-006-0011", conversation, n);
        }
        catch (ObjectStoreFullException objectStoreFullException) {
            FFDCFilter.processException((Throwable)objectStoreFullException, (String)(CLASS_NAME + ".rcvCreateOrderContext"), (String)"3-006-0012");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, objectStoreFullException.getMessage(), objectStoreFullException);
            }
            StaticCATHelper.sendExceptionToClient(objectStoreFullException, "3-006-0012", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCreateOrderContext");
        }
    }

    static void rcvCloseOrderContext(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCloseOrderContext", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        short s2 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "SICoreConnection Id:", (Object)("" + s));
            SibTr.debug(tc, "OrderContext Id:", (Object)("" + s2));
        }
        conversationState.removeObject(s2);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Successfully removed the item from the store");
        }
        try {
            conversation.send(list, 238, n, 7, true, null, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCloseOrderContext"), (String)"3-006-0012");
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2021", sIException);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCloseOrderContext");
        }
    }

    static void rcvCheckMessagingRequired(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCheckMessagingRequired", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "SICoreConnection Id:", (Object)("" + s));
        }
        SIDestinationAddress sIDestinationAddress = CommsUtils.getSIDestinationAddress(wsByteBuffer);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Request destination address", sIDestinationAddress);
        }
        SIDestinationAddress sIDestinationAddress2 = CommsUtils.getSIDestinationAddress(wsByteBuffer);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Reply destination address", sIDestinationAddress2);
        }
        short s2 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Destination Code", (Object)("" + s2));
        }
        DestinationType destinationType = null;
        if (s2 != -1) {
            destinationType = DestinationType.getDestinationType(s2);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Destination Type", destinationType);
        }
        short s3 = wsByteBuffer.getShort();
        byte[] byArray = new byte[s3];
        wsByteBuffer.get(byArray);
        CommsString commsString = conversationState.getCommsString();
        commsString.setBytes(byArray);
        String string = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Alternate User", (Object)string);
        }
        try {
            CATHandshakeProperties cATHandshakeProperties = ((LinkLevelState)conversation.getLinkLevelAttachment()).getCatHandshakeProperties();
            CommsUtils.checkFapLevel(cATHandshakeProperties, (short)2);
            SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
            SIDestinationAddress sIDestinationAddress3 = sICoreConnection.checkMessagingRequired(sIDestinationAddress, sIDestinationAddress2, destinationType, string);
            if (sIDestinationAddress3 != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Sending back ", sIDestinationAddress3);
                }
                WsByteBuffer wsByteBuffer2 = CommsUtils.getDestinationAddressAsBytes(sIDestinationAddress3);
                list.add(wsByteBuffer2);
            }
            try {
                conversation.send(list, 242, n, 7, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCheckMessagingRequired"), (String)"3-006-0013");
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2021", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCheckMessagingRequired"), (String)"3-006-0014");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-006-0014", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCheckMessagingRequired");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATConnection.java, SIB.comms, WAS602.SIB 1.36");
        }
    }
}

