/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsString;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.ObjectStoreFullException;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import java.util.List;

public class StaticCATBrowser {
    private static String CLASS_NAME = StaticCATBrowser.class.getName();
    private static final TraceComponent tc = SibTr.register(StaticCATBrowser.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static WsByteBufferPoolManager bufferPoolManager = null;
    private static final int HIGH_QUEUE_BYTES = CommsUtils.getRuntimeIntProperty("sib.comms.RAHighQueueBytes", "102400");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rcvCreateBrowserSess(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvCreateBrowserSess", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        short s2 = wsByteBuffer.getShort();
        int n2 = wsByteBuffer.getInt();
        short s3 = wsByteBuffer.getShort();
        SIDestinationAddress sIDestinationAddress = CommsUtils.getSIDestinationAddress(wsByteBuffer);
        SelectionCriteria selectionCriteria = CommsUtils.getSelectionCriteria(wsByteBuffer);
        short s4 = wsByteBuffer.getShort();
        byte[] byArray = new byte[s4];
        wsByteBuffer.get(byArray);
        CommsString commsString = new CommsString();
        commsString.setBytes(byArray);
        String string = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "\nrcvCreateBrowserSess> connectionObjectID   = " + s + "\nrcvCreateBrowserSess> clientSessionId      = " + s2 + "\nrcvCreateBrowserSess> requestedBytes       = " + n2 + "\nrcvCreateBrowserSess> destinationTypeShort = " + s3 + "\nrcvCreateBrowserSess> criteria             = " + selectionCriteria + "\nrcvCreateBrowserSess> alternateUser        = " + string);
        }
        if (bl) {
            wsByteBuffer.release();
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "not allocated from pool", wsByteBuffer);
        }
        DestinationType destinationType = null;
        if (s3 != -1) {
            destinationType = DestinationType.getDestinationType(s3);
        }
        SICoreConnection sICoreConnection = ((CATConnection)conversationState.getObject(s)).getSICoreConnection();
        BrowserSession browserSession = null;
        try {
            browserSession = sICoreConnection.createBrowserSession(sIDestinationAddress, destinationType, selectionCriteria, string);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCreateBrowserSess"), (String)"3-015-0001");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-015-0001", conversation, n);
        }
        if (browserSession != null) {
            CATMainConsumer cATMainConsumer = new CATMainConsumer(conversation, s2, browserSession);
            List list = null;
            try {
                short s5 = (short)conversationState.addObject(cATMainConsumer);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "browser session id = " + s5);
                }
                if (bufferPoolManager == null) {
                    bufferPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
                }
                cATMainConsumer.requestMsgs(n, 0, n2);
                StaticCATHelper.sendSessionCreateResponse(223, n, conversation, s5, browserSession, sIDestinationAddress);
            }
            catch (ObjectStoreFullException objectStoreFullException) {
                FFDCFilter.processException((Throwable)objectStoreFullException, (String)(CLASS_NAME + ".rcvCreateBrowserSess"), (String)"3-015-0002");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, objectStoreFullException.getMessage(), objectStoreFullException);
                }
                StaticCATHelper.sendExceptionToClient(objectStoreFullException, "3-015-0003", conversation, n);
                try {
                    browserSession.close();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvCreateBrowserSess"), (String)"3-015-0003");
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, sIException.getMessage(), sIException);
                    }
                }
            }
            finally {
                if (list != null) {
                    conversationState.returnList(list);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvCreateBrowserSess");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rcvResetBrowse(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvResetBrowse", new Object[]{wsByteBuffer, conversation, "" + n, "" + bl});
        }
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        short s2 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rcvResetBrowse> connectionObjectId = " + s + "\nrcvResetBrowse> browserSessionId   = " + s2);
        }
        BrowserSession browserSession = null;
        ConversationState conversationState = null;
        try {
            conversationState = (ConversationState)conversation.getAttachment();
            object = (CATMainConsumer)conversationState.getObject(s2);
            browserSession = ((CATMainConsumer)object).getBrowserSession();
            if (browserSession == null) {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("BROWSER_SESSION_NULL_SICO20", null, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".rcvResetBrowse"), (String)"3-015-0007");
                throw sIErrorException;
            }
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)(CLASS_NAME + ".rcvResetBrowse"), (String)"3-015-0004");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Browser session was null!", nullPointerException);
            }
            StaticCATHelper.sendExceptionToClient(nullPointerException, "3-015-0004", conversation, n);
        }
        if (browserSession != null) {
            try {
                browserSession.reset();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvResetBrowse"), (String)"3-015-0005");
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                StaticCATHelper.sendExceptionToClient(sIException, "3-015-0005", conversation, n);
            }
        }
        object = conversationState.getList();
        try {
            conversation.send((List)object, 224, n, 7, true, null, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvResetBrowse"), (String)"3-015-0006");
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2020", sIException);
        }
        finally {
            conversationState.returnList((List)object);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvResetBrowse");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATBrowser.java, SIB.comms, WAS602.SIB, o0610.11 1.38");
        }
    }
}

