/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.CompHandshake;
import com.ibm.ws.sib.comms.ComponentData;
import com.ibm.ws.sib.comms.common.CATHandshakeProperties;
import com.ibm.ws.sib.comms.common.CommsString;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.common.DirectConnectionImpl;
import com.ibm.ws.sib.comms.common.XidProxy;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.IdToTransactionTable;
import com.ibm.ws.sib.comms.server.IntArray;
import com.ibm.ws.sib.comms.server.LinkLevelState;
import com.ibm.ws.sib.comms.server.ObjectStoreFullException;
import com.ibm.ws.sib.comms.server.TransactionToDispatchableMap;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.comms.server.clientsupport.MulticastConsumerSession;
import com.ibm.ws.sib.comms.server.clientsupport.ServerSICoreConnectionListener;
import com.ibm.ws.sib.comms.server.clientsupport.ServerSideConnection;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATBrowser;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATDestination;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATProducer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATSubscription;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATTransaction;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATXATransaction;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.DispatchToAllNonEmptyDispatchable;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.mfp.CompHandshakeFactory;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.security.auth.SibLoginFactory;
import com.ibm.ws.sib.trm.TrmSingleton;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.List;
import java.util.NoSuchElementException;
import javax.security.auth.Subject;

public class ServerTransportReceiveListener
implements ConversationReceiveListener {
    private static String CLASS_NAME = ServerTransportReceiveListener.class.getName();
    private static final TraceComponent tc = SibTr.register(ServerTransportReceiveListener.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static ServerTransportReceiveListener instance;
    private static WsByteBufferPoolManager bbPoolManager;

    public static ServerTransportReceiveListener getInstance() {
        return instance;
    }

    private ServerTransportReceiveListener() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConversationReceiveListener dataReceived(WsByteBuffer wsByteBuffer, int n, int n2, int n3, boolean bl, boolean bl2, Conversation conversation) {
        Object object;
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "dataReceived");
        }
        if (tc.isDebugEnabled()) {
            string = System.getProperty("line.separator");
            object = string + string + "-------------------------------------------------------" + string;
            object = (String)object + " Segment type  : " + JFapChannelConstants.getSegmentName(n) + " - " + n + " (0x" + Integer.toHexString(n) + ")" + string;
            object = (String)object + " Request number: " + n2 + string;
            object = (String)object + " Priority      : " + n3 + string;
            object = (String)object + " Exchange?     : " + bl2 + string;
            object = (String)object + " Conversation  : " + conversation + string;
            object = (String)object + "-------------------------------------------------------" + string;
            SibTr.debug(tc, (String)object);
        }
        try {
            try {
                switch (n) {
                    case 6: {
                        this.rcvHandshake(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 8: {
                        this.rcvTRMExchange(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 9: {
                        this.rcvMFPExchange(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 12: {
                        this.rcvDirectConnect(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 230: {
                        this.rcvMFPSchema(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 52: {
                        StaticCATXATransaction.rcvXACommit(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 50: {
                        StaticCATXATransaction.rcvXAEnd(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 55: {
                        StaticCATXATransaction.rcvXAForget(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 48: {
                        StaticCATXATransaction.rcvXAOpen(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 51: {
                        StaticCATXATransaction.rcvXAPrepare(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 54: {
                        StaticCATXATransaction.rcvXARecover(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 53: {
                        StaticCATXATransaction.rcvXARollback(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 49: {
                        StaticCATXATransaction.rcvXAStart(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 56: {
                        StaticCATXATransaction.rcvXA_getTxTimeout(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 57: {
                        StaticCATXATransaction.rcvXA_setTxTimeout(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 64: {
                        StaticCATConnection.rcvCloseConnection(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 99: {
                        StaticCATConnection.rcvCloneConnection(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 65: {
                        StaticCATDestination.rcvCreateTempDestination(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 66: {
                        StaticCATDestination.rcvDeleteTempDestination(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 101: {
                        StaticCATDestination.rcvGetDestinationConfiguration(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 67: {
                        StaticCATSubscription.rcvCreateDurableSub(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 68: {
                        StaticCATSubscription.rcvDeleteDurableSub(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 69: {
                        StaticCATProducer.rcvSendConnMsg(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 70: {
                        StaticCATProducer.rcvSendConnMsgNoReply(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 71: {
                        StaticCATConnection.rcvReceiveConnMsg(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 72: {
                        StaticCATProducer.rcvCreateProducerSess(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 73: {
                        StaticCATConsumer.rcvCloseConsumerSess(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 74: {
                        StaticCATProducer.rcvCloseProducerSess(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 75: {
                        StaticCATProducer.rcvSendSessMsg(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 76: {
                        StaticCATProducer.rcvSendSessMsgNoReply(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 77: {
                        StaticCATConsumer.rcvCreateConsumerSess(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 78: {
                        StaticCATConsumer.rcvSessReceive(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 79: {
                        StaticCATConsumer.rcvRequestMsgs(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 80: {
                        StaticCATTransaction.rcvCreateUCTransaction(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 81: {
                        StaticCATTransaction.rcvCommitTransaction(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 82: {
                        StaticCATTransaction.rcvRollbackTransaction(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 83: {
                        StaticCATConsumer.rcvRegisterAsyncConsumer(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 84: {
                        StaticCATConsumer.rcvDeregisterAsyncConsumer(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 85: {
                        StaticCATConsumer.rcvStartSess(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 86: {
                        StaticCATConsumer.rcvStopSess(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 87: {
                        StaticCATConsumer.rcvFlushSess(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 88: {
                        StaticCATConsumer.rcvUnlockAll(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 89: 
                    case 104: {
                        StaticCATConsumer.rcvUnlockSet(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 90: 
                    case 91: {
                        StaticCATConsumer.rcvDeleteSet(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 95: {
                        StaticCATBrowser.rcvCreateBrowserSess(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 96: {
                        StaticCATBrowser.rcvResetBrowse(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 100: {
                        StaticCATConnection.rcvGetUniqueId(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 102: {
                        StaticCATSubscription.rcvCreateConsumerForDurableSub(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 106: {
                        StaticCATConsumer.rcvReadAndDeleteSet(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 105: {
                        StaticCATConsumer.rcvReadSet(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 103: {
                        StaticCATConsumer.rcvCreateBifurcatedSess(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 107: {
                        StaticCATConnection.rcvCreateOrderContext(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 108: {
                        StaticCATDestination.rcvSendToExceptionDest(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 109: {
                        StaticCATConnection.rcvCloseOrderContext(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    case 110: {
                        this.rcvMFPRequestSchema(wsByteBuffer, conversation, n2, n, bl, bl2);
                        break;
                    }
                    case 111: {
                        StaticCATConnection.rcvCheckMessagingRequired(wsByteBuffer, conversation, n2, bl, bl2);
                        break;
                    }
                    default: {
                        string = nls.getFormattedMessage("INVALID_PROP_SICO8011", new Object[]{"" + n}, null);
                        object = new SIConnectionLostException(string);
                        if (bl2) {
                            StaticCATHelper.sendExceptionToClient((Throwable)object, null, conversation, n2);
                        }
                        if (bl) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(tc, "releasing WsByteBuffer");
                            }
                            wsByteBuffer.release();
                        }
                        try {
                            conversation.close();
                            break;
                        }
                        catch (SIConnectionLostException sIConnectionLostException) {
                            FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".dataReceived"), (String)"3-004-0014", (Object)this);
                            if (!tc.isDebugEnabled()) break;
                            SibTr.debug(tc, "Failed to close the connection", sIConnectionLostException);
                        }
                    }
                }
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + ".dataReceived"), (String)"3-004-0013", (Object[])new Object[]{CommsUtils.getWsByteBufferContents(wsByteBuffer, 128), this});
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Caught an exception: ", throwable);
                }
                if (bl2) {
                    StaticCATHelper.sendExceptionToClient(throwable, "3-004-0013", conversation, n2);
                }
                Object var12_13 = null;
                if (!tc.isEntryEnabled()) return null;
                SibTr.exit(tc, "dataReceived");
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "dataReceived");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return null;
        SibTr.exit(tc, "dataReceived");
        return null;
    }

    public void errorOccurred(SIConnectionLostException sIConnectionLostException, int n, int n2, int n3, Conversation conversation) {
        block15: {
            Object[] objectArray;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "errorOccurred", new Object[]{sIConnectionLostException, "" + n, "" + n2, "" + n3, conversation});
            }
            FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".errorOccurred"), (String)"3-004-0010", (Object)this);
            if (tc.isDebugEnabled()) {
                objectArray = new Object[]{new String("Segment type  : " + n + " (0x" + Integer.toHexString(n) + ")"), new String("Request number: " + n2), new String("Priority      : " + n3)};
                SibTr.debug(tc, "Received an error in the ServerTransportReceiveListener", objectArray);
                SibTr.debug(tc, "Primary exception:");
                SibTr.exception(tc, sIConnectionLostException);
            }
            if (conversation != null) {
                objectArray = (Object[])conversation.getAttachment();
                ((ServerSideConnection)objectArray.getCommsConnection()).failed();
                List list = objectArray.getMulticastConsumers();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Stopping " + list.size() + " multicast consumers");
                }
                Object object = list.iterator();
                while (object.hasNext()) {
                    MulticastConsumerSession multicastConsumerSession = (MulticastConsumerSession)object.next();
                    try {
                        multicastConsumerSession.close();
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".errorOccurred"), (String)"3-004-0012", (Object)this);
                        if (!tc.isDebugEnabled()) continue;
                        SibTr.debug(tc, "Unable to close multicast session:", sIException);
                    }
                }
                object = null;
                int n4 = 10;
                while (true) {
                    block16: {
                        try {
                            object = objectArray.getObject(n4);
                            if (object instanceof CATConnection) {
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug(tc, "Found a CATConnection at position " + n4 + " in object store");
                                }
                                CATConnection cATConnection = (CATConnection)object;
                                LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
                                this.cleanUpGlobalTransactions(linkLevelState, cATConnection.getTransactions());
                                SICoreConnection sICoreConnection = cATConnection.getSICoreConnection();
                                sICoreConnection.removeConnectionListener(linkLevelState.getSICoreConnectionListener());
                                sICoreConnection.close();
                                CommsPMI.getClientStats().onApiDisconnect();
                                linkLevelState.getSICoreConnectionListener().removeSICoreConnection(sICoreConnection);
                                linkLevelState.getSICoreConnectionTable().remove(conversation.getId());
                                linkLevelState.getTransactionTable().removeTransactions(cATConnection.getTransactions());
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            break block15;
                        }
                        catch (SIException sIException) {
                            FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".errorOccurred"), (String)"3-004-0011", (Object)this);
                            if (!tc.isDebugEnabled()) break block16;
                            SibTr.debug(tc, "Unable to close SI connection");
                            SibTr.exception(tc, sIException);
                        }
                    }
                    ++n4;
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Conversation was null - nothing I can do");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "errorOccurred");
        }
    }

    public Dispatchable getThreadContext(Conversation conversation, WsByteBuffer wsByteBuffer, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getThreadContext", new Object[]{conversation, wsByteBuffer, "" + n});
        }
        Dispatchable dispatchable = null;
        int n2 = 0;
        int n3 = 0;
        wsByteBuffer.flip();
        LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        switch (n) {
            case 64: 
            case 73: 
            case 74: 
            case 109: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Processing Session close");
                }
                try {
                    dispatchable = DispatchToAllNonEmptyDispatchable.getInstance();
                    break;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getThreadContext"), (String)"3-004-0023", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Unable to create dispatchable", exception);
                    }
                    throw new SIErrorException(nls.getFormattedMessage("UNABLE_TO_CREATE_DISPATCH_TO_ALL_SICO2054", null, null), exception);
                }
            }
        }
        if (dispatchable == null) {
            switch (n) {
                case 80: {
                    TransactionToDispatchableMap transactionToDispatchableMap = ((LinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    wsByteBuffer.getShort();
                    int n4 = wsByteBuffer.getInt();
                    dispatchable = transactionToDispatchableMap.addDispatchableForLocalTransaction(n4);
                    break;
                }
                case 48: 
                case 54: {
                    dispatchable = null;
                    break;
                }
                case 49: {
                    TransactionToDispatchableMap transactionToDispatchableMap = ((LinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    int n5 = wsByteBuffer.getInt();
                    XidProxy xidProxy = new XidProxy(wsByteBuffer);
                    dispatchable = transactionToDispatchableMap.addEnlistedDispatchableForGlobalTransaction(n5, xidProxy);
                    if (dispatchable != null) break;
                    SIErrorException sIErrorException = new SIErrorException("3-004-0023");
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".getThreadContext"), (String)"3-004-0023", (Object[])new Object[]{transactionToDispatchableMap, this});
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, tc, sIErrorException);
                    }
                    throw sIErrorException;
                }
                case 51: 
                case 52: 
                case 53: 
                case 55: {
                    TransactionToDispatchableMap transactionToDispatchableMap = ((LinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    int n6 = wsByteBuffer.getInt();
                    XidProxy xidProxy = new XidProxy(wsByteBuffer);
                    dispatchable = transactionToDispatchableMap.removeDispatchableForGlobalTransaction(n6, xidProxy);
                    break;
                }
                case 50: {
                    TransactionToDispatchableMap transactionToDispatchableMap = ((LinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    int n7 = wsByteBuffer.getInt();
                    XidProxy xidProxy = new XidProxy(wsByteBuffer);
                    dispatchable = transactionToDispatchableMap.getDispatchable(n7);
                    transactionToDispatchableMap.markDispatchableAsNotEnlisted(n7, xidProxy);
                    break;
                }
                case 56: 
                case 57: {
                    TransactionToDispatchableMap transactionToDispatchableMap = ((LinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    int n8 = wsByteBuffer.getInt();
                    dispatchable = transactionToDispatchableMap.getDispatchable(n8);
                    break;
                }
                case 71: 
                case 108: {
                    wsByteBuffer.getShort();
                    int n9 = wsByteBuffer.getInt();
                    if (n9 == 0) {
                        dispatchable = null;
                        break;
                    }
                    TransactionToDispatchableMap transactionToDispatchableMap = ((LinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    dispatchable = transactionToDispatchableMap.getDispatchable(n9);
                    if (dispatchable != null) break;
                    SIErrorException sIErrorException = new SIErrorException("3-004-0023");
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".getThreadContext"), (String)"3-004-0023", (Object[])new Object[]{transactionToDispatchableMap, this});
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, tc, sIErrorException);
                    }
                    throw sIErrorException;
                }
                case 69: 
                case 70: 
                case 75: 
                case 76: 
                case 78: 
                case 90: 
                case 91: {
                    wsByteBuffer.getShort();
                    wsByteBuffer.getShort();
                    n2 = wsByteBuffer.getInt();
                    if (n2 == 0) {
                        dispatchable = null;
                        break;
                    }
                    TransactionToDispatchableMap transactionToDispatchableMap = ((LinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    dispatchable = transactionToDispatchableMap.getDispatchable(n2);
                    if (dispatchable != null) break;
                    SIErrorException sIErrorException = new SIErrorException("3-004-0023");
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".getThreadContext"), (String)"3-004-0023", (Object[])new Object[]{transactionToDispatchableMap, this});
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, tc, sIErrorException);
                    }
                    throw sIErrorException;
                }
                case 81: 
                case 82: {
                    wsByteBuffer.getShort();
                    n2 = wsByteBuffer.getInt();
                    if (n2 == 0) {
                        dispatchable = null;
                        break;
                    }
                    TransactionToDispatchableMap transactionToDispatchableMap = ((LinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    dispatchable = transactionToDispatchableMap.removeDispatchableForLocalTransaction(n2);
                    if (dispatchable != null) break;
                    SIErrorException sIErrorException = new SIErrorException("3-004-0023");
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".getThreadContext"), (String)"3-004-0023", (Object[])new Object[]{transactionToDispatchableMap, this});
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, tc, sIErrorException);
                    }
                    throw sIErrorException;
                }
            }
            if (dispatchable == null) {
                wsByteBuffer.rewind();
                switch (n) {
                    case 69: 
                    case 70: 
                    case 72: {
                        wsByteBuffer.getShort();
                        n3 = wsByteBuffer.getShort();
                        break;
                    }
                    case 83: {
                        wsByteBuffer.getShort();
                        wsByteBuffer.getShort();
                        n3 = wsByteBuffer.getShort();
                    }
                }
                if (n3 != 0) {
                    dispatchable = (Dispatchable)conversationState.getObject(n3);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getThreadContext", dispatchable);
        }
        return dispatchable;
    }

    private void cleanUpGlobalTransactions(LinkLevelState linkLevelState, IntArray intArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "cleanUpGlobalTransactions", new Object[]{linkLevelState, intArray});
        }
        IdToTransactionTable idToTransactionTable = linkLevelState.getTransactionTable();
        for (int i = 0; i < intArray.length(); ++i) {
            CATTransaction cATTransaction = idToTransactionTable.get(intArray.get(i));
            if (!cATTransaction.hasInDoubtTransactions()) continue;
            cATTransaction.rollbackInDoubtTransactions();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "cleanUpGlobalTransactions");
        }
    }

    private void rcvHandshake(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvHandshake", new Object[]{wsByteBuffer, conversation, "" + n});
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
        CATHandshakeProperties cATHandshakeProperties = linkLevelState.getCatHandshakeProperties();
        wsByteBuffer.flip();
        WsByteBuffer wsByteBuffer2 = bbPoolManager.allocate(1);
        wsByteBuffer2.put(wsByteBuffer.get());
        wsByteBuffer2.flip();
        list.add(wsByteBuffer2);
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        block11: while (wsByteBuffer.hasRemaining() && bl3) {
            short s = wsByteBuffer.getShort();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "fieldId", new Short(s));
            }
            switch (s) {
                case 1: {
                    short s2 = wsByteBuffer.getShort();
                    if (s2 != 2) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Field length", new Short(s2));
                        }
                        this.rejectHandshake(conversation, n, "ProductVersion length");
                        bl3 = false;
                        continue block11;
                    }
                    byte by = wsByteBuffer.get();
                    byte by2 = wsByteBuffer.get();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "ProductVersion", new Object[]{new Byte(by), new Byte(by2)});
                    }
                    bl5 = true;
                    cATHandshakeProperties.setMajorVersion(by);
                    cATHandshakeProperties.setMinorVersion(by2);
                    WsByteBuffer wsByteBuffer3 = bbPoolManager.allocate(6);
                    wsByteBuffer3.putShort((short)1);
                    wsByteBuffer3.putShort((short)2);
                    wsByteBuffer3.put((byte)6);
                    wsByteBuffer3.put((byte)0);
                    wsByteBuffer3.flip();
                    list.add(wsByteBuffer3);
                    continue block11;
                }
                case 2: {
                    byte by = wsByteBuffer.getShort();
                    if (by != 2) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Field length", new Short(by));
                        }
                        this.rejectHandshake(conversation, n, "FAPLevel length");
                        bl3 = false;
                        continue block11;
                    }
                    byte by2 = wsByteBuffer.getShort();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "FAPLevel", new Object[]{new Short(by2)});
                    }
                    bl4 = true;
                    if (by2 > 2) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Informing client of negotiatied value:", new Short(2));
                        }
                        WsByteBuffer wsByteBuffer4 = bbPoolManager.allocate(6);
                        wsByteBuffer4.putShort((short)2);
                        wsByteBuffer4.putShort((short)2);
                        wsByteBuffer4.putShort((short)2);
                        wsByteBuffer4.flip();
                        list.add(wsByteBuffer4);
                        cATHandshakeProperties.setFapLevel((short)2);
                        continue block11;
                    }
                    cATHandshakeProperties.setFapLevel(by2);
                    continue block11;
                }
                case 3: {
                    byte by2 = wsByteBuffer.getShort();
                    if (by2 != 8) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Field length", new Short(by2));
                        }
                        this.rejectHandshake(conversation, n, "MaxMessageSize length");
                        bl3 = false;
                        continue block11;
                    }
                    long l = wsByteBuffer.getLong();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "MessageSize", new Object[]{new Long(l)});
                    }
                    cATHandshakeProperties.setMaxMessageSize(l);
                    continue block11;
                }
                case 4: {
                    short s3 = wsByteBuffer.getShort();
                    if (s3 != 4) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Field length", new Short(s3));
                        }
                        this.rejectHandshake(conversation, n, "MaxTransmissionSize length");
                        bl3 = false;
                        continue block11;
                    }
                    short s4 = wsByteBuffer.getInt();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "TransmissionSize", new Object[]{new Integer(s4)});
                    }
                    cATHandshakeProperties.setMaxTransmissionSize(s4);
                    continue block11;
                }
                case 5: {
                    short s5;
                    short s4 = wsByteBuffer.getShort();
                    if (s4 != 2) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Field length", new Short(s4));
                        }
                        this.rejectHandshake(conversation, n, "HeartbeatInterval length");
                        bl3 = false;
                        continue block11;
                    }
                    short s6 = wsByteBuffer.getShort();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Received HeartbeatInterval", new Object[]{new Short(s6)});
                    }
                    if ((s5 = (short)Math.max(conversation.getHeartbeatInterval(), s6)) > s6) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Informing client of negotiatied value:", new Short(s5));
                        }
                        WsByteBuffer wsByteBuffer5 = bbPoolManager.allocate(6);
                        wsByteBuffer5.putShort((short)5);
                        wsByteBuffer5.putShort((short)2);
                        wsByteBuffer5.putShort(s5);
                        wsByteBuffer5.flip();
                        list.add(wsByteBuffer5);
                    } else {
                        conversation.setHeartbeatInterval(s5);
                    }
                    cATHandshakeProperties.setHeartbeatInterval(s5);
                    continue block11;
                }
                case 7: {
                    short s6 = wsByteBuffer.getShort();
                    if (s6 != 2) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Field length", new Short(s6));
                        }
                        this.rejectHandshake(conversation, n, "Capability length");
                        bl3 = false;
                        continue block11;
                    }
                    short s5 = wsByteBuffer.getShort();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Capability", new Object[]{new Short(s5)});
                    }
                    if ((s5 & 0xFFFFFFC0) != 0) {
                        s5 = (short)(s5 & 0x3F);
                        WsByteBuffer wsByteBuffer6 = bbPoolManager.allocate(6);
                        wsByteBuffer6.putShort((short)7);
                        wsByteBuffer6.putShort((short)2);
                        wsByteBuffer6.putShort(s5);
                        wsByteBuffer6.flip();
                        list.add(wsByteBuffer6);
                    }
                    cATHandshakeProperties.setCapabilites(s5);
                    continue block11;
                }
                case 11: {
                    short s5 = wsByteBuffer.getShort();
                    if (s5 != 2) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Product Id length", new Short(s5));
                        }
                        this.rejectHandshake(conversation, n, "Product Id length");
                        bl3 = false;
                        continue block11;
                    }
                    short s7 = wsByteBuffer.getShort();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "ProductId", new Object[]{new Short(s7)});
                    }
                    bl6 = true;
                    cATHandshakeProperties.setProductId(s7);
                    WsByteBuffer wsByteBuffer7 = bbPoolManager.allocate(6);
                    wsByteBuffer7.putShort((short)11);
                    wsByteBuffer7.putShort((short)2);
                    wsByteBuffer7.putShort((short)1);
                    wsByteBuffer7.flip();
                    list.add(wsByteBuffer7);
                    continue block11;
                }
            }
            short s8 = wsByteBuffer.getShort();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Ignoring field ID: ", new Short(s));
                SibTr.debug(tc, "Skipping " + s8 + " bytes");
            }
            wsByteBuffer.position(wsByteBuffer.position() + s8);
        }
        if (bl3) {
            if (!bl4) {
                this.rejectHandshake(conversation, n, "FAPLevel");
            } else if (!bl5) {
                this.rejectHandshake(conversation, n, "ProductVersion");
            } else if (!bl6) {
                this.rejectHandshake(conversation, n, "ProductId");
            } else {
                try {
                    conversation.send(list, 6, n, 7, true, null, null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvHandshake"), (String)"3-004-0002", (Object)this);
                    SibTr.error(tc, "COMMUNICATION_ERROR_SICO2019", sIException);
                }
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvHandshake");
        }
    }

    private void rejectHandshake(Conversation conversation, int n, String string) {
        block3: {
            SIConnectionLostException sIConnectionLostException = new SIConnectionLostException(nls.getFormattedMessage("INVALID_PROP_SICO8012", null, null));
            FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".rejectHandshake"), (String)"3-004-0015", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Invalid handshake type received - rejecting field:", (Object)string);
            }
            StaticCATHelper.sendExceptionToClient(sIConnectionLostException, "3-004-0015", conversation, n);
            try {
                conversation.close();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rejectHandshake"), (String)"3-004-0016", (Object)this);
                if (!tc.isDebugEnabled()) break block3;
                SibTr.debug(tc, "Unable to close the conversation", sIException);
            }
        }
    }

    private void rcvTRMExchange(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvTRMExchange");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params: data, conversation, requestNumber", new Object[]{wsByteBuffer, conversation, new Integer(n)});
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        TrmSingleton trmSingleton = TrmSingleton.getTrmSingleton();
        ComponentData componentData = (ComponentData)trmSingleton.getComponentData();
        ClientConnection clientConnection = (ClientConnection)conversationState.getCommsConnection();
        if (conversationState.getCommsConnection() == null) {
            clientConnection = new ServerSideConnection(conversation);
            conversationState.setCommsConnection(clientConnection);
        }
        try {
            wsByteBuffer.flip();
            byte[] byArray = new byte[wsByteBuffer.remaining()];
            System.arraycopy(wsByteBuffer.array(), wsByteBuffer.arrayOffset(), byArray, 0, wsByteBuffer.remaining());
            byte[] byArray2 = componentData.handShake(clientConnection, byArray);
            if (clientConnection.getSICoreConnection() != null) {
                CommsPMI.getClientStats().onApiConnect();
                ((MPCoreConnection)clientConnection.getSICoreConnection()).setMessageCopiedWhenSent(false);
                ((MPCoreConnection)clientConnection.getSICoreConnection()).setMessageCopiedWhenReceived(false);
                conversationState.addObject(clientConnection);
                this.sendConnectionInfo(conversation);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "TRM did not allocate us a connection");
            }
            list.add(bbPoolManager.wrap(byArray2));
            conversation.send(list, 8, n, 7, true, null, null);
        }
        catch (ObjectStoreFullException objectStoreFullException) {
            FFDCFilter.processException((Throwable)objectStoreFullException, (String)(CLASS_NAME + ".rcvTRMExchange"), (String)"3-004-0003", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, objectStoreFullException.getMessage(), objectStoreFullException);
            }
            StaticCATHelper.sendExceptionToClient(objectStoreFullException, "3-004-0003", conversation, n);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvTRMExchange"), (String)"3-004-0004", (Object)this);
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2019", sIException);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvTRMExchange");
        }
    }

    private void rcvMFPExchange(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvMFPExchange");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params: data, conversation, requestNumber", new Object[]{wsByteBuffer, conversation, new Integer(n)});
        }
        CompHandshake compHandshake = null;
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        ServerSideConnection serverSideConnection = new ServerSideConnection(conversation);
        conversationState.setCommsConnection(serverSideConnection);
        try {
            compHandshake = (CompHandshake)CompHandshakeFactory.getInstance();
            wsByteBuffer.flip();
            byte[] byArray = new byte[wsByteBuffer.remaining()];
            System.arraycopy(wsByteBuffer.array(), wsByteBuffer.arrayOffset(), byArray, 0, wsByteBuffer.remaining());
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            CATHandshakeProperties cATHandshakeProperties = linkLevelState.getCatHandshakeProperties();
            short s = cATHandshakeProperties.getMajorVersion();
            byte[] byArray2 = compHandshake.compHandshakeData(serverSideConnection, s, byArray);
            list.add(bbPoolManager.wrap(byArray2));
            conversation.send(list, 9, n, 7, true, null, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvMFPExchange"), (String)"3-004-0018", (Object)this);
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2019", sIException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".rcvMFPExchange"), (String)"3-004-0017", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "MFP unable to create CompHandshake Singleton", exception);
            }
            StaticCATHelper.sendExceptionToClient(exception, "3-004-0017", conversation, n);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvMFPExchange");
        }
    }

    private void rcvMFPSchema(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        List list;
        ConversationState conversationState;
        block7: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "rcvMFPSchema");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Params: data, conversation, requestNumber", new Object[]{wsByteBuffer, conversation, new Integer(n)});
            }
            CompHandshake compHandshake = null;
            conversationState = (ConversationState)conversation.getAttachment();
            list = conversationState.getList();
            CommsConnection commsConnection = conversationState.getCommsConnection();
            try {
                compHandshake = (CompHandshake)CompHandshakeFactory.getInstance();
                wsByteBuffer.flip();
                byte[] byArray = new byte[wsByteBuffer.remaining()];
                System.arraycopy(wsByteBuffer.array(), wsByteBuffer.arrayOffset(), byArray, 0, wsByteBuffer.remaining());
                LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
                CATHandshakeProperties cATHandshakeProperties = linkLevelState.getCatHandshakeProperties();
                short s = cATHandshakeProperties.getMajorVersion();
                compHandshake.compData(commsConnection, s, byArray);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".rcvMFPSchema"), (String)"3-004-0019", (Object)this);
                if (!tc.isDebugEnabled()) break block7;
                SibTr.debug(tc, "MFP unable to create CompHandshake Singleton", exception);
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvMFPSchema");
        }
    }

    private void rcvMFPRequestSchema(WsByteBuffer wsByteBuffer, Conversation conversation, int n, int n2, boolean bl, boolean bl2) {
        List list;
        ConversationState conversationState;
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "rcvMFPRequestSchema", new Object[]{wsByteBuffer, conversation, "" + n});
            }
            CompHandshake compHandshake = null;
            conversationState = (ConversationState)conversation.getAttachment();
            list = conversationState.getList();
            CommsConnection commsConnection = conversationState.getCommsConnection();
            try {
                compHandshake = (CompHandshake)CompHandshakeFactory.getInstance();
                wsByteBuffer.flip();
                byte[] byArray = new byte[wsByteBuffer.remaining()];
                System.arraycopy(wsByteBuffer.array(), wsByteBuffer.arrayOffset(), byArray, 0, wsByteBuffer.remaining());
                LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
                CATHandshakeProperties cATHandshakeProperties = linkLevelState.getCatHandshakeProperties();
                short s = cATHandshakeProperties.getMajorVersion();
                byte[] byArray2 = compHandshake.compRequest(commsConnection, s, n2, byArray);
                if (byArray2 == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "MFP returned null");
                    }
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("MFP_SCHEMA_REQUEST_FAILED_SICO2056", null, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".rcvMFPRequestSchema"), (String)"3-004-0024", (Object)this);
                    StaticCATHelper.sendExceptionToClient(sIErrorException, null, conversation, n);
                } else {
                    WsByteBuffer wsByteBuffer2 = bbPoolManager.wrap(byArray2);
                    list.add(wsByteBuffer2);
                    try {
                        conversation.send(list, 240, n, 12, true, null, null);
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rcvMFPRequestSchema"), (String)"3-004-0025", (Object)this);
                        SibTr.error(tc, "COMMUNICATION_ERROR_SICO2019", sIException);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".rcvMFPRequestSchema"), (String)"3-004-0026", (Object)this);
                if (!tc.isDebugEnabled()) break block11;
                SibTr.debug(tc, "MFP unable to create CompHandshake Singleton", exception);
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvMFPRequestSchema");
        }
    }

    private void sendConnectionInfo(Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendConnectionInfo");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params: conversation", new Object[]{conversation});
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        List list = conversationState.getList();
        CommsString commsString = conversationState.getCommsString();
        commsString.setString(null);
        ClientConnection clientConnection = (ClientConnection)conversationState.getObject(10);
        try {
            WsByteBuffer wsByteBuffer;
            WsByteBuffer wsByteBuffer2;
            block14: {
                byte[] byArray;
                short s;
                SICoreConnection sICoreConnection;
                block13: {
                    sICoreConnection = clientConnection.getSICoreConnection();
                    s = 0;
                    byArray = new byte[]{};
                    commsString.setString(sICoreConnection.getMeName());
                    try {
                        byArray = sICoreConnection.createUniqueId();
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendConnectionInfo"), (String)"3-004-0008", (Object)this);
                        if (!tc.isDebugEnabled()) break block13;
                        SibTr.debug(tc, "Unable to get the unique ID", sIException);
                    }
                }
                CATConnection cATConnection = new CATConnection(sICoreConnection);
                s = (short)conversationState.addObject(cATConnection);
                conversationState.setConnectionObjectId(s);
                this.attachConnectionListener(conversation, sICoreConnection);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "SICoreConnection Id:", new Short(s));
                    SibTr.debug(tc, "ME Name:", (Object)commsString.getString());
                }
                wsByteBuffer2 = bbPoolManager.allocate(6 + commsString.getLength() + byArray.length);
                wsByteBuffer2.putShort(s);
                wsByteBuffer2.putShort(commsString.getLength());
                wsByteBuffer2.put(commsString.getBytes());
                wsByteBuffer2.putShort((short)byArray.length);
                wsByteBuffer2.put(byArray);
                wsByteBuffer2.flip();
                commsString.setString(sICoreConnection.getMeUuid());
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "ME Uuid: ", (Object)commsString.getString());
                }
                wsByteBuffer = bbPoolManager.allocate(2 + commsString.getLength());
                wsByteBuffer.putShort(commsString.getLength());
                wsByteBuffer.put(commsString.getBytes());
                wsByteBuffer.flip();
                try {
                    commsString.setString(null);
                    commsString.setString(sICoreConnection.getResolvedUserid());
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendConnectionInfo"), (String)"3-004-0008");
                    if (!tc.isDebugEnabled()) break block14;
                    SibTr.debug(tc, "Unable to get User Id", sIException);
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Resolved User Id: ", (Object)commsString.getString());
            }
            WsByteBuffer wsByteBuffer3 = null;
            wsByteBuffer3 = bbPoolManager.allocate(2 + commsString.getLength());
            wsByteBuffer3.putShort(commsString.getLength());
            wsByteBuffer3.put(commsString.getBytes());
            wsByteBuffer3.flip();
            list.add(wsByteBuffer2);
            list.add(wsByteBuffer);
            list.add(wsByteBuffer3);
            conversation.send(list, 226, 0, 7, true, null, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendConnectionInfo"), (String)"3-004-0006", (Object)this);
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2019", sIException);
        }
        catch (ObjectStoreFullException objectStoreFullException) {
            FFDCFilter.processException((Throwable)objectStoreFullException, (String)(CLASS_NAME + ".sendConnectionInfo"), (String)"3-004-0007", (Object)this);
            SibTr.error(tc, "INTERNAL_OBJECT_STORE_FULL_SICO2010", objectStoreFullException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendConnectionInfo");
        }
    }

    private void attachConnectionListener(Conversation conversation, SICoreConnection sICoreConnection) {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "attachConnectionListener", new Object[]{conversation, sICoreConnection});
            }
            LinkLevelState linkLevelState = (LinkLevelState)conversation.getLinkLevelAttachment();
            ServerSICoreConnectionListener serverSICoreConnectionListener = linkLevelState.getSICoreConnectionListener();
            serverSICoreConnectionListener.addSICoreConnection(sICoreConnection, conversation);
            try {
                sICoreConnection.addConnectionListener(serverSICoreConnectionListener);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".attachConnectionListener"), (String)"3-004-0005", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                SibTr.debug(tc, "Unable to register connection listener", sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "attachConnectionListener");
        }
    }

    private void rcvDirectConnect(WsByteBuffer wsByteBuffer, Conversation conversation, int n, boolean bl, boolean bl2) {
        SibLoginFactory sibLoginFactory;
        Subject subject;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rcvDirectConnect", new Object[]{wsByteBuffer, conversation, "" + n});
        }
        ConversationState conversationState = (ConversationState)conversation.getAttachment();
        CommsString commsString = conversationState.getCommsString();
        List list = conversationState.getList();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        byte[] byArray = new byte[s];
        wsByteBuffer.get(byArray);
        commsString.setBytes(byArray);
        String string = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Me Name", (Object)string);
        }
        short s2 = wsByteBuffer.getShort();
        byte[] byArray2 = new byte[s2];
        wsByteBuffer.get(byArray2);
        commsString.setBytes(byArray2);
        String string2 = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Bus Name", (Object)string2);
        }
        short s3 = wsByteBuffer.getShort();
        byte[] byArray3 = new byte[s3];
        wsByteBuffer.get(byArray3);
        commsString.setBytes(byArray3);
        String string3 = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "User Id", (Object)string3);
        }
        short s4 = wsByteBuffer.getShort();
        byte[] byArray4 = new byte[s4];
        wsByteBuffer.get(byArray4);
        commsString.setBytes(byArray4);
        String string4 = commsString.getString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Password", (Object)"****");
        }
        if ((subject = (sibLoginFactory = SibLoginFactory.getInstance()).createNewSibLogin().login(string2, string3, string4)) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Authentication failed");
            }
            StaticCATHelper.sendExceptionToClient(new SIAuthenticationException(null), null, conversation, n);
        } else {
            TrmSingleton trmSingleton = TrmSingleton.getTrmSingleton();
            ComponentData componentData = (ComponentData)trmSingleton.getComponentData();
            DirectConnectionImpl directConnectionImpl = new DirectConnectionImpl();
            directConnectionImpl.setBus(string2);
            directConnectionImpl.setName(string);
            boolean bl3 = componentData.directConnect(directConnectionImpl, subject);
            SICoreConnection sICoreConnection = directConnectionImpl.getSICoreConnection();
            if (!bl3 || sICoreConnection == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "TRM did not allocate us a connection");
                }
                StaticCATHelper.sendExceptionToClient(new SIResourceException(), null, conversation, n);
            } else {
                try {
                    ServerSideConnection serverSideConnection = new ServerSideConnection(conversation);
                    conversationState.setCommsConnection(serverSideConnection);
                    short s5 = (short)conversationState.addObject(serverSideConnection);
                    short s6 = (short)conversationState.addObject(new CATConnection(sICoreConnection));
                    conversationState.setConnectionObjectId(s6);
                    serverSideConnection.setSICoreConnection(sICoreConnection);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "SICoreConnection object ID", (Object)("" + s6));
                    }
                    this.attachConnectionListener(conversation, sICoreConnection);
                    byte[] byArray5 = sICoreConnection.createUniqueId();
                    WsByteBuffer wsByteBuffer2 = bbPoolManager.allocate(4 + byArray5.length);
                    wsByteBuffer2.putShort(s6);
                    wsByteBuffer2.putShort((short)byArray5.length);
                    wsByteBuffer2.put(byArray5);
                    wsByteBuffer2.flip();
                    list.add(wsByteBuffer2);
                    try {
                        conversation.send(list, 13, n, 7, true, null, null);
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".,rcvDirectConnect"), (String)"3-004-0021", (Object)this);
                        SibTr.error(tc, "COMMUNICATION_ERROR_SICO2019", sIException);
                    }
                }
                catch (ObjectStoreFullException objectStoreFullException) {
                    FFDCFilter.processException((Throwable)objectStoreFullException, (String)(CLASS_NAME + ".,rcvDirectConnect"), (String)"3-004-0020", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, objectStoreFullException.getMessage(), objectStoreFullException);
                    }
                    StaticCATHelper.sendExceptionToClient(objectStoreFullException, "3-004-0020", conversation, n);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".,rcvDirectConnect"), (String)"3-004-0022", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, sIException.getMessage(), sIException);
                    }
                    StaticCATHelper.sendExceptionToClient(sIException, "3-004-0022", conversation, n);
                }
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rcvDirectConnect");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/ServerTransportReceiveListener.java, SIB.comms, WAS602.SIB, o0610.11 1.125");
        }
        instance = new ServerTransportReceiveListener();
        bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
    }
}

