/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.XidProxy;
import com.ibm.ws.sib.comms.server.clientsupport.CATCommonDispatchable;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import java.util.HashMap;
import java.util.Iterator;
import javax.transaction.xa.XAException;

public class CATTransaction
extends CATCommonDispatchable {
    private static final TraceComponent tc = SibTr.register(CATTransaction.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static String CLASS_NAME = CATTransaction.class.getName();
    private boolean error = false;
    private SITransaction tran = null;
    private CATConnection owningConnection = null;
    private int transactionId;
    private Throwable firstException = null;
    private HashMap inDoubtXids = new HashMap();
    private Object dummyObj = new Object();

    public CATTransaction(CATConnection cATConnection, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.owningConnection = cATConnection;
        this.transactionId = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public void setTransaction(SITransaction sITransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setTransaction", sITransaction);
        }
        this.tran = sITransaction;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setTransaction");
        }
    }

    public SITransaction getSITransaction() throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSITransaction");
        }
        if (this.tran == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transaction was null");
            }
            throw new SIIncorrectCallException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"TEMPORARY_CWSIC9999", null, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSITransaction", this.tran);
        }
        return this.tran;
    }

    public SICoreConnection getOwningConnection() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getOwningConnection");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getOwningConneciton", this.owningConnection.getSICoreConnection());
        }
        return this.owningConnection.getSICoreConnection();
    }

    public CATConnection getOwningCATConnection() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getOwningCATConnection");
        }
        CATConnection cATConnection = this.owningConnection;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getOwningCATConnection", cATConnection);
        }
        return cATConnection;
    }

    public int getTransactionId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getTransactionId");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTransactionId", (Object)("" + this.transactionId));
        }
        return this.transactionId;
    }

    public boolean isMarkedAsError() {
        return this.error;
    }

    public void markAsError(Throwable throwable) {
        this.error = true;
        if (this.firstException == null) {
            this.firstException = throwable;
        }
    }

    public Throwable getFirstException() {
        return this.firstException;
    }

    public void setInDoubt(XidProxy xidProxy) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setInDoubt", xidProxy);
        }
        this.inDoubtXids.put(xidProxy, this.dummyObj);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setInDoubt");
        }
    }

    public void setComplete(XidProxy xidProxy) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setComplete", xidProxy);
        }
        this.inDoubtXids.remove(xidProxy);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setComplete");
        }
    }

    public boolean hasInDoubtTransactions() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "hasInDoubtTransactions");
        }
        boolean bl2 = bl = this.inDoubtXids.size() != 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "hasInDoubtTransactions", (Object)("" + bl));
        }
        return bl;
    }

    public void rollbackInDoubtTransactions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rollbackInDoubtTransactions");
        }
        if (this.tran instanceof SIXAResource) {
            SIXAResource sIXAResource = (SIXAResource)this.tran;
            Iterator iterator = this.inDoubtXids.keySet().iterator();
            while (iterator.hasNext()) {
                XidProxy xidProxy;
                block9: {
                    xidProxy = (XidProxy)iterator.next();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Attempting to rollback Xid: " + xidProxy);
                    }
                    try {
                        sIXAResource.end(xidProxy, 0);
                    }
                    catch (XAException xAException) {
                        if (!tc.isDebugEnabled()) break block9;
                        SibTr.debug(tc, "end() failed - this could be ok if end() has already been called" + xAException);
                    }
                }
                try {
                    sIXAResource.rollback(xidProxy);
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug(tc, "The transaction was rolled back successfully");
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, (String)(CLASS_NAME + ".rollbackInDoubtTransactions"), (String)"3-029-0001", (Object[])new Object[]{xidProxy, this});
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug(tc, "Rollback failed of Xid: " + xidProxy);
                }
            }
            this.inDoubtXids.clear();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "rollbackInDoubtTransactions");
        }
    }
}

