/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SITransaction;
import java.util.List;

public class CATSyncAsynchReader
implements AsynchConsumerCallback {
    private static String CLASS_NAME = CATSyncAsynchReader.class.getName();
    private int requestNumber;
    private boolean completed = false;
    private Alarm alarm = null;
    private CATTransaction transaction = null;
    private static WsByteBufferPoolManager bbPoolManager = null;
    private Conversation conversation = null;
    private CATMainConsumer mainConsumer = null;
    private boolean currentlyDoingReceiveWithWait = false;
    private static final TraceComponent tc = SibTr.register(CATSyncAsynchReader.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");

    public CATSyncAsynchReader(CATTransaction cATTransaction, Conversation conversation, CATMainConsumer cATMainConsumer, int n) {
        this.transaction = cATTransaction;
        this.conversation = conversation;
        this.mainConsumer = cATMainConsumer;
        this.requestNumber = n;
        if (bbPoolManager == null) {
            bbPoolManager = ServerConnectionManager.getRef().getBufferPoolManager();
        }
    }

    public void setCurrentlyDoingReceiveWithWait(boolean bl) {
        this.currentlyDoingReceiveWithWait = bl;
    }

    public boolean isCurrentlyDoingReceiveWithWait() {
        return this.currentlyDoingReceiveWithWait;
    }

    public void setRequestNumber(int n) {
        this.requestNumber = n;
    }

    public synchronized boolean isComplete() {
        return this.completed;
    }

    public synchronized void setComplete(boolean bl) {
        this.completed = bl;
    }

    public void setCATTimer(Alarm alarm) {
        this.alarm = alarm;
    }

    public void stopSession() throws SIException {
        this.mainConsumer.getConsumerSession().stop();
    }

    public void setTransaction(CATTransaction cATTransaction) {
        this.transaction = cATTransaction;
    }

    public void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) {
        block20: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "consumeMessages");
            }
            if (this.alarm != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Cancelling the alarm: " + this.alarm.toString());
                }
                this.alarm.cancel();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Alarm cancelled");
                }
            }
            if (this.isComplete()) {
                block19: {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "This session has already consumed a message - not processing");
                    }
                    try {
                        lockedMessageEnumeration.nextLocked();
                        lockedMessageEnumeration.unlockCurrent();
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-016-0003", (Object)this);
                        if (!tc.isDebugEnabled()) break block19;
                        SibTr.debug(tc, sIException.getMessage(), sIException);
                    }
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "consumeMessages");
                }
                return;
            }
            this.setComplete(true);
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Stopping the session");
                }
                this.stopSession();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Session stopped");
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-016-0001", (Object)this);
                if (!tc.isDebugEnabled()) break block20;
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
        }
        try {
            JsMessage jsMessage = (JsMessage)lockedMessageEnumeration.nextLocked();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Received message", jsMessage);
            }
            SITransaction sITransaction = null;
            if (this.transaction != null) {
                sITransaction = this.transaction.getSITransaction();
            }
            lockedMessageEnumeration.deleteCurrent(sITransaction);
            this.sendMessageToClient(jsMessage);
            this.mainConsumer.setLowestPriority(JFapChannelConstants.getJFAPPriority(jsMessage.getPriority()));
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-016-0002", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-016-0002", this.conversation, this.requestNumber);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "consumeMessages");
        }
    }

    private void sendMessageToClient(JsMessage jsMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendMessageToClient");
        }
        this.setCurrentlyDoingReceiveWithWait(false);
        ConversationState conversationState = (ConversationState)this.conversation.getAttachment();
        List list = conversationState.getList();
        ++this.mainConsumer.messagesSent;
        int n = 0;
        try {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Encoding JsMessage");
            }
            n = CommsUtils.encodeMessage(list, this.conversation, jsMessage);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Completed");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".sendMessageToClient"), (String)"3-016-0004", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Encode failed: " + exception.getMessage(), exception);
            }
            throw new SIResourceException(exception);
        }
        List list2 = conversationState.getList();
        WsByteBuffer wsByteBuffer = bbPoolManager.allocate(12);
        wsByteBuffer.putShort(conversationState.getConnectionObjectId());
        if (!this.mainConsumer.getUsingConnectionReceive()) {
            wsByteBuffer.putShort(this.mainConsumer.getConsumerSessionId());
        }
        wsByteBuffer.putLong((long)n);
        wsByteBuffer.flip();
        list2.add(wsByteBuffer);
        list2.addAll(list);
        int n2 = 206;
        if (this.mainConsumer.getUsingConnectionReceive()) {
            n2 = 199;
        }
        short s = JFapChannelConstants.getJFAPPriority(jsMessage.getPriority());
        try {
            this.conversation.send(list2, n2, this.requestNumber, s, false, null, null);
            CommsPMI.getClientStats().onWriteMessage(n);
            CommsPMI.getClientDetailedStats().onSendMessage(s);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendMessageToClient"), (String)"3-016-0005", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2015", sIException);
        }
        conversationState.returnList(list2);
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendMessageToClient");
        }
    }

    protected void sendNoMessageToClient() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendNoMessageToClient");
        }
        this.setCurrentlyDoingReceiveWithWait(false);
        this.setComplete(true);
        WsByteBuffer wsByteBuffer = bbPoolManager.allocate(12);
        int n = -1;
        ConversationState conversationState = (ConversationState)this.conversation.getAttachment();
        List list = conversationState.getList();
        wsByteBuffer.putShort(conversationState.getConnectionObjectId());
        if (!this.mainConsumer.getUsingConnectionReceive()) {
            wsByteBuffer.putShort(this.mainConsumer.getConsumerSessionId());
        }
        wsByteBuffer.putLong((long)n);
        wsByteBuffer.flip();
        list.add(wsByteBuffer);
        int n2 = 206;
        if (this.mainConsumer.getUsingConnectionReceive()) {
            n2 = 199;
        }
        try {
            this.conversation.send(list, n2, this.requestNumber, 7, true, null, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendNoMessageToClient"), (String)"3-016-0007", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2015", sIException);
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendNoMessageToClient");
        }
    }

    protected void sendErrorToClient(Throwable throwable, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendErrorToClient");
        }
        this.setComplete(true);
        this.setCurrentlyDoingReceiveWithWait(false);
        StaticCATHelper.sendExceptionToClient(throwable, string, this.conversation, this.requestNumber);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendErrorToClient");
        }
    }

    public String toString() {
        return "currentlyDoingReceiveWithWait: " + this.currentlyDoingReceiveWithWait;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATSyncAsynchReader.java, SIB.comms, WAS602.SIB, o0610.11 1.35");
        }
    }
}

