/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.CATAsynchReadAheadReader;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import java.util.List;

public class CATProxyConsumer
extends CATConsumer {
    private static String CLASS_NAME = CATProxyConsumer.class.getName();
    private static final TraceComponent tc = SibTr.register(CATProxyConsumer.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private CATAsynchReadAheadReader callback;
    private CATMainConsumer mainConsumer;
    private int sentBytes = 0;
    private int requestedBytes = 0;

    public CATProxyConsumer(CATMainConsumer cATMainConsumer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.mainConsumer = cATMainConsumer;
        this.requestedBytes = cATMainConsumer.getRequestedBytes();
        this.callback = new CATAsynchReadAheadReader(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    protected boolean isRecoverable(SIBusMessage sIBusMessage) {
        return this.mainConsumer.isRecoverable(sIBusMessage);
    }

    protected Reliability getUnrecoverableReliability() {
        return this.mainConsumer.getUnrecoverableReliability();
    }

    protected ConsumerSession getConsumerSession() {
        return this.mainConsumer.getConsumerSession();
    }

    protected Conversation getConversation() {
        return this.mainConsumer.getConversation();
    }

    protected int getLowestPriority() {
        return this.mainConsumer.getLowestPriority();
    }

    protected short getClientSessionId() {
        return this.mainConsumer.getClientSessionId();
    }

    protected boolean isMulticast() {
        return this.mainConsumer.getMulticast();
    }

    public void setAsynchConsumerCallback(int n, int n2, long l, int n3, OrderingContext orderingContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setAsynchConsumerCallback", new Object[]{"" + n, "" + n3, orderingContext});
        }
        try {
            if (n3 > 1 && tc.isDebugEnabled()) {
                SibTr.debug(tc, "*** The batch size submitted to CATProxyConsumer was great than 1");
            }
            this.getConsumerSession().registerAsynchConsumerCallback(this.callback, n2, l, n3, null);
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException(exception.getMessage(), exception);
            throw runtimeException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setAsynchConsumerCallback");
        }
    }

    public void unlockSet(int n, SIMessageHandle[] sIMessageHandleArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockSet");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Request to delete " + sIMessageHandleArray.length + " message(s)");
        }
        try {
            this.getConsumerSession().unlockSet(sIMessageHandleArray);
            if (bl) {
                ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
                List list = conversationState.getList();
                try {
                    this.getConversation().send(list, 233, n, 7, true, null, null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".unlockSet"), (String)"3-021-0004", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, sIException.getMessage(), sIException);
                    }
                    SibTr.error(tc, "COMMUNICATION_ERROR_SICO2014", sIException);
                }
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".unlockSet"), (String)"3-021-0003", (Object)this);
            if (bl) {
                StaticCATHelper.sendExceptionToClient(sIException, "3-021-0003", this.getConversation(), n);
            }
            SibTr.error(tc, "UNABLE_TO_UNLOCK_MSGS_SICO2006", sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unlockSet");
        }
    }

    public void deleteSet(int n, SIMessageHandle[] sIMessageHandleArray, CATTransaction cATTransaction, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteSet");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Request to delete " + sIMessageHandleArray.length + " message(s)");
            if (bl) {
                SibTr.debug(tc, "Client is expecting a reply");
            }
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        try {
            SITransaction sITransaction = null;
            if (cATTransaction != null) {
                sITransaction = cATTransaction.getSITransaction();
            }
            this.getConsumerSession().deleteSet(sIMessageHandleArray, sITransaction);
            try {
                if (bl) {
                    this.getConversation().send(list, 219, n, 7, true, null, null);
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".deleteSet"), (String)"3-021-0002", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2014", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".deleteSet"), (String)"3-021-0001", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            if (bl) {
                StaticCATHelper.sendExceptionToClient(sIException, "3-021-0001", this.getConversation(), n);
            }
            SibTr.error(tc, "UNABLE_TO_DELETE_MSGS_SICO2007", sIException);
            StaticCATHelper.sendAsyncExceptionToClient(sIException, "3-021-0001", this.getClientSessionId(), this.getConversation(), 0);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAll(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockAll");
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        try {
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().stop();
                this.started = false;
            }
            this.mainConsumer.incremenetMessageBatchNumber();
            this.getConsumerSession().unlockAll();
            CATProxyConsumer cATProxyConsumer = this;
            synchronized (cATProxyConsumer) {
                this.setSentBytes(0);
            }
            short s = JFapChannelConstants.getJFAPPriority(new Integer(this.mainConsumer.getLowestPriority()));
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Sending with JFAP priority of " + s);
            }
            try {
                this.getConversation().send(list, 216, n, s, true, null, null);
                if (this.mainConsumer.isStarted()) {
                    this.getConsumerSession().start(false);
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".unlockAll"), (String)"3-021-0005", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2014", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".unlockAll"), (String)"3-021-0006", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-021-0006", this.getConversation(), n);
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unlockAll");
        }
    }

    public void flush(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "flush");
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        try {
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().stop();
            }
            this.getConsumerSession().activateAsynchConsumer(true);
            if (this.mainConsumer.isStarted()) {
                this.getConsumerSession().start(false);
            }
            short s = JFapChannelConstants.getJFAPPriority(new Integer(this.mainConsumer.getLowestPriority()));
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Sending with JFAP priority of " + s);
            }
            try {
                this.getConversation().send(list, 215, n, s, true, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".flush"), (String)"3-021-0007", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, sIException.getMessage(), sIException);
                }
                SibTr.error(tc, "COMMUNICATION_ERROR_SICO2014", sIException);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".flush"), (String)"3-021-0008", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendExceptionToClient(sIException, "3-021-0008", this.getConversation(), n);
        }
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "flush");
        }
    }

    protected int sendMessage(SIBusMessage sIBusMessage) throws MessageCopyFailedException, IncorrectMessageTypeException, MessageEncodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "sendMessage");
        }
        ConversationState conversationState = (ConversationState)this.getConversation().getAttachment();
        List list = conversationState.getList();
        int n = 0;
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Encoding JsMessage");
        }
        n = CommsUtils.encodeMessage(list, this.getConversation(), (JsMessage)sIBusMessage);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Completed");
        }
        List list2 = conversationState.getList();
        WsByteBuffer wsByteBuffer = bbPoolManager.allocate(14);
        wsByteBuffer.putShort(conversationState.getConnectionObjectId());
        wsByteBuffer.putShort(this.mainConsumer.getClientSessionId());
        wsByteBuffer.putShort(this.mainConsumer.getMessageBatchNumber());
        wsByteBuffer.putLong((long)n);
        wsByteBuffer.flip();
        list2.add(wsByteBuffer);
        list2.addAll(list);
        short s = JFapChannelConstants.getJFAPPriority(sIBusMessage.getPriority());
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Sending with JFAP priority of " + s);
        }
        try {
            this.getConversation().send(list2, 220, 0, s, false, null, null);
            CommsPMI.getClientStats().onWriteMessage(n);
            CommsPMI.getClientDetailedStats().onSendMessage(s);
            ++this.messagesSent;
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".sendMessage"), (String)"3-021-0009", (Object)this);
            SibTr.error(tc, "COMMUNICATION_ERROR_SICO2014", sIException);
        }
        conversationState.returnList(list2);
        conversationState.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "sendMessage");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestMsgs(int n, int n2, int n3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "requestMsgs", new Object[]{"" + n, "" + n2, "" + n3});
        }
        try {
            CATProxyConsumer cATProxyConsumer = this;
            synchronized (cATProxyConsumer) {
                this.setSentBytes(this.getSentBytes() - n2);
                this.setRequestedBytes(n3);
                int n4 = this.getSentBytes();
                if (n4 < n3) {
                    if (!this.started) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Starting the session (sentBytes < requestedBytes && !started)");
                        }
                        this.getConsumerSession().start(false);
                        this.started = true;
                    } else if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Already started");
                    }
                }
                if (n4 >= n3) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Stopping the session (sentBytes >= requestedBytes)");
                    }
                    this.getConsumerSession().stop();
                    this.started = false;
                }
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".requestMsgs"), (String)"3-021-0010", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, sIException.getMessage(), sIException);
            }
            StaticCATHelper.sendAsyncExceptionToClient(sIException, "3-021-0010", this.getClientSessionId(), this.getConversation(), 0);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "requestMsgs");
        }
    }

    public int getRequestedBytes() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getRequestedBytes");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=", new Integer(this.requestedBytes));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getRequestedBytes");
        }
        return this.requestedBytes;
    }

    public void setRequestedBytes(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setRequestedBytes");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params: newRequestedBytes", new Integer(n));
        }
        this.requestedBytes = n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setRequestedBytes");
        }
    }

    public int getSentBytes() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSentBytes");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=", new Integer(this.sentBytes));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSentBytes");
        }
        return this.sentBytes;
    }

    public void setSentBytes(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setSentBytes");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params: newSentBytes", new Integer(n));
        }
        this.sentBytes = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setSentBytes");
        }
    }

    public void setLowestPriority(short s) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setLowestPriority");
        }
        this.mainConsumer.setLowestPriority(s);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setLowestPriority");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATProxyConsumer.java, SIB.comms, WAS602.SIB, o0610.11 1.48.1.1");
        }
    }
}

