/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class IntArray {
    private static final TraceComponent tc = SibTr.register(IntArray.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private List allArrays = null;
    private int arraySize;
    private int[] current;
    private int currentCursor = 0;
    private int elements = 0;
    private static final int DEFAULT_SIZE = 20;

    public IntArray(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params: initialArraySize", new Integer(n));
        }
        this.arraySize = n;
        this.current = new int[this.arraySize];
        this.allArrays = new ArrayList();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public IntArray() {
        this(20);
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public void add(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "add");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params: int", new Integer(n));
        }
        if (this.currentCursor == this.arraySize) {
            this.allArrays.add(this.current);
            this.current = new int[this.arraySize];
            this.currentCursor = 0;
        }
        this.current[this.currentCursor] = n;
        ++this.currentCursor;
        ++this.elements;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "add");
        }
    }

    public int get(int n) throws NoSuchElementException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "get");
        }
        int n2 = 0;
        int n3 = n / this.arraySize;
        if (n + 1 > this.elements) {
            throw new NoSuchElementException();
        }
        if (n < 0) {
            throw new NoSuchElementException();
        }
        if (this.allArrays.size() == n3) {
            n2 = this.current[n - n3 * this.arraySize];
        } else {
            int[] nArray = (int[])this.allArrays.get(n3);
            n2 = nArray[n - n3 * this.arraySize];
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=", new Integer(n2));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "get");
        }
        return n2;
    }

    public int length() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "length");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "rc=", new Integer(this.elements));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "length");
        }
        return this.elements;
    }

    public String toString() {
        String string = "[";
        for (int i = 0; i < this.length(); ++i) {
            string = i == 0 ? string + this.get(i) : string + ", " + this.get(i);
        }
        string = string + "]";
        return string;
    }
}

