/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.comms.common.XidProxy;
import com.ibm.ws.sib.comms.server.IdToObjectMap;
import com.ibm.ws.sib.comms.server.IntArray;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATTransaction;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;

public class IdToTransactionTable {
    private static final TraceComponent tc = SibTr.register(IdToTransactionTable.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private IdToObjectMap map = new IdToObjectMap();

    public synchronized void addLocalTran(int n, CATConnection cATConnection, SIUncoordinatedTransaction sIUncoordinatedTransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "add", (Object)("" + n));
        }
        CATTransaction cATTransaction = new CATTransaction(cATConnection, n);
        cATTransaction.setTransaction(sIUncoordinatedTransaction);
        cATConnection.associateTransaction(n);
        this.map.put(n, cATTransaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "add");
        }
    }

    public synchronized void addGlobalTran(int n, CATConnection cATConnection, SIXAResource sIXAResource, XidProxy xidProxy) {
        CATTransaction cATTransaction = null;
        if (this.map.containsKey(n)) {
            cATTransaction = (CATTransaction)this.map.get(n);
        } else {
            cATTransaction = new CATTransaction(cATConnection, n);
            this.map.put(n, cATTransaction);
            cATConnection.associateTransaction(n);
        }
        cATTransaction.setInDoubt(xidProxy);
        cATTransaction.setTransaction(sIXAResource);
    }

    public synchronized CATTransaction get(int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "get", new Object[]{"" + n, "" + bl});
        }
        CATTransaction cATTransaction = null;
        if (bl) {
            if (this.map.containsKey(n)) {
                cATTransaction = (CATTransaction)this.map.get(n);
            }
        } else {
            cATTransaction = (CATTransaction)this.map.get(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "get", cATTransaction);
        }
        return cATTransaction;
    }

    public CATTransaction get(int n) {
        return this.get(n, false);
    }

    public synchronized void removeLocalTran(int n) {
        CATTransaction cATTransaction;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "remove", (Object)("" + n));
        }
        if ((cATTransaction = (CATTransaction)this.map.remove(n)) == null) {
            throw new SIErrorException();
        }
        cATTransaction.getOwningCATConnection().disassociateTransaction(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "remove", (Object)("" + n));
        }
    }

    public synchronized void removeGlobalTran(int n, XidProxy xidProxy) {
        CATTransaction cATTransaction;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "removeGlobalTran", new Object[]{"" + n, xidProxy});
        }
        if ((cATTransaction = (CATTransaction)this.map.get(n)) == null) {
            throw new SIErrorException();
        }
        cATTransaction.setComplete(xidProxy);
        if (!cATTransaction.hasInDoubtTransactions()) {
            this.map.remove(n);
            cATTransaction.getOwningCATConnection().disassociateTransaction(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "removeGlobalTran");
        }
    }

    public synchronized void removeTransactions(IntArray intArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "removeTransactions", intArray);
        }
        for (int i = 0; i < intArray.length(); ++i) {
            this.map.remove(intArray.get(i));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "removeTransactions");
        }
    }

    public String toString() {
        return this.map.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/IdToTransactionTable.java, SIB.comms, WAS602.SIB, o0610.11 1.13");
        }
    }
}

