/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.common.CommsString;
import com.ibm.ws.sib.comms.server.ListPool;
import com.ibm.ws.sib.comms.server.ObjectStoreFullException;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CachedSessionProperties;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class ConversationState {
    private static TraceComponent tc = SibTr.register(ConversationState.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static String CLASS_NAME = ConversationState.class.getName();
    public static final int OBJECT_TABLE_ORIGIN = 10;
    public static final int INITIAL_SIZE_OF_OBJECT_TABLE = 42;
    static final int MINUS_ONE = -1;
    static final int OBJECT_TABLE_EXTEND_FACTOR = 2;
    private int maxIndex = 41;
    private int highWatermark = 10;
    private int freeSlot = 10;
    private int maxTableSize = 0;
    private Object[] objectTable;
    private boolean foundFreeSlot;
    private short connectionObjectId;
    private int requestNumber = 0;
    private CachedSessionProperties cachedProps = null;
    private CATMainConsumer cachedConsumer = null;
    private ListPool listPool = new ListPool();
    private CommsConnection cc = null;
    private ArrayList mtConsumers = new ArrayList();

    public ConversationState() {
        this(Short.MAX_VALUE);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public ConversationState(int n) {
        this(42, n);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", "" + n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public ConversationState(int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{"" + n, "" + n2});
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "ConversationState", (Object)"CS> Create a new Conversation State (Object Store)");
        }
        if (n <= 0 || n2 <= 0) {
            throw new NegativeArraySizeException();
        }
        if (n < 10) {
            throw new IllegalArgumentException();
        }
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        this.maxTableSize = n2;
        this.objectTable = new Object[n];
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public void setConnectionObjectId(short s) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setConnectionObjectId", new Short(s));
        }
        this.connectionObjectId = s;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setConnectionObjectId");
        }
    }

    public short getConnectionObjectId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getConnectionObjectId");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getConnectionObjectId", new Short(this.connectionObjectId));
        }
        return this.connectionObjectId;
    }

    public void setCachedConsumerProps(CachedSessionProperties cachedSessionProperties) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setCachedConsumerProps", cachedSessionProperties);
        }
        this.cachedProps = cachedSessionProperties;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setCachedConsumerProps");
        }
    }

    public CachedSessionProperties getCachedConsumerProps() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getCachedConsumerProps");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getCachedConsumerProps", this.cachedProps);
        }
        return this.cachedProps;
    }

    public CATMainConsumer getCachedConsumer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getCachedConsumer");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getCachedConsumer", this.cachedConsumer);
        }
        return this.cachedConsumer;
    }

    public void setCachedConsumer(CATMainConsumer cATMainConsumer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setCachedConsumer", cATMainConsumer);
        }
        this.cachedConsumer = cATMainConsumer;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setCachedConsumer");
        }
    }

    public CommsString getCommsString() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getCommsString");
        }
        CommsString commsString = new CommsString();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getCommsString", commsString);
        }
        return commsString;
    }

    public List getList() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getList");
        }
        List list = this.listPool.getList();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getList", list);
        }
        return list;
    }

    public void returnList(List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "returnList", list);
        }
        this.listPool.returnList(list);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "returnList");
        }
    }

    public void addMulticastConsumer(ConsumerSession consumerSession) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "addMulticastConsumer", consumerSession);
        }
        this.mtConsumers.add(consumerSession);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "addMulticastConsumer");
        }
    }

    public void removeMulticastConsumer(ConsumerSession consumerSession) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "removeMulticastConsumer", consumerSession);
        }
        this.mtConsumers.remove(consumerSession);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "removeMulticastConsumer");
        }
    }

    public List getMulticastConsumers() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getMulticastConsumers");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getMulticastConsumers", this.mtConsumers);
        }
        return this.mtConsumers;
    }

    public int getObjectCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getObjectCount");
        }
        int n = 0;
        for (int i = 10; i < this.maxIndex; ++i) {
            if (this.objectTable[i] == null) continue;
            ++n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getObjectCount", new Integer(n));
        }
        return n;
    }

    public synchronized int addObject(Object object) throws ObjectStoreFullException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "addObject");
        }
        int n2 = 0;
        if (this.freeSlot == -1) {
            this.extendObjectTable();
        }
        n2 = this.freeSlot;
        this.objectTable[n2] = object;
        this.highWatermark = Math.max(this.highWatermark, this.freeSlot);
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "High Water Mark = ", new Integer(this.highWatermark));
        }
        this.foundFreeSlot = false;
        for (n = this.highWatermark + 1; n <= this.maxIndex; ++n) {
            if (this.objectTable[n] != null) continue;
            this.freeSlot = n;
            this.foundFreeSlot = true;
            break;
        }
        if (!this.foundFreeSlot) {
            for (n = 10; n <= this.highWatermark - 1; ++n) {
                if (this.objectTable[n] != null) continue;
                this.freeSlot = n;
                this.foundFreeSlot = true;
                break;
            }
        }
        if (!this.foundFreeSlot) {
            this.freeSlot = -1;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Next free slot = ", new Integer(this.freeSlot));
            SibTr.debug(tc, "Max Index = ", new Integer(this.maxIndex));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "addObject", "" + n2);
        }
        return n2;
    }

    private synchronized void extendObjectTable() throws ObjectStoreFullException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "extendObjectTable");
        }
        if ((n = (this.maxIndex + 1) * 2 - 10) > this.maxTableSize) {
            if (this.maxIndex + 1 < this.maxTableSize) {
                n = this.maxTableSize;
            } else {
                ObjectStoreFullException objectStoreFullException = new ObjectStoreFullException();
                FFDCFilter.processException((Throwable)objectStoreFullException, (String)(CLASS_NAME + ".extendObjectTable"), (String)"5-004-0001", (Object[])new Object[]{this.getLastItemsInStore(), this});
                throw objectStoreFullException;
            }
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.objectTable, 0, objectArray, 0, this.maxIndex + 1);
        this.freeSlot = this.maxIndex + 1;
        this.maxIndex = n - 1;
        this.objectTable = objectArray;
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Next free slot = ", new Integer(this.freeSlot));
            SibTr.debug(tc, "Max Index = ", new Integer(this.maxIndex));
            SibTr.debug(tc, "High Water Mark = ", new Integer(this.highWatermark));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "extendObjectTable");
        }
    }

    public synchronized Object getObject(int n) throws IndexOutOfBoundsException, NoSuchElementException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getObject", "" + n);
        }
        if (n < 10 || n > this.maxIndex) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Invalid object index");
            }
            throw new IndexOutOfBoundsException();
        }
        Object object = this.objectTable[n];
        if (object == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "No such element existed!");
            }
            throw new NoSuchElementException();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getObject", object);
        }
        return object;
    }

    public synchronized void removeObject(int n) throws IndexOutOfBoundsException, NoSuchElementException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "removeObject", new Integer(n));
        }
        if (n < 10 || n > this.maxIndex) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Invalid object index");
            }
            throw new IndexOutOfBoundsException();
        }
        if (this.objectTable[n] == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "No object exists at the entry");
            }
            throw new NoSuchElementException();
        }
        this.objectTable[n] = null;
        this.freeSlot = this.freeSlot == -1 ? n : Math.min(this.freeSlot, n);
        if (this.highWatermark == n) {
            while (this.objectTable[this.highWatermark] == null && this.highWatermark != 10) {
                --this.highWatermark;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "removeObject");
        }
    }

    public synchronized List getAllObjects() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getAllObjects");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 10; i < this.maxIndex; ++i) {
            if (this.objectTable[i] == null) continue;
            arrayList.add(this.objectTable[i]);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getAllObjects", arrayList);
        }
        return arrayList;
    }

    public void dumpObjectTable(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "dumpObjectTable");
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 10; i < 10 + n; ++i) {
            System.out.println(this.objectTable[i]);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "dumpObjectTable");
        }
    }

    public CommsConnection getCommsConnection() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getCommsConnection");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getCommsConnection", this.cc);
        }
        return this.cc;
    }

    public void setCommsConnection(CommsConnection commsConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setCommsConnection", commsConnection);
        }
        this.cc = commsConnection;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setCommsConnection");
        }
    }

    public void setInitialRequestNumber(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setInitialRequestNumber", new Integer(n));
        }
        this.requestNumber = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setInitialRequestNumber");
        }
    }

    public synchronized int getUniqueRequestNumber() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getUniqueRequestNumber");
        }
        this.requestNumber += 2;
        if (this.requestNumber > Short.MAX_VALUE) {
            this.requestNumber %= 2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getUniqueRequestNumber", "" + this.requestNumber);
        }
        return this.requestNumber;
    }

    public synchronized String getLastItemsInStore() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getLastItemsInStore");
        }
        String string = "";
        for (int i = this.maxIndex; i > this.maxIndex - 101; --i) {
            string = " [" + i + "]: " + this.objectTable[i] + "\r\n" + string;
        }
        string = "The last 100 items in the store:\r\n\r\n" + string;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getLastItemsInStore");
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/server/ConversationState.java, SIB.comms, WAS602.SIB, o0610.11 1.28");
        }
    }
}

