/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.pmi;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

public class MQLinkStats
implements StatisticActionListener {
    private static final TraceComponent tc = SibTr.register(MQLinkStats.class, "SIBCommunications", null);
    private StatsInstance stats = null;
    private boolean pmiEnabled = false;
    private static final int BATCHES_SENT_ID = 1;
    private static final int BATCHES_RECEIVED_ID = 2;
    private static final int MESSAGES_SENT_ID = 3;
    private static final int MESSAGES_RECEIVED_ID = 4;
    private static final int SENDER_BYTES_SENT_ID = 5;
    private static final int SENDER_BYTES_RECEIVED_ID = 6;
    private static final int RECEIVER_BYTES_SENT_ID = 7;
    private static final int RECEIVER_BYTES_RECEIVED_ID = 8;
    private static final int SHORT_RETRIES_ID = 9;
    private static final int LONG_RETRIES_ID = 10;
    private static final int COMMS_ERRORS_ID = 11;
    private static final int QM_ATTACHED_ID = 12;
    private static final int WRITES_BLOCKED_ID = 13;
    private static final int READS_BLOCKED_ID = 14;
    private SPICountStatistic batchesSent = null;
    private SPICountStatistic batchesReceived = null;
    private SPICountStatistic messagesSent = null;
    private SPICountStatistic messagesReceived = null;
    private SPICountStatistic senderBytesSent = null;
    private SPICountStatistic senderBytesReceived = null;
    private SPICountStatistic receiverBytesSent = null;
    private SPICountStatistic receiverBytesReceived = null;
    private SPICountStatistic shortRetries = null;
    private SPICountStatistic longRetries = null;
    private SPICountStatistic commsErrors = null;
    private SPICountStatistic qmAttached = null;
    private SPICountStatistic writesBlocked = null;
    private SPICountStatistic readsBlocked = null;

    public void setPMIEnabled(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setPMIEnabled", (Object)("" + bl));
        }
        this.pmiEnabled = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setPMIEnabled");
        }
    }

    protected void setStatsInstance(StatsInstance statsInstance) {
        this.stats = statsInstance;
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "statisticCreated", sPIStatistic);
        }
        switch (sPIStatistic.getId()) {
            case 1: {
                this.batchesSent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 2: {
                this.batchesReceived = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 3: {
                this.messagesSent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 4: {
                this.messagesReceived = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 5: {
                this.senderBytesSent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 6: {
                this.senderBytesReceived = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 7: {
                this.receiverBytesSent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 8: {
                this.receiverBytesReceived = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 9: {
                this.shortRetries = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 10: {
                this.longRetries = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 11: {
                this.commsErrors = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 12: {
                this.qmAttached = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 13: {
                this.writesBlocked = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 14: {
                this.readsBlocked = (SPICountStatistic)sPIStatistic;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug(tc, "Received an unknown stat Id", (Object)("" + sPIStatistic.getId()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "statisticCreated");
        }
    }

    public void updateStatisticOnRequest(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "updateStatisticOnRequest", (Object)("" + n));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "updateStatisticOnRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWriteBlocked() {
        if (this.pmiEnabled && this.writesBlocked != null && this.writesBlocked.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.writesBlocked;
            synchronized (sPICountStatistic) {
                this.writesBlocked.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadBlocked() {
        if (this.pmiEnabled && this.readsBlocked != null && this.readsBlocked.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.readsBlocked;
            synchronized (sPICountStatistic) {
                this.readsBlocked.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onQmAttach() {
        if (this.pmiEnabled && this.qmAttached != null && this.qmAttached.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.qmAttached;
            synchronized (sPICountStatistic) {
                this.qmAttached.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onQmDetach() {
        if (this.pmiEnabled && this.qmAttached != null && this.qmAttached.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.qmAttached;
            synchronized (sPICountStatistic) {
                this.qmAttached.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSendBatch() {
        if (this.pmiEnabled && this.batchesSent != null && this.batchesSent.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.batchesSent;
            synchronized (sPICountStatistic) {
                this.batchesSent.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceiveBatch() {
        if (this.pmiEnabled && this.batchesReceived != null && this.batchesReceived.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.batchesReceived;
            synchronized (sPICountStatistic) {
                this.batchesReceived.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSendMessage() {
        if (this.pmiEnabled && this.messagesSent != null && this.messagesSent.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.messagesSent;
            synchronized (sPICountStatistic) {
                this.messagesSent.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceiveMessage() {
        if (this.pmiEnabled && this.messagesReceived != null && this.messagesReceived.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.messagesReceived;
            synchronized (sPICountStatistic) {
                this.messagesReceived.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSenderSendBytes(int n) {
        if (this.pmiEnabled && this.senderBytesSent != null && this.senderBytesSent.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.senderBytesSent;
            synchronized (sPICountStatistic) {
                this.senderBytesSent.increment((long)n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSenderReceiveBytes(int n) {
        if (this.pmiEnabled && this.senderBytesReceived != null && this.senderBytesReceived.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.senderBytesReceived;
            synchronized (sPICountStatistic) {
                this.senderBytesReceived.increment((long)n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceiverSendBytes(int n) {
        if (this.pmiEnabled && this.receiverBytesSent != null && this.receiverBytesSent.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.receiverBytesSent;
            synchronized (sPICountStatistic) {
                this.receiverBytesSent.increment((long)n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceiverReceiveBytes(int n) {
        if (this.pmiEnabled && this.receiverBytesReceived != null && this.receiverBytesReceived.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.receiverBytesReceived;
            synchronized (sPICountStatistic) {
                this.receiverBytesReceived.increment((long)n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommsError() {
        if (this.pmiEnabled && this.commsErrors != null && this.commsErrors.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.commsErrors;
            synchronized (sPICountStatistic) {
                this.commsErrors.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onShortRetry() {
        if (this.pmiEnabled && this.shortRetries != null && this.shortRetries.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.shortRetries;
            synchronized (sPICountStatistic) {
                this.shortRetries.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLongRetry() {
        if (this.pmiEnabled && this.longRetries != null && this.longRetries.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.longRetries;
            synchronized (sPICountStatistic) {
                this.longRetries.increment();
            }
        }
    }
}

