/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.pmi;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

public class MQClientLinkStats
implements StatisticActionListener {
    private static final TraceComponent tc = SibTr.register(MQClientLinkStats.class, "SIBCommunications", null);
    private StatsInstance stats = null;
    private boolean pmiEnabled = false;
    private static final int BATCHES_SENT_ID = 1;
    private static final int MESSAGES_SENT_ID = 2;
    private static final int MESSAGES_RECEIVED_ID = 3;
    private static final int BYTES_SENT_ID = 4;
    private static final int BYTES_RECEIVED_ID = 5;
    private static final int API_CALLS_SERVICED_ID = 6;
    private static final int COMMS_ERRORS_ID = 7;
    private static final int CLIENTS_ATTACHED_ID = 8;
    private static final int WRITES_BLOCKED_ID = 9;
    private static final int READS_BLOCKED_ID = 10;
    private SPICountStatistic batchesSent = null;
    private SPICountStatistic messagesSent = null;
    private SPICountStatistic messagesReceived = null;
    private SPICountStatistic bytesSent = null;
    private SPICountStatistic bytesReceived = null;
    private SPICountStatistic apiCallsServiced = null;
    private SPICountStatistic commsErrors = null;
    private SPICountStatistic clientsAttached = null;
    private SPICountStatistic writesBlocked = null;
    private SPICountStatistic readsBlocked = null;

    public void setPMIEnabled(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setPMIEnabled", (Object)("" + bl));
        }
        this.pmiEnabled = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setPMIEnabled");
        }
    }

    protected void setStatsInstance(StatsInstance statsInstance) {
        this.stats = statsInstance;
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "statisticCreated", sPIStatistic);
        }
        switch (sPIStatistic.getId()) {
            case 1: {
                this.batchesSent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 2: {
                this.messagesSent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 3: {
                this.messagesReceived = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 4: {
                this.bytesSent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 5: {
                this.bytesReceived = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 6: {
                this.apiCallsServiced = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 7: {
                this.commsErrors = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 8: {
                this.clientsAttached = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 9: {
                this.writesBlocked = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 10: {
                this.readsBlocked = (SPICountStatistic)sPIStatistic;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug(tc, "Received an unknown stat Id", (Object)("" + sPIStatistic.getId()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "statisticCreated");
        }
    }

    public void updateStatisticOnRequest(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "updateStatisticOnRequest", (Object)("" + n));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "updateStatisticOnRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWriteBlocked() {
        if (this.pmiEnabled && this.writesBlocked != null && this.writesBlocked.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.writesBlocked;
            synchronized (sPICountStatistic) {
                this.writesBlocked.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadBlocked() {
        if (this.pmiEnabled && this.readsBlocked != null && this.readsBlocked.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.readsBlocked;
            synchronized (sPICountStatistic) {
                this.readsBlocked.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientAttach() {
        if (this.pmiEnabled && this.clientsAttached != null && this.clientsAttached.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.clientsAttached;
            synchronized (sPICountStatistic) {
                this.clientsAttached.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientDetach() {
        if (this.pmiEnabled && this.clientsAttached != null && this.clientsAttached.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.clientsAttached;
            synchronized (sPICountStatistic) {
                this.clientsAttached.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApiCall() {
        if (this.pmiEnabled && this.apiCallsServiced != null && this.apiCallsServiced.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.apiCallsServiced;
            synchronized (sPICountStatistic) {
                this.apiCallsServiced.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSendBatch() {
        if (this.pmiEnabled && this.batchesSent != null && this.batchesSent.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.batchesSent;
            synchronized (sPICountStatistic) {
                this.batchesSent.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSendMessage() {
        if (this.pmiEnabled && this.messagesSent != null && this.messagesSent.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.messagesSent;
            synchronized (sPICountStatistic) {
                this.messagesSent.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceiveMessage() {
        if (this.pmiEnabled && this.messagesReceived != null && this.messagesReceived.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.messagesReceived;
            synchronized (sPICountStatistic) {
                this.messagesReceived.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSendBytes(int n) {
        if (this.pmiEnabled && this.bytesSent != null && this.bytesSent.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.bytesSent;
            synchronized (sPICountStatistic) {
                this.bytesSent.increment((long)n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceiveBytes(int n) {
        if (this.pmiEnabled && this.bytesReceived != null && this.bytesReceived.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.bytesReceived;
            synchronized (sPICountStatistic) {
                this.bytesReceived.increment((long)n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommsError() {
        if (this.pmiEnabled && this.commsErrors != null && this.commsErrors.isEnabled()) {
            SPICountStatistic sPICountStatistic = this.commsErrors;
            synchronized (sPICountStatistic) {
                this.commsErrors.increment();
            }
        }
    }
}

