/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.common;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XidProxy
implements Xid {
    private static final TraceComponent tc = SibTr.register(XidProxy.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private int formatId;
    private byte[] branchQualifier;
    private byte[] globalTransactionId;

    public XidProxy(Xid xid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.formatId = xid.getFormatId();
        this.branchQualifier = xid.getBranchQualifier();
        this.globalTransactionId = xid.getGlobalTransactionId();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, this.toString());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public XidProxy(int n, byte[] byArray, byte[] byArray2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.formatId = n;
        if (byArray2 != null) {
            this.branchQualifier = byArray;
        }
        if (byArray != null) {
            this.globalTransactionId = byArray2;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, this.toString());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public XidProxy(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.formatId = wsByteBuffer.getInt();
        int n = wsByteBuffer.getInt();
        this.globalTransactionId = new byte[n];
        wsByteBuffer.get(this.globalTransactionId);
        int n2 = wsByteBuffer.getInt();
        this.branchQualifier = new byte[n2];
        wsByteBuffer.get(this.branchQualifier);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, this.toString());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public void serialize(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "serialize");
        }
        wsByteBuffer.putInt(this.formatId);
        wsByteBuffer.putInt(this.globalTransactionId.length);
        wsByteBuffer.put(this.globalTransactionId);
        wsByteBuffer.putInt(this.branchQualifier.length);
        wsByteBuffer.put(this.branchQualifier);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "serialize");
        }
    }

    public int getSerializableLength() {
        return 12 + this.globalTransactionId.length + this.branchQualifier.length;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof XidProxy)) {
            return false;
        }
        XidProxy xidProxy = (XidProxy)object;
        if (this.formatId != xidProxy.getFormatId()) {
            return false;
        }
        if (!Arrays.equals(this.branchQualifier, xidProxy.getBranchQualifier())) {
            return false;
        }
        return Arrays.equals(this.globalTransactionId, xidProxy.getGlobalTransactionId());
    }

    public int hashCode() {
        if (this.branchQualifier.length < 4) {
            return 0;
        }
        int n = this.branchQualifier.length - 4;
        return ((0xFF & this.branchQualifier[n + 0]) << 24) + ((0xFF & this.branchQualifier[n + 1]) << 16) + ((0xFF & this.branchQualifier[n + 2]) << 8) + ((0xFF & this.branchQualifier[n + 3]) << 0);
    }

    public String toString() {
        return "JS Comms Xid: Format(" + this.formatId + "), Branch Qualifier[" + Util.toHexString((byte[])this.branchQualifier) + "], Global Transaction ID[" + Util.toHexString((byte[])this.globalTransactionId) + "]";
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/common/XidProxy.java, SIB.comms, WAS602.SIB, o0610.11 1.11");
        }
    }
}

