/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.common;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;

public class CommsString {
    private static String CLASS_NAME = CommsString.class.getName();
    private String encoding = "UTF-8";
    private static final TraceComponent tc = SibTr.register(CommsString.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private String theString = null;
    private long length = 0L;
    private byte[] bytes = null;
    private boolean thisIsNull = false;

    public CommsString() {
        this.setString(null);
    }

    public CommsString(String string) {
        this.setString(string);
    }

    public void setString(String string) {
        this.theString = string;
        if (string != null) {
            try {
                this.bytes = string.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)(CLASS_NAME + ".setString"), (String)"5-002-0001", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Unable to encode String: ", unsupportedEncodingException);
                }
                SibTr.error(tc, "UNSUPPORTED_STRING_ENCODING_SICO8005", new Object[]{this.encoding, unsupportedEncodingException});
                throw new SIErrorException(nls.getFormattedMessage("UNSUPPORTED_STRING_ENCODING_SICO8005", new Object[]{this.encoding, unsupportedEncodingException}, null));
            }
            this.length = this.bytes.length;
            this.thisIsNull = false;
        } else {
            this.length = 1L;
            this.bytes = new byte[]{0};
            this.thisIsNull = true;
        }
        this.validate();
    }

    public void setBytes(byte[] byArray) {
        if (byArray.length == 1 && byArray[0] == 0) {
            this.thisIsNull = true;
            this.length = 1L;
            this.bytes = byArray;
            this.theString = null;
        } else {
            try {
                this.theString = new String(byArray, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)(CLASS_NAME + ".setBytes"), (String)"5-002-0002", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Unable to encode String: ", unsupportedEncodingException);
                    SibTr.exception(tc, unsupportedEncodingException);
                }
                SibTr.error(tc, "UNSUPPORTED_STRING_ENCODING_SICO8005", new Object[]{this.encoding, unsupportedEncodingException});
                throw new SIErrorException(nls.getFormattedMessage("UNSUPPORTED_STRING_ENCODING_SICO8005", new Object[]{this.encoding, unsupportedEncodingException}, null));
            }
            this.length = byArray.length;
            this.bytes = byArray;
            this.thisIsNull = false;
        }
        this.validate();
    }

    private void validate() {
        if (this.length > 32767L) {
            SibTr.error(tc, "STRING_TOO_LONG_SICO8006");
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("STRING_TOO_LONG_SICO8006", new Object[]{new Long(this.length), "32767"}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".validate"), (String)"5-002-0003", (Object)this);
            throw sIErrorException;
        }
    }

    public String getString() {
        return this.theString;
    }

    public short getLength() {
        return (short)this.length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean isNull() {
        return this.thisIsNull;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/common/CommsString.java, SIB.comms, WAS602.SIB, o0610.11 1.17");
        }
    }
}

