/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.queue;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.DestinationSessionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.asynch.AsynchConsumerThreadPool;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelper;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.LockedMessageEnumerationImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.MulticastReadAheadProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.BaseQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.QueueData;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.ReadAheadData;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.Date;
import java.util.LinkedList;

public class ReadAheadQueue
extends BaseQueue {
    private static String CLASS_NAME = ReadAheadQueue.class.getName();
    private static final TraceComponent tc = SibTr.register(ReadAheadQueue.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private LinkedList queue = new LinkedList();
    private short currentBatchNumber = 0;
    private ConversationHelper convHelper;
    private boolean serviced = false;
    private Object closeLock = new Object();
    private Object descriptorLock = new Object();
    private QuickApproxTime approxTimeThread = null;
    private Reliability unrecoverableReliability = Reliability.NONE;
    private Object concAccessMonitor = new Object();
    private int HIGH_QUEUE_BYTES = CommsUtils.getRuntimeIntProperty("sib.comms.RAHighQueueBytes", "102400");
    private double LOW_QUEUE_FACTOR = CommsUtils.getRuntimeDoubleProperty("sib.comms.RALowQueueBytesFactor", "0.5");
    private double HIGH_QUEUE_BYTES_THRESHOLD_FACTOR = CommsUtils.getRuntimeDoubleProperty("sib.comms.RAHighQueueBytesThreshold", "0");
    private int HIGH_QUEUE_BYTES_MAX = CommsUtils.getRuntimeIntProperty("sib.comms.RAHighQueueBytesMax", "10240000");
    private int HIGH_QUEUE_BYTES_ALTERATION_TIMEOUT = CommsUtils.getRuntimeIntProperty("sib.comms.RAHighQueueBytesTimeOut", "2000");
    private int LOW_QUEUE_BYTES = (int)((double)this.HIGH_QUEUE_BYTES * this.LOW_QUEUE_FACTOR);
    private boolean trackBytes;
    private int bytesReceivedSinceLastRequestForMsgs = 0;
    private int bytesGivenToUserSinceLastRequestForMsgs = 0;
    private int totalRequests = 0;
    private long totalBytesGiven = 0L;
    private long messagesReceived = 0L;
    private long goneEmptyCount = 0L;
    private long currentBytesOnQueue = 0L;
    private long lastRequestForMessagesTime = 0L;
    private int NEW_HIGH_QUEUE_BYTES = 0;
    private int NEW_LOW_QUEUE_BYTES = 0;

    public ReadAheadQueue(short s, ConversationHelper conversationHelper) {
        this(s, conversationHelper, true, null);
    }

    public ReadAheadQueue(short s, ConversationHelper conversationHelper, Reliability reliability) {
        this(s, conversationHelper, true, reliability);
    }

    public ReadAheadQueue(short s, ConversationHelper conversationHelper, boolean bl, Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>", new Object[]{"" + s, conversationHelper, "" + bl, reliability});
        }
        this.convHelper = conversationHelper;
        this.trackBytes = bl;
        if (reliability != null) {
            this.unrecoverableReliability = reliability;
        }
        if (this.approxTimeThread == null) {
            this.approxTimeThread = QuickApproxTime.getRef();
            this.approxTimeThread.setInterval(50L);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "ReadAhead Queue Startup paramters:", new Object[]{"HIGH_QUEUE_BYTES=" + this.HIGH_QUEUE_BYTES, "LOW_QUEUE_BYTES=" + this.LOW_QUEUE_BYTES, "HIGH_QUEUE_BYTES_THRESHOLD_FACTOR=" + this.HIGH_QUEUE_BYTES_THRESHOLD_FACTOR, "HIGH_QUEUE_BYTES_ALTERATION_TIMEOUT=" + this.HIGH_QUEUE_BYTES_ALTERATION_TIMEOUT, "HIGH_QUEUE_BYTES_MAX=" + this.HIGH_QUEUE_BYTES_MAX});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public void putToFront(QueueData queueData, short s) {
        this._put(queueData, s, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _put(QueueData queueData, short s, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "_put", new Object[]{queueData, "" + s, "" + bl});
        }
        boolean bl2 = false;
        ReadAheadQueue readAheadQueue = this;
        synchronized (readAheadQueue) {
            if (s == this.currentBatchNumber) {
                if (this.HIGH_QUEUE_BYTES_THRESHOLD_FACTOR != 0.0 && this.HIGH_QUEUE_BYTES != this.HIGH_QUEUE_BYTES_MAX && this.bytesReceivedSinceLastRequestForMsgs == 0) {
                    float f = (float)this.currentBytesOnQueue / (float)this.HIGH_QUEUE_BYTES;
                    int n = (int)f * 100;
                    if ((double)f < this.HIGH_QUEUE_BYTES_THRESHOLD_FACTOR) {
                        long l = System.currentTimeMillis();
                        if (l < this.lastRequestForMessagesTime + (long)this.HIGH_QUEUE_BYTES_ALTERATION_TIMEOUT) {
                            if (this.NEW_HIGH_QUEUE_BYTES == 0) {
                                this.NEW_HIGH_QUEUE_BYTES = this.HIGH_QUEUE_BYTES;
                                this.NEW_LOW_QUEUE_BYTES = this.LOW_QUEUE_BYTES;
                            }
                            int n2 = this.NEW_HIGH_QUEUE_BYTES;
                            int n3 = (int)(this.HIGH_QUEUE_BYTES_THRESHOLD_FACTOR * (double)this.NEW_HIGH_QUEUE_BYTES);
                            this.NEW_HIGH_QUEUE_BYTES += n3 - (int)this.currentBytesOnQueue;
                            if (this.NEW_HIGH_QUEUE_BYTES > this.HIGH_QUEUE_BYTES_MAX) {
                                this.NEW_HIGH_QUEUE_BYTES = this.HIGH_QUEUE_BYTES_MAX;
                            }
                            this.NEW_LOW_QUEUE_BYTES = (int)((double)this.NEW_HIGH_QUEUE_BYTES * this.LOW_QUEUE_FACTOR);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(tc, "HIGH_QUEUE_BYTES altered as Queue is " + n + "% full (" + this.currentBytesOnQueue + "/" + n2 + ")");
                            }
                        } else if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Messages arrived outside the alteration timeout - no alteration made (Request made at: " + this.lastRequestForMessagesTime + ", now: " + l);
                        }
                    } else if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Queue depth is fine - no need to alter (" + n + "% full)");
                    }
                }
                long l = queueData.getData().remaining();
                if (this.trackBytes) {
                    this.bytesReceivedSinceLastRequestForMsgs = (int)((long)this.bytesReceivedSinceLastRequestForMsgs + l);
                }
                ReadAheadData readAheadData = new ReadAheadData(queueData, this.approxTimeThread.getApproxTime());
                if (bl) {
                    this.queue.addFirst(readAheadData);
                } else {
                    this.queue.addLast(readAheadData);
                }
                ++this.messagesReceived;
                this.currentBytesOnQueue += l;
            } else if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Message is not being put as the batch number (" + s + ") != current batch number (" + this.currentBatchNumber + ")");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "_put");
        }
    }

    public synchronized JsMessage get(short s) throws MessageDecodeFailedException, SIConnectionDroppedException, SIConnectionLostException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "get");
        }
        JsMessage jsMessage = null;
        if (!this.queue.isEmpty()) {
            WsByteBuffer wsByteBuffer = null;
            while (!this.queue.isEmpty()) {
                block18: {
                    ReadAheadData readAheadData = (ReadAheadData)this.queue.removeLast();
                    ProxyQueue proxyQueue = readAheadData.getProxyQueue();
                    wsByteBuffer = readAheadData.getData();
                    DestinationSessionProxy destinationSessionProxy = proxyQueue.getDestinationSessionProxy();
                    jsMessage = destinationSessionProxy instanceof ConsumerSessionProxy && ((ConsumerSessionProxy)destinationSessionProxy).isMulticastSession() ? this.convert(wsByteBuffer, this.convHelper.getCommsConnection()) : this.convert(wsByteBuffer);
                    boolean bl = false;
                    long l = jsMessage.getRemainingTimeToLive();
                    if (l != -1L) {
                        long l2 = this.approxTimeThread.getApproxTime();
                        long l3 = readAheadData.getArrivalTime();
                        l += 500L;
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Arrived: " + new Date(l3) + ", Now: " + new Date(l2) + ", Expires: " + new Date(l3 + l));
                        }
                        if (l2 > l3 + l) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(tc, "Message has expired: " + jsMessage.getMessageHandle());
                            }
                            bl = true;
                        }
                    }
                    if (this.trackBytes) {
                        this.bytesGivenToUserSinceLastRequestForMsgs += wsByteBuffer.remaining();
                    }
                    this.totalBytesGiven += (long)this.bytesGivenToUserSinceLastRequestForMsgs;
                    this.currentBytesOnQueue -= (long)wsByteBuffer.remaining();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Current bytes on the queue", "" + this.currentBytesOnQueue);
                        SibTr.debug(this, tc, "Bytes given since last request", "" + this.bytesGivenToUserSinceLastRequestForMsgs);
                    }
                    if (this.trackBytes && this.bytesGivenToUserSinceLastRequestForMsgs >= this.HIGH_QUEUE_BYTES - this.LOW_QUEUE_BYTES) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "Need more messages: " + this.bytesGivenToUserSinceLastRequestForMsgs + " >= " + (this.HIGH_QUEUE_BYTES - this.LOW_QUEUE_BYTES));
                        }
                        if (this.NEW_HIGH_QUEUE_BYTES != 0) {
                            this.HIGH_QUEUE_BYTES = this.NEW_HIGH_QUEUE_BYTES;
                            this.LOW_QUEUE_BYTES = this.NEW_LOW_QUEUE_BYTES;
                        }
                        this.convHelper.requestMoreMessages(this.bytesReceivedSinceLastRequestForMsgs, this.HIGH_QUEUE_BYTES);
                        this.bytesGivenToUserSinceLastRequestForMsgs = 0;
                        this.bytesReceivedSinceLastRequestForMsgs = 0;
                        ++this.totalRequests;
                        this.lastRequestForMessagesTime = System.currentTimeMillis();
                        if (this.queue.isEmpty()) {
                            ++this.goneEmptyCount;
                        }
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "Queue is now: ", this);
                        }
                    }
                    if (!bl) break;
                    if (this.isRecoverable(jsMessage) && !(proxyQueue instanceof MulticastReadAheadProxyQueueImpl)) {
                        try {
                            this.convHelper.unlockSet(new SIMessageHandle[]{jsMessage.getMessageHandle()});
                        }
                        catch (SIException sIException) {
                            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".get"), (String)"2-012-0002", (Object)this);
                            if (!tc.isDebugEnabled()) break block18;
                            SibTr.debug(tc, "Unable to unlock expired message", sIException);
                        }
                    }
                }
                jsMessage = null;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "get", jsMessage);
        }
        return jsMessage;
    }

    public synchronized JsMessage[] getBatch(int n, short s) throws MessageDecodeFailedException, SIConnectionDroppedException, SIConnectionLostException {
        int n2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBatch", (Object)("" + n));
        }
        if ((n2 = this.queue.size()) > n) {
            n2 = n;
        }
        JsMessage[] jsMessageArray = new JsMessage[n2];
        for (int i = 0; i < jsMessageArray.length; ++i) {
            jsMessageArray[i] = this.get(s);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBatch", jsMessageArray);
        }
        return jsMessageArray;
    }

    public boolean isQueueEmpty() {
        return this.queue.isEmpty();
    }

    public synchronized void unlockAll() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockAll");
        }
        if (this.trackBytes) {
            this.currentBatchNumber = (short)(this.currentBatchNumber + 1);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unlockAll", (Object)("" + this.currentBatchNumber));
        }
    }

    public String toString() {
        return "ReadAheadQueue@" + Integer.toHexString(this.hashCode()) + ":- CurDepth: " + this.queue.size() + ", serviced: " + this.serviced + ", messagesReceived: " + this.messagesReceived + ", totalRequests: " + this.totalRequests + ", goneEmptyCount: " + this.goneEmptyCount + ", bytesGivenToUserSinceLastRequest: " + this.bytesGivenToUserSinceLastRequestForMsgs + ", bytesReceivedSinceLastRequest: " + this.bytesReceivedSinceLastRequestForMsgs + ", totalBytesGiven: " + this.totalBytesGiven + ", totalBytesOnQueue: " + this.currentBytesOnQueue;
    }

    private boolean isRecoverable(JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isRecoverable");
        }
        boolean bl = false;
        Reliability reliability = jsMessage.getReliability();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Message Reliability: ", reliability);
        }
        if (reliability.compareTo(this.unrecoverableReliability) > 0) {
            bl = true;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Message is recoverable");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isRecoverable");
        }
        return bl;
    }

    public void put(QueueData queueData, short s) {
        this._put(queueData, s, true);
    }

    public void deliverBatch(int n, short s, ConversationHelper conversationHelper) {
        AsynchConsumerProxyQueue asynchConsumerProxyQueue;
        block19: {
            Object object;
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "deliverBatch", new Object[]{"" + n, "" + s, conversationHelper});
            }
            Throwable throwable = null;
            QueueData queueData = (QueueData)this.queue.get(0);
            asynchConsumerProxyQueue = (AsynchConsumerProxyQueue)queueData.getProxyQueue();
            asynchConsumerProxyQueue.setAsynchConsumerThread(Thread.currentThread());
            try {
                JsMessage[] jsMessageArray = this.getBatch(n, s);
                object = new LockedMessageEnumerationImpl(asynchConsumerProxyQueue, this, jsMessageArray, Thread.currentThread(), asynchConsumerProxyQueue.getLMEOperationMonitor());
                asynchConsumerProxyQueue.getAsynchConsumerCallback().consumeMessages((LockedMessageEnumeration)object);
                int n2 = ((LockedMessageEnumerationImpl)object).getRemainingMessageCount();
                if (n2 != 0) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "There are still " + n2 + " locked messages! - Unlocking them");
                    }
                    ((LockedMessageEnumerationImpl)object).unlockUnseen();
                }
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-012-0004", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "exception thrown");
                }
                if (tc.isEventEnabled()) {
                    SibTr.event(tc, "exception", throwable2);
                }
                asynchConsumerProxyQueue.setAsynchConsumerThread(null);
                object = (ConsumerSessionProxy)asynchConsumerProxyQueue.getDestinationSessionProxy();
                ((ConsumerSessionProxy)object).deliverAsyncException(throwable);
                try {
                    ((ConsumerSessionProxy)object).unlockAll();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-012-0006", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "exception thrown");
                    }
                    if (!tc.isEventEnabled()) break block19;
                    SibTr.event(tc, "exception", sIException);
                }
            }
        }
        boolean bl = asynchConsumerProxyQueue.didUserCloseInsideAsynchCallback();
        boolean bl2 = asynchConsumerProxyQueue.didUserStopInsideAsynchCallback();
        asynchConsumerProxyQueue.setAsynchConsumerThread(null);
        ConsumerSessionProxy consumerSessionProxy = (ConsumerSessionProxy)asynchConsumerProxyQueue.getDestinationSessionProxy();
        if (bl) {
            try {
                consumerSessionProxy.close();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-012-0007", (Object)this);
                consumerSessionProxy.deliverAsyncException(sIException);
            }
        } else if (bl2) {
            try {
                consumerSessionProxy.stop();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-012-0008", (Object)this);
                consumerSessionProxy.deliverAsyncException(sIException);
            }
        } else {
            AsynchConsumerThreadPool.getInstance().dispatch(asynchConsumerProxyQueue);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "deliverBatch");
        }
    }

    public boolean isEmpty(short s) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isEmpty", (Object)("" + s));
        }
        boolean bl = this.queue.isEmpty();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isEmpty", (Object)("" + bl));
        }
        return bl;
    }

    public void purge(short s) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "purge", (Object)("" + s));
        }
        this.queue.clear();
        this.bytesGivenToUserSinceLastRequestForMsgs = 0;
        this.bytesReceivedSinceLastRequestForMsgs = 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "purge");
        }
    }

    public Object getConcurrentAccessLock() {
        return this.concAccessMonitor;
    }

    public void setTrackBytes(boolean bl) {
        this.trackBytes = bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/queue/ReadAheadQueue.java, SIB.comms, WAS602.SIB, o0610.11 1.43");
        }
    }
}

