/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.queue;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelper;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.LockedMessageEnumerationImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.BaseQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.QueueData;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.LinkedList;

public class AsynchConsumerQueue
extends BaseQueue {
    private static String CLASS_NAME = AsynchConsumerQueue.class.getName();
    private static final TraceComponent tc = SibTr.register(AsynchConsumerQueue.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private boolean ordered = false;
    private int batchesReady = 0;
    private LinkedList queue = new LinkedList();
    private long batchesReceived = 0L;
    private long messagesReceived = 0L;
    private Object concurrentAccessLock = new Object();

    public AsynchConsumerQueue(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>", (Object)("" + bl));
        }
        this.ordered = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(QueueData queueData, short s) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "put", new Object[]{queueData, "" + s});
        }
        boolean bl = false;
        AsynchConsumerQueue asynchConsumerQueue = this;
        synchronized (asynchConsumerQueue) {
            if (!this.ordered && this.batchesReady == 1) {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("ASYNC_BATCH_ALREADY_READY_SICO1031", null, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".put"), (String)"2-007-0001", (Object)this);
                throw sIErrorException;
            }
            this.queue.addLast(queueData);
            if (queueData.isLastInBatch()) {
                ++this.batchesReceived;
                ++this.batchesReady;
            }
            ++this.messagesReceived;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "put");
        }
    }

    public synchronized JsMessage get() throws MessageDecodeFailedException, SIConnectionDroppedException, SIConnectionLostException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "get");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "get method invoked for asynch consumer queue");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "get");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("GET_METHOD_INVALID_SICO1032", null, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".get"), (String)"2-007-0002", (Object)this);
        throw sIErrorException;
    }

    public synchronized boolean isEmpty(short s) {
        QueueData queueData;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isEmpty");
        }
        boolean bl = true;
        if (!this.isQueueEmpty() && (queueData = (QueueData)this.queue.get(0)).getProxyQueue().getId() == s && this.batchesReady > 0) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isEmpty", (Object)("" + bl));
        }
        return bl;
    }

    public synchronized boolean isQueueEmpty() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isQueueEmpty");
        }
        boolean bl = this.queue.isEmpty();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isQueueEmpty", (Object)("" + bl));
        }
        return bl;
    }

    public synchronized void purge(short s) {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "purge", (Object)("" + s));
        }
        int[] nArray = new int[this.queue.size()];
        int n2 = 0;
        boolean bl = false;
        for (n = 0; n < this.queue.size(); ++n) {
            QueueData queueData = (QueueData)this.queue.get(n);
            if (queueData.getProxyQueue().getId() != s) continue;
            nArray[n2++] = n;
            bl = queueData.isLastInBatch();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Removing " + n2 + " entries");
        }
        for (n = n2 - 1; n >= 0; --n) {
            this.queue.remove(nArray[n]);
        }
        if (bl) {
            --this.batchesReady;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "purge");
        }
    }

    public String toString() {
        return "AsyncQueue@" + Integer.toHexString(this.hashCode()) + ":- CurDepth: " + this.queue.size() + ", ordered: " + this.ordered + ", messagesReceived: " + this.messagesReceived + ", batchesReceived: " + this.batchesReceived + ", batchesReady: " + this.batchesReady;
    }

    public Object getConcurrentAccessLock() {
        return this.concurrentAccessLock;
    }

    private synchronized JsMessage[] getBatch(int n, ConversationHelper conversationHelper) throws MessageDecodeFailedException, SIConnectionLostException, SIConnectionDroppedException {
        QueueData queueData;
        AsynchConsumerProxyQueue asynchConsumerProxyQueue;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBatch");
        }
        if (this.batchesReady == 0) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("ASYNC_BATCH_NOT_READY_SICO1033", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".getBatch"), (String)"2-007-0003", (Object)this);
            throw sIErrorException;
        }
        short s = 0;
        JsMessage[] jsMessageArray = new JsMessage[n];
        QueueData queueData2 = null;
        for (int i = 0; i < jsMessageArray.length; ++i) {
            queueData2 = (QueueData)this.queue.removeFirst();
            s = queueData2.getProxyQueue().getId();
            jsMessageArray[i] = this.convert(queueData2.getData());
            if (queueData2.isLastInBatch()) break;
        }
        --this.batchesReady;
        if (!this.isQueueEmpty() && (asynchConsumerProxyQueue = (AsynchConsumerProxyQueue)(queueData = (QueueData)this.queue.get(0)).getProxyQueue()).getId() != s) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Next data on the queue is for a different session:", asynchConsumerProxyQueue);
            }
            asynchConsumerProxyQueue.nudge();
        }
        conversationHelper.requestNextMessageBatch();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBatch", jsMessageArray);
        }
        return jsMessageArray;
    }

    public void deliverBatch(int n, short s, ConversationHelper conversationHelper) {
        AsynchConsumerProxyQueue asynchConsumerProxyQueue;
        block18: {
            Object object;
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "deliverBatch", new Object[]{"" + n, "" + s, conversationHelper});
            }
            QueueData queueData = (QueueData)this.queue.get(0);
            asynchConsumerProxyQueue = (AsynchConsumerProxyQueue)queueData.getProxyQueue();
            asynchConsumerProxyQueue.setAsynchConsumerThread(Thread.currentThread());
            try {
                JsMessage[] jsMessageArray = this.getBatch(n, conversationHelper);
                object = new LockedMessageEnumerationImpl(asynchConsumerProxyQueue, this, jsMessageArray, Thread.currentThread(), asynchConsumerProxyQueue.getLMEOperationMonitor());
                asynchConsumerProxyQueue.getAsynchConsumerCallback().consumeMessages((LockedMessageEnumeration)object);
                int n2 = ((LockedMessageEnumerationImpl)object).getRemainingMessageCount();
                if (n2 != 0) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "There are still " + n2 + " locked messages! - Unlocking them");
                    }
                    ((LockedMessageEnumerationImpl)object).unlockUnseen();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-007-0005", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "exception thrown");
                }
                if (tc.isEventEnabled()) {
                    SibTr.event(tc, "exception", throwable);
                }
                asynchConsumerProxyQueue.setAsynchConsumerThread(null);
                object = (ConsumerSessionProxy)asynchConsumerProxyQueue.getDestinationSessionProxy();
                ((ConsumerSessionProxy)object).deliverAsyncException(throwable);
                try {
                    ((ConsumerSessionProxy)object).unlockAll();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-007-0007", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "exception thrown");
                    }
                    if (!tc.isEventEnabled()) break block18;
                    SibTr.event(tc, "exception", sIException);
                }
            }
        }
        boolean bl = asynchConsumerProxyQueue.didUserCloseInsideAsynchCallback();
        boolean bl2 = asynchConsumerProxyQueue.didUserStopInsideAsynchCallback();
        asynchConsumerProxyQueue.setAsynchConsumerThread(null);
        ConsumerSessionProxy consumerSessionProxy = (ConsumerSessionProxy)asynchConsumerProxyQueue.getDestinationSessionProxy();
        if (bl) {
            try {
                consumerSessionProxy.close();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-007-0008", (Object)this);
                consumerSessionProxy.deliverAsyncException(sIException);
            }
        } else if (bl2) {
            try {
                consumerSessionProxy.stop();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-007-0009", (Object)this);
                consumerSessionProxy.deliverAsyncException(sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "deliverBatch");
        }
    }

    public JsMessage get(short s) throws MessageDecodeFailedException, SIConnectionLostException, SIConnectionDroppedException {
        throw new SIErrorException();
    }

    public void unlockAll() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "unlockAll");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "unlockAll");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#) SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/queue/AsynchConsumerQueue.java, SIB.comms, WAS602.SIB, o0610.11 1.27");
        }
    }
}

