/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.IdAllocatorException;
import com.ibm.ws.sib.utils.ras.SibTr;

public class ShortIdAllocator {
    private static String CLASS_NAME = ShortIdAllocator.class.getName();
    private static final TraceComponent tc = SibTr.register(ShortIdAllocator.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final short NULL_ID = -1;
    private static final short MAX_SHORT_ID = Short.MAX_VALUE;
    private short maxId = Short.MAX_VALUE;
    private boolean allowZero = false;
    private short nextId = (short)-1;
    private short lastFreeId = (short)-1;
    private byte[] allocMap = null;

    public ShortIdAllocator(boolean bl) {
        this(bl, Short.MAX_VALUE);
    }

    public ShortIdAllocator(boolean bl, short s) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>", new Object[]{"" + bl, "" + s});
        }
        if (s < 0) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INVALID_MAX_VALUE_SICO1058", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".<init>"), (String)"2-013-0001", (Object)this);
            throw sIErrorException;
        }
        this.allowZero = bl;
        this.maxId = s;
        this.allocMap = new byte[(this.maxId + 1) / 8];
        this.nextId = bl ? (short)0 : 1;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public synchronized short allocateId() throws IdAllocatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "allocateId");
        }
        int n = -1;
        if (this.lastFreeId != -1) {
            n = this.lastFreeId;
            this.lastFreeId = (short)-1;
        } else if (this.nextId != -1) {
            n = this.nextId;
            this.nextId = this.nextId == this.maxId ? (short)-1 : (short)(this.nextId + 1);
        } else {
            for (int n2 = 0; n2 < this.allocMap.length; n2 = (int)((short)(n2 + 1))) {
                byte by = this.allocMap[n2];
                if (by != -1) {
                    if ((by & 0x80) == 0) {
                        n = (short)((n2 + 1) * 8 - 1);
                        continue;
                    }
                    if ((by & 0x40) == 0) {
                        n = (short)((n2 + 1) * 8 - 2);
                        continue;
                    }
                    if ((by & 0x20) == 0) {
                        n = (short)((n2 + 1) * 8 - 3);
                        continue;
                    }
                    if ((by & 0x10) == 0) {
                        n = (short)((n2 + 1) * 8 - 4);
                        continue;
                    }
                    if ((by & 8) == 0) {
                        n = (short)((n2 + 1) * 8 - 5);
                        continue;
                    }
                    if ((by & 4) == 0) {
                        n = (short)((n2 + 1) * 8 - 6);
                        continue;
                    }
                    if ((by & 2) == 0) {
                        n = (short)((n2 + 1) * 8 - 7);
                        continue;
                    }
                    if ((by & 1) != 0 || (n = (short)((n2 + 1) * 8 - 8)) != 0 || this.allowZero) continue;
                    n = -1;
                    continue;
                }
                if (n != -1) break;
            }
        }
        if (n == -1) {
            throw new IdAllocatorException();
        }
        this.allocate((short)n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "allocateId", (Object)("" + this.nextId));
        }
        return (short)n;
    }

    public synchronized void releaseId(short s) throws IdAllocatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "releaseId", (Object)("" + s));
        }
        this.deallocate(s);
        if (s == this.nextId - 1) {
            this.nextId = s;
            if (this.nextId == this.lastFreeId) {
                this.lastFreeId = (short)-1;
            }
        } else {
            this.lastFreeId = s;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "releaseId");
        }
    }

    private void allocate(short s) throws IdAllocatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "allocate", (Object)("" + s));
        }
        int n = s % 8 + 1;
        int n2 = (int)Math.floor((float)s / 8.0f);
        byte by = this.allocMap[n2];
        if (n == 1) {
            if ((by & 1) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 1);
        } else if (n == 2) {
            if ((by & 2) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 2);
        } else if (n == 3) {
            if ((by & 4) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 4);
        } else if (n == 4) {
            if ((by & 8) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 8);
        } else if (n == 5) {
            if ((by & 0x10) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 0x10);
        } else if (n == 6) {
            if ((by & 0x20) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 0x20);
        } else if (n == 7) {
            if ((by & 0x40) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 0x40);
        } else if (n == 8) {
            if ((by & 0x80) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 0x80);
        }
        this.allocMap[n2] = by;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "allocate");
        }
    }

    private void deallocate(short s) throws IdAllocatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deallocate", (Object)("" + s));
        }
        int n = s % 8 + 1;
        int n2 = (int)Math.floor((float)s / 8.0f);
        byte by = this.allocMap[n2];
        by = (byte)(by ^ 0xFF);
        if (n == 1) {
            if ((by & 1) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 1);
        } else if (n == 2) {
            if ((by & 2) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 2);
        } else if (n == 3) {
            if ((by & 4) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 4);
        } else if (n == 4) {
            if ((by & 8) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 8);
        } else if (n == 5) {
            if ((by & 0x10) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 0x10);
        } else if (n == 6) {
            if ((by & 0x20) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 0x20);
        } else if (n == 7) {
            if ((by & 0x40) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 0x40);
        } else if (n == 8) {
            if ((by & 0x80) != 0) {
                throw new IdAllocatorException();
            }
            by = (byte)(by | 0x80);
        }
        this.allocMap[n2] = (byte)(by ^ 0xFF);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deallocate");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/impl/ShortIdAllocator.java, SIB.comms, WAS602.SIB, o0610.11 1.11");
        }
    }
}

