/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.BrowserSessionProxy;
import com.ibm.ws.sib.comms.client.DestinationSessionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.BrowserProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelper;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelperImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ProxyQueueConversationGroupImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.QueueData;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.ReadAheadQueue;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public class BrowserProxyQueueImpl
implements BrowserProxyQueue {
    private static String CLASS_NAME = BrowserProxyQueueImpl.class.getName();
    private static final TraceComponent tc = SibTr.register(BrowserProxyQueueImpl.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private short proxyQueueId;
    private ConversationHelper convHelper;
    private ReadAheadQueue queue;
    private BrowserSessionProxy browserSession = null;
    private ProxyQueueConversationGroupImpl owningGroup;
    private volatile boolean closed = false;

    public BrowserProxyQueueImpl(ProxyQueueConversationGroupImpl proxyQueueConversationGroupImpl, short s, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>", new Object[]{proxyQueueConversationGroupImpl, new Short(s), conversation});
        }
        this.owningGroup = proxyQueueConversationGroupImpl;
        this.convHelper = new ConversationHelperImpl(conversation, 0);
        this.proxyQueueId = s;
        this.queue = new ReadAheadQueue(s, this.convHelper);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    protected BrowserProxyQueueImpl(ProxyQueueConversationGroupImpl proxyQueueConversationGroupImpl, short s, ConversationHelper conversationHelper) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>", new Object[]{proxyQueueConversationGroupImpl, new Short(s), conversationHelper});
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "test form of constructor invoked");
        }
        this.owningGroup = proxyQueueConversationGroupImpl;
        this.proxyQueueId = s;
        this.convHelper = conversationHelper;
        this.queue = new ReadAheadQueue(s, this.convHelper);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public JsMessage next() throws MessageDecodeFailedException, SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "next");
        }
        JsMessage jsMessage = null;
        jsMessage = this.queue.get(this.proxyQueueId);
        if (jsMessage == null) {
            this.convHelper.flushConsumer();
            jsMessage = this.queue.get(this.proxyQueueId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "next", jsMessage);
        }
        return jsMessage;
    }

    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "close");
        }
        if (!this.closed) {
            this.convHelper.closeSession();
            this.queue.purge(this.proxyQueueId);
            this.owningGroup.notifyClose(this);
            this.closed = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close");
        }
    }

    public short getId() {
        return this.proxyQueueId;
    }

    public void put(WsByteBuffer wsByteBuffer, short s, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "put", new Object[]{wsByteBuffer, new Short(s), new Boolean(bl)});
        }
        this.queue.put(new QueueData(this, bl, wsByteBuffer), s);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "put");
        }
    }

    public void setBrowserSession(BrowserSessionProxy browserSessionProxy) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setBrowserSession", browserSessionProxy);
        }
        if (this.browserSession != null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("RESET_OF_BROWSER_SESSION_SICO1035", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".setBrowserSession"), (String)"2-008-0001", (Object)this);
            throw sIErrorException;
        }
        if (browserSessionProxy == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NULL_BROWSER_SESSION_SICO1036", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".setBrowserSession"), (String)"2-008-0002", (Object)this);
            throw sIErrorException;
        }
        this.browserSession = browserSessionProxy;
        this.convHelper.setSessionId(browserSessionProxy.getProxyID());
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setBrowserSession");
        }
    }

    public void reset() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "reset");
        }
        this.convHelper.exchangeResetBrowse();
        this.queue.purge(this.proxyQueueId);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "reset");
        }
    }

    public String toString() {
        return "BrowserPQ@" + Integer.toHexString(this.hashCode()) + ": " + this.queue.toString();
    }

    public ConversationHelper getConversationHelper() {
        return this.convHelper;
    }

    public DestinationSessionProxy getDestinationSessionProxy() {
        return this.browserSession;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#) SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/impl/BrowserProxyQueueImpl.java, SIB.comms, WAS602.SIB, o0610.11 1.22");
        }
    }
}

