/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.DestinationSessionProxy;
import com.ibm.ws.sib.comms.client.OrderingContextProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.asynch.AsynchConsumerThreadPool;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelper;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelperImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ProxyQueueConversationGroupImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.AsynchConsumerQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.Queue;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.QueueData;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.ReadAheadQueue;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.ArrayList;

public abstract class AsynchConsumerProxyQueueImpl
implements AsynchConsumerProxyQueue {
    private static String CLASS_NAME = AsynchConsumerProxyQueueImpl.class.getName();
    private static final TraceComponent tc = SibTr.register(AsynchConsumerProxyQueueImpl.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    protected ConversationHelper convHelper;
    protected Queue queue;
    protected AsynchConsumerCallback asynchConsumerCallback = null;
    protected boolean readAhead = false;
    protected int maxBatchSize;
    protected ConsumerSessionProxy consumerSession;
    protected short id;
    protected ProxyQueueConversationGroupImpl owningGroup;
    protected ArrayList exceptionQueue = new ArrayList();
    private boolean flushRHRecvWithWait = CommsUtils.getRuntimeBooleanProperty("sib.comms.ForceRHRecvWithWaitFlush", "false");
    private short currentBatchNumber = 0;
    private OrderingContext currentOrderContext = null;
    protected static final int READAHEAD = 1;
    protected static final int ASYNCH = 2;
    protected static final int ORDERED = 3;
    protected int type;
    private Thread asynchConsumerThread;
    private boolean closedInsideAsynchConsumer = false;
    private boolean stoppedInsideAsynchConsumer = false;
    protected boolean _closed;
    protected boolean _started;

    protected AsynchConsumerProxyQueueImpl(ProxyQueueConversationGroupImpl proxyQueueConversationGroupImpl, short s, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.owningGroup = proxyQueueConversationGroupImpl;
        if (conversation != null) {
            this.convHelper = new ConversationHelperImpl(conversation, s);
        }
        this.id = s;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public JsMessage receiveNoWait(SITransaction sITransaction) throws MessageDecodeFailedException, SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        throw new SIErrorException();
    }

    public synchronized JsMessage receiveWithWait(long l, SITransaction sITransaction) throws MessageDecodeFailedException, SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        throw new SIErrorException();
    }

    public short getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(WsByteBuffer wsByteBuffer, short s, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "put", new Object[]{wsByteBuffer, "" + s, "" + bl});
        }
        if (s == this.currentBatchNumber) {
            Queue queue = this.queue;
            synchronized (queue) {
                boolean bl2 = this.queue.isEmpty(this.id);
                this.queue.put(new QueueData(this, bl, wsByteBuffer), s);
                if (bl2 && !this.queue.isEmpty(this.id) && this._started) {
                    if (this.asynchConsumerCallback != null) {
                        AsynchConsumerThreadPool.getInstance().dispatch(this);
                    } else {
                        this.notifyAll();
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Received data for msgbatch: " + s + " when we are expecting " + this.currentBatchNumber);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "put");
        }
    }

    public void setConsumerSession(ConsumerSessionProxy consumerSessionProxy) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setConsumerSession", consumerSessionProxy);
        }
        if (this.consumerSession != null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("RESET_OF_CONSUMER_SESSION_SICO1055", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".setConsumerSession"), (String)"2-011-0001", (Object)this);
            throw sIErrorException;
        }
        if (consumerSessionProxy == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NULL_CONSUMER_SESSION_SICO1056", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".setConsumerSession"), (String)"2-011-0002", (Object)this);
            throw sIErrorException;
        }
        this.consumerSession = consumerSessionProxy;
        this.convHelper.setSessionId(consumerSessionProxy.getProxyID());
        if (this.exceptionQueue.size() != 0) {
            this.processExceptions();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setConsumerSession");
        }
    }

    public short getCurrentMessageBatchSequenceNumber() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverException(Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deliverException");
        }
        ArrayList arrayList = this.exceptionQueue;
        synchronized (arrayList) {
            this.exceptionQueue.add(throwable);
        }
        this.processExceptions();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deliverException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExceptions() {
        block13: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "processExceptions");
            }
            if (this.consumerSession == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Null consumer session - not processing");
                }
            } else {
                try {
                    SICoreConnection sICoreConnection = ((ClientConversationState)this.owningGroup.getConversation().getAttachment()).getSICoreConnection();
                    SICoreConnectionListener[] sICoreConnectionListenerArray = sICoreConnection.getConnectionListeners();
                    ArrayList arrayList = this.exceptionQueue;
                    synchronized (arrayList) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Core connection has " + sICoreConnectionListenerArray.length + " listeners");
                            SibTr.debug(tc, "Queue has " + this.exceptionQueue.size() + " exception(s) on it");
                        }
                        for (int i = 0; i < sICoreConnectionListenerArray.length; ++i) {
                            for (int j = 0; j < this.exceptionQueue.size(); ++j) {
                                Throwable throwable = (Throwable)this.exceptionQueue.get(j);
                                sICoreConnectionListenerArray[i].asynchronousException(this.consumerSession, throwable);
                            }
                        }
                        this.exceptionQueue.clear();
                    }
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".processExceptions"), (String)"2-011-0003", (Object)this);
                    if (!tc.isDebugEnabled()) break block13;
                    SibTr.debug(tc, "Failed to get the conversation from the proxy queue", sIException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "processExceptions");
        }
    }

    public int getBatchSize() {
        return this.maxBatchSize;
    }

    public AsynchConsumerCallback getAsynchConsumerCallback() {
        return this.asynchConsumerCallback;
    }

    public void setAsynchConsumerThread(Thread thread) {
        this.closedInsideAsynchConsumer = false;
        this.stoppedInsideAsynchConsumer = false;
        this.asynchConsumerThread = thread;
    }

    public Thread getAsynchConsumerThread() {
        return this.asynchConsumerThread;
    }

    public void closeInsideAsynchConsumerNotification() {
        this.closedInsideAsynchConsumer = true;
    }

    public void stopInsideAsynchConsumerNotification() throws SISessionUnavailableException {
        if (this.closedInsideAsynchConsumer) {
            throw new SISessionUnavailableException("");
        }
        this.stoppedInsideAsynchConsumer = true;
    }

    public void startInsideAsynchConsumerNotification() throws SISessionUnavailableException {
        if (this.closedInsideAsynchConsumer) {
            throw new SISessionUnavailableException("");
        }
        this.stoppedInsideAsynchConsumer = false;
    }

    public boolean didUserStopInsideAsynchCallback() {
        return this.stoppedInsideAsynchConsumer;
    }

    public boolean didUserCloseInsideAsynchCallback() {
        return this.closedInsideAsynchConsumer;
    }

    public DestinationSessionProxy getDestinationSessionProxy() {
        return this.consumerSession;
    }

    public ConversationHelper getConversationHelper() {
        return this.convHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closing() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "closing");
        }
        this._started = false;
        this._closed = true;
        Queue queue = this.queue;
        synchronized (queue) {
            this.queue.purge(this.id);
        }
        this.notify();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "closing");
        }
    }

    public void closed() throws SIConnectionDroppedException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "closed");
        }
        this.convHelper.closeSession();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "closed");
        }
    }

    public synchronized void start() throws SIConnectionDroppedException, SIConnectionLostException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "start");
        }
        this._started = true;
        if (this.asynchConsumerCallback == null) {
            this.notify();
        } else if (!this.queue.isEmpty(this.id)) {
            AsynchConsumerThreadPool.getInstance().dispatch(this);
        } else if (!this.readAhead) {
            this.convHelper.sendStart();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "start");
        }
    }

    public synchronized void stopping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "stopping");
        }
        this._started = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "stopping");
        }
    }

    public void stopped() throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "stopping");
        }
        if (!this.readAhead) {
            this.convHelper.exchangeStop();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "stopping");
        }
    }

    public void setAsynchCallback(AsynchConsumerCallback asynchConsumerCallback, int n, long l, int n2, OrderingContext orderingContext) throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIErrorException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setAsynchCallback", new Object[]{asynchConsumerCallback, "" + n, "" + l, "" + n2, orderingContext});
        }
        if (asynchConsumerCallback == null) {
            if (!this.readAhead) {
                this.convHelper.unsetAsynchConsumer();
            }
            this.currentOrderContext = null;
            this.asynchConsumerCallback = null;
            this.maxBatchSize = 0;
        } else if (this.asynchConsumerCallback != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Performing a re-reg");
            }
            if (this.readAhead) {
                orderingContext = null;
            }
            if (this.currentOrderContext != null && orderingContext == null || this.currentOrderContext == null && orderingContext != null || this.currentOrderContext != orderingContext || this.maxBatchSize != n2) {
                if (this.currentOrderContext != null && orderingContext == null) {
                    this.type = 2;
                } else if (this.currentOrderContext == null && orderingContext != null) {
                    this.type = 3;
                }
                try {
                    this.unlockAll();
                }
                catch (SIResourceException sIResourceException) {
                    FFDCFilter.processException((Throwable)sIResourceException, (String)(CLASS_NAME + ".setAsynchCallback"), (String)"2-006-0004", (Object)this);
                    throw new SIErrorException(sIResourceException);
                }
                this.convHelper.unsetAsynchConsumer();
                this.queue = this.obtainQueue(this.type, orderingContext, null);
                this.convHelper.setAsynchConsumer(asynchConsumerCallback, n, l, n2, orderingContext);
            }
            this.currentOrderContext = orderingContext;
            this.asynchConsumerCallback = asynchConsumerCallback;
            this.maxBatchSize = n2;
        } else {
            this.asynchConsumerCallback = asynchConsumerCallback;
            this.currentOrderContext = orderingContext;
            this.maxBatchSize = n2;
            if (!this.readAhead) {
                if (asynchConsumerCallback == null) {
                    this.convHelper.unsetAsynchConsumer();
                } else {
                    this.convHelper.setAsynchConsumer(asynchConsumerCallback, n, l, n2, orderingContext);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setAsynchCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Queue obtainQueue(int n, OrderingContext orderingContext, Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createQueue", new Object[]{"" + n, orderingContext});
        }
        Queue queue = null;
        if (n == 1) {
            queue = new ReadAheadQueue(this.id, this.convHelper, reliability);
        } else if (n == 2) {
            queue = new AsynchConsumerQueue(false);
        } else {
            OrderingContext orderingContext2 = orderingContext;
            synchronized (orderingContext2) {
                OrderingContextProxy orderingContextProxy = (OrderingContextProxy)orderingContext;
                queue = orderingContextProxy.getAssociatedQueue();
                if (queue == null) {
                    queue = new AsynchConsumerQueue(true);
                    orderingContextProxy.associateWithQueue(queue);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createQueue", queue);
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "deliverMessages");
        }
        Object object = this.consumerSession.getAsynchLock();
        synchronized (object) {
            Object object2 = this.queue.getConcurrentAccessLock();
            synchronized (object2) {
                if (this._started && !this.queue.isEmpty(this.id)) {
                    this.queue.deliverBatch(this.maxBatchSize, this.id, this.convHelper);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "deliverMessages");
        }
    }

    public void unlockAll() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unlockAll");
        }
        this.currentBatchNumber = (short)(this.currentBatchNumber + 1);
        this.queue.purge(this.id);
        this.queue.unlockAll();
        this.convHelper.unlockAll();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unlockAll");
        }
    }

    public Object getLMEOperationMonitor() {
        return this.consumerSession.getLMEMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nudge() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "nudge");
        }
        if (!this.queue.isEmpty(this.id) && this._started) {
            if (this.asynchConsumerCallback != null) {
                AsynchConsumerThreadPool.getInstance().dispatch(this);
            } else {
                AsynchConsumerProxyQueueImpl asynchConsumerProxyQueueImpl = this;
                synchronized (asynchConsumerProxyQueueImpl) {
                    this.notifyAll();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "nudge");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/impl/AsynchConsumerProxyQueueImpl.java, SIB.comms, WAS602.SIB, o0610.11 1.38");
        }
    }
}

