/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.comms.client.ClientLinkLevelState;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.MulticastMessage;
import com.ibm.ws.sib.comms.client.Proxy;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.MulticastReadAheadProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.QueueData;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.ReadAheadQueue;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.util.ArrayList;

public class Transaction
extends Proxy {
    private static final TraceComponent tc = SibTr.register(Transaction.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    protected short lowestPriority = (short)11;
    private int localTranasctionId = 0;
    private boolean hasMulticastWork = false;
    private ArrayList multicastMessages = new ArrayList();

    public Transaction(Conversation conversation, ConnectionProxy connectionProxy) {
        super(conversation, connectionProxy);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{conversation, connectionProxy});
        }
        ClientLinkLevelState clientLinkLevelState = (ClientLinkLevelState)conversation.getLinkLevelAttachment();
        this.localTranasctionId = clientLinkLevelState.getNextTransactionId();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public int getTransactionId() {
        return this.localTranasctionId;
    }

    public short getLowestMessagePriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getLowestMessagePriority");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getLowestMessagePriority", "" + this.lowestPriority);
        }
        return this.lowestPriority;
    }

    public void updateLowestMessagePriority(short s) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "updateLowestMessagePriority", new Object[]{"" + s});
        }
        if (s < this.lowestPriority) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Updating lowest priority");
            }
            this.lowestPriority = s;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "updateLowestMessagePriority");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMulticastMessage(JsMessage jsMessage, ProxyQueue proxyQueue) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "addMulticastMessage", new Object[]{jsMessage, proxyQueue});
        }
        this.hasMulticastWork = true;
        try {
            ArrayList arrayList = this.multicastMessages;
            synchronized (arrayList) {
                this.multicastMessages.add(new MulticastMessage(jsMessage.getReceived(), proxyQueue));
            }
        }
        catch (MessageCopyFailedException messageCopyFailedException) {
            throw new SIResourceException(messageCopyFailedException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "addMulticastMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitMulticastMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "commitMulticastMessages");
        }
        if (this.hasMulticastWork) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Committing " + this.multicastMessages.size() + " message(s)");
            }
            ArrayList arrayList = this.multicastMessages;
            synchronized (arrayList) {
                this.multicastMessages.clear();
                this.hasMulticastWork = false;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "commitMulticastMessages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackMulticastMessages() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "rollbackMulticastMessages");
        }
        if (this.hasMulticastWork) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "There are " + this.multicastMessages.size() + " message(s) to rollback");
            }
            ArrayList arrayList = this.multicastMessages;
            synchronized (arrayList) {
                try {
                    boolean bl = true;
                    while (bl) {
                        int n = 0;
                        int n2 = this.multicastMessages.size() - 1;
                        MulticastMessage multicastMessage = (MulticastMessage)this.multicastMessages.get(n2);
                        MulticastReadAheadProxyQueueImpl multicastReadAheadProxyQueueImpl = multicastMessage.getProxyQueue();
                        ReadAheadQueue readAheadQueue = (ReadAheadQueue)multicastReadAheadProxyQueueImpl.getQueue();
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "Rolling back message(s) to " + readAheadQueue);
                        }
                        ReadAheadQueue readAheadQueue2 = readAheadQueue;
                        synchronized (readAheadQueue2) {
                            for (int i = n2; i >= 0; --i) {
                                multicastMessage = (MulticastMessage)this.multicastMessages.get(i);
                                if (multicastMessage.getProxyQueue().getQueue() != readAheadQueue) continue;
                                JsMessage jsMessage = multicastMessage.getMessage();
                                jsMessage.setRedeliveredCount(jsMessage.getRedeliveredCount() + 1);
                                WsByteBuffer wsByteBuffer = ((ConsumerSessionProxy)multicastReadAheadProxyQueueImpl.getDestinationSessionProxy()).getMessageBufferFromMessage(multicastMessage.getMessage());
                                readAheadQueue.putToFront(new QueueData(multicastMessage.getProxyQueue(), false, wsByteBuffer), (short)0);
                                ++n;
                                this.multicastMessages.remove(i);
                            }
                            multicastReadAheadProxyQueueImpl.nudge();
                        }
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "Rolled back " + n + " message(s)");
                        }
                        if (!this.multicastMessages.isEmpty()) continue;
                        bl = false;
                    }
                }
                catch (MessageEncodeFailedException messageEncodeFailedException) {
                    throw new SIResourceException(messageEncodeFailedException);
                }
                finally {
                    this.multicastMessages.clear();
                    this.hasMulticastWork = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "rollbackMulticastMessages");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/Transaction.java, SIB.comms, WAS602.SIB, o0610.11 1.15");
        }
    }
}

