/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.comms.common.XidProxy;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIXAResource;
import java.util.LinkedList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SIXAResourceProxy
extends Transaction
implements SIXAResource {
    private static String CLASS_NAME = SIXAResourceProxy.class.getName();
    private static final TraceComponent tc = SibTr.register(SIXAResourceProxy.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private boolean isEnlisted = false;

    public SIXAResourceProxy(Conversation conversation, ConnectionProxy connectionProxy) {
        super(conversation, connectionProxy);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public boolean isEnlisted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "isEnlisted");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isEnlisted", (Object)("" + this.isEnlisted));
        }
        return this.isEnlisted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "commit", new Object[]{xid, "" + bl});
            }
            try {
                this.commitMulticastMessages();
                XidProxy xidProxy = new XidProxy(xid);
                WsByteBuffer wsByteBuffer = this.getWsBuffer(xidProxy.getSerializableLength() + 5);
                wsByteBuffer.putInt(this.getTransactionId());
                xidProxy.serialize(wsByteBuffer);
                if (bl) {
                    wsByteBuffer.put((byte)1);
                } else {
                    wsByteBuffer.put((byte)0);
                }
                wsByteBuffer.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 52, this.getLowestMessagePriority(), true);
                try {
                    this.checkXACommandCompletionStatus(receivedData, 180);
                    Object var8_9 = null;
                    if (receivedData == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    throw throwable;
                }
                receivedData.getBuffer().release();
            }
            catch (XAException xAException) {
                throw xAException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".commit"), (String)"1-007-0001", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Caught a comms problem:", exception);
                }
                throw new XAException(-3);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void end(Xid xid, int n) throws XAException {
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "end", new Object[]{xid, "" + n});
            }
            if (!this.isEnlisted) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "We are not enlisted - rejecting this call");
                }
                throw new XAException(-5);
            }
            try {
                XidProxy xidProxy = new XidProxy(xid);
                WsByteBuffer wsByteBuffer = this.getWsBuffer(xidProxy.getSerializableLength() + 8);
                wsByteBuffer.putInt(this.getTransactionId());
                xidProxy.serialize(wsByteBuffer);
                wsByteBuffer.putInt(n);
                wsByteBuffer.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 50, this.getLowestMessagePriority(), true);
                try {
                    this.checkXACommandCompletionStatus(receivedData, 178);
                    this.isEnlisted = false;
                    Object var8_9 = null;
                    if (receivedData == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    throw throwable;
                }
                receivedData.getBuffer().release();
            }
            catch (XAException xAException) {
                throw xAException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".end"), (String)"1-007-0002", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Caught a comms problem:", exception);
                }
                throw new XAException(-3);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void forget(Xid xid) throws XAException {
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "forget", xid);
            }
            try {
                XidProxy xidProxy = new XidProxy(xid);
                WsByteBuffer wsByteBuffer = this.getWsBuffer(xidProxy.getSerializableLength() + 4);
                wsByteBuffer.putInt(this.getTransactionId());
                xidProxy.serialize(wsByteBuffer);
                wsByteBuffer.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 55, 7, true);
                try {
                    this.checkXACommandCompletionStatus(receivedData, 183);
                    Object var7_8 = null;
                    if (receivedData == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    throw throwable;
                }
                receivedData.getBuffer().release();
            }
            catch (XAException xAException) {
                throw xAException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".forget"), (String)"1-007-0003", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Caught a comms problem:", exception);
                }
                throw new XAException(-3);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "forget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTransactionTimeout() throws XAException {
        int n;
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "getTransactionTimeout");
            }
            n = 0;
            try {
                WsByteBuffer wsByteBuffer = this.getWsBuffer(4);
                wsByteBuffer.putInt(this.getTransactionId());
                wsByteBuffer.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 56, 7, true);
                try {
                    this.checkXACommandCompletionStatus(receivedData, 184);
                    receivedData.getBuffer().flip();
                    n = receivedData.getBuffer().getInt();
                    Object var6_7 = null;
                    if (receivedData == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    throw throwable;
                }
                receivedData.getBuffer().release();
            }
            catch (XAException xAException) {
                throw xAException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getTransactionTimeout"), (String)"1-007-0004", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Caught a comms problem:", exception);
                }
                throw new XAException(-3);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getTransactionTimeout", "" + n);
        }
        return n;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl;
        block5: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "isSameRM", xAResource);
            }
            bl = false;
            if (xAResource instanceof SIXAResourceProxy) {
                try {
                    SICoreConnection sICoreConnection = ((ClientConversationState)this.getConversation().getAttachment()).getSICoreConnection();
                    SICoreConnection sICoreConnection2 = ((ClientConversationState)((SIXAResourceProxy)xAResource).getConversation().getAttachment()).getSICoreConnection();
                    bl = sICoreConnection.isEquivalentTo(sICoreConnection2);
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block5;
                    SibTr.debug(tc, "Caught an exception comparing the connections", throwable);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isSameRM", (Object)("" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int prepare(Xid xid) throws XAException {
        int n;
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "prepare", xid);
            }
            n = 0;
            try {
                XidProxy xidProxy = new XidProxy(xid);
                WsByteBuffer wsByteBuffer = this.getWsBuffer(xidProxy.getSerializableLength() + 4);
                wsByteBuffer.putInt(this.getTransactionId());
                xidProxy.serialize(wsByteBuffer);
                wsByteBuffer.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 51, this.getLowestMessagePriority(), true);
                try {
                    this.checkXACommandCompletionStatus(receivedData, 179);
                    receivedData.getBuffer().flip();
                    n = receivedData.getBuffer().getInt();
                    Object var8_9 = null;
                    if (receivedData == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    throw throwable;
                }
                receivedData.getBuffer().release();
            }
            catch (XAException xAException) {
                throw xAException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".prepare"), (String)"1-007-0005", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Caught a comms problem:", exception);
                }
                throw new XAException(-3);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "prepare", "" + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray;
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "recover", "" + n);
            }
            try {
                WsByteBuffer wsByteBuffer = this.getWsBuffer(8);
                wsByteBuffer.putInt(this.getTransactionId());
                wsByteBuffer.putInt(n);
                wsByteBuffer.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 54, 7, true);
                try {
                    this.checkXACommandCompletionStatus(receivedData, 182);
                    receivedData.getBuffer().flip();
                    int n2 = receivedData.getBuffer().getShort();
                    xidArray = new Xid[n2];
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Received " + n2 + " Xid(s)");
                    }
                    for (int i = 0; i < n2; ++i) {
                        xidArray[i] = new XidProxy(receivedData.getBuffer());
                        if (!tc.isDebugEnabled()) continue;
                        SibTr.debug(tc, "Xid[" + i + "]: " + xidArray[i]);
                    }
                    Object var9_10 = null;
                    if (receivedData == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    throw throwable;
                }
                receivedData.getBuffer().release();
            }
            catch (XAException xAException) {
                throw xAException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".recover"), (String)"1-007-0006", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Caught a comms problem:", exception);
                }
                throw new XAException(-3);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "recover");
        }
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback(Xid xid) throws XAException {
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "rollback", xid);
            }
            try {
                this.rollbackMulticastMessages();
                XidProxy xidProxy = new XidProxy(xid);
                WsByteBuffer wsByteBuffer = this.getWsBuffer(xidProxy.getSerializableLength() + 4);
                wsByteBuffer.putInt(this.getTransactionId());
                xidProxy.serialize(wsByteBuffer);
                wsByteBuffer.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 53, this.getLowestMessagePriority(), true);
                try {
                    this.checkXACommandCompletionStatus(receivedData, 181);
                    Object var7_8 = null;
                    if (receivedData == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    throw throwable;
                }
                receivedData.getBuffer().release();
            }
            catch (XAException xAException) {
                throw xAException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".rollback"), (String)"1-007-0007", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Caught a comms problem:", exception);
                }
                throw new XAException(-3);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "rollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setTransactionTimeout(int n) throws XAException {
        boolean bl;
        block10: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "setTransactionTimeout", "" + n);
            }
            bl = false;
            try {
                WsByteBuffer wsByteBuffer = this.getWsBuffer(8);
                wsByteBuffer.putInt(this.getTransactionId());
                wsByteBuffer.putInt(n);
                wsByteBuffer.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 57, 7, true);
                try {
                    this.checkXACommandCompletionStatus(receivedData, 185);
                    receivedData.getBuffer().flip();
                    if (receivedData.getBuffer().get() == 1) {
                        bl = true;
                    }
                    Object var7_8 = null;
                    if (receivedData == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    throw throwable;
                }
                receivedData.getBuffer().release();
            }
            catch (XAException xAException) {
                throw xAException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".setTransactionTimeout"), (String)"1-007-0008", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Caught a comms problem:", exception);
                }
                throw new XAException(-3);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setTransactionTimeout", (Object)("" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(Xid xid, int n) throws XAException {
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "start", new Object[]{xid, "" + n});
            }
            if (this.isEnlisted) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "We are already enlisted - rejecting this call");
                }
                throw new XAException(-5);
            }
            try {
                XidProxy xidProxy = new XidProxy(xid);
                WsByteBuffer wsByteBuffer = this.getWsBuffer(xidProxy.getSerializableLength() + 8);
                wsByteBuffer.putInt(this.getTransactionId());
                xidProxy.serialize(wsByteBuffer);
                wsByteBuffer.putInt(n);
                wsByteBuffer.flip();
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                linkedList.add(wsByteBuffer);
                ReceivedData receivedData = this.JFAPExchange(linkedList, 49, 7, true);
                try {
                    this.checkXACommandCompletionStatus(receivedData, 177);
                    this.isEnlisted = true;
                    Object var8_9 = null;
                    if (receivedData == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    throw throwable;
                }
                receivedData.getBuffer().release();
            }
            catch (XAException xAException) {
                throw xAException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".start"), (String)"1-007-0009", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Caught a comms problem:", exception);
                }
                throw new XAException(-3);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "start");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/SIXAResourceProxy.java, SIB.comms, WAS602.SIB, o0610.11 1.23");
        }
    }
}

