/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.CompHandshake;
import com.ibm.ws.sib.comms.client.ClientAsynchEventThreadPool;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ClientLinkLevelState;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroup;
import com.ibm.ws.sib.comms.common.CATHandshakeProperties;
import com.ibm.ws.sib.comms.common.CommsString;
import com.ibm.ws.sib.comms.common.JFAPCommunicator;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.mfp.CompHandshakeFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class ProxyReceiveListener
implements ConversationReceiveListener {
    private static String CLASS_NAME = ProxyReceiveListener.class.getName();
    private static final TraceComponent tc = SibTr.register(ProxyReceiveListener.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    public ConversationReceiveListener dataReceived(WsByteBuffer wsByteBuffer, int n, int n2, int n3, boolean bl, boolean bl2, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "dataReceived");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params: data, segmentType, requestNumber, priority, allocatedFromBufferPool, conversation", new Object[]{wsByteBuffer, new Integer(n), new Integer(n2), new Integer(n3), new Boolean(bl), conversation});
        }
        boolean bl3 = true;
        switch (n) {
            case 221: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Received an ASYNC message");
                }
                bl3 = false;
                this.processMessage(wsByteBuffer, true, false, conversation);
                break;
            }
            case 222: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Received a BROWSE message");
                }
                bl3 = false;
                this.processMessage(wsByteBuffer, false, true, conversation);
                break;
            }
            case 220: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Received a PROXY message");
                }
                bl3 = false;
                this.processMessage(wsByteBuffer, false, true, conversation);
                break;
            }
            case 225: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Received a Server Event");
                }
                this.processEvent(wsByteBuffer, conversation);
                break;
            }
            case 226: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Received a connection info event");
                }
                this.processConnectionInfo(wsByteBuffer, conversation);
                break;
            }
            case 230: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Received a message schema");
                }
                this.processSchema(wsByteBuffer, conversation);
                break;
            }
            default: {
                String string = ((ClientConversationState)conversation.getAttachment()).getCommsConnection().getConnectionInfo();
                String string2 = n + " (0x" + Integer.toHexString(n).toUpperCase() + ")";
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("UNEXPECTED_MESS_RECVD_SICO1010", new Object[]{string2, string}, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".dataReceived"), (String)"1-008-0001", (Object[])new Object[]{SibTr.formatBytes(wsByteBuffer.array(), 0, wsByteBuffer.array().length), this});
                SibTr.error(tc, "UNEXPECTED_MESS_RECVD_SICO1010", new Object[]{string2, string});
                try {
                    conversation.close();
                    break;
                }
                catch (SIConnectionLostException sIConnectionLostException) {
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".dataReceived"), (String)"1-008-0002", (Object)this);
                    if (!tc.isDebugEnabled()) break;
                    SibTr.debug(tc, sIConnectionLostException.getMessage(), sIConnectionLostException);
                }
            }
        }
        if (bl && bl3) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Releasing WsByteBuffer");
            }
            wsByteBuffer.release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "dataReceived");
        }
        return null;
    }

    public void errorOccurred(SIConnectionLostException sIConnectionLostException, int n, int n2, int n3, Conversation conversation) {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "errorOccurred");
        }
        FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".errorOccurred"), (String)"3-004-0010", (Object)this);
        if (tc.isDebugEnabled()) {
            objectArray = new Object[]{new String("Segment type  : " + n + " (0x" + Integer.toHexString(n) + ")"), new String("Request number: " + n2), new String("Priority      : " + n3)};
            SibTr.debug(tc, "Received an error in the ProxyReceiveListener", objectArray);
            SibTr.debug(tc, "Primary exception:");
            SibTr.exception(tc, sIConnectionLostException);
        }
        if (conversation != null && (objectArray = (Object[])conversation.getAttachment()) != null) {
            SICoreConnection sICoreConnection = objectArray.getSICoreConnection();
            ClientAsynchEventThreadPool.getInstance().dispatchCommsException(sICoreConnection, sIConnectionLostException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "errorOccurred");
        }
    }

    public Dispatchable getThreadContext(Conversation conversation, WsByteBuffer wsByteBuffer, int n) {
        return null;
    }

    private void processMessage(WsByteBuffer wsByteBuffer, boolean bl, boolean bl2, Conversation conversation) {
        ProxyQueueConversationGroup proxyQueueConversationGroup;
        short s;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "processAsyncMessage");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params data, asyncMessage, enableReadAhead, conversation", new Object[]{wsByteBuffer, new Boolean(bl), new Boolean(bl2), conversation});
        }
        wsByteBuffer.flip();
        if (tc.isDebugEnabled()) {
            SibTr.bytes(tc, wsByteBuffer.array());
        }
        short s2 = wsByteBuffer.getShort();
        short s3 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "connectionObjectId: " + s2);
            SibTr.debug(tc, "clientSessionID: " + s3);
        }
        boolean bl3 = false;
        if (bl) {
            s = wsByteBuffer.getShort();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "lastInBatchFlag: " + s);
            }
            if (s == 1) {
                bl3 = true;
            }
        }
        s = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "messageBatch: " + s);
        }
        int n = (int)wsByteBuffer.getLong();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Received a message of length: " + n);
        }
        if ((proxyQueueConversationGroup = ((ClientConversationState)conversation.getAttachment()).getProxyQueueConversationHGroup()) == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NO_PROXY_CONV_GROUP_SICO1011", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".processAsyncMessage"), (String)"1-008-0003", (Object)this);
            SibTr.error(tc, "NO_PROXY_CONV_GROUP_SICO1011", sIErrorException);
            throw sIErrorException;
        }
        ProxyQueue proxyQueue = proxyQueueConversationGroup.find(s3);
        if (proxyQueue == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("UNABLE_TO_FIND_PROXY_QUEUE_SICO1012", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".processAsyncMessage"), (String)"1-008-0003", (Object)this);
            SibTr.error(tc, "UNABLE_TO_FIND_PROXY_QUEUE_SICO1012", sIErrorException);
            throw sIErrorException;
        }
        proxyQueue.put(wsByteBuffer, s, bl3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "processAsyncMessage");
        }
    }

    private void processEvent(WsByteBuffer wsByteBuffer, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "processEvent", new Object[]{wsByteBuffer, conversation});
        }
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        short s2 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Event Id", (Object)("" + s2));
        }
        if (s2 == 2 || s2 == 3) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Received an ME event");
            }
            ClientAsynchEventThreadPool.getInstance().dispatchAsynchEvent(s2, conversation);
        } else if (s2 == 4) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Received an Async exception event");
            }
            short s3 = wsByteBuffer.getShort();
            WsByteBuffer wsByteBuffer2 = wsByteBuffer.slice();
            short s4 = wsByteBuffer2.getShort();
            Exception exception = JFAPCommunicator.getException(wsByteBuffer2, s4);
            ProxyQueueConversationGroup proxyQueueConversationGroup = ((ClientConversationState)conversation.getAttachment()).getProxyQueueConversationHGroup();
            if (proxyQueueConversationGroup == null) {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NO_PROXY_CONV_GROUP_SICO1011", null, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".processEvent"), (String)"1-008-0005", (Object)this);
                SibTr.error(tc, "NO_PROXY_CONV_GROUP_SICO1011", sIErrorException);
                throw sIErrorException;
            }
            ProxyQueue proxyQueue = proxyQueueConversationGroup.find(s3);
            if (proxyQueue == null) {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("UNABLE_TO_FIND_PROXY_QUEUE_SICO1012", null, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".processEvent"), (String)"1-008-0006", (Object)this);
                SibTr.error(tc, "UNABLE_TO_FIND_PROXY_QUEUE_SICO1012", sIErrorException);
                throw sIErrorException;
            }
            ClientAsynchEventThreadPool.getInstance().dispatchAsynchException(proxyQueue, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "processEvent");
        }
    }

    private void processConnectionInfo(WsByteBuffer wsByteBuffer, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "processConnectionInfo");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Params: data, conversation", new Object[]{wsByteBuffer, conversation});
        }
        ClientConversationState clientConversationState = (ClientConversationState)conversation.getAttachment();
        ClientLinkLevelState clientLinkLevelState = (ClientLinkLevelState)conversation.getLinkLevelAttachment();
        CommsString commsString = clientConversationState.getCommsString();
        wsByteBuffer.flip();
        short s = wsByteBuffer.getShort();
        short s2 = wsByteBuffer.getShort();
        byte[] byArray = new byte[s2];
        wsByteBuffer.get(byArray, 0, new Integer(s2).intValue());
        commsString.setBytes(byArray);
        clientConversationState.setConnectionObjectID(s);
        clientLinkLevelState.getCatHandshakeProperties().setSourceMEName(commsString.getString());
        ConnectionProxy connectionProxy = new ConnectionProxy(conversation);
        clientConversationState.setSICoreConnection(connectionProxy);
        short s3 = wsByteBuffer.getShort();
        if (s3 != 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Got unique id of length:", new Short(s3));
            }
            byte[] byArray2 = new byte[s3];
            wsByteBuffer.get(byArray2);
            if (tc.isDebugEnabled()) {
                SibTr.bytes(tc, byArray2);
            }
            connectionProxy.setInitialUniqueId(byArray2);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "No unique Id was returned");
        }
        short s4 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Got Uuid of length " + s4);
        }
        byte[] byArray3 = new byte[s4];
        wsByteBuffer.get(byArray3);
        commsString.setBytes(byArray3);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Uuid: ", (Object)commsString.getString());
        }
        connectionProxy.setMeUuid(commsString.getString());
        short s5 = wsByteBuffer.getShort();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Got user id of length " + s5);
        }
        byte[] byArray4 = new byte[s5];
        wsByteBuffer.get(byArray4);
        commsString.setBytes(byArray4);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Resolved UserId: ", (Object)commsString.getString());
        }
        connectionProxy.setResolvedUserId(commsString.getString());
        clientConversationState.returnCommsString(commsString);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "processConnectionInfo");
        }
    }

    private void processSchema(WsByteBuffer wsByteBuffer, Conversation conversation) {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "processSchema", new Object[]{wsByteBuffer, conversation});
            }
            ClientConversationState clientConversationState = (ClientConversationState)conversation.getAttachment();
            wsByteBuffer.flip();
            byte[] byArray = new byte[wsByteBuffer.remaining()];
            System.arraycopy(wsByteBuffer.array(), wsByteBuffer.arrayOffset(), byArray, 0, wsByteBuffer.remaining());
            CommsConnection commsConnection = clientConversationState.getCommsConnection();
            try {
                ClientLinkLevelState clientLinkLevelState = (ClientLinkLevelState)conversation.getLinkLevelAttachment();
                CATHandshakeProperties cATHandshakeProperties = clientLinkLevelState.getCatHandshakeProperties();
                short s = cATHandshakeProperties.getMajorVersion();
                CompHandshake compHandshake = (CompHandshake)CompHandshakeFactory.getInstance();
                compHandshake.compData(commsConnection, s, byArray);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".processSchema"), (String)"1-008-0008", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                SibTr.debug(tc, "MFP unable to create CompHandshake Singleton", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "processSchema");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/ProxyReceiveListener.java, SIB.comms, WAS602.SIB, o0610.11 1.59");
        }
    }
}

