/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.DestinationSessionProxy;
import com.ibm.ws.sib.comms.client.LocalTransactionProxy;
import com.ibm.ws.sib.comms.client.OrderingContextProxy;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.pmi.rm.SIBPmiRm;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.LinkedList;
import java.util.List;

public class ProducerSessionProxy
extends DestinationSessionProxy
implements ProducerSession {
    private static String CLASS_NAME;
    private static final TraceComponent tc;
    private static final TraceNLS nls;
    private WriterPriorityReadersWriterLock closeLock;
    private short lowestPriority = (short)12;
    private boolean exchangeTransactedSends = CommsUtils.getRuntimeBooleanProperty("sib.comms.ForceTransactedSendExchange", "false");
    private boolean exchangeExpressSends = CommsUtils.getRuntimeBooleanProperty("sib.comms.ForceExpressSendExchange", "false");
    private static SIBPmiRm sibPmiRm;
    private OrderingContextProxy oc = null;

    public ProducerSessionProxy(Conversation conversation, ConnectionProxy connectionProxy, OrderingContextProxy orderingContextProxy, WsByteBuffer wsByteBuffer, SIDestinationAddress sIDestinationAddress) {
        super(conversation, connectionProxy);
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{conversation, connectionProxy, orderingContextProxy, wsByteBuffer, sIDestinationAddress});
        }
        this.oc = orderingContextProxy;
        this.setDestinationAddress(sIDestinationAddress);
        this.inflateData(wsByteBuffer);
        this.closeLock = connectionProxy.closeLock;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SIBusMessage sIBusMessage, SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        block12: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "send", new Object[]{sIBusMessage, sITransaction});
            }
            try {
                this.closeLock.startReading();
                try {
                    this.checkAlreadyClosed();
                    if (sITransaction != null) {
                        SITransaction sITransaction2 = sITransaction;
                        synchronized (sITransaction2) {
                            if (sITransaction instanceof LocalTransactionProxy && !((LocalTransactionProxy)sITransaction).isValid()) {
                                throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                            }
                            this._send(sIBusMessage, sITransaction);
                            break block12;
                        }
                    }
                    this._send(sIBusMessage, sITransaction);
                }
                finally {
                    this.closeLock.stopReading();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "send");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _send(SIBusMessage sIBusMessage, SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "_send");
        }
        ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
        Object object = null;
        if (sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
            sibPmiRm.attachCurrentContextCorrelators(sIBusMessage, true);
            object = sibPmiRm.produceMessageBlock(this.destinationAddress.getBusName(), this.destinationAddress.getDestinationName());
        }
        boolean bl = false;
        try {
            block21: {
                WsByteBuffer wsByteBuffer;
                List list;
                try {
                    list = ((JsMessage)sIBusMessage).encode(clientConversationState.getCommsConnection());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "._send"), (String)"1-004-0001", (Object)this);
                    throw new SIResourceException(exception);
                }
                LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                int n = 0;
                for (int i = 0; i < list.size(); n += wsByteBuffer.limit(), ++i) {
                    wsByteBuffer = this.wrapToWsBuffer((byte[])list.get(i));
                    linkedList.add(wsByteBuffer);
                }
                WsByteBuffer wsByteBuffer2 = this.getWsBuffer(16);
                wsByteBuffer2.putShort((short)this.getConnectionObjectID());
                wsByteBuffer2.putShort(this.getProxyID());
                if (sITransaction != null) {
                    wsByteBuffer2.putInt(((Transaction)((Object)sITransaction)).getTransactionId());
                } else {
                    wsByteBuffer2.putInt(0);
                }
                wsByteBuffer2.putLong((long)n);
                linkedList.add(0, wsByteBuffer2);
                wsByteBuffer2.flip();
                short s = JFapChannelConstants.getJFAPPriority(sIBusMessage.getPriority());
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Sending with JFAP priority of " + s);
                }
                this.updateLowestPriority(s);
                if (sITransaction != null && !this.exchangeTransactedSends || (sIBusMessage.getReliability() == Reliability.BEST_EFFORT_NONPERSISTENT || sIBusMessage.getReliability() == Reliability.EXPRESS_NONPERSISTENT) && !this.exchangeExpressSends) {
                    this.JFAPSend(linkedList, 76, s, false);
                    if (sITransaction != null) {
                        ((Transaction)((Object)sITransaction)).updateLowestMessagePriority(s);
                    }
                } else {
                    ReceivedData receivedData = this.JFAPExchange(linkedList, 75, s, false);
                    try {
                        short s2 = this.getCommandCompletionCode(receivedData, 203);
                        if (s2 != 0) {
                            this.checkFor_SISessionUnavailableException(receivedData, s2);
                            this.checkFor_SISessionDroppedException(receivedData, s2);
                            this.checkFor_SIConnectionUnavailableException(receivedData, s2);
                            this.checkFor_SIConnectionDroppedException(receivedData, s2);
                            this.checkFor_SIResourceException(receivedData, s2);
                            this.checkFor_SIConnectionLostException(receivedData, s2);
                            this.checkFor_SILimitExceededException(receivedData, s2);
                            this.checkFor_SINotAuthorizedException(receivedData, s2);
                            this.checkFor_SIIncorrectCallException(receivedData, s2);
                            this.checkFor_SIErrorException(receivedData, s2);
                            this.defaultChecker(receivedData, s2);
                        }
                        Object var14_16 = null;
                        if (receivedData == null) break block21;
                    }
                    catch (Throwable throwable) {
                        Object var14_17 = null;
                        if (receivedData != null) {
                            receivedData.getBuffer().release();
                        }
                        throw throwable;
                    }
                    receivedData.getBuffer().release();
                }
            }
            bl = true;
            if (sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.produceMessageUnblock(object, 0);
            }
            Object var16_19 = null;
            if (!bl && sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.produceMessageUnblock(object, 1);
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            if (!bl && sibPmiRm != null && sibPmiRm.isActiveOnThread()) {
                sibPmiRm.produceMessageUnblock(object, 1);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "_send");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "close");
        }
        if (!this.isClosed()) {
            try {
                this.closeLock.startWriting();
                try {
                    block13: {
                        WsByteBuffer wsByteBuffer = this.getWsBuffer(10);
                        wsByteBuffer.putShort((short)this.getConnectionObjectID());
                        wsByteBuffer.putShort(this.getProxyID());
                        wsByteBuffer.flip();
                        LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
                        linkedList.add(wsByteBuffer);
                        ReceivedData receivedData = this.JFAPExchange(linkedList, 74, this.lowestPriority, true);
                        try {
                            short s = this.getCommandCompletionCode(receivedData, 202);
                            if (s != 0) {
                                this.checkFor_SIConnectionDroppedException(receivedData, s);
                                this.checkFor_SIResourceException(receivedData, s);
                                this.checkFor_SIConnectionLostException(receivedData, s);
                                this.checkFor_SIErrorException(receivedData, s);
                                this.defaultChecker(receivedData, s);
                            }
                            Object var6_6 = null;
                            if (receivedData == null) break block13;
                        }
                        catch (Throwable throwable) {
                            Object var6_7 = null;
                            if (receivedData != null) {
                                receivedData.getBuffer().release();
                            }
                            throw throwable;
                        }
                        receivedData.getBuffer().release();
                    }
                    this.setClosed();
                    if (this.oc != null) {
                        this.oc.decrementUseCount();
                    }
                }
                finally {
                    this.closeLock.stopWriting();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    private void updateLowestPriority(short s) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "updateLowestPriority", "" + s);
        }
        if (s < this.lowestPriority) {
            this.lowestPriority = s;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "updateLowestPriority");
        }
    }

    static {
        block4: {
            CLASS_NAME = ProducerSessionProxy.class.getName();
            tc = SibTr.register(ProducerSessionProxy.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
            nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/ProducerSessionProxy.java, SIB.comms, WAS602.SIB, o0610.11 1.54");
            }
            try {
                sibPmiRm = SIBPmiRm.getInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".<clinit>"), (String)"1-004-0002", null);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Encountered error obtaining PMI RM instance - RM disabled for this producer");
                }
                if (!tc.isEventEnabled()) break block4;
                SibTr.exception(tc, exception);
            }
        }
    }
}

