/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.ClientComponentHandshake;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.comms.CompHandshake;
import com.ibm.ws.sib.comms.ConnectionMetaData;
import com.ibm.ws.sib.comms.ConnectionProperties;
import com.ibm.ws.sib.comms.NoCapacityException;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ClientLinkLevelState;
import com.ibm.ws.sib.comms.client.ConnectionMetaDataImpl;
import com.ibm.ws.sib.comms.client.ProxyReceiveListener;
import com.ibm.ws.sib.comms.common.CATHandshakeProperties;
import com.ibm.ws.sib.comms.common.CommsServiceUtility;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.common.JFAPCommunicator;
import com.ibm.ws.sib.jfapchannel.ClientConnectionManager;
import com.ibm.ws.sib.jfapchannel.ConnectionClosedListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.mfp.CompHandshakeFactory;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.Map;

public class ClientSideConnection
extends JFAPCommunicator
implements ClientConnection,
ConnectionClosedListener {
    private static String CLASS_NAME = ClientSideConnection.class.getName();
    private static final TraceComponent tc = SibTr.register(ClientSideConnection.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private String connectionInfo = "Unknown";

    public ClientSideConnection() {
        super(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(ConnectionProperties connectionProperties, ClientComponentHandshake clientComponentHandshake) throws SIResourceException, SIAuthenticationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connect", new Object[]{connectionProperties, clientComponentHandshake});
        }
        ClientConnectionManager clientConnectionManager = null;
        if (connectionProperties == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NULL_CONNECTION_PROPERTIES_SICO1039", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".connect"), (String)"1-001-0004", (Object)this);
            throw sIErrorException;
        }
        if (clientComponentHandshake == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("NULL_CCH_SICO1040", null, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".connect"), (String)"1-001-0005", (Object)this);
            throw sIErrorException;
        }
        Conversation conversation = null;
        boolean bl = false;
        try {
            try {
                Object object;
                Object object2;
                String string;
                ClientConnectionManager.initialise();
                CommsUtils.initialise(ClientConnectionManager.getRef());
                clientConnectionManager = ClientConnectionManager.getRef();
                if (connectionProperties.getMode() == ConnectionProperties.HOSTNAME_PORT) {
                    string = connectionProperties.getEndPoint().getHost();
                    int n = connectionProperties.getEndPoint().getPort();
                    object2 = connectionProperties.getChainName();
                    this.connectionInfo = string + ":" + n + " - " + (String)object2;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Connecting to: " + this.connectionInfo);
                    }
                    conversation = clientConnectionManager.connect(new InetSocketAddress(string, n), new ProxyReceiveListener(), (String)object2);
                } else if (connectionProperties.getMode() == ConnectionProperties.WLM_ENDPOINT) {
                    string = connectionProperties.getWLMEndPointData();
                    this.connectionInfo = string.toString();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Connecting to: " + this.connectionInfo);
                    }
                    conversation = clientConnectionManager.connect((CFEndPoint)string, new ProxyReceiveListener());
                } else {
                    this.connectionInfo = "tcp bridge service";
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Connecting via: " + this.connectionInfo);
                    }
                    conversation = clientConnectionManager.connect(new ProxyReceiveListener());
                }
                string = RuntimeInfo.getProperty("sib.comms.ServicePort");
                if (string != null) {
                    CommsServiceUtility commsServiceUtility = CommsServiceUtility.getInstance();
                    commsServiceUtility.registerConversation(conversation);
                }
                this.setConversation(conversation);
                this.createConversationState();
                this.setCommsConnection(this);
                Map map = connectionProperties.getClientConnectionPropertyMap();
                if (map != null) {
                    String string2;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Client properties: ", map);
                    }
                    object2 = (ClientConversationState)conversation.getAttachment();
                    object = (String)map.get("subscriptionProtocol");
                    if (object != null) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "Subscription protocol:", object);
                        }
                        if (((String)object).equals("Multicast")) {
                            ((ClientConversationState)object2).setMulticastEnabled(true);
                            ((ClientConversationState)object2).setUnicastEnabled(false);
                        } else if (((String)object).equals("Unicast")) {
                            ((ClientConversationState)object2).setMulticastEnabled(false);
                            ((ClientConversationState)object2).setUnicastEnabled(true);
                        } else if (((String)object).equals("UnicastAndMulticast")) {
                            ((ClientConversationState)object2).setMulticastEnabled(true);
                            ((ClientConversationState)object2).setUnicastEnabled(true);
                        }
                    }
                    if ((string2 = (String)map.get("multicastInterface")) != null) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "Multicast interface:", string2);
                        }
                        ((ClientConversationState)object2).setMulticastInterface(string2);
                    }
                }
                if (conversation.isFirst()) {
                    conversation.setConnectionClosedListener(this);
                    this.initiateCommsHandshaking();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Handshake completed successfully");
                    }
                    bl = true;
                    object2 = (ClientLinkLevelState)this.getConversation().getLinkLevelAttachment();
                    object = ((ClientLinkLevelState)object2).getCatHandshakeProperties();
                    short s = ((CATHandshakeProperties)object).getMajorVersion();
                    try {
                        CompHandshake compHandshake = (CompHandshake)CompHandshakeFactory.getInstance();
                        compHandshake.compStartHandshake(this, s);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".connect"), (String)"1-001-0003", (Object)this);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "MFP unable to create CompHandshake Singleton", exception);
                        }
                        String string3 = nls.getFormattedMessage("MFP_HANDSHAKE_FAILED_SICO1005", new Object[]{exception}, null);
                        SIResourceException sIResourceException = new SIResourceException(string3, exception);
                        throw sIResourceException;
                    }
                }
                if (!clientComponentHandshake.connect(this)) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "TRM connection returned false - connection will be aborted");
                    }
                    object2 = new SIResourceException(nls.getFormattedMessage("TRM_HANDSHAKE_FAILED_SICO1037", null, null));
                    FFDCFilter.processException((Throwable)object2, (String)(CLASS_NAME + ".connect"), (String)"1-001-0006", (Object)this);
                    throw object2;
                }
                Object var15_23 = null;
            }
            catch (SIException sIException) {
                block45: {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".connect"), (String)"1-001-0001", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Unable to make initial connection", sIException);
                    }
                    try {
                        if (conversation != null) {
                            conversation.close();
                        }
                    }
                    catch (SIException sIException2) {
                        if (!tc.isDebugEnabled()) break block45;
                        SibTr.debug(this, tc, "Failed to close connection: " + sIException2);
                    }
                }
                SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("CONNECT_FAILED_SICO1001", new Object[]{sIException, this.connectionInfo}, null));
                sIResourceException.initCause(sIException);
                throw sIResourceException;
            }
        }
        catch (Throwable throwable) {
            Object var15_24 = null;
            try {
                if (conversation == null) throw throwable;
                if (bl) {
                    conversation.handshakeComplete();
                    throw throwable;
                }
                conversation.handshakeFailed();
                throw throwable;
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                if (!tc.isDebugEnabled()) throw new SIResourceException(sIConnectionDroppedException);
                SibTr.debug(this, tc, "Connection dropped: ", sIConnectionDroppedException);
                throw new SIResourceException(sIConnectionDroppedException);
            }
        }
        try {}
        catch (SIConnectionDroppedException sIConnectionDroppedException) {
            if (!tc.isDebugEnabled()) throw new SIResourceException(sIConnectionDroppedException);
            SibTr.debug(this, tc, "Connection dropped: ", sIConnectionDroppedException);
            throw new SIResourceException(sIConnectionDroppedException);
        }
        if (conversation != null) {
            if (bl) {
                conversation.handshakeComplete();
            } else {
                conversation.handshakeFailed();
            }
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(this, tc, "connect");
    }

    public String getConnectionInfo() {
        return this.connectionInfo;
    }

    public void setSICoreConnection(SICoreConnection sICoreConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setSICoreConnection", sICoreConnection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setSICoreConnection");
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("METHOD_CALL_NOT_ALLOWED_SICO8003", new Object[]{"setSICoreConnection"}, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".setSICoreConnection"), (String)"1-001-0009", (Object)this);
        throw sIErrorException;
    }

    public SICoreConnection getSICoreConnection() throws SIConnectionLostException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getSICoreConnection");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Building connection proxy object using ID: ", "" + this.getConnectionObjectID());
        }
        ClientConversationState clientConversationState = (ClientConversationState)this.getConversation().getAttachment();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getSICoreConnection", clientConversationState.getSICoreConnection());
        }
        return clientConversationState.getSICoreConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] trmHandshakeExchange(byte[] byArray) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException {
        byte[] byArray2;
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "trmHandshakeExchange");
            }
            WsByteBuffer wsByteBuffer = this.wrapToWsBuffer(byArray);
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = this.JFAPExchange(linkedList, 8, 7, true);
            WsByteBuffer wsByteBuffer2 = receivedData.getBuffer();
            try {
                short s = this.getCommandCompletionCode(receivedData, 8);
                if (s != 0) {
                    this.checkFor_SIConnectionLostException(receivedData, s);
                    this.checkFor_SIConnectionDroppedException(receivedData, s);
                    this.checkFor_SIConnectionUnavailableException(receivedData, s);
                    this.checkFor_SIErrorException(receivedData, s);
                    this.defaultChecker(receivedData, s);
                }
                wsByteBuffer2.flip();
                byArray2 = new byte[wsByteBuffer2.remaining()];
                System.arraycopy(wsByteBuffer2.array(), wsByteBuffer2.arrayOffset(), byArray2, 0, wsByteBuffer2.remaining());
                Object var9_8 = null;
                if (receivedData == null) break block6;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "trmHandshakeExchange");
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] mfpHandshakeExchange(byte[] byArray) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException {
        byte[] byArray2;
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "mfpHandshakeExchange");
            }
            WsByteBuffer wsByteBuffer = this.wrapToWsBuffer(byArray);
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            ReceivedData receivedData = this.JFAPExchange(linkedList, 9, 7, true);
            WsByteBuffer wsByteBuffer2 = receivedData.getBuffer();
            try {
                short s = this.getCommandCompletionCode(receivedData, 9);
                if (s != 0) {
                    this.checkFor_SIConnectionLostException(receivedData, s);
                    this.checkFor_SIConnectionDroppedException(receivedData, s);
                    this.checkFor_SIConnectionUnavailableException(receivedData, s);
                    this.checkFor_SIErrorException(receivedData, s);
                    this.defaultChecker(receivedData, s);
                }
                wsByteBuffer2.flip();
                byArray2 = new byte[wsByteBuffer2.remaining()];
                System.arraycopy(wsByteBuffer2.array(), wsByteBuffer2.arrayOffset(), byArray2, 0, wsByteBuffer2.remaining());
                Object var9_8 = null;
                if (receivedData == null) break block6;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (receivedData != null) {
                    receivedData.getBuffer().release();
                }
                throw throwable;
            }
            receivedData.getBuffer().release();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "mfpHandshakeExchange");
        }
        return byArray2;
    }

    public void sendMFPSchema(byte[] byArray) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException {
        block5: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "sendMFPSchema");
            }
            WsByteBuffer wsByteBuffer = this.wrapToWsBuffer(byArray);
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            try {
                this.JFAPSend(linkedList, 230, 12, true);
            }
            catch (com.ibm.ws.sib.jfapchannel.NoCapacityException noCapacityException) {
                FFDCFilter.processException((Throwable)noCapacityException, (String)(CLASS_NAME + ".sendMFPSchema"), (String)"1-001-0010", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "NoCapacityException caught!");
                }
                if (!tc.isEventEnabled()) break block5;
                SibTr.exception((Object)this, tc, noCapacityException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "sendMFPSchema");
        }
    }

    public void close() {
        block5: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "close");
            }
            try {
                Conversation conversation = this.getConversation();
                if (conversation != null) {
                    conversation.close();
                }
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                FFDCFilter.processException((Throwable)sIConnectionLostException, (String)(CLASS_NAME + ".close"), (String)"1-001-0002", (Object)this);
                if (!tc.isDebugEnabled()) break block5;
                SibTr.debug(this, tc, "Unable to close connection", sIConnectionLostException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    public Object getUniqueLinkObject() {
        return this.getConversation().getLinkLevelAttachment();
    }

    public ConnectionMetaData getMetaData() {
        ClientLinkLevelState clientLinkLevelState = (ClientLinkLevelState)this.getConversation().getLinkLevelAttachment();
        return new ConnectionMetaDataImpl(this.getConversation().getMetaData(), clientLinkLevelState.getCatHandshakeProperties());
    }

    public String toString() {
        return "ClientSideConnection@" + Integer.toHexString(this.hashCode()) + ": " + this.connectionInfo;
    }

    public void connectionClosed(Object object) {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "connectionClosed", object);
            }
            try {
                CompHandshake compHandshake = (CompHandshake)CompHandshakeFactory.getInstance();
                compHandshake.compClose(this);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                SibTr.debug(this, tc, "MFP unable to create CompHandshake Singleton", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connectionClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] requestMFPSchemata(byte[] byArray) throws SIConnectionLostException, SIConnectionDroppedException, NoCapacityException, SIConnectionUnavailableException, SIErrorException {
        byte[] byArray2;
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "requestMFPSchemata", byArray);
            }
            byArray2 = null;
            WsByteBuffer wsByteBuffer = this.wrapToWsBuffer(byArray);
            LinkedList<WsByteBuffer> linkedList = new LinkedList<WsByteBuffer>();
            linkedList.add(wsByteBuffer);
            try {
                ReceivedData receivedData = this.JFAPExchange(linkedList, 110, 12, true);
                try {
                    short s = this.getCommandCompletionCode(receivedData, 240);
                    if (s != 0) {
                        this.checkFor_SIConnectionUnavailableException(receivedData, s);
                        this.checkFor_SIErrorException(receivedData, s);
                        this.defaultChecker(receivedData, s);
                    }
                    byArray2 = receivedData.getBuffer().array();
                    Object var8_8 = null;
                    if (receivedData == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (receivedData != null) {
                        receivedData.getBuffer().release();
                    }
                    throw throwable;
                }
                receivedData.getBuffer().release();
            }
            catch (com.ibm.ws.sib.jfapchannel.NoCapacityException noCapacityException) {
                FFDCFilter.processException((Throwable)noCapacityException, (String)(CLASS_NAME + ".requestMFPSchemata"), (String)"1-001-0011", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "NoCapacityException caught!");
                }
                if (!tc.isEventEnabled()) break block9;
                SibTr.exception((Object)this, tc, noCapacityException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "requestMFPSchemata", byArray2);
        }
        return byArray2;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.comms.impl/src/com/ibm/ws/sib/comms/client/ClientSideConnection.java, SIB.comms, WAS602.SIB, o0610.11 1.80");
        }
    }
}

