/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class ClientAsynchEventThreadPool {
    private static final TraceComponent tc = SibTr.register(ClientAsynchEventThreadPool.class, "SIBCommunications", "com.ibm.ws.sib.comms.CWSICMessages");
    private static ClientAsynchEventThreadPool instance = null;
    private ThreadPool threadPool = null;

    public static ClientAsynchEventThreadPool getInstance() {
        if (instance == null) {
            instance = new ClientAsynchEventThreadPool();
        }
        return instance;
    }

    private ClientAsynchEventThreadPool() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        this.threadPool = new ThreadPool("ClientAsynchEventThread", 1, 1);
        this.threadPool.setGrowAsNeeded(true);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public void dispatchAsynchException(ProxyQueue proxyQueue, Exception exception) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "dispatchAsynchException");
        }
        AsynchExceptionThread asynchExceptionThread = new AsynchExceptionThread(proxyQueue, exception);
        this.dispatchThread(asynchExceptionThread);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "dispatchAsynchException");
        }
    }

    public void dispatchAsynchEvent(short s, Conversation conversation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "dispatchAsynchEvent");
        }
        AsynchEventThread asynchEventThread = new AsynchEventThread(s, conversation);
        this.dispatchThread(asynchEventThread);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "dispatchAsynchEvent");
        }
    }

    public void dispatchCommsException(SICoreConnection sICoreConnection, SIConnectionLostException sIConnectionLostException) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "dispatchCommsException");
        }
        CommsExceptionThread commsExceptionThread = new CommsExceptionThread(sICoreConnection, sIConnectionLostException);
        this.dispatchThread(commsExceptionThread);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "dispatchCommsException");
        }
    }

    private void dispatchThread(Thread thread) {
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "dispatchThread");
            }
            try {
                this.threadPool.execute((Runnable)thread, 1);
            }
            catch (ThreadPool.ThreadPoolQueueIsFullException threadPoolQueueIsFullException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Unable to dispatch thread", (Object)threadPoolQueueIsFullException);
                }
            }
            catch (InterruptedException interruptedException) {
                if (!tc.isDebugEnabled()) break block6;
                SibTr.debug(tc, "Thread was interrupted", interruptedException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "dispatchThread");
        }
    }

    private void invokeCallback(SICoreConnection sICoreConnection, ConsumerSession consumerSession, Exception exception, int n) {
        block12: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "invokeCallback");
            }
            if (sICoreConnection != null) {
                try {
                    SICoreConnectionListener[] sICoreConnectionListenerArray = sICoreConnection.getConnectionListeners();
                    block8: for (int i = 0; i < sICoreConnectionListenerArray.length; ++i) {
                        switch (n) {
                            case 0: {
                                sICoreConnectionListenerArray[i].commsFailure(sICoreConnection, (SIConnectionLostException)exception);
                                continue block8;
                            }
                            case 2: {
                                sICoreConnectionListenerArray[i].meQuiescing(sICoreConnection);
                                continue block8;
                            }
                            case 3: {
                                sICoreConnectionListenerArray[i].meTerminated(sICoreConnection);
                                continue block8;
                            }
                            case 4: {
                                sICoreConnectionListenerArray[i].asynchronousException(consumerSession, exception);
                                continue block8;
                            }
                            default: {
                                if (!tc.isDebugEnabled()) continue block8;
                                SibTr.debug(this, tc, "Invalid event ID: " + n);
                            }
                        }
                    }
                }
                catch (SIException sIException) {
                    if (!tc.isDebugEnabled()) break block12;
                    SibTr.debug(this, tc, "Unable to get connection listeners", sIException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "invokeCallback");
        }
    }

    private class CommsExceptionThread
    extends Thread {
        private SICoreConnection conn = null;
        private SIConnectionLostException exception = null;

        public CommsExceptionThread(SICoreConnection sICoreConnection, SIConnectionLostException sIConnectionLostException) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "<init>");
            }
            this.conn = sICoreConnection;
            this.exception = sIConnectionLostException;
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "<init>");
            }
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "run");
            }
            ClientAsynchEventThreadPool.this.invokeCallback(this.conn, null, this.exception, 0);
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "run");
            }
        }
    }

    private class AsynchExceptionThread
    extends Thread {
        private ProxyQueue proxyQueue = null;
        private Exception exception = null;

        public AsynchExceptionThread(ProxyQueue proxyQueue, Exception exception) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "<init>");
            }
            this.proxyQueue = proxyQueue;
            this.exception = exception;
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "<init>");
            }
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "run");
            }
            if (this.proxyQueue instanceof AsynchConsumerProxyQueue) {
                ((AsynchConsumerProxyQueue)this.proxyQueue).deliverException(this.exception);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Unable to deliver exception to proxy queue of type: ", this.proxyQueue);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "run");
            }
        }
    }

    private class AsynchEventThread
    extends Thread {
        private short eventId = 0;
        private Conversation conversation = null;

        public AsynchEventThread(short s, Conversation conversation) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "<init>");
            }
            this.eventId = s;
            this.conversation = conversation;
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "<init>");
            }
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "run");
            }
            ClientConversationState clientConversationState = (ClientConversationState)this.conversation.getAttachment();
            SICoreConnection sICoreConnection = clientConversationState.getSICoreConnection();
            String string = sICoreConnection.getMeName();
            ClientAsynchEventThreadPool.this.invokeCallback(sICoreConnection, null, null, this.eventId);
            Conversation[] conversationArray = this.conversation.getConversationsSharingSameLink();
            for (int i = 0; i < conversationArray.length; ++i) {
                if (conversationArray[i] == this.conversation || !(sICoreConnection = (clientConversationState = (ClientConversationState)conversationArray[i].getAttachment()).getSICoreConnection()).getMeName().equals(string)) continue;
                ClientAsynchEventThreadPool.this.invokeCallback(sICoreConnection, null, null, this.eventId);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "run");
            }
        }
    }
}

