/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.comms.EndPoint;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import java.util.Map;

public class ConnectionProperties {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private EndPoint endPoint;
    private String chain;
    private CFEndPoint wlmEndPointData;
    private PropertiesType mode;
    private Map clientConnectionProperties = null;
    public static final PropertiesType WLM_ENDPOINT = new PropertiesType("wlm endpoint");
    public static final PropertiesType HOSTNAME_PORT = new PropertiesType("hostname port");
    public static final PropertiesType Z_TCP_PROXY = new PropertiesType("zOS tcp proxy");
    public static final String CHAIN_NAME_JFAP_TCP = "BootstrapBasicMessaging";
    public static final String CHAIN_NAME_JFAP_SSL_TCP = "BootstrapSecureMessaging";
    public static final String CHAIN_NAME_JFAP_HTTP_TCP = "BootstrapTunneledMessaging";
    public static final String CHAIN_NAME_JFAP_HTTP_SSL_TCP = "BootstrapTunneledSecureMessaging";

    public ConnectionProperties() {
        this.mode = Z_TCP_PROXY;
    }

    public ConnectionProperties(EndPoint endPoint, String string) {
        if (endPoint == null) {
            throw new SIErrorException(nls.getFormattedMessage("TEMPORARY_CWSIC9999", new Object[]{"The Endpoint passed in was null"}, null));
        }
        if (string == null) {
            throw new SIErrorException(nls.getFormattedMessage("TEMPORARY_CWSIC9999", new Object[]{"The Chain Name passed in was null"}, null));
        }
        this.endPoint = endPoint;
        this.chain = string;
        this.mode = HOSTNAME_PORT;
    }

    public ConnectionProperties(CFEndPoint cFEndPoint) {
        if (cFEndPoint == null) {
            throw new SIErrorException(nls.getFormattedMessage("TEMPORARY_CWSIC9999", new Object[]{"The WLM Endpoint data passed in was null"}, null));
        }
        this.wlmEndPointData = cFEndPoint;
        this.mode = WLM_ENDPOINT;
    }

    public CFEndPoint getWLMEndPointData() {
        if (this.mode != WLM_ENDPOINT) {
            throw new SIErrorException(nls.getFormattedMessage("TEMPORARY_CWSIC9999", new Object[]{"This object does not represent a WLM Endpoint"}, null));
        }
        return this.wlmEndPointData;
    }

    public PropertiesType getMode() {
        return this.mode;
    }

    public EndPoint getEndPoint() {
        if (this.mode != HOSTNAME_PORT) {
            throw new SIErrorException(nls.getFormattedMessage("TEMPORARY_CWSIC9999", new Object[]{"This object does not represent a Host / Port combination"}, null));
        }
        return this.endPoint;
    }

    public String getChainName() {
        if (this.mode != HOSTNAME_PORT) {
            throw new SIErrorException(nls.getFormattedMessage("TEMPORARY_CWSIC9999", new Object[]{"This object does not represent a Host / Port combination"}, null));
        }
        return this.chain;
    }

    public void setClientConnectionPropertyMap(Map map) {
        this.clientConnectionProperties = map;
    }

    public Map getClientConnectionPropertyMap() {
        return this.clientConnectionProperties;
    }

    public String toString() {
        String string = "ConnectionProperties@" + Integer.toHexString(System.identityHashCode(this)) + ":- ";
        string = string + "Mode: " + this.mode;
        if (this.mode == HOSTNAME_PORT) {
            string = string + ", Endpoint: " + this.endPoint + ", Chain: " + this.chain;
        } else if (this.mode == WLM_ENDPOINT) {
            string = string + ", CFEndpoint: " + this.wlmEndPointData;
        }
        string = string + ", ClientConnectionProperties: " + this.clientConnectionProperties;
        return string;
    }

    private static class PropertiesType {
        private String description;

        private PropertiesType(String string) {
            this.description = string;
        }

        public String toString() {
            return this.description;
        }
    }
}

