/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jmsra.JmsJcaSession;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnection;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnectionFactoryImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ManagedConnectionFactory;

final class JmsJcaSessionImpl
implements JmsJcaSession {
    private JmsJcaManagedConnection _managedConnection;
    private JmsJcaConnectionImpl _connection;
    private boolean _transacted;
    private SIUncoordinatedTransaction _applicationLocalTransaction;
    private final JmsJcaConnectionRequestInfo _requestInfo;
    private boolean _sessionClosed = false;
    private boolean _sessionInvalidated = false;
    private static TraceComponent TRACE = SibTr.register(JmsJcaSessionImpl.class, "SIBJmsRa", "com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String FFDC_PROBE_7 = "7";
    private static final String CLASS_NAME = JmsJcaSessionImpl.class.getName();

    JmsJcaSessionImpl(JmsJcaManagedConnection jmsJcaManagedConnection, JmsJcaConnectionRequestInfo jmsJcaConnectionRequestInfo) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "JmsJcaSessionImpl", new Object[]{jmsJcaManagedConnection, jmsJcaConnectionRequestInfo});
        }
        this._managedConnection = jmsJcaManagedConnection;
        this._requestInfo = jmsJcaConnectionRequestInfo;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "JmsJcaSessionImpl");
        }
    }

    JmsJcaSessionImpl() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "JmsJcaSessionImpl");
        }
        this._requestInfo = null;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "JmsJcaSessionImpl");
        }
    }

    public SICoreConnection getSICoreConnection() throws IllegalStateException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getSICoreConnection");
        }
        if (this._sessionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1123", new Object[]{"getSICoreConnection"}, null));
        }
        if (this._sessionInvalidated) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1124", new Object[]{"getSICoreConnection"}, null));
        }
        SICoreConnection sICoreConnection = null;
        if (this._connection != null) {
            sICoreConnection = this._connection.getSICoreConnection();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getSICoreConnection", sICoreConnection);
        }
        return sICoreConnection;
    }

    public SITransaction getCurrentTransaction() throws IllegalStateException, ResourceException, SIException, SIErrorException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "getCurrentTransaction");
        }
        if (this._sessionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1130", new Object[]{"getCurrentTransaction"}, null));
        }
        if (this._sessionInvalidated) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1134", new Object[]{"getCurrentTransaction"}, null));
        }
        SITransaction sITransaction = null;
        if (this._applicationLocalTransaction != null) {
            sITransaction = this._applicationLocalTransaction;
        } else if (!this._connection.getConnectionFactory().isManaged()) {
            if (this.getTransacted()) {
                sITransaction = this._applicationLocalTransaction = this._connection.getSICoreConnection().createUncoordinatedTransaction();
            }
        } else {
            sITransaction = this.getManagedConnection().getCurrentTransaction(this._connection.getConnectionManager());
            if (sITransaction == null && this.getTransacted()) {
                try {
                    this._applicationLocalTransaction = this._connection.getSICoreConnection().createUncoordinatedTransaction();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".getCurrentTransaction"), (String)FFDC_PROBE_2, (Object)this);
                    if (TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, TRACE, sIException);
                    }
                    throw sIException;
                }
                catch (SIErrorException sIErrorException) {
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".getCurrentTransaction"), (String)FFDC_PROBE_5, (Object)this);
                    if (TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, TRACE, sIErrorException);
                    }
                    throw sIErrorException;
                }
                this._managedConnection.localTransactionStarted();
                sITransaction = this._applicationLocalTransaction;
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "getCurrentTransaction", sITransaction);
        }
        return sITransaction;
    }

    public boolean getTransacted() throws IllegalStateException {
        if (this._sessionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1131", new Object[]{"getTransacted"}, null));
        }
        if (this._sessionInvalidated) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1135", new Object[]{"getTransacted"}, null));
        }
        return this._transacted;
    }

    public void commitLocalTransaction() throws IllegalStateException, LocalTransactionException, ResourceException, SIException, SIErrorException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "commitLocalTransaction");
        }
        if (this._sessionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1132", new Object[]{"commitLocalTransaction"}, null));
        }
        if (this._sessionInvalidated) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1136", new Object[]{"commitLocalTransaction"}, null));
        }
        if (!this.getTransacted()) {
            throw new LocalTransactionException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1125", new Object[]{"commitLocalTransaction"}, null));
        }
        if (this._applicationLocalTransaction == null) {
            SITransaction sITransaction;
            if (this._connection.getConnectionFactory().isManaged() && (sITransaction = this.getManagedConnection().getCurrentTransaction(this._connection.getConnectionManager())) != null) {
                throw new LocalTransactionException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1138", new Object[]{"commitLocalTransaction"}, null));
            }
        } else {
            try {
                this._applicationLocalTransaction.commit();
            }
            catch (SIRollbackException sIRollbackException) {
                if (this._connection.getConnectionFactory().isManaged()) {
                    this._managedConnection.localTransactionRolledBack();
                }
                this._applicationLocalTransaction = null;
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, TRACE, sIRollbackException);
                }
                throw sIRollbackException;
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".commitLocalTranaction"), (String)FFDC_PROBE_3, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, TRACE, sIException);
                }
                throw sIException;
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".commitLocalTranaction"), (String)FFDC_PROBE_6, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, TRACE, sIErrorException);
                }
                throw sIErrorException;
            }
            if (this._connection.getConnectionFactory().isManaged()) {
                this._managedConnection.localTransactionCommitted();
            }
            this._applicationLocalTransaction = null;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "commitLocalTransaction");
        }
    }

    public void rollbackLocalTransaction() throws IllegalStateException, LocalTransactionException, ResourceException, SIException, SIErrorException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "rollbackLocalTransaction");
        }
        if (this._sessionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1133", new Object[]{"rollbackLocalTransaction"}, null));
        }
        if (this._sessionInvalidated) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1137", new Object[]{"rollbackLocalTransaction"}, null));
        }
        if (!this.getTransacted()) {
            throw new LocalTransactionException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1139", new Object[]{"rollbackLocalTransaction"}, null));
        }
        if (this._applicationLocalTransaction == null) {
            SITransaction sITransaction;
            if (this._connection.getConnectionFactory().isManaged() && (sITransaction = this.getManagedConnection().getCurrentTransaction(this._connection.getConnectionManager())) != null) {
                throw new LocalTransactionException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1140", new Object[]{"rollbackLocalTransaction"}, null));
            }
        } else {
            try {
                this._applicationLocalTransaction.rollback();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".rollbackLocalTransaction"), (String)FFDC_PROBE_4, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, TRACE, sIException);
                }
                throw sIException;
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".rollbackLocalTransaction"), (String)FFDC_PROBE_7, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, TRACE, sIErrorException);
                }
                throw sIErrorException;
            }
            if (this._connection.getConnectionFactory().isManaged()) {
                this._managedConnection.localTransactionRolledBack();
            }
            this._applicationLocalTransaction = null;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "rollbackLocalTransaction");
        }
    }

    public void close() throws SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        this.close(true);
    }

    JmsJcaManagedConnection getManagedConnection() throws IllegalStateException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getManagedConnection");
        }
        if (this._managedConnection == null) {
            ConnectionManager connectionManager = this._connection.getConnectionManager();
            if (connectionManager == null) {
                throw new IllegalStateException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1126", new Object[]{"getManagedConnection"}, null));
            }
            if (connectionManager instanceof LazyAssociatableConnectionManager) {
                try {
                    JmsJcaManagedConnectionFactoryImpl jmsJcaManagedConnectionFactoryImpl = this._connection.getConnectionFactory().getManagedConnectionFactory();
                    ((LazyAssociatableConnectionManager)connectionManager).associateConnection((Object)this, (ManagedConnectionFactory)jmsJcaManagedConnectionFactoryImpl, (ConnectionRequestInfo)this._requestInfo);
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + "getManagedConnection"), (String)FFDC_PROBE_1, (Object)this);
                    SibTr.exception((Object)this, TRACE, (Exception)((Object)resourceException));
                    throw new IllegalStateException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1121", new Object[]{"getManagedConnection", resourceException}, null), (Throwable)resourceException);
                }
            } else {
                throw new IllegalStateException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1122", new Object[]{"getManagedConnection", connectionManager.getClass().getName(), LazyAssociatableConnectionManager.class.getName()}, null));
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getManagedConnection", this._managedConnection);
        }
        return this._managedConnection;
    }

    void close(boolean bl) throws SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "close", bl);
        }
        if (this._applicationLocalTransaction != null) {
            this._applicationLocalTransaction.rollback();
            if (this._connection.getConnectionFactory().isManaged()) {
                this._managedConnection.localTransactionRolledBack();
            }
            this._applicationLocalTransaction = null;
        }
        if (this._managedConnection != null) {
            this._managedConnection.sessionClosed(this);
        }
        if (bl) {
            this._connection.removeSession(this);
        }
        this._sessionClosed = true;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "close");
        }
    }

    void commitUnresolvedLocalTransaction() throws LocalTransactionException, SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "commitUnresolvedLocalTransaction");
        }
        if (this._applicationLocalTransaction == null) {
            throw new LocalTransactionException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1141", new Object[]{"commitUnresolvedLocalTransaction"}, null));
        }
        this._applicationLocalTransaction.commit();
        this._applicationLocalTransaction = null;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "commitUnresolvedLocalTransaction");
        }
    }

    void rollbackUnresolvedLocalTransaction() throws LocalTransactionException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "rollbackUnresolvedLocalTransaction");
        }
        if (this._applicationLocalTransaction == null) {
            throw new LocalTransactionException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1142", new Object[]{"rollbackUnresolvedLocalTransaction"}, null));
        }
        this._applicationLocalTransaction.rollback();
        this._applicationLocalTransaction = null;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "rollbackUnresolvedLocalTransaction");
        }
    }

    void dissociate() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "dissociate");
        }
        this._managedConnection = null;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "dissociate");
        }
    }

    void associate(JmsJcaManagedConnection jmsJcaManagedConnection) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "associate", jmsJcaManagedConnection);
        }
        if (this._managedConnection != null) {
            this._managedConnection.disassociateSession(this);
        }
        this._managedConnection = jmsJcaManagedConnection;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "associate");
        }
    }

    JmsJcaConnectionImpl getConnection() {
        return this._connection;
    }

    void setTransacted(boolean bl) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "setTransacted", bl);
        }
        this._transacted = bl;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "setTransacted");
        }
    }

    void invalidate() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "invalidate");
        }
        this._sessionInvalidated = true;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "invalidate");
        }
    }

    void setParentConnection(JmsJcaConnectionImpl jmsJcaConnectionImpl) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "setParentConnection", jmsJcaConnectionImpl);
        }
        this._connection = jmsJcaConnectionImpl;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "setParentConnection");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("@");
        stringBuffer.append(System.identityHashCode(this));
        stringBuffer.append(" <managedConnection=");
        stringBuffer.append(System.identityHashCode(this._managedConnection));
        stringBuffer.append("> <connection=");
        stringBuffer.append(System.identityHashCode(this._connection));
        stringBuffer.append("> <transacted=");
        stringBuffer.append(this._transacted);
        stringBuffer.append("> <applicationLocalTransaction=");
        stringBuffer.append(this._applicationLocalTransaction);
        stringBuffer.append("> <reqInfo=");
        stringBuffer.append(this._requestInfo);
        stringBuffer.append("> <sessionClosed=");
        stringBuffer.append(this._sessionClosed);
        stringBuffer.append("> <sessionInvalidated=");
        stringBuffer.append(this._sessionInvalidated);
        stringBuffer.append(">]");
        return stringBuffer.toString();
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug(TRACE, "Source info: @(#)SIB/ws/code/sib.api.jmsra.outbound.impl/src/com/ibm/ws/sib/api/jmsra/impl/JmsJcaSessionImpl.java, SIB.api.jmsra, WAS602.SIB, o0610.11 1.41");
        }
    }
}

