/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.StringArrayWrapper;
import com.ibm.ws.sib.api.jmsra.JmsJcaReferenceUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class JmsJcaReferenceUtilsImpl
extends JmsJcaReferenceUtils {
    private static TraceComponent TRACE = SibTr.register(JmsJcaReferenceUtilsImpl.class, "SIBJmsRa", "com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static final String FFDC_PROBE_1 = "1";
    private static final String PREFIX_NULL = "NULL";
    private static final String PREFIX_BOOLEAN = "BOOL";
    private static final String PREFIX_INT = "INT";
    private static final String PREFIX_BYTE = "BYTE";
    private static final String PREFIX_SHORT = "SHORT";
    private static final String PREFIX_STRING = "STRING";
    private static final String PREFIX_FLOAT = "FLOAT";
    private static final String PREFIX_DOUBLE = "DOUBLE";
    private static final String PREFIX_LONG = "LONG";
    private static final String PREFIX_ROUTING_PATH = "ROUTINGPATH";
    private static final String PREFIX_SEPARATOR = "_";
    private static Map prefixTable;

    public void populatePrefixTable() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "populatePrefixTable");
        }
        prefixTable = new HashMap();
        prefixTable.put(Boolean.class, PREFIX_BOOLEAN);
        prefixTable.put(Integer.class, PREFIX_INT);
        prefixTable.put(Byte.class, PREFIX_BYTE);
        prefixTable.put(Short.class, PREFIX_SHORT);
        prefixTable.put(String.class, PREFIX_STRING);
        prefixTable.put(Float.class, PREFIX_FLOAT);
        prefixTable.put(Double.class, PREFIX_DOUBLE);
        prefixTable.put(Long.class, PREFIX_LONG);
        prefixTable.put(StringArrayWrapper.class, PREFIX_ROUTING_PATH);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "populatePrefixTable");
        }
    }

    public Map getStringEncodedMap(Map map) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getStringEncodedMap", map);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null) continue;
            Object v = map.get(string);
            String string2 = null;
            String string3 = null;
            if (v == null) {
                string2 = PREFIX_NULL;
                string3 = null;
            } else {
                if (prefixTable == null) {
                    this.populatePrefixTable();
                }
                if ((string2 = (String)prefixTable.get(v.getClass())) == null) {
                    if (!TRACE.isDebugEnabled()) continue;
                    SibTr.debug(TRACE, "unsupported type for property: " + v.getClass().getName());
                    continue;
                }
                string3 = v.toString();
            }
            String string4 = string2 + PREFIX_SEPARATOR + string;
            hashMap.put(string4, string3);
            if (!TRACE.isDebugEnabled()) continue;
            SibTr.debug(TRACE, "encoded: " + string4 + " = '" + string3 + "'");
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getStringEncodedMap", hashMap);
        }
        return hashMap;
    }

    public Map getStringDecodedMap(Map map) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getStringDecodedMap", map);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = null;
            Object object = null;
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            String string4 = null;
            int n = string2.indexOf(PREFIX_SEPARATOR);
            if (n == -1) {
                if (!TRACE.isDebugEnabled()) continue;
                SibTr.debug(TRACE, "Ignoring malformed encoded name: " + string2);
                continue;
            }
            string4 = string2.substring(0, n);
            string = string2.substring(n + PREFIX_SEPARATOR.length());
            try {
                if (PREFIX_NULL.equals(string4)) {
                    object = null;
                } else if (PREFIX_STRING.equals(string4)) {
                    object = string3;
                    if (object == null) {
                        object = "";
                    }
                } else if (PREFIX_BOOLEAN.equals(string4)) {
                    object = Boolean.valueOf(string3);
                } else if (PREFIX_INT.equals(string4)) {
                    object = Integer.valueOf(string3);
                } else if (PREFIX_BYTE.equals(string4)) {
                    object = Byte.valueOf(string3);
                } else if (PREFIX_SHORT.equals(string4)) {
                    object = Short.valueOf(string3);
                } else if (PREFIX_FLOAT.equals(string4)) {
                    object = Float.valueOf(string3);
                } else if (PREFIX_DOUBLE.equals(string4)) {
                    object = Double.valueOf(string3);
                } else if (PREFIX_LONG.equals(string4)) {
                    object = Long.valueOf(string3);
                } else if (PREFIX_ROUTING_PATH.equals(string4)) {
                    String[] stringArray = string3.split("<#>");
                    String string5 = (String)map.get("STRING_DEST_NAME");
                    object = StringArrayWrapper.create(stringArray, string5);
                } else {
                    if (!TRACE.isDebugEnabled()) continue;
                    SibTr.debug(TRACE, "Ignoring unknown prefix: " + string4);
                    continue;
                }
                hashMap.put(string, (String)object);
                if (!TRACE.isDebugEnabled()) continue;
                SibTr.debug(TRACE, "retrieved: " + string + " = " + object);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.api.jmsra.impl.JmsJcaReferenceUtilsImpl.getStringDecodedMap", (String)FFDC_PROBE_1, (Object)this);
                if (!TRACE.isDebugEnabled()) continue;
                SibTr.debug(TRACE, "Error decoding string to object. ", exception);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getStringDecodedMap", hashMap);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMapFromReference(Reference reference) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getMapFromReference", reference);
        }
        Map map = null;
        Reference reference2 = reference;
        synchronized (reference2) {
            Enumeration<RefAddr> enumeration = reference.getAll();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (enumeration.hasMoreElements()) {
                StringRefAddr stringRefAddr = (StringRefAddr)enumeration.nextElement();
                String string = stringRefAddr.getType();
                String string2 = (String)stringRefAddr.getContent();
                hashMap.put(string, string2);
            }
            map = this.getStringDecodedMap(hashMap);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getMapFromReference", map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateReference(Reference reference, Map map) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "populateReference", new Object[]{reference, map});
        }
        Map map2 = map;
        synchronized (map2) {
            Map map3 = this.getStringEncodedMap(map);
            Iterator iterator = map3.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map3.get(string);
                reference.add(new StringRefAddr(string, string2));
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "populateReference");
        }
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug(TRACE, "Source info: @(#)SIB/ws/code/sib.api.jmsra.outbound.impl/src/com/ibm/ws/sib/api/jmsra/impl/JmsJcaReferenceUtilsImpl.java, SIB.api.jmsra, WAS602.SIB, o0610.11 1.16");
        }
        prefixTable = null;
    }
}

