/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsConnectionFactory;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsRAFactoryFactory;
import com.ibm.ws.sib.api.jms.ute.UTEHelperFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaManagedConnectionFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaReferenceUtils;
import com.ibm.ws.sib.api.jmsra.JmsraConstants;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionFactoryImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnection;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnectionSynchronizationProvider;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaUserDetails;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import com.ibm.wsspi.sib.core.selector.SICoreConnectionFactorySelector;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class JmsJcaManagedConnectionFactoryImpl
implements JmsJcaManagedConnectionFactory {
    private transient PrintWriter _logWriter;
    private transient JmsRAFactoryFactory _jmsFactoryFactory;
    private Map _properties = new HashMap();
    static final String CONN_FACTORY_TYPE = "javax.jms.ConnectionFactory";
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String CLASS_NAME = JmsJcaManagedConnectionFactoryImpl.class.getName();
    private static final long serialVersionUID = 8124956584686200082L;
    private static TraceComponent TRACE = SibTr.register(JmsJcaManagedConnectionFactoryImpl.class, "SIBJmsRa", "com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;

    public JmsJcaManagedConnectionFactoryImpl() {
        this.setBusName(JmsraConstants.DEFAULT_BUS_NAME);
        this.setClientID(JmsraConstants.DEFAULT_CLIENT_ID);
        this.setNonPersistentMapping(ApiJmsConstants.MAPPING_EXPRESS_NONPERSISTENT);
        this.setPersistentMapping(ApiJmsConstants.MAPPING_RELIABLE_PERSISTENT);
        this.setPassword(JmsraConstants.DEFAULT_PASSWORD);
        this.setUserName(JmsraConstants.DEFAULT_USER_NAME);
        this.setDurableSubscriptionHome(JmsraConstants.DEFAULT_DURABLE_SUB_HOME);
        this.setReadAhead("Default");
        this._properties.put("tempQueueNamePrefix", JmsraConstants.DEFAULT_TEMP_QUEUE_NAME_PREFIX);
        this._properties.put("tempTopicNamePrefix", JmsraConstants.DEFAULT_TEMP_TOPIC_NAME_PREFIX);
        this.setTarget(JmsraConstants.DEFAULT_TARGET);
        this.setTargetType("BusMember");
        this.setTargetSignificance("Preferred");
        this.setTargetTransportChain(JmsraConstants.DEFAULT_TARGET_TRANSPORT_CHAIN);
        this.setProviderEndpoints(JmsraConstants.DEFAULT_PROVIDER_ENDPOINTS);
        this.setConnectionProximity("Bus");
        this.setXARecoveryAlias(JmsraConstants.DEFAULT_XA_RECOVERY_ALIAS);
        this.setShareDurableSubscriptions("InCluster");
        this.setShareDataSourceWithCMP(JmsraConstants.DEFAULT_SHARE_DATA_SOURCE_WITH_CMP);
        this.setSubscriptionProtocol("Unicast");
        this.setMulticastInterface("none");
    }

    public final Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "createConnectionFactory", connectionManager);
        }
        JmsJcaConnectionFactoryImpl jmsJcaConnectionFactoryImpl = new JmsJcaConnectionFactoryImpl(this, connectionManager);
        JmsRAFactoryFactory jmsRAFactoryFactory = this.getJmsRAFactoryFactory();
        ConnectionFactory connectionFactory = this.createJmsConnFactory(jmsRAFactoryFactory, jmsJcaConnectionFactoryImpl);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "createConnectionFactory", connectionFactory);
        }
        return connectionFactory;
    }

    public final Object createConnectionFactory() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "createConnectionFactory");
        }
        JmsJcaConnectionFactoryImpl jmsJcaConnectionFactoryImpl = new JmsJcaConnectionFactoryImpl(this);
        JmsRAFactoryFactory jmsRAFactoryFactory = this.getJmsRAFactoryFactory();
        ConnectionFactory connectionFactory = this.createJmsConnFactory(jmsRAFactoryFactory, jmsJcaConnectionFactoryImpl, this);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "createConnectionFactory", connectionFactory);
        }
        return connectionFactory;
    }

    public final ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object object;
        Object object2;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "createManagedConnection", new Object[]{JmsJcaManagedConnection.subjectToString(subject), connectionRequestInfo});
        }
        JmsJcaConnectionRequestInfo jmsJcaConnectionRequestInfo = null;
        SICoreConnection sICoreConnection = null;
        if (connectionRequestInfo != null) {
            if (!(connectionRequestInfo instanceof JmsJcaConnectionRequestInfo)) {
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1022", new Object[]{"createManagedConnection", JmsJcaConnectionRequestInfo.class.getName(), connectionRequestInfo.getClass().getName()}, null));
            }
            jmsJcaConnectionRequestInfo = (JmsJcaConnectionRequestInfo)connectionRequestInfo;
            sICoreConnection = jmsJcaConnectionRequestInfo.getSICoreConnection();
        }
        JmsJcaUserDetails jmsJcaUserDetails = this.getUserDetails(subject, connectionRequestInfo);
        if (sICoreConnection == null) {
            if (!UTEHelperFactory.jmsTestEnvironmentEnabled) {
                try {
                    object2 = SICoreConnectionFactorySelector.getSICoreConnectionFactory(FactoryType.TRM_CONNECTION);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_5, (Object)this);
                    throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1021", new Object[]{sIException, "getSICoreConnectionFactory"}, null), (Throwable)sIException);
                }
            } else {
                object2 = UTEHelperFactory.getHelperInstance().setupJmsTestEnvironment();
            }
            if (object2 == null) {
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("SICORECONNECTION_ERROR_CWSJR1023", new Object[]{"createManagedConnection"}, null));
            }
            try {
                object = this.getTrmProperties();
                sICoreConnection = jmsJcaUserDetails == null ? object2.createConnection(subject, (Map)object) : object2.createConnection(jmsJcaUserDetails.getUserName(), jmsJcaUserDetails.getPassword(), (Map)object);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, TRACE, sIException);
                }
                throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1028", new Object[]{sIException, "createManagedConnection"}, null), (Throwable)sIException);
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_2, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, TRACE, sIErrorException);
                }
                throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1028", new Object[]{sIErrorException, "createManagedConnection"}, null), (Throwable)sIErrorException);
            }
            if (jmsJcaConnectionRequestInfo != null) {
                jmsJcaConnectionRequestInfo.setSICoreConnection(sICoreConnection);
            }
        }
        try {
            object = jmsJcaConnectionRequestInfo != null ? sICoreConnection.cloneConnection() : sICoreConnection;
            object2 = this.getShareDataSourceWithCMP() != null && this.getShareDataSourceWithCMP().booleanValue() ? new JmsJcaManagedConnectionSynchronizationProvider(this, (SICoreConnection)object, jmsJcaUserDetails, subject) : new JmsJcaManagedConnection(this, (SICoreConnection)object, jmsJcaUserDetails, subject);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_3, (Object)this);
            throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1026", new Object[]{sIException, "createManagedConnection"}, null), (Throwable)sIException);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_4, (Object)this);
            throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1026", new Object[]{sIErrorException, "createManagedConnection"}, null), (Throwable)sIErrorException);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "createManagedConnection", object2);
        }
        return object2;
    }

    public final ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "matchManagedConnections", new Object[]{set, JmsJcaManagedConnection.subjectToString(subject), connectionRequestInfo});
        }
        SICoreConnection sICoreConnection = connectionRequestInfo instanceof JmsJcaConnectionRequestInfo ? ((JmsJcaConnectionRequestInfo)connectionRequestInfo).getSICoreConnection() : null;
        JmsJcaUserDetails jmsJcaUserDetails = this.getUserDetails(subject, connectionRequestInfo);
        if (TRACE.isDebugEnabled()) {
            if (jmsJcaUserDetails != null) {
                SibTr.debug(TRACE, "Got a username and password");
            } else {
                SibTr.debug(TRACE, "Using subject");
            }
        }
        JmsJcaManagedConnection jmsJcaManagedConnection = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JmsJcaManagedConnection)) continue;
            JmsJcaManagedConnection jmsJcaManagedConnection2 = (JmsJcaManagedConnection)e;
            if (jmsJcaUserDetails != null) {
                if (!jmsJcaManagedConnection2.match(jmsJcaUserDetails, sICoreConnection)) continue;
                jmsJcaManagedConnection = jmsJcaManagedConnection2;
                if (!TRACE.isDebugEnabled()) break;
                SibTr.debug(TRACE, "Matched a connection against the subject username and password");
                break;
            }
            if (!jmsJcaManagedConnection2.match(subject, sICoreConnection)) continue;
            jmsJcaManagedConnection = jmsJcaManagedConnection2;
            if (!TRACE.isDebugEnabled()) break;
            SibTr.debug(TRACE, "Matched a connection against the subject");
            break;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "matchManagedConnections", jmsJcaManagedConnection);
        }
        return jmsJcaManagedConnection;
    }

    public final void setLogWriter(PrintWriter printWriter) {
        this._logWriter = printWriter;
    }

    public final PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public final int hashCode() {
        int n = 11;
        n = 23 * n + (this.getBusName() == null ? 0 : this.getBusName().hashCode());
        n = 23 * n + (this.getClientID() == null ? 0 : this.getClientID().hashCode());
        n = 23 * n + (this.getUserName() == null ? 0 : this.getUserName().hashCode());
        n = 23 * n + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        n = 23 * n + (this.getXARecoveryAlias() == null ? 0 : this.getXARecoveryAlias().hashCode());
        n = 23 * n + (this.getNonPersistentMapping() == null ? 0 : this.getNonPersistentMapping().hashCode());
        n = 23 * n + (this.getPersistentMapping() == null ? 0 : this.getPersistentMapping().hashCode());
        n = 23 * n + (this.getDurableSubscriptionHome() == null ? 0 : this.getDurableSubscriptionHome().hashCode());
        n = 23 * n + (this.getReadAhead() == null ? 0 : this.getReadAhead().hashCode());
        n = 23 * n + (this.getTemporaryQueueNamePrefix() == null ? 0 : this.getTemporaryQueueNamePrefix().hashCode());
        n = 23 * n + (this.getTemporaryTopicNamePrefix() == null ? 0 : this.getTemporaryTopicNamePrefix().hashCode());
        n = 23 * n + (this.getTarget() == null ? 0 : this.getTarget().hashCode());
        n = 23 * n + (this.getTargetType() == null ? 0 : this.getTargetType().hashCode());
        n = 23 * n + (this.getTargetSignificance() == null ? 0 : this.getTargetSignificance().hashCode());
        n = 23 * n + (this.getTargetTransportChain() == null ? 0 : this.getTargetTransportChain().hashCode());
        n = 23 * n + (this.getProviderEndpoints() == null ? 0 : this.getProviderEndpoints().hashCode());
        n = 23 * n + (this.getConnectionProximity() == null ? 0 : this.getConnectionProximity().hashCode());
        n = 23 * n + (this.getShareDataSourceWithCMP() == null ? 0 : this.getShareDataSourceWithCMP().hashCode());
        n = 23 * n + (this.getShareDurableSubscriptions() == null ? 0 : this.getShareDurableSubscriptions().hashCode());
        n = 23 * n + (this.getSubscriptionProtocol() == null ? 0 : this.getSubscriptionProtocol().hashCode());
        n = 23 * n + (this.getMulticastInterface() == null ? 0 : this.getMulticastInterface().hashCode());
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JmsJcaManagedConnectionFactoryImpl)) {
            return false;
        }
        JmsJcaManagedConnectionFactoryImpl jmsJcaManagedConnectionFactoryImpl = (JmsJcaManagedConnectionFactoryImpl)object;
        if (this.getBusName() == null && jmsJcaManagedConnectionFactoryImpl.getBusName() != null) {
            return false;
        }
        if (this.getClientID() == null && jmsJcaManagedConnectionFactoryImpl.getClientID() != null) {
            return false;
        }
        if (this.getUserName() == null && jmsJcaManagedConnectionFactoryImpl.getUserName() != null) {
            return false;
        }
        if (this.getPassword() == null && jmsJcaManagedConnectionFactoryImpl.getPassword() != null) {
            return false;
        }
        if (this.getXARecoveryAlias() == null && jmsJcaManagedConnectionFactoryImpl.getXARecoveryAlias() != null) {
            return false;
        }
        if (this.getNonPersistentMapping() == null && jmsJcaManagedConnectionFactoryImpl.getNonPersistentMapping() != null) {
            return false;
        }
        if (this.getPersistentMapping() == null && jmsJcaManagedConnectionFactoryImpl.getPersistentMapping() != null) {
            return false;
        }
        if (this.getDurableSubscriptionHome() == null && jmsJcaManagedConnectionFactoryImpl.getDurableSubscriptionHome() != null) {
            return false;
        }
        if (this.getReadAhead() == null && jmsJcaManagedConnectionFactoryImpl.getReadAhead() != null) {
            return false;
        }
        if (this.getTemporaryQueueNamePrefix() == null && jmsJcaManagedConnectionFactoryImpl.getTemporaryQueueNamePrefix() != null) {
            return false;
        }
        if (this.getTemporaryTopicNamePrefix() == null && jmsJcaManagedConnectionFactoryImpl.getTemporaryTopicNamePrefix() != null) {
            return false;
        }
        if (this.getTarget() == null && jmsJcaManagedConnectionFactoryImpl.getTarget() != null) {
            return false;
        }
        if (this.getTargetType() == null && jmsJcaManagedConnectionFactoryImpl.getTargetType() != null) {
            return false;
        }
        if (this.getTargetSignificance() == null && jmsJcaManagedConnectionFactoryImpl.getTargetSignificance() != null) {
            return false;
        }
        if (this.getTargetTransportChain() == null && jmsJcaManagedConnectionFactoryImpl.getTargetTransportChain() != null) {
            return false;
        }
        if (this.getProviderEndpoints() == null && jmsJcaManagedConnectionFactoryImpl.getProviderEndpoints() != null) {
            return false;
        }
        if (this.getConnectionProximity() == null && jmsJcaManagedConnectionFactoryImpl.getConnectionProximity() != null) {
            return false;
        }
        if (this.getShareDataSourceWithCMP() == null && jmsJcaManagedConnectionFactoryImpl.getShareDataSourceWithCMP() != null) {
            return false;
        }
        if (this.getShareDurableSubscriptions() == null && jmsJcaManagedConnectionFactoryImpl.getShareDurableSubscriptions() != null) {
            return false;
        }
        if (this.getSubscriptionProtocol() == null && jmsJcaManagedConnectionFactoryImpl.getSubscriptionProtocol() != null) {
            return false;
        }
        if (this.getMulticastInterface() == null && jmsJcaManagedConnectionFactoryImpl.getMulticastInterface() != null) {
            return false;
        }
        boolean bl = true;
        if (this.getBusName() != null && bl) {
            bl = this.getBusName().equals(jmsJcaManagedConnectionFactoryImpl.getBusName());
        }
        if (this.getClientID() != null && bl) {
            bl = this.getClientID().equals(jmsJcaManagedConnectionFactoryImpl.getClientID());
        }
        if (this.getUserName() != null && bl) {
            bl = this.getUserName().equals(jmsJcaManagedConnectionFactoryImpl.getUserName());
        }
        if (this.getPassword() != null && bl) {
            bl = this.getPassword().equals(jmsJcaManagedConnectionFactoryImpl.getPassword());
        }
        if (this.getXARecoveryAlias() != null && bl) {
            bl = this.getXARecoveryAlias().equals(jmsJcaManagedConnectionFactoryImpl.getXARecoveryAlias());
        }
        if (this.getNonPersistentMapping() != null && bl) {
            bl = this.getNonPersistentMapping().equals(jmsJcaManagedConnectionFactoryImpl.getNonPersistentMapping());
        }
        if (this.getPersistentMapping() != null && bl) {
            bl = this.getPersistentMapping().equals(jmsJcaManagedConnectionFactoryImpl.getPersistentMapping());
        }
        if (this.getDurableSubscriptionHome() != null && bl) {
            bl = this.getDurableSubscriptionHome().equals(jmsJcaManagedConnectionFactoryImpl.getDurableSubscriptionHome());
        }
        if (this.getReadAhead() != null && bl) {
            bl = this.getReadAhead().equals(jmsJcaManagedConnectionFactoryImpl.getReadAhead());
        }
        if (this.getTemporaryQueueNamePrefix() != null && bl) {
            bl = this.getTemporaryQueueNamePrefix().equals(jmsJcaManagedConnectionFactoryImpl.getTemporaryQueueNamePrefix());
        }
        if (this.getTemporaryTopicNamePrefix() != null && bl) {
            bl = this.getTemporaryTopicNamePrefix().equals(jmsJcaManagedConnectionFactoryImpl.getTemporaryTopicNamePrefix());
        }
        if (this.getTarget() != null && bl) {
            bl = this.getTarget().equals(jmsJcaManagedConnectionFactoryImpl.getTarget());
        }
        if (this.getTargetType() != null && bl) {
            bl = this.getTargetType().equals(jmsJcaManagedConnectionFactoryImpl.getTargetType());
        }
        if (this.getTargetSignificance() != null && bl) {
            bl = this.getTargetSignificance().equals(jmsJcaManagedConnectionFactoryImpl.getTargetSignificance());
        }
        if (this.getTargetTransportChain() != null && bl) {
            bl = this.getTargetTransportChain().equals(jmsJcaManagedConnectionFactoryImpl.getTargetTransportChain());
        }
        if (this.getProviderEndpoints() != null && bl) {
            bl = this.getProviderEndpoints().equals(jmsJcaManagedConnectionFactoryImpl.getProviderEndpoints());
        }
        if (this.getConnectionProximity() != null && bl) {
            bl = this.getConnectionProximity().equals(jmsJcaManagedConnectionFactoryImpl.getConnectionProximity());
        }
        if (this.getShareDataSourceWithCMP() != null && bl) {
            bl = this.getShareDataSourceWithCMP().equals(jmsJcaManagedConnectionFactoryImpl.getShareDataSourceWithCMP());
        }
        if (this.getShareDurableSubscriptions() != null && bl) {
            bl = this.getShareDurableSubscriptions().equals(jmsJcaManagedConnectionFactoryImpl.getShareDurableSubscriptions());
        }
        if (this.getSubscriptionProtocol() != null && bl) {
            bl = this.getSubscriptionProtocol().equals(jmsJcaManagedConnectionFactoryImpl.getSubscriptionProtocol());
        }
        if (this.getMulticastInterface() != null && bl) {
            bl = this.getMulticastInterface().equals(jmsJcaManagedConnectionFactoryImpl.getMulticastInterface());
        }
        return bl;
    }

    public final void setClientID(String string) {
        this._properties.put("clientID", string);
    }

    public final String getClientID() {
        return (String)this._properties.get("clientID");
    }

    public final void setBusName(String string) {
        this._properties.put("busName", string);
    }

    public final String getBusName() {
        return (String)this._properties.get("busName");
    }

    public final void setPassword(String string) {
        this._properties.put("password", string);
    }

    public final String getPassword() {
        return (String)this._properties.get("password");
    }

    public final void setUserName(String string) {
        this._properties.put("userName", string);
    }

    public final String getUserName() {
        return (String)this._properties.get("userName");
    }

    public String getDurableSubscriptionHome() {
        return (String)this._properties.get("durableSubscriptionHome");
    }

    public void setDurableSubscriptionHome(String string) {
        this._properties.put("durableSubscriptionHome", string);
    }

    public String getReadAhead() {
        return (String)this._properties.get("readAhead");
    }

    public void setReadAhead(String string) {
        this._properties.put("readAhead", string);
    }

    public String getTemporaryQueueNamePrefix() {
        return (String)this._properties.get("tempQueueNamePrefix");
    }

    public void setTemporaryQueueNamePrefix(String string) throws JMSException {
        if (string != null && string.length() > 12) {
            JMSException jMSException = new JMSException(NLS.getFormattedMessage("DESTINATION_PREFIX_LONG_CWSJR1025", new Object[]{string}, null));
            if (TRACE.isEntryEnabled()) {
                SibTr.exception((Object)this, TRACE, (Exception)((Object)jMSException));
            }
            throw jMSException;
        }
        this._properties.put("tempQueueNamePrefix", string);
    }

    public String getTemporaryTopicNamePrefix() {
        return (String)this._properties.get("tempTopicNamePrefix");
    }

    public void setTemporaryTopicNamePrefix(String string) throws JMSException {
        if (string != null && string.length() > 12) {
            JMSException jMSException = new JMSException(NLS.getFormattedMessage("DESTINATION_PREFIX_LONG_CWSJR1029", new Object[]{string}, null));
            if (TRACE.isEntryEnabled()) {
                SibTr.exception((Object)this, TRACE, (Exception)((Object)jMSException));
            }
            throw jMSException;
        }
        this._properties.put("tempTopicNamePrefix", string);
    }

    public String getNonPersistentMapping() {
        return (String)this._properties.get("nonPersistentMapping");
    }

    public void setNonPersistentMapping(String string) {
        this._properties.put("nonPersistentMapping", string);
    }

    public String getPersistentMapping() {
        return (String)this._properties.get("persistentMapping");
    }

    public void setPersistentMapping(String string) {
        this._properties.put("persistentMapping", string);
    }

    public String getTarget() {
        return (String)this._properties.get("targetGroup");
    }

    public void setTarget(String string) {
        this._properties.put("targetGroup", string);
    }

    public String getTargetType() {
        return (String)this._properties.get("targetType");
    }

    public void setTargetType(String string) {
        this._properties.put("targetType", string);
    }

    public String getTargetSignificance() {
        return (String)this._properties.get("targetSignificance");
    }

    public void setTargetSignificance(String string) {
        this._properties.put("targetSignificance", string);
    }

    public String getTargetTransportChain() {
        return (String)this._properties.get("targetTransportChain");
    }

    public void setTargetTransportChain(String string) {
        this._properties.put("targetTransportChain", string);
    }

    public String getProviderEndpoints() {
        return (String)this._properties.get("providerEndpoints");
    }

    public void setProviderEndpoints(String string) {
        this._properties.put("providerEndpoints", string);
    }

    public Boolean getShareDataSourceWithCMP() {
        return (Boolean)this._properties.get("shareDataSourceWithCMP");
    }

    public void setShareDataSourceWithCMP(Boolean bl) {
        this._properties.put("shareDataSourceWithCMP", bl);
    }

    public String getConnectionProximity() {
        return (String)this._properties.get("connectionProximity");
    }

    public void setConnectionProximity(String string) {
        this._properties.put("connectionProximity", string);
    }

    String getXARecoveryAlias() {
        return (String)this._properties.get("xaRecoveryAlias");
    }

    public void setXARecoveryAlias(String string) {
        this._properties.put("xaRecoveryAlias", string);
    }

    public String getShareDurableSubscriptions() {
        return (String)this._properties.get("shareDurableSubs");
    }

    public void setShareDurableSubscriptions(String string) {
        this._properties.put("shareDurableSubs", string);
    }

    public String getSubscriptionProtocol() {
        return (String)this._properties.get("subscriptionProtocol");
    }

    public void setSubscriptionProtocol(String string) {
        this._properties.put("subscriptionProtocol", string);
    }

    public String getMulticastInterface() {
        return (String)this._properties.get("multicastInterface");
    }

    public void setMulticastInterface(String string) {
        this._properties.put("multicastInterface", string);
    }

    JmsJcaUserDetails getUserDetails(final Subject subject, ConnectionRequestInfo connectionRequestInfo) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getUserDetails", new Object[]{JmsJcaManagedConnection.subjectToString(subject), connectionRequestInfo});
        }
        JmsJcaUserDetails jmsJcaUserDetails = null;
        if (subject == null) {
            String string = null;
            String string2 = null;
            if (connectionRequestInfo instanceof JmsJcaConnectionRequestInfo) {
                JmsJcaConnectionRequestInfo jmsJcaConnectionRequestInfo = (JmsJcaConnectionRequestInfo)connectionRequestInfo;
                jmsJcaUserDetails = jmsJcaConnectionRequestInfo.getUserDetails();
            }
            if (jmsJcaUserDetails == null) {
                string = this.getUserName();
                string2 = this.getPassword();
                jmsJcaUserDetails = new JmsJcaUserDetails(string, string2);
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug(this, TRACE, "Using default credentials from managed connection factory");
                }
            } else if (TRACE.isDebugEnabled()) {
                SibTr.debug(this, TRACE, "Using credentials passed by application");
            }
        } else {
            PasswordCredential passwordCredential = (PasswordCredential)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Set set = subject.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential == null ? (class$javax$resource$spi$security$PasswordCredential = JmsJcaManagedConnectionFactoryImpl.class$("javax.resource.spi.security.PasswordCredential")) : class$javax$resource$spi$security$PasswordCredential);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        PasswordCredential passwordCredential;
                        Object t = iterator.next();
                        if (!(t instanceof PasswordCredential) || !JmsJcaManagedConnectionFactoryImpl.this.equals((passwordCredential = (PasswordCredential)t).getManagedConnectionFactory())) continue;
                        return passwordCredential;
                    }
                    return null;
                }
            });
            if (passwordCredential == null) {
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug(this, TRACE, "No PasswordCredential in Subject - using Subject for authentication");
                }
            } else {
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug(TRACE, "Using PasswordCredential from Subject");
                }
                jmsJcaUserDetails = new JmsJcaUserDetails(passwordCredential.getUserName(), String.valueOf(passwordCredential.getPassword()));
            }
        }
        if (TRACE.isDebugEnabled() && jmsJcaUserDetails != null) {
            SibTr.debug(this, TRACE, "Credential contains userName", jmsJcaUserDetails.getUserName());
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getUserDetails", jmsJcaUserDetails);
        }
        return jmsJcaUserDetails;
    }

    Map getTrmProperties() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getTrmProperties");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string9 = this.getBusName();
        if (string9 != null && !string9.equals("")) {
            hashMap.put("busName", string9);
        }
        if ((string8 = this.getTarget()) != null && !string8.equals("")) {
            hashMap.put("targetGroup", string8);
        }
        if ((string7 = this.getTargetType()) != null && !string7.equals("")) {
            hashMap.put("targetType", string7);
        }
        if ((string6 = this.getTargetSignificance()) != null && !string6.equals("")) {
            hashMap.put("targetSignificance", string6);
        }
        if ((string5 = this.getTargetTransportChain()) != null && !string5.equals("")) {
            hashMap.put("targetTransportChain", string5);
        }
        if ((string4 = this.getProviderEndpoints()) != null && !string4.equals("")) {
            hashMap.put("providerEndpoints", string4);
        }
        if ((string3 = this.getConnectionProximity()) != null && !string3.equals("")) {
            hashMap.put("connectionProximity", string3);
        }
        if ((string2 = this.getSubscriptionProtocol()) != null && !string2.equals("")) {
            hashMap.put("subscriptionProtocol", string2);
        }
        if ((string = this.getMulticastInterface()) != null && !string.equals("")) {
            hashMap.put("multicastInterface", string);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getTrmProperties", hashMap);
        }
        return hashMap;
    }

    private JmsRAFactoryFactory getJmsRAFactoryFactory() throws ResourceException {
        if (this._jmsFactoryFactory == null) {
            try {
                JmsFactoryFactory jmsFactoryFactory = JmsFactoryFactory.getInstance();
                if (!(jmsFactoryFactory instanceof JmsRAFactoryFactory)) {
                    throw new ResourceAdapterInternalException(NLS.getFormattedMessage("JMS_CONNECTION_FAIL_CWSJR1024", new Object[]{"getJmsRAFactoryFactory", JmsRAFactoryFactory.class.getName(), jmsFactoryFactory == null ? "null" : jmsFactoryFactory.getClass().getName()}, null));
                }
                this._jmsFactoryFactory = (JmsRAFactoryFactory)((Object)jmsFactoryFactory);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)(CLASS_NAME + ".getJmsRAFactoryFactory"), (String)FFDC_PROBE_5, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, TRACE, (Exception)((Object)jMSException));
                }
                throw new ResourceException((Throwable)jMSException);
            }
        }
        return this._jmsFactoryFactory;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("@");
        stringBuffer.append(System.identityHashCode(this));
        stringBuffer.append(" <logWriter=");
        stringBuffer.append(this._logWriter);
        stringBuffer.append("> <busName=");
        stringBuffer.append(this.getBusName());
        stringBuffer.append("> <clientID=");
        stringBuffer.append(this.getClientID());
        stringBuffer.append("> <userName=");
        stringBuffer.append(this.getUserName());
        stringBuffer.append("> <password=");
        stringBuffer.append(this.getPassword() == null ? null : "*****");
        stringBuffer.append("> <xaRecoveryAlias=");
        stringBuffer.append(this.getXARecoveryAlias());
        stringBuffer.append("> <nonPersistentMapping=");
        stringBuffer.append(this.getNonPersistentMapping());
        stringBuffer.append("> <persistentMapping=");
        stringBuffer.append(this.getPersistentMapping());
        stringBuffer.append("> <durableSubscriptionHome=");
        stringBuffer.append(this.getDurableSubscriptionHome());
        stringBuffer.append("> <readAhead=");
        stringBuffer.append(this.getReadAhead());
        stringBuffer.append("> <temporaryQueueNamePrefix=");
        stringBuffer.append(this.getTemporaryQueueNamePrefix());
        stringBuffer.append("> <temporaryTopicNamePrefix=");
        stringBuffer.append(this.getTemporaryTopicNamePrefix());
        stringBuffer.append("> <target=");
        stringBuffer.append(this.getTarget());
        stringBuffer.append("> <targetSignificance=");
        stringBuffer.append(this.getTargetSignificance());
        stringBuffer.append("> <targetTransportChain=");
        stringBuffer.append(this.getTargetTransportChain());
        stringBuffer.append("> <targetType=");
        stringBuffer.append(this.getTargetType());
        stringBuffer.append("> <providerEndpoints=");
        stringBuffer.append(this.getProviderEndpoints());
        stringBuffer.append("> <connectionProximity=");
        stringBuffer.append(this.getConnectionProximity());
        stringBuffer.append("> <shareDataSourceWithCMP=");
        stringBuffer.append(this.getShareDataSourceWithCMP());
        stringBuffer.append("> <shareDurableSubscriptions=");
        stringBuffer.append(this.getShareDurableSubscriptions());
        stringBuffer.append("> <cachedFactory=");
        stringBuffer.append(this._jmsFactoryFactory);
        stringBuffer.append(">]");
        return stringBuffer.toString();
    }

    String getConnectionType() {
        return CONN_FACTORY_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Reference getReference() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getReference");
        }
        Reference reference = new Reference(this.getConnectionType(), this.getClass().getName(), null);
        Map map = this._properties;
        synchronized (map) {
            Map map2 = JmsJcaReferenceUtils.getInstance().getStringEncodedMap(this._properties);
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                reference.add(new StringRefAddr(string, string2));
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(TRACE, "getReference", reference);
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReference(Reference reference) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "setReference", reference);
        }
        Map map = this._properties;
        synchronized (map) {
            this._properties = JmsJcaReferenceUtils.getInstance().getMapFromReference(reference);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "setReference");
        }
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        JmsConnectionFactory jmsConnectionFactory = null;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getObjectInstance", new Object[]{object, name, context, hashtable});
        }
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            String string = reference.getClassName();
            if (TRACE.isDebugEnabled()) {
                SibTr.debug(this, TRACE, "class name is " + string);
            }
            if (CONN_FACTORY_TYPE.equals(string) || "javax.jms.QueueConnectionFactory".equals(string) || "javax.jms.TopicConnectionFactory".equals(string)) {
                try {
                    jmsConnectionFactory = (JmsConnectionFactory)this.createConnectionFactory();
                    jmsConnectionFactory.setReference(reference);
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + "getObjectInstance"), (String)FFDC_PROBE_6, (Object)this);
                    throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1027", new Object[]{resourceException, "getObjectInstance"}, null), (Throwable)resourceException);
                }
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getObjectInstance", jmsConnectionFactory);
        }
        return jmsConnectionFactory;
    }

    ConnectionFactory createJmsConnFactory(JmsRAFactoryFactory jmsRAFactoryFactory, JmsJcaConnectionFactoryImpl jmsJcaConnectionFactoryImpl) {
        return jmsRAFactoryFactory.createConnectionFactory(jmsJcaConnectionFactoryImpl);
    }

    ConnectionFactory createJmsConnFactory(JmsRAFactoryFactory jmsRAFactoryFactory, JmsJcaConnectionFactoryImpl jmsJcaConnectionFactoryImpl, JmsJcaManagedConnectionFactory jmsJcaManagedConnectionFactory) {
        return jmsRAFactoryFactory.createConnectionFactory(jmsJcaConnectionFactoryImpl, jmsJcaManagedConnectionFactory);
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug(TRACE, "Source info: @(#)SIB/ws/code/sib.api.jmsra.outbound.impl/src/com/ibm/ws/sib/api/jmsra/impl/JmsJcaManagedConnectionFactoryImpl.java, SIB.api.jmsra, WAS602.SIB, o0610.11 1.100");
        }
    }
}

