/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnectionFactoryImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaRecoverableSiXaResource;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaSessionImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaUserDetails;
import com.ibm.ws.sib.ra.SibRaEngineComponent;
import com.ibm.ws.sib.ra.recovery.SibRaRecoveryManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class JmsJcaManagedConnection
implements ManagedConnection,
LazyEnlistableManagedConnection,
DissociatableManagedConnection {
    private final JmsJcaManagedConnectionFactoryImpl _managedConnectionFactory;
    protected final SICoreConnection _coreConnection;
    protected final JmsJcaConnectionListener _connectionListener;
    private final JmsJcaUserDetails _userDetails;
    private final Subject _subject;
    private final Set _sessions = new HashSet();
    private final List _connectionListeners = new ArrayList();
    private JmsJcaLocalTransaction _localTransaction;
    private SIXAResource _xaResource;
    private JmsJcaManagedConnectionMetaData _metaData;
    private Exception _connectionException;
    private PrintWriter _logWriter;
    private static TraceComponent TRACE = SibTr.register(JmsJcaManagedConnection.class, "SIBJmsRa", "com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceComponent LOCAL_TRANSACTION_TRACE = SibTr.register(JmsJcaLocalTransaction.class, "SIBJmsRa", "com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceComponent LISTENER_TRACE = SibTr.register(JmsJcaConnectionListener.class, "SIBJmsRa", "com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String FFDC_PROBE_7 = "7";
    private static final String FFDC_PROBE_8 = "8";
    private static final String FFDC_PROBE_9 = "9";
    private static final String FFDC_PROBE_10 = "10";
    private static final String FFDC_PROBE_11 = "11";
    private static final String FFDC_PROBE_12 = "12";
    private static final String FFDC_PROBE_13 = "13";
    private static final String FFDC_PROBE_16 = "16";
    private static final String FFDC_PROBE_17 = "17";
    private static final String FFDC_PROBE_18 = "18";
    private static final String FFDC_PROBE_19 = "19";
    private static final String FFDC_PROBE_21 = "21";
    private static final String FFDC_PROBE_22 = "22";
    private static final String FFDC_PROBE_23 = "23";
    private static final String FFDC_PROBE_24 = "24";
    private static final String CLASS_NAME = JmsJcaManagedConnection.class.getName();

    JmsJcaManagedConnection(JmsJcaManagedConnectionFactoryImpl jmsJcaManagedConnectionFactoryImpl, SICoreConnection sICoreConnection, JmsJcaUserDetails jmsJcaUserDetails, Subject subject) throws SIConnectionDroppedException, SIConnectionUnavailableException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "JmsJcaManagedConnection", new Object[]{jmsJcaManagedConnectionFactoryImpl, sICoreConnection, jmsJcaUserDetails, JmsJcaManagedConnection.subjectToString(subject)});
        }
        this._managedConnectionFactory = jmsJcaManagedConnectionFactoryImpl;
        this._coreConnection = sICoreConnection;
        this._userDetails = jmsJcaUserDetails;
        this._subject = subject;
        this._connectionListener = new JmsJcaConnectionListener();
        this._coreConnection.addConnectionListener(this._connectionListener);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "JmsJcaManagedConnection");
        }
    }

    public final Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getConnection", new Object[]{JmsJcaManagedConnection.subjectToString(subject), connectionRequestInfo});
        }
        JmsJcaUserDetails jmsJcaUserDetails = this._managedConnectionFactory.getUserDetails(subject, connectionRequestInfo);
        if (this._userDetails != null) {
            if (!this._userDetails.equals(jmsJcaUserDetails)) {
                throw new ResourceException(NLS.getFormattedMessage("AUTHENTICATION_ERROR_CWSJR1103", new Object[]{"JmsJcaManagedConnection.getConnection", this._userDetails.getUserName(), jmsJcaUserDetails == null ? null : jmsJcaUserDetails.getUserName()}, null));
            }
        } else if (!this._subject.equals(subject)) {
            throw new ResourceException(NLS.getFormattedMessage("AUTHENTICATION_ERROR_CWSJR1117", new Object[]{"JmsJcaManagedConnection.getConnection"}, null));
        }
        JmsJcaSessionImpl jmsJcaSessionImpl = null;
        if (connectionRequestInfo instanceof JmsJcaConnectionRequestInfo) {
            JmsJcaConnectionRequestInfo jmsJcaConnectionRequestInfo = (JmsJcaConnectionRequestInfo)connectionRequestInfo;
            if (jmsJcaConnectionRequestInfo.getSICoreConnection() == null) {
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug(this, TRACE, "SICoreConnection not set in request information - setting it now");
                }
                try {
                    this._connectionException = null;
                    jmsJcaConnectionRequestInfo.setSICoreConnection(this._coreConnection.cloneConnection());
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "getConnection"), (String)FFDC_PROBE_5, (Object)this);
                    this.connectionErrorOccurred(sIException, true);
                    this._connectionException = sIException;
                }
                catch (SIErrorException sIErrorException) {
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "getConnection"), (String)FFDC_PROBE_6, (Object)this);
                    this.connectionErrorOccurred(sIErrorException, true);
                    this._connectionException = sIErrorException;
                }
            }
            if (jmsJcaConnectionRequestInfo.getSICoreConnection() != null) {
                jmsJcaSessionImpl = new JmsJcaSessionImpl(this, jmsJcaConnectionRequestInfo);
                this._sessions.add(jmsJcaSessionImpl);
            } else {
                jmsJcaSessionImpl = new JmsJcaSessionImpl(this, jmsJcaConnectionRequestInfo);
            }
        } else {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1101", new Object[]{"getConnection", JmsJcaConnectionRequestInfo.class.getName(), connectionRequestInfo.getClass().getName()}, null));
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getConnection", jmsJcaSessionImpl);
        }
        return jmsJcaSessionImpl;
    }

    public final void destroy() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "destroy");
        }
        Iterator iterator = this._sessions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JmsJcaSessionImpl)) continue;
            JmsJcaSessionImpl jmsJcaSessionImpl = (JmsJcaSessionImpl)e;
            jmsJcaSessionImpl.invalidate();
        }
        this._sessions.clear();
        try {
            this._coreConnection.removeConnectionListener(this._connectionListener);
            this._coreConnection.close();
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "destroy"), (String)FFDC_PROBE_7, (Object)this);
            throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1110", new Object[]{sIException, "createManagedConnection"}, null), (Throwable)sIException);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "destroy"), (String)FFDC_PROBE_8, (Object)this);
            throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1110", new Object[]{sIErrorException, "createManagedConnection"}, null), (Throwable)sIErrorException);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "destroy");
        }
    }

    public final void cleanup() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "cleanup");
        }
        Iterator iterator = this._sessions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JmsJcaSessionImpl)) continue;
            ((JmsJcaSessionImpl)e).invalidate();
        }
        this._sessions.clear();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "cleanup");
        }
    }

    public final void associateConnection(Object object) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "associateConnection", object);
        }
        if (!(object instanceof JmsJcaSessionImpl)) {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("INVALID_SESSION_CWSJR1104", new Object[]{"associateConnection", JmsJcaSessionImpl.class.getName(), object == null ? "null" : object.getClass().getName()}, null));
        }
        JmsJcaSessionImpl jmsJcaSessionImpl = (JmsJcaSessionImpl)object;
        jmsJcaSessionImpl.associate(this);
        this._sessions.add(jmsJcaSessionImpl);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "associateConnection");
        }
    }

    final void disassociateSession(JmsJcaSessionImpl jmsJcaSessionImpl) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "disassociateSession", jmsJcaSessionImpl);
        }
        this._sessions.remove(jmsJcaSessionImpl);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "disassociateSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "addConnectionEventListener", connectionEventListener);
        }
        List list = this._connectionListeners;
        synchronized (list) {
            this._connectionListeners.add(connectionEventListener);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "addConnectionEventListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "removeConnectionEventListener", connectionEventListener);
        }
        List list = this._connectionListeners;
        synchronized (list) {
            this._connectionListeners.remove(connectionEventListener);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "removeConnectionEventListener");
        }
    }

    public final XAResource getXAResource() throws ResourceException {
        block9: {
            if (TRACE.isEntryEnabled()) {
                SibTr.entry(this, TRACE, "getXAResource");
            }
            if (this._coreConnection == null) {
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1106", new Object[]{"getXAResource"}, null));
            }
            if (this._xaResource == null) {
                try {
                    if (SibRaRecoveryManager.isAvailable()) {
                        this._xaResource = new JmsJcaRecoverableSiXaResource(this._coreConnection.getSIXAResource(), this._managedConnectionFactory.getBusName(), this._coreConnection.getMeName(), this._coreConnection.getMeUuid(), this._managedConnectionFactory.getXARecoveryAlias(), this._managedConnectionFactory.getUserName(), this._managedConnectionFactory.getPassword());
                        break block9;
                    }
                    if ("ME".equals(this._managedConnectionFactory.getTargetType()) && this._managedConnectionFactory.getTarget() != null) {
                        this._xaResource = this._coreConnection.getSIXAResource();
                        break block9;
                    }
                    throw new NotSupportedException(NLS.getFormattedMessage("ME_NAME_REQUIRED_CWSJR1108", null, null));
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "getXAResource"), (String)FFDC_PROBE_9, (Object)this);
                    throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1111", new Object[]{sIException, "getXAResource"}, null), (Throwable)sIException);
                }
                catch (SIErrorException sIErrorException) {
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "getXAResource"), (String)FFDC_PROBE_11, (Object)this);
                    throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1111", new Object[]{sIErrorException, "getXAResource"}, null), (Throwable)sIErrorException);
                }
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getXAResource", this._xaResource);
        }
        return this._xaResource;
    }

    public final LocalTransaction getLocalTransaction() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getLocalTransaction");
        }
        if (this._coreConnection == null) {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1107", new Object[]{"getLocalTransaction"}, null));
        }
        if (this._localTransaction == null) {
            this._localTransaction = new JmsJcaLocalTransaction();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getLocalTransaction", this._localTransaction);
        }
        return this._localTransaction;
    }

    public final ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getMetaData");
        }
        if (this._metaData == null) {
            this._metaData = new JmsJcaManagedConnectionMetaData();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getMetaData", this._metaData);
        }
        return this._metaData;
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this._logWriter = printWriter;
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        if (this._logWriter == null) {
            return this._managedConnectionFactory.getLogWriter();
        }
        return this._logWriter;
    }

    public final void dissociateConnections() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(TRACE, "dissociateConnections");
        }
        Iterator iterator = this._sessions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JmsJcaSessionImpl)) continue;
            ((JmsJcaSessionImpl)e).dissociate();
            iterator.remove();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "dissociateConnections");
        }
    }

    final SITransaction getCurrentTransaction(ConnectionManager connectionManager) throws ResourceException {
        SITransaction sITransaction;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getCurrentTransaction", connectionManager);
        }
        if ((sITransaction = this.getActiveTransaction()) == null && connectionManager instanceof LazyEnlistableConnectionManager) {
            if (TRACE.isDebugEnabled()) {
                SibTr.debug(this, TRACE, "Lazy enlisting on the connection manager");
            }
            try {
                ((LazyEnlistableConnectionManager)connectionManager).lazyEnlist((ManagedConnection)this);
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + "getCurrentTransaction"), (String)FFDC_PROBE_10, (Object)this);
                SibTr.error(TRACE, "EXCEPTION_RECEIVED_CWSJR1102", (Object)resourceException);
                throw resourceException;
            }
            sITransaction = this.getActiveTransaction();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getCurrentTransaction", sITransaction);
        }
        return sITransaction;
    }

    protected SITransaction getActiveTransaction() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "getActiveTransaction");
        }
        SITransaction sITransaction = null;
        if (this._xaResource != null && this._xaResource.isEnlisted()) {
            if (TRACE.isDebugEnabled()) {
                SibTr.debug(this, TRACE, "Current transaction is an XA global transaction");
            }
            sITransaction = this._xaResource instanceof JmsJcaRecoverableSiXaResource ? ((JmsJcaRecoverableSiXaResource)this._xaResource).getSiXaResource() : this._xaResource;
        } else if (this._localTransaction != null && this._localTransaction.getLocalSITransaction() != null) {
            if (TRACE.isDebugEnabled()) {
                SibTr.debug(TRACE, "Current transaction is a container-managed local transaction");
            }
            sITransaction = this._localTransaction.getLocalSITransaction();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "getActiveTransaction", sITransaction);
        }
        return sITransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void localTransactionStarted() {
        ArrayList arrayList;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "localTransactionStarted");
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 2);
        Object object = this._connectionListeners;
        synchronized (object) {
            arrayList = new ArrayList(this._connectionListeners);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (!(e instanceof ConnectionEventListener)) continue;
            ((ConnectionEventListener)e).localTransactionStarted(connectionEvent);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "localTransactionStarted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void localTransactionCommitted() {
        ArrayList arrayList;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "localTransactionCommited");
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 3);
        Object object = this._connectionListeners;
        synchronized (object) {
            arrayList = new ArrayList(this._connectionListeners);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (!(e instanceof ConnectionEventListener)) continue;
            ((ConnectionEventListener)e).localTransactionCommitted(connectionEvent);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "localTransactionCommitted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void localTransactionRolledBack() {
        ArrayList arrayList;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "localTransactionCommited");
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 4);
        Object object = this._connectionListeners;
        synchronized (object) {
            arrayList = new ArrayList(this._connectionListeners);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (!(e instanceof ConnectionEventListener)) continue;
            ((ConnectionEventListener)e).localTransactionRolledback(connectionEvent);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "localTransactionRolledBack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sessionClosed(JmsJcaSessionImpl jmsJcaSessionImpl) {
        ArrayList arrayList;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "sessionClosed", jmsJcaSessionImpl);
        }
        if (TRACE.isDebugEnabled()) {
            SibTr.debug(this, TRACE, "Sending connection closed events to the " + this._connectionListeners.size() + " listeners");
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 1);
        connectionEvent.setConnectionHandle((Object)jmsJcaSessionImpl);
        Object object = this._connectionListeners;
        synchronized (object) {
            arrayList = new ArrayList(this._connectionListeners);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (!(e instanceof ConnectionEventListener)) continue;
            ((ConnectionEventListener)e).connectionClosed(connectionEvent);
        }
        this._sessions.remove(jmsJcaSessionImpl);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "sessionClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void connectionErrorOccurred(Exception exception, boolean bl) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "connectionErrorOccurred");
        }
        if (!SibRaEngineComponent.isServerStopping()) {
            ArrayList arrayList;
            ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 5, exception);
            Object object = this._connectionListeners;
            synchronized (object) {
                arrayList = new ArrayList(this._connectionListeners);
            }
            if (bl) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    if (!(e instanceof ConnectionEventListener)) continue;
                    ((ConnectionEventListener)e).connectionErrorOccurred(connectionEvent);
                }
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "connectionErrorOccurred");
        }
    }

    final boolean match(Subject subject, SICoreConnection sICoreConnection) {
        boolean bl = this._subject == null ? subject == null : this._subject.equals(subject);
        boolean bl2 = sICoreConnection == null || sICoreConnection.isEquivalentTo(this._coreConnection);
        return bl && bl2;
    }

    final boolean match(JmsJcaUserDetails jmsJcaUserDetails, SICoreConnection sICoreConnection) {
        boolean bl = this._userDetails == null ? jmsJcaUserDetails == null : this._userDetails.equals(jmsJcaUserDetails);
        boolean bl2 = sICoreConnection == null || sICoreConnection.isEquivalentTo(this._coreConnection);
        return bl && bl2;
    }

    final SICoreConnection getCoreConnection() {
        return this._coreConnection;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("@");
        stringBuffer.append(System.identityHashCode(this));
        stringBuffer.append(" ");
        this.toStringFields(stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void toStringFields(StringBuffer stringBuffer) {
        stringBuffer.append("<managedConnectionFactory=");
        stringBuffer.append(this._managedConnectionFactory);
        stringBuffer.append("> <coreConnection=");
        stringBuffer.append(this._coreConnection);
        stringBuffer.append("> <localTransaction=");
        stringBuffer.append(this._localTransaction);
        stringBuffer.append("> <xaResource=");
        stringBuffer.append(this._xaResource);
        stringBuffer.append("> <metaData=");
        stringBuffer.append(this._metaData);
        stringBuffer.append("> <userDetails=");
        stringBuffer.append(this._userDetails);
        stringBuffer.append("> <subject=");
        stringBuffer.append(JmsJcaManagedConnection.subjectToString(this._subject));
        stringBuffer.append("> <logWriter=");
        stringBuffer.append(this._logWriter);
        stringBuffer.append("> <sessions=");
        stringBuffer.append(this._sessions);
        stringBuffer.append("> <connectionListeners=");
        stringBuffer.append(this._connectionListeners);
        stringBuffer.append(">");
    }

    public static String subjectToString(Subject subject) {
        String string;
        if (subject == null) {
            string = "null";
        } else {
            StringBuffer stringBuffer = new StringBuffer("[");
            stringBuffer.append(subject.getClass().getName());
            stringBuffer.append("@");
            stringBuffer.append(Integer.toHexString(System.identityHashCode(subject)));
            stringBuffer.append(" <principals=");
            stringBuffer.append(subject.getPrincipals());
            stringBuffer.append(">]");
            string = stringBuffer.toString();
        }
        return string;
    }

    public Exception getConnectionException() {
        return this._connectionException;
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug(TRACE, "Source info: @(#)SIB/ws/code/sib.api.jmsra.outbound.impl/src/com/ibm/ws/sib/api/jmsra/impl/JmsJcaManagedConnection.java, SIB.api.jmsra, WAS602.SIB, o0610.11 1.60.1.2");
        }
    }

    private final class JmsJcaConnectionListener
    implements SICoreConnectionListener {
        private JmsJcaConnectionListener() {
        }

        public void asynchronousException(ConsumerSession consumerSession, Throwable throwable) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry(this, LISTENER_TRACE, "asynchronousException", new Object[]{consumerSession, throwable});
                SibTr.exit(this, LISTENER_TRACE, "asynchronousException");
            }
        }

        public void meQuiescing(SICoreConnection sICoreConnection) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry(this, LISTENER_TRACE, "meQuiescing", sICoreConnection);
                SibTr.exit(this, LISTENER_TRACE, "meQuiescing");
            }
        }

        public void commsFailure(SICoreConnection sICoreConnection, SIConnectionLostException sIConnectionLostException) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry(this, LISTENER_TRACE, "commsFailure", new Object[]{sICoreConnection, sIConnectionLostException});
            }
            JmsJcaManagedConnection.this.connectionErrorOccurred(sIConnectionLostException, false);
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit(this, LISTENER_TRACE, "commsFailure");
            }
        }

        public void meTerminated(SICoreConnection sICoreConnection) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry(this, LISTENER_TRACE, "meTerminated", sICoreConnection);
            }
            JmsJcaManagedConnection.this.connectionErrorOccurred(null, false);
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit(this, LISTENER_TRACE, "meTerminated");
            }
        }
    }

    private final class JmsJcaManagedConnectionMetaData
    implements ManagedConnectionMetaData {
        private JmsJcaManagedConnectionMetaData() {
        }

        public String getEISProductName() throws ResourceException {
            return "WebSphere JMS";
        }

        public String getEISProductVersion() throws ResourceException {
            return "1.0";
        }

        public int getMaxConnections() throws ResourceException {
            return 0;
        }

        public String getUserName() throws ResourceException {
            String string = null;
            if (JmsJcaManagedConnection.this._userDetails != null) {
                string = JmsJcaManagedConnection.this._userDetails.getUserName();
            }
            return string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[");
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("@");
            stringBuffer.append(System.identityHashCode(this));
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private final class JmsJcaLocalTransaction
    implements LocalTransaction {
        private SIUncoordinatedTransaction localSITransaction;

        private JmsJcaLocalTransaction() {
        }

        public void begin() throws LocalTransactionException {
            if (LOCAL_TRANSACTION_TRACE.isEntryEnabled()) {
                SibTr.entry(this, LOCAL_TRANSACTION_TRACE, "begin");
            }
            if (this.localSITransaction == null) {
                try {
                    this.localSITransaction = JmsJcaManagedConnection.this._coreConnection.createUncoordinatedTransaction();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + ".JmsJcaLocalTransaction.begin"), (String)JmsJcaManagedConnection.FFDC_PROBE_12, (Object)this);
                    throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1112", new Object[]{sIException, "begin"}, null), (Throwable)sIException);
                }
                catch (SIErrorException sIErrorException) {
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + ".JmsJcaLocalTransaction.begin"), (String)JmsJcaManagedConnection.FFDC_PROBE_13, (Object)this);
                    throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1112", new Object[]{sIErrorException, "begin"}, null), (Throwable)sIErrorException);
                }
            } else {
                throw new LocalTransactionException(NLS.getFormattedMessage("INVALID_SESSION_CWSJR1105", null, null));
            }
            if (LOCAL_TRANSACTION_TRACE.isEntryEnabled()) {
                SibTr.exit(this, LOCAL_TRANSACTION_TRACE, "begin");
            }
        }

        public void commit() throws LocalTransactionException {
            if (LOCAL_TRANSACTION_TRACE.isEntryEnabled()) {
                SibTr.entry(this, LOCAL_TRANSACTION_TRACE, "commit");
            }
            if (this.localSITransaction != null) {
                try {
                    this.localSITransaction.commit();
                    this.localSITransaction = null;
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "JmsJcaLocalTransaction.commit"), (String)JmsJcaManagedConnection.FFDC_PROBE_16, (Object)this);
                    throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1113", new Object[]{sIException, "commit"}, null), (Throwable)sIException);
                }
                catch (SIErrorException sIErrorException) {
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "JmsJcaLocalTransaction.commit"), (String)JmsJcaManagedConnection.FFDC_PROBE_18, (Object)this);
                    throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1113", new Object[]{sIErrorException, "commit"}, null), (Throwable)sIErrorException);
                }
            } else {
                Iterator iterator = JmsJcaManagedConnection.this._sessions.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof JmsJcaSessionImpl)) continue;
                    JmsJcaSessionImpl jmsJcaSessionImpl = (JmsJcaSessionImpl)e;
                    try {
                        jmsJcaSessionImpl.commitUnresolvedLocalTransaction();
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "JmsJcaLocalTransaction.commit"), (String)JmsJcaManagedConnection.FFDC_PROBE_17, (Object)this);
                        throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1114", new Object[]{sIException, "commit"}, null), (Throwable)sIException);
                    }
                    catch (SIErrorException sIErrorException) {
                        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "JmsJcaLocalTransaction.commit"), (String)JmsJcaManagedConnection.FFDC_PROBE_19, (Object)this);
                        throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1114", new Object[]{sIErrorException, "commit"}, null), (Throwable)sIErrorException);
                    }
                }
            }
            if (LOCAL_TRANSACTION_TRACE.isEntryEnabled()) {
                SibTr.exit(this, LOCAL_TRANSACTION_TRACE, "commit");
            }
        }

        public void rollback() throws LocalTransactionException {
            if (TRACE.isEntryEnabled()) {
                SibTr.entry(this, LOCAL_TRANSACTION_TRACE, "rollback");
            }
            if (this.localSITransaction != null) {
                try {
                    this.localSITransaction.rollback();
                    this.localSITransaction = null;
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "JmsJcaLocalTransaction.rollback"), (String)JmsJcaManagedConnection.FFDC_PROBE_21, (Object)this);
                    throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1115", new Object[]{sIException, "rollback"}, null), (Throwable)sIException);
                }
                catch (SIErrorException sIErrorException) {
                    FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "JmsJcaLocalTransaction.rollback"), (String)JmsJcaManagedConnection.FFDC_PROBE_23, (Object)this);
                    throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1115", new Object[]{sIErrorException, "rollback"}, null), (Throwable)sIErrorException);
                }
            } else {
                Iterator iterator = JmsJcaManagedConnection.this._sessions.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof JmsJcaSessionImpl)) continue;
                    JmsJcaSessionImpl jmsJcaSessionImpl = (JmsJcaSessionImpl)e;
                    try {
                        jmsJcaSessionImpl.rollbackUnresolvedLocalTransaction();
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "JmsJcaLocalTransaction.rollback"), (String)JmsJcaManagedConnection.FFDC_PROBE_22, (Object)this);
                        throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1116", new Object[]{sIException, "rollback"}, null), (Throwable)sIException);
                    }
                    catch (SIErrorException sIErrorException) {
                        FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "JmsJcaLocalTransaction.rollback"), (String)JmsJcaManagedConnection.FFDC_PROBE_24, (Object)this);
                        throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1116", new Object[]{sIErrorException, "rollback"}, null), (Throwable)sIErrorException);
                    }
                }
            }
            if (LOCAL_TRANSACTION_TRACE.isEntryEnabled()) {
                SibTr.exit(this, LOCAL_TRANSACTION_TRACE, "rollback");
            }
        }

        SITransaction getLocalSITransaction() {
            return this.localSITransaction;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[");
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("@");
            stringBuffer.append(System.identityHashCode(this));
            stringBuffer.append(" <localSITransaction=");
            stringBuffer.append(this.localSITransaction);
            stringBuffer.append(">]");
            return stringBuffer.toString();
        }
    }
}

