/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnection;
import com.ibm.ws.sib.api.jmsra.JmsJcaSession;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionFactoryImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaSessionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;

final class JmsJcaConnectionImpl
implements JmsJcaConnection {
    private final JmsJcaConnectionFactoryImpl _connectionFactory;
    private final SICoreConnection _coreConnection;
    private final Set _sessions = new HashSet();
    private final JmsJcaConnectionRequestInfo _requestInfo;
    private boolean firstSessionCached = true;
    private boolean connectionClosed = false;
    private static TraceComponent TRACE = SibTr.register(JmsJcaConnectionImpl.class, "SIBJmsRa", "com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static final String FFDC_PROBE_1 = "1";
    private static final String CLASS_NAME = JmsJcaConnectionImpl.class.getName();

    JmsJcaConnectionImpl(JmsJcaConnectionFactoryImpl jmsJcaConnectionFactoryImpl, SICoreConnection sICoreConnection, JmsJcaSessionImpl jmsJcaSessionImpl, String string, String string2) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "JmsJcaConnectionImpl", new Object[]{jmsJcaConnectionFactoryImpl, sICoreConnection, jmsJcaSessionImpl, string, "*****"});
        }
        this._connectionFactory = jmsJcaConnectionFactoryImpl;
        this._coreConnection = sICoreConnection;
        this._sessions.add(jmsJcaSessionImpl);
        jmsJcaSessionImpl.setParentConnection(this);
        this._requestInfo = new JmsJcaConnectionRequestInfo(sICoreConnection, string, string2);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "JmsJcaConnectionImpl");
        }
    }

    JmsJcaConnectionImpl(JmsJcaConnectionFactoryImpl jmsJcaConnectionFactoryImpl, SICoreConnection sICoreConnection, JmsJcaSessionImpl jmsJcaSessionImpl) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "JmsJcaConnectionImpl", new Object[]{jmsJcaConnectionFactoryImpl, sICoreConnection, jmsJcaSessionImpl});
        }
        this._connectionFactory = jmsJcaConnectionFactoryImpl;
        this._coreConnection = sICoreConnection;
        this._sessions.add(jmsJcaSessionImpl);
        jmsJcaSessionImpl.setParentConnection(this);
        this._requestInfo = new JmsJcaConnectionRequestInfo(sICoreConnection);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "JmsJcaConnectionImpl");
        }
    }

    JmsJcaConnectionImpl(JmsJcaConnectionFactoryImpl jmsJcaConnectionFactoryImpl, SICoreConnection sICoreConnection, String string, String string2) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "JmsJcaConnectionImpl", new Object[]{jmsJcaConnectionFactoryImpl, sICoreConnection, string, "*****"});
        }
        this._connectionFactory = jmsJcaConnectionFactoryImpl;
        this._coreConnection = sICoreConnection;
        this._requestInfo = new JmsJcaConnectionRequestInfo(sICoreConnection, string, string2);
        this.firstSessionCached = false;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "JmsJcaConnectionImpl");
        }
    }

    JmsJcaConnectionImpl(JmsJcaConnectionFactoryImpl jmsJcaConnectionFactoryImpl, SICoreConnection sICoreConnection) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "JmsJcaConnectionImpl", new Object[]{jmsJcaConnectionFactoryImpl, sICoreConnection});
        }
        this._connectionFactory = jmsJcaConnectionFactoryImpl;
        this._coreConnection = sICoreConnection;
        this._requestInfo = new JmsJcaConnectionRequestInfo(sICoreConnection);
        this.firstSessionCached = false;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "JmsJcaConnectionImpl");
        }
    }

    public synchronized JmsJcaSession createSession(boolean bl) throws ResourceException, IllegalStateException, SIException, SIErrorException {
        JmsJcaSessionImpl jmsJcaSessionImpl;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "createSession", new Object[]{bl});
        }
        if (this.connectionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1085", new Object[]{"createSession"}, null));
        }
        if (this.firstSessionCached) {
            if (TRACE.isDebugEnabled()) {
                SibTr.debug(TRACE, "Using the first session that was created as part of the createConnection process");
            }
            if (this._sessions.size() != 1) {
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1082", new Object[]{"createSession", "" + this._sessions.size()}, null));
            }
            Iterator iterator = this._sessions.iterator();
            Object e = iterator.next();
            if (!(e instanceof JmsJcaSessionImpl)) {
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1083", new Object[]{"createSession", e.getClass().getName(), this.getClass().getName()}, null));
            }
            this.firstSessionCached = false;
            jmsJcaSessionImpl = (JmsJcaSessionImpl)e;
        } else {
            if (TRACE.isDebugEnabled()) {
                SibTr.debug(this, TRACE, "We have already used the first session... creating a new one");
            }
            if (this._connectionFactory.isManaged()) {
                try {
                    Object object = this._connectionFactory.getConnectionManager().allocateConnection((ManagedConnectionFactory)this._connectionFactory.getManagedConnectionFactory(), (ConnectionRequestInfo)this._requestInfo);
                    if (!(object instanceof JmsJcaSessionImpl)) {
                        throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1084", new Object[]{"createSession", object.getClass().getName(), JmsJcaSessionImpl.class.getName()}, null));
                    }
                    jmsJcaSessionImpl = (JmsJcaSessionImpl)object;
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + ".createSession"), (String)FFDC_PROBE_1, (Object)this);
                    if (resourceException.getCause() instanceof SIException) {
                        throw (SIException)resourceException.getCause();
                    }
                    if (resourceException.getCause() instanceof SIErrorException) {
                        throw (SIErrorException)resourceException.getCause();
                    }
                    throw resourceException;
                }
            } else {
                jmsJcaSessionImpl = new JmsJcaSessionImpl();
            }
            jmsJcaSessionImpl.setParentConnection(this);
            this._sessions.add(jmsJcaSessionImpl);
        }
        jmsJcaSessionImpl.setTransacted(bl);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "createSession", jmsJcaSessionImpl);
        }
        return jmsJcaSessionImpl;
    }

    public SICoreConnection getSICoreConnection() throws IllegalStateException {
        if (this.connectionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1086", new Object[]{"getSICoreConnection"}, null));
        }
        return this._coreConnection;
    }

    public synchronized void close() throws SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException, SIConnectionDroppedException, SIConnectionUnavailableException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry(this, TRACE, "close");
        }
        Iterator iterator = this._sessions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof JmsJcaSessionImpl) {
                JmsJcaSessionImpl jmsJcaSessionImpl = (JmsJcaSessionImpl)e;
                jmsJcaSessionImpl.close(false);
            }
            iterator.remove();
        }
        if (this._coreConnection != null) {
            this._coreConnection.close();
        }
        this.connectionClosed = true;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit(this, TRACE, "close");
        }
    }

    void removeSession(JmsJcaSessionImpl jmsJcaSessionImpl) {
        this._sessions.remove(jmsJcaSessionImpl);
    }

    ConnectionManager getConnectionManager() {
        return this._connectionFactory.getConnectionManager();
    }

    JmsJcaConnectionFactoryImpl getConnectionFactory() {
        return this._connectionFactory;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("@");
        stringBuffer.append(System.identityHashCode(this));
        stringBuffer.append(" <connectionFactory=");
        stringBuffer.append(this._connectionFactory);
        stringBuffer.append("> <coreConnection=");
        stringBuffer.append(this._coreConnection);
        stringBuffer.append("> <firstSessionCached=");
        stringBuffer.append(this.firstSessionCached);
        stringBuffer.append("> <connectionClosed=");
        stringBuffer.append(this.connectionClosed);
        stringBuffer.append("> <sessions=");
        stringBuffer.append(this._sessions);
        stringBuffer.append(">]");
        return stringBuffer.toString();
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug(TRACE, "Source info: @(#)SIB/ws/code/sib.api.jmsra.outbound.impl/src/com/ibm/ws/sib/api/jmsra/impl/JmsJcaConnectionImpl.java, SIB.api.jmsra, WAS602.SIB, o0610.11 1.36");
        }
    }
}

