/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl.ute;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsAdminFactory;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.ute.UTEHelper;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.processor.Administrator;
import com.ibm.ws.sib.processor.SIMPAdmin;
import com.ibm.ws.sib.processor.test.SIMPJsStandaloneEngine;
import com.ibm.ws.sib.processor.test.SIMPJsStandaloneFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;

public class UTEHelperImpl
implements UTEHelper {
    private static TraceComponent tcInt = Tr.register((Class)UTEHelperImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private SIMPJsStandaloneEngine myME = null;
    private Administrator admin = null;
    private SICoreConnection coreConnection = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SICoreConnectionFactory setupJmsTestEnvironment() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "setupJmsTestEnvironment");
        }
        SICoreConnectionFactory sICoreConnectionFactory = null;
        UTEHelperImpl uTEHelperImpl = this;
        synchronized (uTEHelperImpl) {
            if (this.myME == null) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "ME not yet created.");
                }
                System.out.println("***************************************");
                System.out.println("*  JMS Unit Test Environment Enabled  *");
                System.out.println("***************************************");
                this.myME = this.getStandaloneEngine();
            }
            sICoreConnectionFactory = (SICoreConnectionFactory)((Object)this.myME.getMessageProcessor());
            this.enableDestinationCreation(sICoreConnectionFactory);
            try {
                this.coreConnection = sICoreConnectionFactory.createConnection(null, null, null);
            }
            catch (SIException sIException) {
                System.out.println("*** Failed to create a connection ***");
                sIException.printStackTrace();
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "setupJmsTestEnvironment");
        }
        return sICoreConnectionFactory;
    }

    public void createDestination(DestinationDefinition destinationDefinition) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "createDestination(DestinationDefinition)");
        }
        try {
            Reliability reliability;
            Reliability reliability2 = destinationDefinition.getDefaultReliability();
            if (reliability2 == null) {
                destinationDefinition.setDefaultReliability(Reliability.ASSURED_PERSISTENT);
            }
            if ((reliability = destinationDefinition.getMaxReliability()) == null) {
                destinationDefinition.setMaxReliability(Reliability.ASSURED_PERSISTENT);
            }
            LocalizationDefinition localizationDefinition = JsAdminFactory.getInstance().createLocalizationDefinition(destinationDefinition.getName());
            this.admin.createDestinationLocalization(destinationDefinition, localizationDefinition, null);
        }
        catch (Exception exception) {
            if (tcInt.isEntryEnabled()) {
                SibTr.debug(tcInt, "Exception creating Destination Localisation", exception);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "createDestination(DestinationDefinition)");
            }
            throw new RuntimeException("Unable to create Destination Localization", exception);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "createDestination(DestinationDefinition)");
        }
    }

    public void createDestination(Destination destination) throws JMSException {
        this.createDestination(destination, Reliability.ASSURED_PERSISTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDestination(Destination destination, Reliability reliability) throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "createDestination(Destination)");
            }
            DestinationType destinationType = null;
            String string = null;
            try {
                if (destination instanceof JmsQueue) {
                    destinationType = DestinationType.QUEUE;
                    string = ((JmsQueue)destination).getQueueName();
                } else if (destination instanceof JmsTopic) {
                    destinationType = DestinationType.TOPICSPACE;
                    string = ((JmsTopic)destination).getTopicSpace();
                } else {
                    destinationType = null;
                    string = null;
                }
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "    name: " + string);
                    SibTr.debug(tcInt, "destType: " + destinationType);
                }
                if (destinationType == null) {
                    throw new JMSException("Could not create Destination - destType was null");
                }
                this.createDestination(string, destinationType, reliability);
            }
            catch (JMSException jMSException) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "JMSException during createDestination", (Object)jMSException);
                }
                throw jMSException;
            }
            catch (Exception exception) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Exception during createDestionation", exception);
                }
                JMSException jMSException = new JMSException("Exception from createDestination");
                jMSException.setLinkedException(exception);
                jMSException.initCause((Throwable)exception);
                throw jMSException;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "createDestination(Destination)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "createDestination(Destination)");
        }
    }

    public void deleteDestination(Destination destination) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "deleteDestination(Destination)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "dest: " + destination);
        }
        String string = ((JmsDestinationImpl)destination).getDestName();
        try {
            SIDestinationAddress sIDestinationAddress = SIDestinationAddressFactory.getInstance().createSIDestinationAddress(string, null);
            DestinationConfiguration destinationConfiguration = this.coreConnection.getDestinationConfiguration(sIDestinationAddress);
            if (destinationConfiguration != null) {
                String string2 = destinationConfiguration.getUUID();
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "delete name: " + string);
                }
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "delete UUID: " + string2);
                }
                this.admin.deleteDestinationLocalization(string2, null);
            } else if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "No object was returned from getDestinationConfiguration");
            }
        }
        catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "Destination does not exist: " + string, sINotPossibleInCurrentConfigurationException);
            }
        }
        catch (Exception exception) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "Exception deleting", exception);
            }
            JMSException jMSException = new JMSException("Exception received while deleting");
            jMSException.setLinkedException(exception);
            jMSException.initCause((Throwable)exception);
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "deleteDestination(Destination)");
            }
            throw jMSException;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "deleteDestination(Destination)");
        }
    }

    public void enableDestinationCreation(SICoreConnectionFactory sICoreConnectionFactory) {
        block7: {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "enableDestinationCreation");
            }
            try {
                if (this.admin == null) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Setting up destination definition objects.");
                    }
                    this.admin = ((SIMPAdmin)sICoreConnectionFactory).getAdministrator();
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "DestinationDefinition objects complete");
                    }
                }
            }
            catch (Exception exception) {
                if (!tcInt.isDebugEnabled()) break block7;
                SibTr.debug(tcInt, "Exception enabling destination creation", exception);
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "enableDestinationCreation");
        }
    }

    private void createDestination(String string, DestinationType destinationType, Reliability reliability) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "createDestination(String, DestinationType)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "name: " + string);
            SibTr.debug(tcInt, "type: " + destinationType);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            try {
                object3 = SIDestinationAddressFactory.getInstance().createSIDestinationAddress(string, null);
                object2 = this.coreConnection.getDestinationConfiguration((SIDestinationAddress)object3);
                if (object2 != null) {
                    object = object2.getUUID();
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "delete UUID: " + (String)object);
                    }
                    this.admin.deleteDestinationLocalization((String)object, null);
                } else if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "No object was returned from getDestinationConfiguration");
                }
            }
            catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                // empty catch block
            }
            object3 = JsAdminFactory.getInstance().createDestinationDefinition(destinationType, string);
            object3.setMaxReliability(Reliability.ASSURED_PERSISTENT);
            object3.setDefaultReliability(reliability);
            object2 = "_SYSTEM.Exception.Destination." + this.getMEName();
            object3.setExceptionDestination((String)object2);
            object = JsAdminFactory.getInstance().createLocalizationDefinition(string);
            object.setDestinationHighMsgs(30000L);
            this.admin.createDestinationLocalization((DestinationDefinition)object3, (LocalizationDefinition)object, null);
        }
        catch (Exception exception) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "Exception creating", exception);
            }
            JMSException jMSException = new JMSException("Exception received creating destination");
            jMSException.setLinkedException(exception);
            jMSException.initCause((Throwable)exception);
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "createDestination(String, DestinationDefinition)");
            }
            throw jMSException;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "createDestination(String, DestinationDefinition)");
        }
    }

    private SIMPJsStandaloneEngine getStandaloneEngine() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getStandaloneEngine");
        }
        try {
            this.myME = SIMPJsStandaloneFactory.getInstance().createNewMessagingEngine("BigRedFunBus", "jmsTestME", true, true);
            this.myME.initializeMessageProcessor();
        }
        catch (Exception exception) {
            if (tcInt.isEntryEnabled()) {
                SibTr.debug(tcInt, "Exception getting standalone me", exception);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "getStandaloneEngine");
            }
            throw new RuntimeException("Unable to create test environment engine", exception);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getStandaloneEngine");
        }
        return this.myME;
    }

    public void stopME() {
        try {
            if (this.coreConnection != null) {
                this.coreConnection.close();
            }
        }
        catch (SIException sIException) {
            sIException.printStackTrace();
        }
        this.myME.stop(0);
        ((MessageStore)this.myME.getMessageStore()).stop(0);
        this.myME.destroy();
        this.myME = null;
        this.admin = null;
    }

    public String getMEName() {
        if (this.myME == null) {
            this.setupJmsTestEnvironment();
        }
        return this.myME.getName();
    }

    static {
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/ute/UTEHelperImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.42");
        }
    }
}

