/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMsgProducerImpl;
import com.ibm.ws.sib.mfp.PersistenceType;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;

public class ProducerProperties {
    private static TraceComponent tcInt = SibTr.register(ProducerProperties.class, "SIBJms_Internal", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private String inDmOverride = "Application";
    private Integer inPriOverride = null;
    private Long inTTL_Override = null;
    private Reliability nonPerReliability = Reliability.EXPRESS_NONPERSISTENT;
    private Reliability perReliability = Reliability.RELIABLE_PERSISTENT;
    private Reliability outboundReliability;
    private int inDeliveryMode = 2;
    private int inPriority = 4;
    private long inTTL = 0L;
    private List outboundForwardRoutingPath = null;
    private List outboundReverseRoutingPath_Part = null;
    private PersistenceType outboundDeliveryMode = PersistenceType.PERSISTENT;
    private Integer outboundPriority = new Integer(this.inPriority);
    private long outboundTTL = this.inTTL;
    private String outboundDiscrim = null;

    public ProducerProperties(JmsDestinationImpl jmsDestinationImpl, JmsMsgProducerImpl jmsMsgProducerImpl, Map map) throws JMSException {
        if (map != null) {
            String string = (String)map.get("nonPersistentMapping");
            if (string != null) {
                this.nonPerReliability = ProducerProperties.lookupReliability(string);
            }
            if ((string = (String)map.get("persistentMapping")) != null) {
                this.perReliability = ProducerProperties.lookupReliability(string);
            }
        }
        this.setInDeliveryModeOverride(jmsDestinationImpl.getDeliveryMode());
        this.setInPriorityOverride(jmsDestinationImpl.getPriority());
        this.setInTTL_Override(jmsDestinationImpl.getTimeToLive());
        this.outboundForwardRoutingPath = jmsDestinationImpl.getConvertedFRP();
        this.outboundReverseRoutingPath_Part = jmsDestinationImpl.getConvertedRRP();
        this.outboundDiscrim = jmsDestinationImpl.getDestDiscrim();
        if (jmsMsgProducerImpl != null) {
            this.setInDeliveryMode(jmsMsgProducerImpl.getDeliveryMode());
            this.setInPriority(jmsMsgProducerImpl.getPriority());
            this.setInTTL(jmsMsgProducerImpl.getTimeToLive());
        }
        this.recalcOutReliability();
    }

    public void setInDeliveryModeOverride(String string) {
        if (!this.inDmOverride.equals(string)) {
            this.inDmOverride = string;
            this.recalcOutDeliveryMode();
        }
    }

    public void setInDeliveryMode(int n) {
        if (this.inDeliveryMode != n) {
            this.inDeliveryMode = n;
            this.recalcOutDeliveryMode();
            this.recalcOutReliability();
        }
    }

    public void setInPriorityOverride(Integer n) {
        if (this.inPriOverride == null && n != null || this.inPriOverride != null && !this.inPriOverride.equals(n)) {
            this.inPriOverride = n;
            this.recalcOutPriority();
        }
    }

    public void setInPriority(int n) {
        if (this.inPriority != n) {
            this.inPriority = n;
            this.recalcOutPriority();
        }
    }

    public void setInTTL_Override(Long l) {
        if (this.inTTL_Override == null && l != null || this.inTTL_Override != null && !this.inTTL_Override.equals(l)) {
            this.inTTL_Override = l;
            this.recalcOutTTL();
        }
    }

    public void setInTTL(long l) throws JMSException {
        if (this.inTTL != l) {
            if (l < 0L || l > 9191815209357175807L) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0301", new Object[]{"timeToLive", "" + l}, tcInt);
            }
            this.inTTL = l;
            this.recalcOutTTL();
        }
    }

    public PersistenceType getEffectiveDeliveryMode() {
        return this.outboundDeliveryMode;
    }

    public Integer getEffectivePriority() {
        return this.outboundPriority;
    }

    public long getEffectiveTTL() {
        return this.outboundTTL;
    }

    public List getConvertedFRP() {
        return this.outboundForwardRoutingPath;
    }

    public List getConvertedRRP_Part() {
        return this.outboundReverseRoutingPath_Part;
    }

    public String getDiscriminator() {
        return this.outboundDiscrim;
    }

    public Reliability getEffectiveReliability() {
        return this.outboundReliability;
    }

    private void recalcOutDeliveryMode() {
        this.outboundDeliveryMode = this.inDmOverride.equals("Persistent") ? PersistenceType.PERSISTENT : (this.inDmOverride.equals("NonPersistent") ? PersistenceType.NON_PERSISTENT : (this.inDeliveryMode == 2 ? PersistenceType.PERSISTENT : PersistenceType.NON_PERSISTENT));
    }

    private void recalcOutPriority() {
        this.outboundPriority = this.inPriOverride == null ? new Integer(this.inPriority) : this.inPriOverride;
    }

    private void recalcOutTTL() {
        this.outboundTTL = this.inTTL_Override == null ? this.inTTL : this.inTTL_Override;
    }

    private void recalcOutReliability() {
        this.outboundReliability = this.outboundDeliveryMode == PersistenceType.NON_PERSISTENT ? this.nonPerReliability : this.perReliability;
    }

    static Reliability lookupReliability(String string) throws JMSException {
        Reliability reliability;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "lookupReliability");
        }
        if ("AsSIBDestination".equals(string)) {
            reliability = Reliability.NONE;
        } else {
            try {
                reliability = Reliability.getReliabilityByName(string);
            }
            catch (Exception exception) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0301", new Object[]{"quality of service", string}, tcInt);
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "lookupReliability");
        }
        return reliability;
    }

    static {
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/ProducerProperties.java, SIB.api.jms, WAS602.SIB, o0610.11 1.17");
        }
    }
}

