/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsDestination;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.websphere.sib.api.jms.JmsMsgConsumer;
import com.ibm.websphere.sib.api.jms.JmsMsgProducer;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.JmsSession;
import com.ibm.ws.sib.api.jms.impl.ConsumerProperties;
import com.ibm.ws.sib.api.jms.impl.JmsBytesMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsConnectionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsDurableSubscriberImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMapMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsMsgConsumerImpl;
import com.ibm.ws.sib.api.jms.impl.JmsMsgProducerImpl;
import com.ibm.ws.sib.api.jms.impl.JmsObjectMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsQueueBrowserImpl;
import com.ibm.ws.sib.api.jms.impl.JmsStreamMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTemporaryQueueImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTemporaryTopicImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTextMessageImpl;
import com.ibm.ws.sib.api.jmsra.JmsJcaSession;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.resource.spi.LocalTransactionException;

public class JmsSessionImpl
implements JmsSession,
ApiJmsConstants,
JmsInternalConstants {
    private static TraceComponent tc = SibTr.register(JmsSessionImpl.class, "SIBJms_External", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceComponent tcInt = SibTr.register(JmsSessionImpl.class, "SIBJms_Internal", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private final Map passThruProps;
    private final SICoreConnection coreConnection;
    private final JmsConnectionImpl connection;
    private final JmsJcaSession jcaSession;
    private final boolean transacted;
    private final int acknowledgeMode;
    private final boolean isManaged;
    private int uncommittedReceiveCount = 0;
    private final int dupsCommitThreshold;
    private int state = 1;
    private final Object stateLock = new Object();
    private final Object asyncDeliveryLock = new Object();
    private final Object sessionSyncLock = new Object();
    private final List producers;
    private final List syncConsumers;
    private final List asyncConsumers;
    private final Object consumerListsLock = new Object();
    private final List browsers;
    private final byte[] currentMessageID;
    private OrderingContext orderingContext;
    private static final byte[] MSG_ID_PAD_BYTES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JmsSessionImpl(boolean bl, int n, SICoreConnection sICoreConnection, JmsConnectionImpl jmsConnectionImpl, JmsJcaSession jmsJcaSession) throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "JmsSessionImpl(boolean, int, SICoreConnection, JmsConnectionImpl, JmsJcaSession)");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "transacted : " + bl);
                SibTr.debug(tcInt, "acknowledgeMode : " + n);
                SibTr.debug(tcInt, "coreConnection : " + sICoreConnection);
                SibTr.debug(tcInt, "jmsConnection : " + jmsConnectionImpl);
                SibTr.debug(tcInt, "jcaSession : " + jmsJcaSession);
            }
            this.transacted = bl;
            this.acknowledgeMode = n;
            this.connection = jmsConnectionImpl;
            this.coreConnection = sICoreConnection;
            this.jcaSession = jmsJcaSession;
            this.isManaged = jmsConnectionImpl.isManaged();
            this.passThruProps = jmsConnectionImpl.getPassThruProps();
            this.dupsCommitThreshold = JmsConnectionImpl.DEFAULT_DUPS_THRESHOLD;
            this.producers = Collections.synchronizedList(new ArrayList());
            this.syncConsumers = Collections.synchronizedList(new ArrayList());
            this.asyncConsumers = Collections.synchronizedList(new ArrayList());
            this.browsers = Collections.synchronizedList(new ArrayList());
            if (sICoreConnection == null) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "JCA_RESOURCE_EXC_CWSIA0005", null, null, "JmsSessionImpl.constructor#2", this, tcInt);
            }
            try {
                int n2;
                byte[] byArray = sICoreConnection.createUniqueId();
                int n3 = byArray.length;
                this.currentMessageID = new byte[24];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.currentMessageID[n2] = byArray[n2];
                }
                n2 = 16 - n3;
                for (int i = 0; i < n2 && i < MSG_ID_PAD_BYTES.length; ++i) {
                    this.currentMessageID[n3 + i] = MSG_ID_PAD_BYTES[i];
                }
            }
            catch (SIException sIException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sIException, "JmsSessionImpl.<constructor>"}, sIException, null, this, tcInt);
            }
            try {
                this.orderingContext = sICoreConnection.createOrderingContext();
            }
            catch (SIException sIException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sIException, "JmsSessionImpl.<constructor>"}, sIException, null, this, tcInt);
            }
            if (jmsConnectionImpl.getState() == 2) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "start session because connection was started");
                }
                this.start();
            } else {
                this.stop();
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "JmsSessionImpl(boolean, int, SICoreConnection, JmsConnectionImpl, JmsJcaSession)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsSessionImpl(boolean, int, SICoreConnection, JmsConnectionImpl, JmsJcaSession)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesMessage createBytesMessage() throws JMSException {
        JmsBytesMessageImpl jmsBytesMessageImpl;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createBytesMessage()");
            }
            this.checkNotClosed();
            jmsBytesMessageImpl = new JmsBytesMessageImpl();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block4;
                SibTr.exit(tc, "createBytesMessage()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createBytesMessage()");
        }
        return jmsBytesMessageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapMessage createMapMessage() throws JMSException {
        JmsMapMessageImpl jmsMapMessageImpl;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createMapMessage()");
            }
            this.checkNotClosed();
            jmsMapMessageImpl = new JmsMapMessageImpl();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block4;
                SibTr.exit(tc, "createMapMessage()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createMapMessage()");
        }
        return jmsMapMessageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message createMessage() throws JMSException {
        JmsMessageImpl jmsMessageImpl;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createMessage()");
            }
            this.checkNotClosed();
            jmsMessageImpl = new JmsMessageImpl();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block4;
                SibTr.exit(tc, "createMessage()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createMessage()");
        }
        return jmsMessageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMessage createObjectMessage() throws JMSException {
        ObjectMessage objectMessage;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createObjectMessage()");
            }
            this.checkNotClosed();
            objectMessage = this.createObjectMessage(null);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block4;
                SibTr.exit(tc, "createObjectMessage()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createObjectMessage()");
        }
        return objectMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        JmsObjectMessageImpl jmsObjectMessageImpl;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createObjectMessage(Serializable)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "object : " + serializable);
            }
            this.checkNotClosed();
            jmsObjectMessageImpl = new JmsObjectMessageImpl(serializable);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (!tc.isEntryEnabled()) break block5;
                SibTr.exit(tc, "createObjectMessage(Serializable)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createObjectMessage(Serializable)");
        }
        return jmsObjectMessageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamMessage createStreamMessage() throws JMSException {
        JmsStreamMessageImpl jmsStreamMessageImpl;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createStreamMessage()");
            }
            this.checkNotClosed();
            jmsStreamMessageImpl = new JmsStreamMessageImpl();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block4;
                SibTr.exit(tc, "createStreamMessage()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createStreamMessage()");
        }
        return jmsStreamMessageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextMessage createTextMessage() throws JMSException {
        JmsTextMessageImpl jmsTextMessageImpl;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createTextMessage()");
            }
            this.checkNotClosed();
            jmsTextMessageImpl = new JmsTextMessageImpl();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block4;
                SibTr.exit(tc, "createTextMessage()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createTextMessage()");
        }
        return jmsTextMessageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextMessage createTextMessage(String string) throws JMSException {
        JmsTextMessageImpl jmsTextMessageImpl;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createTextMessage(String)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "text : " + string);
            }
            this.checkNotClosed();
            jmsTextMessageImpl = new JmsTextMessageImpl(string);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (!tc.isEntryEnabled()) break block5;
                SibTr.exit(tc, "createTextMessage(String)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createTextMessage(String)");
        }
        return jmsTextMessageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getTransacted() throws JMSException {
        boolean bl;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getTransacted()");
            }
            this.checkNotClosed();
            bl = this.transacted;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var3_3 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return boolean : " + this.transacted);
                }
                if (!tc.isEntryEnabled()) break block6;
                SibTr.exit(tc, "getTransacted()");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return boolean : " + this.transacted);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTransacted()");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAcknowledgeMode() throws JMSException {
        int n;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getAcknowledgeMode()");
            }
            this.checkNotClosed();
            n = this.acknowledgeMode;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var3_3 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return int : " + this.acknowledgeMode);
                }
                if (!tc.isEntryEnabled()) break block6;
                SibTr.exit(tc, "getAcknowledgeMode()");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return int : " + this.acknowledgeMode);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getAcknowledgeMode()");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "commit()");
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "got lock");
            }
            try {
                this.checkNotClosed();
                this.checkSynchronousUsage("commit");
                if (this.acknowledgeMode != 0) {
                    throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "INVALID_OP_FOR_NONTRANS_SESSION_CWSIA0042", new Object[]{"commit"}, tc);
                }
                this.commitTransaction();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "commit()");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "commit()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "rollback()");
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "got lock");
            }
            try {
                this.checkNotClosed();
                this.checkSynchronousUsage("rollback");
                if (this.acknowledgeMode != 0) {
                    throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "INVALID_OP_FOR_NONTRANS_SESSION_CWSIA0042", new Object[]{"rollback"}, tc);
                }
                this.rollbackTransaction();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "rollback()");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "rollback()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "close()");
            }
            if (this.getState() != 3) {
                int n;
                Object[] objectArray;
                List list = this.syncConsumers;
                synchronized (list) {
                    objectArray = this.syncConsumers.toArray();
                    for (n = 0; n < objectArray.length; ++n) {
                        ((MessageConsumer)objectArray[n]).close();
                    }
                    this.syncConsumers.clear();
                }
                this.stop();
                this.setState(3);
                switch (this.acknowledgeMode) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.commitTransaction();
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "session " + this + " closing producers.");
                }
                list = this.producers;
                synchronized (list) {
                    objectArray = this.producers.toArray();
                    for (n = 0; n < objectArray.length; ++n) {
                        ((MessageProducer)objectArray[n]).close();
                    }
                    this.producers.clear();
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "session " + this + " closing consumers.");
                }
                list = this.asyncConsumers;
                synchronized (list) {
                    objectArray = this.asyncConsumers.toArray();
                    for (n = 0; n < objectArray.length; ++n) {
                        ((MessageConsumer)objectArray[n]).close();
                    }
                    this.asyncConsumers.clear();
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "session " + this + "closing queue browsers.");
                }
                list = this.browsers;
                synchronized (list) {
                    objectArray = this.browsers.toArray();
                    for (n = 0; n < objectArray.length; ++n) {
                        ((QueueBrowser)objectArray[n]).close();
                    }
                    this.browsers.clear();
                }
                try {
                    this.jcaSession.close();
                }
                catch (SIException sIException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sIException, "JmsSessionImpl.close"}, sIException, "JmsSessionImpl.close#1", this, tc);
                }
                this.connection.removeSession(this);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "close()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "recover()");
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "got lock");
            }
            try {
                this.checkNotClosed();
                this.checkSynchronousUsage("recover");
                switch (this.acknowledgeMode) {
                    case 2: {
                        if (this.uncommittedReceiveCount <= 0) break;
                        this.rollbackTransaction();
                        break;
                    }
                    case 3: {
                        if (this.uncommittedReceiveCount <= 0) break;
                        this.commitTransaction();
                        break;
                    }
                    case 0: {
                        throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "INVALID_OP_FOR_TRANS_SESSION_CWSIA0050", new Object[]{"recover"}, tc);
                    }
                    case 1: {
                        this.uncommittedReceiveCount = 0;
                        break;
                    }
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "recover()");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "recover()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageListener getMessageListener() throws JMSException {
        MessageListener messageListener;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getMessageListener()");
            }
            this.checkNotClosed();
            if (this.isManaged) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "MGD_ENV_CWSIA0052", new Object[]{"Session.getMessageListener"}, tc);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "getMessageListener() optional, not implemented");
            }
            messageListener = null;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block8: {
                Object var3_3 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return MessageListener : " + null);
                }
                if (!tc.isEntryEnabled()) break block8;
                SibTr.exit(tc, "getMessageListener()");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return MessageListener : " + null);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMessageListener()");
        }
        return messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setMessageListener(MessageListener)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "listener : " + messageListener);
            }
            this.checkNotClosed();
            if (this.isManaged) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "MGD_ENV_CWSIA0052", new Object[]{"Session.setMessageListener"}, tc);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "setMessageListener(MessageListener) optional, not implemented");
            }
            throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "UNSUPPORTED_OPERATION_CWSIA0045", new Object[]{"Session.setMessageListener"}, tc);
        }
        catch (Throwable throwable) {
            block6: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block6;
                SibTr.exit(tc, "setMessageListener(MessageListener)");
            }
            throw throwable;
        }
    }

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer createProducer(Destination destination) throws JMSException {
        JmsMsgProducer jmsMsgProducer;
        JmsMsgProducer jmsMsgProducer2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createProducer(Destination)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "destination : " + destination);
            }
            this.checkNotClosed();
            jmsMsgProducer2 = this.instantiateProducer(destination);
            this.producers.add(jmsMsgProducer2);
            jmsMsgProducer = jmsMsgProducer2;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_5 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return MessageProducer : " + jmsMsgProducer2);
                }
                if (!tc.isEntryEnabled()) break block7;
                SibTr.exit(tc, "createProducer(Destination)");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return MessageProducer : " + jmsMsgProducer2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createProducer(Destination)");
        }
        return jmsMsgProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        MessageConsumer messageConsumer;
        MessageConsumer messageConsumer2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createConsumer(Destination)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "destination : " + destination);
            }
            this.checkNotClosed();
            messageConsumer = messageConsumer2 = this.createConsumer(destination, null, false);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_5 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return MessageConsumer : " + messageConsumer2);
                }
                if (!tc.isEntryEnabled()) break block7;
                SibTr.exit(tc, "createConsumer(Destination)");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return MessageConsumer : " + messageConsumer2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createConsumer(Destination)");
        }
        return messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        MessageConsumer messageConsumer;
        MessageConsumer messageConsumer2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createConsumer(Destination, String)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "destination : " + destination);
                SibTr.debug(tc, "messageSelector : '" + string + "'");
            }
            this.checkNotClosed();
            messageConsumer = messageConsumer2 = this.createConsumer(destination, string, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var6_6 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return MessageConsumer : " + messageConsumer2);
                }
                if (!tc.isEntryEnabled()) break block7;
                SibTr.exit(tc, "createConsumer(Destination, String)");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return MessageConsumer : " + messageConsumer2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createConsumer(Destination, String)");
        }
        return messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        JmsMsgConsumer jmsMsgConsumer;
        JmsMsgConsumer jmsMsgConsumer2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createConsumer(Destination, String, boolean)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "destination : " + destination);
                SibTr.debug(tc, "messageSelector : '" + string + "'");
                SibTr.debug(tc, "noLocal : " + bl);
            }
            this.checkNotClosed();
            if (destination == null) {
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"Destination", "null"}, tc);
            }
            JmsDestinationImpl.checkNativeInstance(destination);
            JmsDestinationImpl.checkBlockedStatus((JmsDestinationImpl)destination);
            ConsumerProperties consumerProperties = new ConsumerProperties((JmsDestination)destination, null, string, null, false, true, bl, null, null, false, null);
            jmsMsgConsumer2 = this.instantiateConsumer(consumerProperties);
            this.syncConsumers.add(jmsMsgConsumer2);
            jmsMsgConsumer = jmsMsgConsumer2;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var8_8 = null;
                if (!tc.isEntryEnabled()) break block6;
                SibTr.exit(tc, "createConsumer(Destination, String, boolean)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createConsumer(Destination, String, boolean)");
        }
        return jmsMsgConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue createQueue(String string) throws JMSException {
        JmsQueue jmsQueue;
        JmsQueue jmsQueue2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createQueue(String)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "queueName : " + string);
            }
            this.checkNotClosed();
            jmsQueue = jmsQueue2 = JmsFactoryFactory.getInstance().createQueue(string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_5 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, " return Queue : " + jmsQueue2);
                }
                if (!tc.isEntryEnabled()) break block7;
                SibTr.exit(tc, "createQueue(String)");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, " return Queue : " + jmsQueue2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createQueue(String)");
        }
        return jmsQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic createTopic(String string) throws JMSException {
        JmsTopic jmsTopic;
        JmsTopic jmsTopic2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createTopic(String)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "topicName : " + string);
            }
            this.checkNotClosed();
            jmsTopic = jmsTopic2 = JmsFactoryFactory.getInstance().createTopic(string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_5 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, " return Topic : " + jmsTopic2);
                }
                if (!tc.isEntryEnabled()) break block7;
                SibTr.exit(tc, "createTopic(String)");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, " return Topic : " + jmsTopic2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createTopic(String)");
        }
        return jmsTopic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        TopicSubscriber topicSubscriber;
        TopicSubscriber topicSubscriber2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createDurableSubscriber(Topic, String)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "topic : " + topic);
                SibTr.debug(tc, "name : " + string);
            }
            this.checkNotClosed();
            topicSubscriber = topicSubscriber2 = this.createDurableSubscriber(topic, string, null, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var6_6 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return TopicSubscriber : " + topicSubscriber2);
                }
                if (!tc.isEntryEnabled()) break block7;
                SibTr.exit(tc, "createDurableSubscriber(Topic, String)");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return TopicSubscriber : " + topicSubscriber2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDurableSubscriber(Topic, String)");
        }
        return topicSubscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        JmsDurableSubscriberImpl jmsDurableSubscriberImpl;
        JmsDurableSubscriberImpl jmsDurableSubscriberImpl2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createDurableSubscriber(Topic, String, String, boolean");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "topic : " + topic);
                SibTr.debug(tc, "name : " + string);
                SibTr.debug(tc, "messageSelector : " + string2);
                SibTr.debug(tc, "noLocal : " + bl);
            }
            this.checkNotClosed();
            if (topic == null) {
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"Topic", "null"}, tc);
            }
            if (string == null || "".equals(string)) {
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"name", string}, tc);
            }
            JmsDestinationImpl.checkNativeInstance((Destination)topic);
            JmsDestinationImpl.checkBlockedStatus((JmsDestinationImpl)topic);
            String string3 = this.connection.getClientID();
            if (string3 == null || "".equals(string3)) {
                throw (InvalidClientIDException)JmsErrorUtils.newThrowable(InvalidClientIDException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"clientID", string3}, tc);
            }
            String string4 = (String)this.passThruProps.get("durableSubscriptionHome");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "DurableSubHome : " + string4);
            }
            if (string4 == null || "".equals(string4)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "User Error - No durableSubscriptionHome was specified.");
                }
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "DURABLE_SUB_HOME_NOT_SPECIFIED_CWSIA0056", null, tc);
            }
            String string5 = (String)this.passThruProps.get("shareDurableSubscriptions");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "shareDurableSubs: " + string5);
            }
            boolean bl2 = false;
            if (string5 == null || "".equals(string5) || "InCluster".equals(string5)) {
                boolean bl3 = JmsConnectionImpl.isClonedServer();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "isClonedServer: " + bl3);
                }
                bl2 = bl3;
            } else {
                bl2 = "AlwaysShared".equals(string5);
            }
            ConsumerProperties consumerProperties = new ConsumerProperties((JmsDestination)topic, null, string2, null, false, true, bl, string, string3, bl2, string4);
            jmsDurableSubscriberImpl2 = new JmsDurableSubscriberImpl(this.coreConnection, this, consumerProperties);
            this.syncConsumers.add(jmsDurableSubscriberImpl2);
            jmsDurableSubscriberImpl = jmsDurableSubscriberImpl2;
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            block17: {
                Object var13_14 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return TopicSubscriber : " + jmsDurableSubscriberImpl2);
                }
                if (!tc.isEntryEnabled()) break block17;
                SibTr.exit(tc, "createDurableSubscriber(Topic, String, String, boolean");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return TopicSubscriber : " + jmsDurableSubscriberImpl2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDurableSubscriber(Topic, String, String, boolean");
        }
        return jmsDurableSubscriberImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        QueueBrowser queueBrowser;
        QueueBrowser queueBrowser2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createBrowser(Queue)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "queue : " + queue);
            }
            this.checkNotClosed();
            queueBrowser = queueBrowser2 = this.createBrowser(queue, null);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_5 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return QueueBrowser : " + queueBrowser2);
                }
                if (!tc.isEntryEnabled()) break block7;
                SibTr.exit(tc, "createBrowser(Queue)");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return QueueBrowser : " + queueBrowser2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createBrowser(Queue)");
        }
        return queueBrowser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        JmsQueueBrowserImpl jmsQueueBrowserImpl;
        JmsQueueBrowserImpl jmsQueueBrowserImpl2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createBrowser(Queue, String)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "queue : " + queue);
                SibTr.debug(tc, "messageSelector : " + string);
            }
            this.checkNotClosed();
            JmsDestinationImpl jmsDestinationImpl = null;
            if (queue == null) {
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"Queue", "null"}, tc);
            }
            JmsDestinationImpl.checkNativeInstance((Destination)queue);
            jmsDestinationImpl = (JmsDestinationImpl)queue;
            JmsDestinationImpl.checkBlockedStatus(jmsDestinationImpl);
            jmsQueueBrowserImpl2 = new JmsQueueBrowserImpl(this, jmsDestinationImpl, string);
            this.browsers.add(jmsQueueBrowserImpl2);
            jmsQueueBrowserImpl = jmsQueueBrowserImpl2;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block8: {
                Object var7_7 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return QueueBrowser : " + jmsQueueBrowserImpl2);
                }
                if (!tc.isEntryEnabled()) break block8;
                SibTr.exit(tc, "createBrowser(Queue, String)");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return QueueBrowser : " + jmsQueueBrowserImpl2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createBrowser(Queue, String)");
        }
        return jmsQueueBrowserImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        Object object;
        JmsTemporaryQueueImpl jmsTemporaryQueueImpl = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createTemporaryQueue()");
            }
            this.checkNotClosed();
            object = this.stateLock;
            synchronized (object) {
                String string = (String)this.passThruProps.get("tempQueueNamePrefix");
                SIDestinationAddress sIDestinationAddress = this.createTemporaryDestination(Distribution.ONE, string);
                jmsTemporaryQueueImpl = new JmsTemporaryQueueImpl(sIDestinationAddress, this);
                this.connection.addTemporaryDestination(jmsTemporaryQueueImpl);
            }
            object = jmsTemporaryQueueImpl;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block9: {
                Object var7_7 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return TemporaryQueue : " + jmsTemporaryQueueImpl);
                }
                if (!tc.isEntryEnabled()) break block9;
                SibTr.exit(tc, "createTemporaryQueue()");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return TemporaryQueue : " + jmsTemporaryQueueImpl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createTemporaryQueue()");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        Object object;
        JmsTemporaryTopicImpl jmsTemporaryTopicImpl = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createTemporaryTopic()");
            }
            this.checkNotClosed();
            object = this.stateLock;
            synchronized (object) {
                String string = (String)this.passThruProps.get("tempTopicNamePrefix");
                SIDestinationAddress sIDestinationAddress = this.createTemporaryDestination(Distribution.ALL, string);
                jmsTemporaryTopicImpl = new JmsTemporaryTopicImpl(sIDestinationAddress, this);
                this.connection.addTemporaryDestination(jmsTemporaryTopicImpl);
            }
            object = jmsTemporaryTopicImpl;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block9: {
                Object var7_7 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return TemporaryTopic : " + jmsTemporaryTopicImpl);
                }
                if (!tc.isEntryEnabled()) break block9;
                SibTr.exit(tc, "createTemporaryTopic()");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return TemporaryTopic : " + jmsTemporaryTopicImpl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createTemporaryTopic()");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String string) throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "unsubscribe()");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "name : " + string);
            }
            this.checkNotClosed();
            if (string == null || "".equals(string)) {
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"name", string}, tc);
            }
            String string2 = this.connection.getClientID();
            if (string2 == null || "".equals(string2)) {
                throw (InvalidClientIDException)JmsErrorUtils.newThrowable(InvalidClientIDException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"clientID", string2}, tc);
            }
            String string3 = JmsInternalsFactory.getSharedUtils().getCoreDurableSubName(string2, string);
            String string4 = (String)this.passThruProps.get("durableSubscriptionHome");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "subscriptionName : " + string3);
                SibTr.debug(tc, "  durableSubHome : " + string4);
            }
            if (string4 == null || "".equals(string4)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "User Error - No durableSubscriptionHome was specified.");
                }
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "DURABLE_SUB_HOME_NOT_SPECIFIED_CWSIA0056", null, tc);
            }
            try {
                this.coreConnection.deleteDurableSubscription(string3, string4);
            }
            catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "CONN_CLOSED_CWSIA0041", null, sIConnectionUnavailableException, null, this, tc);
            }
            catch (SIDestinationLockedException sIDestinationLockedException) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "DSUB_LOCKED_CWSIA0043", null, sIDestinationLockedException, null, this, tc);
            }
            catch (SIDurableSubscriptionNotFoundException sIDurableSubscriptionNotFoundException) {
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "DURABLE_SUB_DOES_NOT_EXIST_CWSIA0054", new Object[]{string3}, sIDurableSubscriptionNotFoundException, null, this, tc);
            }
            catch (SINotAuthorizedException sINotAuthorizedException) {
                throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "NOT_AUTH_CWSIA0044", null, sINotAuthorizedException, null, this, tc);
            }
            catch (SIException sIException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sIException, "JmsSessionImpl.unsubscribe (#5)"}, sIException, "JmsSessionImpl.unsubscribe#5", this, tc);
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "unsubscribe()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unsubscribe()");
        }
    }

    boolean isManaged() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "isManaged()");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return boolean : " + this.isManaged);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "isManaged()");
        }
        return this.isManaged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getState() {
        int n;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getState()");
        }
        Object object = this.stateLock;
        synchronized (object) {
            n = this.state;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return int : " + n);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getState()");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(int n) {
        int n2 = -1;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "setState(int)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "newState : " + n);
        }
        if (n == 3 || n == 2 || n == 1) {
            Object object = this.stateLock;
            synchronized (object) {
                n2 = this.state;
                this.state = n;
            }
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "oldState : " + n2);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "setState(int)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNotClosed() throws JMSException {
        int n;
        Object object = this.stateLock;
        synchronized (object) {
            n = this.state;
        }
        if (n == 3) {
            throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "SESSION_CLOSED_CWSIA0049", null, tcInt);
        }
    }

    Map getPassThruProps() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getPassThruProps()");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return Map : " + this.passThruProps);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getPassThruProps()");
        }
        return this.passThruProps;
    }

    Object getAsyncDeliveryLock() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getAsyncDeliveryLock()");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return Object : " + this.asyncDeliveryLock);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getAsyncDeliveryLock()");
        }
        return this.asyncDeliveryLock;
    }

    Connection getConnection() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getConnection()");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return JmsConection : " + this.connection);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getConnection()");
        }
        return this.connection;
    }

    SICoreConnection getCoreConnection() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getCoreConnection()");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return SICoreConnection : " + this.coreConnection);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getCoreConnection()");
        }
        return this.coreConnection;
    }

    JmsJcaSession getJcaSession() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getJcaSession()");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return JmsJcaSession : " + this.jcaSession);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getJcaSession()");
        }
        return this.jcaSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JmsMsgProducer instantiateProducer(Destination destination) throws JMSException {
        JmsMsgProducerImpl jmsMsgProducerImpl;
        JmsMsgProducerImpl jmsMsgProducerImpl2 = null;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "instantiateProducer(JmsDestinationImpl)");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "jmsDestination : " + destination);
            }
            jmsMsgProducerImpl = jmsMsgProducerImpl2 = new JmsMsgProducerImpl(destination, this.coreConnection, this);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_5 = null;
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "return JmsMsgProducer : " + jmsMsgProducerImpl2);
                }
                if (!tcInt.isEntryEnabled()) break block7;
                SibTr.exit(tcInt, "instantiateProducer(JmsDestinationImpl)");
            }
            throw throwable;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return JmsMsgProducer : " + jmsMsgProducerImpl2);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "instantiateProducer(JmsDestinationImpl)");
        }
        return jmsMsgProducerImpl;
    }

    OrderingContext getOrderingContext() {
        return this.orderingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JmsMsgConsumer instantiateConsumer(ConsumerProperties consumerProperties) throws JMSException {
        JmsMsgConsumerImpl jmsMsgConsumerImpl;
        JmsMsgConsumerImpl jmsMsgConsumerImpl2 = null;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "instantiateConsumer(ConsumerProperties)");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "consumerProperties : " + consumerProperties);
            }
            jmsMsgConsumerImpl = jmsMsgConsumerImpl2 = new JmsMsgConsumerImpl(this.coreConnection, this, consumerProperties);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_5 = null;
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "return JmsMsgConsumer : " + jmsMsgConsumerImpl2);
                }
                if (!tcInt.isEntryEnabled()) break block7;
                SibTr.exit(tcInt, "instantiateConsumer(ConsumerProperties)");
            }
            throw throwable;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return JmsMsgConsumer : " + jmsMsgConsumerImpl2);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "instantiateConsumer(ConsumerProperties)");
        }
        return jmsMsgConsumerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "start()");
            }
            Object object = this.stateLock;
            synchronized (object) {
                Object object2;
                JMSException jMSException = null;
                Iterator iterator = this.syncConsumers.iterator();
                while (iterator.hasNext()) {
                    try {
                        object2 = (JmsMsgConsumerImpl)iterator.next();
                        ((JmsMsgConsumerImpl)object2).start();
                    }
                    catch (JMSException jMSException2) {
                        if (jMSException != null) continue;
                        if (tcInt.isDebugEnabled()) {
                            SibTr.debug(tcInt, "JMSException received at Session.start. Caching for later use.");
                            SibTr.debug(tcInt, "Will continue trying to start the remaining consumers.");
                        }
                        jMSException = jMSException2;
                    }
                }
                object2 = this.asyncConsumers.iterator();
                while (object2.hasNext()) {
                    try {
                        JmsMsgConsumerImpl jmsMsgConsumerImpl = (JmsMsgConsumerImpl)object2.next();
                        jmsMsgConsumerImpl.start();
                    }
                    catch (JMSException jMSException3) {
                        if (jMSException != null) continue;
                        if (tcInt.isDebugEnabled()) {
                            SibTr.debug(tcInt, "JMSException received at Session.start. Caching for later use.");
                            SibTr.debug(tcInt, "Will continue trying to start the remaining consumers.");
                        }
                        jMSException = jMSException3;
                    }
                }
                if (jMSException != null) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "An exception was received during Session.start. Propogate to Connection.");
                    }
                    throw jMSException;
                }
                this.setState(2);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "start()");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "start()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() throws JMSException {
        try {
            Object[] objectArray;
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "stop()");
            }
            this.setState(1);
            JMSException jMSException = null;
            Object object = this.consumerListsLock;
            synchronized (object) {
                List list = this.syncConsumers;
                synchronized (list) {
                    Iterator iterator = this.syncConsumers.iterator();
                    while (iterator.hasNext()) {
                        try {
                            ((JmsMsgConsumerImpl)iterator.next()).stop();
                        }
                        catch (JMSException jMSException2) {
                            if (jMSException != null) continue;
                            if (tcInt.isDebugEnabled()) {
                                SibTr.debug(tcInt, "JMSException received at Session.stop. Caching for later use.");
                                SibTr.debug(tcInt, "Will continue trying to stop the remaining consumers.");
                            }
                            jMSException = jMSException2;
                        }
                    }
                }
                objectArray = this.asyncConsumers.toArray();
            }
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    ((JmsMsgConsumerImpl)objectArray[i]).stop();
                    continue;
                }
                catch (JMSException jMSException3) {
                    if (jMSException != null) continue;
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "JMSException received at Session.stop. Caching for later use.");
                        SibTr.debug(tcInt, "Will continue trying to stop the remaining consumers.");
                    }
                    jMSException = jMSException3;
                }
            }
            if (jMSException != null) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "An exception was received during Session.stop. Propogate to Connection.");
                }
                throw jMSException;
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "stop()");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "stop()");
        }
    }

    public int getProducerCount() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getProducerCount()");
        }
        int n = this.producers.size();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return int : " + n);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getProducerCount()");
        }
        return n;
    }

    public int getConsumerCount() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getConsumerCount()");
        }
        int n = this.syncConsumers.size();
        n += this.asyncConsumers.size();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return int : " + n);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getConsumerCount()");
        }
        return n;
    }

    void removeProducer(JmsMsgProducerImpl jmsMsgProducerImpl) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "removeProducer(JmsMsgProducer)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "producer : " + jmsMsgProducerImpl);
        }
        this.producers.remove(jmsMsgProducerImpl);
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "removeProducer(JmsMsgProducer)");
        }
    }

    void removeConsumer(JmsMsgConsumerImpl jmsMsgConsumerImpl) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "removeConsumer(JmsMsgConsumerImpl)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "consumer : " + jmsMsgConsumerImpl);
        }
        if (this.acknowledgeMode == 3 && this.uncommittedReceiveCount > 0) {
            this.commitTransaction();
        }
        this.syncConsumers.remove(jmsMsgConsumerImpl);
        this.asyncConsumers.remove(jmsMsgConsumerImpl);
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "removeConsumer(JmsMsgConsumerImpl)");
        }
    }

    void removeBrowser(JmsQueueBrowserImpl jmsQueueBrowserImpl) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "removeBrowser(JmsQueueBrowserImpl)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "browser : " + jmsQueueBrowserImpl);
        }
        this.browsers.remove(jmsQueueBrowserImpl);
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "removeBrowser(JmsQueueBrowserImpl");
        }
    }

    void notifyMessagePreConsume(SITransaction sITransaction) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "notifyMessagePreConsume(SITransaction)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "transaction : " + sITransaction);
        }
        if (!(sITransaction instanceof SIXAResource)) {
            ++this.uncommittedReceiveCount;
            if (tcInt.isDebugEnabled() && this.uncommittedReceiveCount % 100 == 0) {
                SibTr.debug(tcInt, "session " + this + " uncommittedReceiveCount : " + this.uncommittedReceiveCount);
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "notifyMessagePreConsume(SITransaction)");
        }
    }

    void notifyMessagePostConsume() throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "notifyMessagePostConsume()");
        }
        if (this.acknowledgeMode == 3 && this.uncommittedReceiveCount >= this.dupsCommitThreshold) {
            this.commitTransaction();
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "notifyMessagePostConsume()");
        }
    }

    void notifyMessageConsumed(SITransaction sITransaction) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "notifyMessageConsumed(SITransaction)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "transaction : " + sITransaction);
        }
        this.notifyMessagePreConsume(sITransaction);
        this.notifyMessagePostConsume();
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "notifyMessageConsumed(SITransaction)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SITransaction getTransaction() throws JMSException {
        SITransaction sITransaction;
        SITransaction sITransaction2 = null;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "getTransaction()");
            }
            try {
                sITransaction2 = this.jcaSession.getCurrentTransaction();
            }
            catch (javax.resource.spi.IllegalStateException illegalStateException) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{illegalStateException, "JmsSessionImpl.getTransaction (#1)"}, illegalStateException, null, this, tcInt);
            }
            catch (Exception exception) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{exception, "JmsSessionImpl.getTransaction (#2)"}, exception, "JmsSessionImpl.getTransaction#2", this, tcInt);
            }
            sITransaction = sITransaction2;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            block9: {
                Object var4_6 = null;
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "return SITransaction : " + sITransaction2);
                }
                if (!tcInt.isEntryEnabled()) break block9;
                SibTr.exit(tcInt, "getTransaction()");
            }
            throw throwable;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return SITransaction : " + sITransaction2);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getTransaction()");
        }
        return sITransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitTransaction() throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "commitTransaction()");
            }
            try {
                this.jcaSession.commitLocalTransaction();
                this.uncommittedReceiveCount = 0;
            }
            catch (javax.resource.spi.IllegalStateException illegalStateException) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{illegalStateException, "JmsSessionImpl.commitTransaction (#1)"}, illegalStateException, "JmsSessionImpl.commitTransaction#1", this, tcInt);
            }
            catch (LocalTransactionException localTransactionException) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{localTransactionException, "JmsSessionImpl.commitTransaction (#2)"}, localTransactionException, "JmsSessionImpl.commitTransaction#2", this, tcInt);
            }
            catch (Exception exception) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{exception, "JmsSessionImpl.commitTransaction (#3)"}, exception, "JmsSessionImpl.commitTransaction#3", this, tcInt);
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "commitTransaction()");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "commitTransaction()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackTransaction() throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "rollbackTransaction()");
            }
            try {
                this.jcaSession.rollbackLocalTransaction();
                this.uncommittedReceiveCount = 0;
            }
            catch (javax.resource.spi.IllegalStateException illegalStateException) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{illegalStateException, "JmsSessionImpl.rollbackTransaction (#1)"}, illegalStateException, null, this, tcInt);
            }
            catch (LocalTransactionException localTransactionException) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{localTransactionException, "JmsSessionImpl.rollbackTransaction (#2)"}, localTransactionException, "JmsSessionImpl.rollbackTransaction#2", this, tcInt);
            }
            catch (Exception exception) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{exception, "JmsSessionImpl.rollbackTransaction (#3)"}, exception, "JmsSessionImpl.rollbackTransaction#3", this, tcInt);
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "rollbackTransaction()");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "rollbackTransaction()");
        }
    }

    int getAndResetCommitCount() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getAndResetCommitCount()");
        }
        int n = this.uncommittedReceiveCount;
        this.uncommittedReceiveCount = 0;
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return int : " + n);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getAndResetCommitCount()");
        }
        return n;
    }

    byte[] createMessageID() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "createMessageID");
        }
        int n = this.currentMessageID.length;
        int n2 = this.currentMessageID.length - 8;
        do {
            int n3 = --n;
            this.currentMessageID[n3] = (byte)(this.currentMessageID[n3] + 1);
        } while (this.currentMessageID[n] == 0 && n > n2);
        if (tcInt.isDebugEnabled()) {
            SibTr.bytes(tcInt, this.currentMessageID);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "createMessageID");
        }
        return this.currentMessageID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SIDestinationAddress createTemporaryDestination(Distribution distribution, String string) throws JMSException {
        SIDestinationAddress sIDestinationAddress;
        String string2 = null;
        try {
            try {
                if (tcInt.isEntryEnabled()) {
                    SibTr.entry(tcInt, "createTemporaryDestination(Distribution)");
                }
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "destType : " + distribution);
                }
                SIDestinationAddress sIDestinationAddress2 = this.getCoreConnection().createTemporaryDestination(distribution, string);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "returns: " + sIDestinationAddress2);
                }
                sIDestinationAddress = sIDestinationAddress2;
                Object var8_13 = null;
            }
            catch (SIInvalidDestinationPrefixException sIInvalidDestinationPrefixException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0048", new Object[]{"TempDestPrefix", string}, sIInvalidDestinationPrefixException, null, this, tcInt);
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sIConnectionLostException, "JmsSessionImpl.createTemporaryDestination (#2)"}, sIConnectionLostException, null, this, tcInt);
            }
            catch (SINotAuthorizedException sINotAuthorizedException) {
                String string3 = "<unknown>";
                try {
                    string3 = this.coreConnection.getResolvedUserid();
                    throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "AUTHORIZATION_FAILED_CWSIA0057", new Object[]{string3}, sINotAuthorizedException, null, this, tcInt);
                }
                catch (SIException sIException) {
                    if (!tcInt.isDebugEnabled()) throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "AUTHORIZATION_FAILED_CWSIA0057", new Object[]{string3}, sINotAuthorizedException, null, this, tcInt);
                    SibTr.debug(tcInt, "failed to get resovledUserId: " + sIException);
                }
                throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "AUTHORIZATION_FAILED_CWSIA0057", new Object[]{string3}, sINotAuthorizedException, null, this, tcInt);
            }
            catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                Class clazz;
                if (class$javax$jms$IllegalStateException == null) {
                    clazz = class$javax$jms$IllegalStateException = JmsSessionImpl.class$("javax.jms.IllegalStateException");
                    throw (IllegalStateException)JmsErrorUtils.newThrowable(clazz, "CONNECTION_CLOSED_CWSIA0051", null, sIConnectionUnavailableException, null, this, tcInt);
                }
                clazz = class$javax$jms$IllegalStateException;
                throw (IllegalStateException)JmsErrorUtils.newThrowable(clazz, "CONNECTION_CLOSED_CWSIA0051", null, sIConnectionUnavailableException, null, this, tcInt);
            }
            catch (SIException sIException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sIException, "JmsSessionImpl.createTemporaryDestination (#5)"}, sIException, null, this, tcInt);
            }
            catch (Exception exception) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{exception, "JmsSessionImpl.createTemporaryDestination (#6)"}, exception, "JmsSessionImpl.createTemporaryDestination#6", this, tcInt);
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "return String : " + string2);
            }
            if (!tcInt.isEntryEnabled()) throw throwable;
            SibTr.exit(tcInt, "createTemporaryDestination(Distribution)");
            throw throwable;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return String : " + string2);
        }
        if (!tcInt.isEntryEnabled()) return sIDestinationAddress;
        SibTr.exit(tcInt, "createTemporaryDestination(Distribution)");
        return sIDestinationAddress;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void deleteTemporaryDestination(SIDestinationAddress sIDestinationAddress) throws JMSException {
        try {
            try {
                if (tcInt.isEntryEnabled()) {
                    SibTr.entry(tcInt, "deleteTemporaryDestination(SIDestinationAddress)");
                }
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "dest : " + sIDestinationAddress);
                }
                this.getCoreConnection().deleteTemporaryDestination(sIDestinationAddress);
            }
            catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "DESTINATION_DOES_NOT_EXIST_CWSIA0052", new Object[]{sIDestinationAddress.getDestinationName()}, sITemporaryDestinationNotFoundException, null, this, tcInt);
            }
            catch (SIDestinationLockedException sIDestinationLockedException) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "DEST_LOCKED_CWSIA0058", null, sIDestinationLockedException, null, this, tcInt);
            }
            catch (SINotAuthorizedException sINotAuthorizedException) {
                String string = "<unknown>";
                try {
                    string = this.coreConnection.getResolvedUserid();
                    throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "AUTHORIZATION_FAILED_CWSIA0057", new Object[]{string}, sINotAuthorizedException, null, this, tcInt);
                }
                catch (SIException sIException) {
                    if (!tcInt.isDebugEnabled()) throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "AUTHORIZATION_FAILED_CWSIA0057", new Object[]{string}, sINotAuthorizedException, null, this, tcInt);
                    SibTr.debug(tcInt, "failed to get resovledUserId: " + sIException);
                }
                throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "AUTHORIZATION_FAILED_CWSIA0057", new Object[]{string}, sINotAuthorizedException, null, this, tcInt);
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sIConnectionLostException, "JmsSessionImpl.deleteTemporaryDestination (#3)"}, sIConnectionLostException, null, this, tcInt);
            }
            catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "CONNECTION_CLOSED_CWSIA0051", null, sIConnectionUnavailableException, null, this, tcInt);
            }
            catch (SIException sIException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{sIException, "JmsSessionImpl.deleteTemporaryDestination (#6)"}, sIException, "JmsSessionImpl.deleteTemporaryDestination#6", this, tcInt);
            }
            catch (Exception exception) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0053", new Object[]{exception, "JmsSessionImpl.deleteTemporaryDestination (#7)"}, exception, "JmsSessionImpl.deleteTemporaryDestination#7", this, tcInt);
            }
            Object var6_2 = null;
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            if (!tcInt.isEntryEnabled()) throw throwable;
            SibTr.exit(tcInt, "deleteTemporaryDestination(SIDestinationAddress)");
            throw throwable;
        }
        if (!tcInt.isEntryEnabled()) return;
        SibTr.exit(tcInt, "deleteTemporaryDestination(SIDestinationAddress)");
    }

    boolean isAsync() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isAsync");
        }
        boolean bl2 = bl = !this.asyncConsumers.isEmpty() && this.getState() == 2;
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "isAsync=" + bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isAsync");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkSynchronousUsage(String string) throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "checkSynchronousUsage()");
            }
            if (this.isAsync() && !Thread.holdsLock(this.asyncDeliveryLock)) {
                throw (JMSException)JmsErrorUtils.newThrowable(IllegalStateException.class, "ASYNC_IN_PROGRESS_CWSIA0082", new Object[]{string}, tcInt);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "checkSynchronousUsage()");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "checkSynchronousUsage()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSyncConsumer(MessageConsumer messageConsumer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "registerSyncConsumer");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "params: " + messageConsumer);
        }
        Object object = this.consumerListsLock;
        synchronized (object) {
            this.asyncConsumers.remove(messageConsumer);
            if (!this.syncConsumers.contains(messageConsumer)) {
                this.syncConsumers.add(messageConsumer);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "registerSyncConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerAsyncConsumer(MessageConsumer messageConsumer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "registerAsyncConsumer(MessageConsumer)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "consumer: " + messageConsumer);
        }
        Object object = this.consumerListsLock;
        synchronized (object) {
            this.syncConsumers.remove(messageConsumer);
            if (!this.asyncConsumers.contains(messageConsumer)) {
                this.asyncConsumers.add(messageConsumer);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "registerAsyncConsumer(MessageConsumer)");
        }
    }

    Object getSessionSyncLock() {
        return this.sessionSyncLock;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsSessionImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.126.1.1");
        }
        MSG_ID_PAD_BYTES = new byte[]{17, 10, 19, 79, 33, 32, 74, 77, 83};
    }
}

