/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;

public class JmsObjectMessageImpl
extends JmsMessageImpl
implements ObjectMessage {
    private static final long serialVersionUID = -8638295995751681706L;
    private JsJmsObjectMessage objMsg;
    private transient String cachedObjectToString = null;
    private static TraceComponent tc = Tr.register((Class)JmsObjectMessageImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceComponent tcInt = Tr.register((Class)JmsObjectMessageImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    public JmsObjectMessageImpl() throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsObjectMessageImpl");
        }
        this.messageClass = "jms_object";
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsObjectMessageImpl");
        }
    }

    public JmsObjectMessageImpl(Serializable serializable) throws JMSException {
        this();
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsObjectMessageImpl(Serializable)");
        }
        this.messageClass = "jms_object";
        this.setObject(serializable);
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsObjectMessageImpl(Serializable)");
        }
    }

    public JmsObjectMessageImpl(JsJmsObjectMessage jsJmsObjectMessage, JmsSessionImpl jmsSessionImpl) {
        super(jsJmsObjectMessage, jmsSessionImpl);
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsObjectMessageImpl(JsJmsObjectMessage, JmsSessionImpl)");
        }
        this.objMsg = jsJmsObjectMessage;
        this.messageClass = "jms_object";
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsObjectMessageImpl(JsJmsObjectMessage, JmsSessionImpl)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JmsObjectMessageImpl(ObjectMessage objectMessage) throws JMSException {
        super((Message)objectMessage);
        this.messageClass = "jms_object";
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "JmsObjectMessageImpl(ObjectMessage)");
            }
            this.setObject(objectMessage.getObject());
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "JmsObjectMessageImpl(ObjectMessage)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsObjectMessageImpl(ObjectMessage)");
        }
    }

    public String toString() {
        String string = super.toString();
        if (this.cachedObjectToString == null) {
            String string2 = null;
            Serializable serializable = null;
            try {
                serializable = this.getObjectInternal();
            }
            catch (Exception exception) {
                String string3;
                string2 = string3 = nls.getFormattedMessage("DESERIALIZATION_EXCEPTION_CWSIA0122", new Object[]{exception.getClass().getName().toString()}, null);
            }
            if (string2 == null) {
                string2 = serializable == null ? "<null>" : serializable.getClass().toString();
            }
            this.cachedObjectToString = string2;
        }
        return string + "\n" + this.cachedObjectToString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(Serializable serializable) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setObject");
        }
        try {
            try {
                this.checkBodyWriteable("setObject");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(serializable);
                this.objMsg.setSerializedObject(byteArrayOutputStream.toByteArray());
                byteArrayOutputStream = null;
                objectOutputStream = null;
                this.cachedObjectToString = null;
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "SERIALIZATION_EXCEPTION_CWSIA0121", new Object[]{iOException}, iOException, "JmsObjectMessageImpl.setObject#1", this, tc);
                SibTr.debug(tc, "Error serializing object", iOException);
                throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "SERIALIZATION_EXCEPTION_CWSIA0121", new Object[]{iOException}, iOException, "JmsObjectMessageImpl.setObject#1", this, tc);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "setObject");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "setObject");
    }

    public Serializable getObject() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getObject");
        }
        Serializable serializable = null;
        try {
            serializable = this.getObjectInternal();
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Error deserializing object", classNotFoundException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getObject");
            }
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "DESERIALIZATION_EXCEPTION_CWSIA0122", new Object[]{classNotFoundException}, classNotFoundException, null, this, tc);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Error deserializing object", exception);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getObject");
            }
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "DESERIALIZATION_EXCEPTION_CWSIA0122", new Object[]{exception}, exception, "JmsObjectMessageImpl.getObject#1", this, tc);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getObject");
        }
        return serializable;
    }

    private Serializable getObjectInternal() throws Exception {
        byte[] byArray;
        Serializable serializable = null;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getObjectInternal");
        }
        if ((byArray = this.objMsg.getSerializedObject()) != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                WsObjectInputStream wsObjectInputStream = new WsObjectInputStream((InputStream)byteArrayInputStream, classLoader);
                serializable = (Serializable)wsObjectInputStream.readObject();
                byteArrayInputStream = null;
                wsObjectInputStream = null;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Exception deserializing object - throw on to caller");
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "getObjectInternal");
                }
                throw exception;
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getObjectInternal");
        }
        return serializable;
    }

    protected JsJmsMessage instantiateMessage() throws Exception {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "instantiateMessage");
        }
        JsJmsObjectMessage jsJmsObjectMessage = null;
        try {
            jsJmsObjectMessage = jmfact.createJmsObjectMessage();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "Error occurred creating message: ", messageCreateFailedException);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "instantiateMessage");
            }
            throw messageCreateFailedException;
        }
        this.objMsg = jsJmsObjectMessage;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "instantiateMessage");
        }
        return jsJmsObjectMessage;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsObjectMessageImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.32");
        }
    }
}

