/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsMsgProducer;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.impl.ProducerProperties;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.PersistenceType;
import com.ibm.ws.sib.mfp.util.HexString;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.Queue;
import javax.jms.Topic;

public class JmsMsgProducerImpl
implements JmsMsgProducer,
ApiJmsConstants,
JmsInternalConstants {
    private static TraceComponent tc = SibTr.register(JmsMsgProducerImpl.class, "SIBJms_External", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceComponent tcInt = SibTr.register(JmsMsgProducerImpl.class, "SIBJms_Internal", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private SICoreConnection coreConnection;
    private ProducerSession prod;
    private int defaultDeliveryMode = 2;
    private int defaultPriority = 4;
    private long defaultTimeToLive = 0L;
    private JmsDestinationImpl dest = null;
    private JmsSessionImpl session = null;
    private boolean closed = false;
    private Object closedLock = new Object();
    private boolean disableTimestamp = false;
    private boolean disableMessageID = false;
    private Object sessionSyncLock;
    private ProducerProperties producerProperties = null;
    private Reliability nonPersistentReliability;
    private Reliability persistentReliability;
    private boolean propsOverriden = false;
    private String resolvedUserID;
    private OrderingContext orderingContext;
    private String busName;

    private JmsMsgProducerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JmsMsgProducerImpl(Destination destination, SICoreConnection sICoreConnection, JmsSessionImpl jmsSessionImpl) throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "JmsMsgProducerImpl(JmsDestinationImpl, SICoreConection, JmsSessionImpl)");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "theDest : " + destination);
                SibTr.debug(tcInt, "coreConnection : " + sICoreConnection);
                SibTr.debug(tcInt, "newSession : " + jmsSessionImpl);
            }
            if (destination != null) {
                JmsDestinationImpl.checkNativeInstance(destination);
                this.dest = (JmsDestinationImpl)destination;
                JmsDestinationImpl.checkBlockedStatus(this.dest);
            }
            this.coreConnection = sICoreConnection;
            this.prod = null;
            this.session = jmsSessionImpl;
            this.sessionSyncLock = this.session.getSessionSyncLock();
            try {
                this.resolvedUserID = sICoreConnection.getResolvedUserid();
            }
            catch (SIException sIException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sIException, "JmsMsgProducerImpl.<constructor>"}, sIException, null, this, tcInt);
            }
            this.orderingContext = this.session.getOrderingContext();
            Map map = this.session.getPassThruProps();
            this.busName = (String)map.get("busName");
            String string = (String)map.get("nonPersistentMapping");
            if (string != null) {
                this.nonPersistentReliability = ProducerProperties.lookupReliability(string);
            } else {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "WARNING: no non-persistent mapping in passThruProps");
                }
                this.nonPersistentReliability = Reliability.EXPRESS_NONPERSISTENT;
            }
            string = (String)map.get("persistentMapping");
            if (string != null) {
                this.persistentReliability = ProducerProperties.lookupReliability(string);
            } else {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "WARNING: no persistent mapping in passThruProps");
                }
                this.persistentReliability = Reliability.RELIABLE_PERSISTENT;
            }
            if (this.dest != null) {
                this.producerProperties = new ProducerProperties(this.dest, this, map);
                try {
                    DestinationType destinationType = null;
                    if (this.dest.isProducerTypeCheck()) {
                        destinationType = destination instanceof Queue ? DestinationType.QUEUE : DestinationType.TOPICSPACE;
                    }
                    SIDestinationAddress sIDestinationAddress = this.dest.getProducerSIDestinationAddress();
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Creating producer session;");
                        SibTr.debug(tcInt, "  destAddr: " + sIDestinationAddress);
                        SibTr.debug(tcInt, "      type: " + destinationType);
                    }
                    String string2 = this.dest.getDestDiscrim();
                    this.prod = sICoreConnection.createProducerSession(sIDestinationAddress, string2, destinationType, this.orderingContext, null);
                }
                catch (SINotAuthorizedException sINotAuthorizedException) {
                    throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "PRODUCER_AUTH_ERROR_CWSIA0069", null, sINotAuthorizedException, null, this, tcInt);
                }
                catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                    String string3 = "MP_CREATE_FAILED_CWSIA0062";
                    throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, string3, new Object[]{destination}, sINotPossibleInCurrentConfigurationException, null, this, tcInt);
                }
                catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
                    String string4 = "MP_CREATE_FAILED_CWSIA0062";
                    throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, string4, new Object[]{destination}, sITemporaryDestinationNotFoundException, null, this, tcInt);
                }
                catch (SIIncorrectCallException sIIncorrectCallException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sIIncorrectCallException, "JmsMsgProducerImpl.<constructor>"}, sIIncorrectCallException, "JmsMsgProducerImpl#4", this, tcInt);
                }
                catch (SIException sIException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sIException, "JmsMsgProducerImpl.<constructor>"}, sIException, null, this, tcInt);
                }
                catch (Exception exception) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{exception, "JmsMsgProducerImpl.<constructor>"}, exception, "JmsMsgProducerImpl#5", this, tcInt);
                }
            }
            Object var10_18 = null;
        }
        catch (Throwable throwable) {
            Object var10_19 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "JmsMsgProducerImpl(JmsDestinationImpl, SICoreConection, JmsSessionImpl)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsMsgProducerImpl(JmsDestinationImpl, SICoreConection, JmsSessionImpl)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisableMessageID(boolean bl) throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setDisableMessageID(boolean)");
            }
            this.checkClosed();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "value : " + bl);
            }
            this.disableMessageID = bl;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setDisableMessageID(boolean)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setDisableMessageID(boolean)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDisableMessageID() throws JMSException {
        boolean bl;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getDisableMessageID()");
            }
            this.checkClosed();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "return boolean : " + this.disableMessageID);
            }
            bl = this.disableMessageID;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block5;
                SibTr.exit(tc, "getDisableMessageID()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDisableMessageID()");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setDisableMessageTimestamp(boolean)");
            }
            this.checkClosed();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "value : " + bl);
            }
            this.disableTimestamp = bl;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setDisableMessageTimestamp(boolean)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setDisableMessageTimestamp(boolean)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDisableMessageTimestamp() throws JMSException {
        boolean bl;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getDisableMessageTimestamp()");
            }
            this.checkClosed();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "return boolean : " + this.disableTimestamp);
            }
            bl = this.disableTimestamp;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block5;
                SibTr.exit(tc, "getDisableMessageTimestamp()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDisableMessageTimestamp()");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeliveryMode(int n) throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setDeliveryMode(int)");
            }
            this.checkClosed();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "deliveryMode : " + n);
            }
            this.validateDeliveryMode(n);
            this.defaultDeliveryMode = n;
            if (this.producerProperties != null) {
                this.producerProperties.setInDeliveryMode(n);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setDeliveryMode(int)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setDeliveryMode(int)");
        }
    }

    private void validateDeliveryMode(int n) throws JMSException {
        switch (n) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"JMSDeliveryMode", "" + n}, tc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeliveryMode() throws JMSException {
        int n;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getDeliveryMode()");
            }
            this.checkClosed();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "return int : " + this.defaultDeliveryMode);
            }
            n = this.defaultDeliveryMode;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block5;
                SibTr.exit(tc, "getDeliveryMode()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDeliveryMode()");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int n) throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setPriority(int)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "priority : " + n);
            }
            this.checkClosed();
            this.validatePriority(n);
            this.defaultPriority = n;
            if (this.producerProperties != null) {
                this.producerProperties.setInPriority(n);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setPriority(int)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setPriority(int)");
        }
    }

    private void validatePriority(int n) throws JMSException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"JMSPriority", "" + n}, tc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPriority() throws JMSException {
        int n;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getPriority()");
            }
            this.checkClosed();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "return int : " + this.defaultPriority);
            }
            n = this.defaultPriority;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block5;
                SibTr.exit(tc, "getPriority()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getPriority()");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeToLive(long l) throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setTimeToLive(long)");
            }
            this.checkClosed();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "timeToLive : " + l);
            }
            this.validateTimeToLive(l);
            this.defaultTimeToLive = l;
            if (this.producerProperties != null) {
                this.producerProperties.setInTTL(l);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setTimeToLive(long)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setTimeToLive(long)");
        }
    }

    private void validateTimeToLive(long l) throws JMSException {
        if (l < 0L || l > 9191815209357175807L) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"timeToLive", "" + l}, tc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeToLive() throws JMSException {
        long l;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getTimeToLive()");
            }
            this.checkClosed();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "return long : " + this.defaultTimeToLive);
            }
            l = this.defaultTimeToLive;
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_3 = null;
                if (!tc.isEntryEnabled()) break block5;
                SibTr.exit(tc, "getTimeToLive()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTimeToLive()");
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getDestination() throws JMSException {
        JmsDestinationImpl jmsDestinationImpl;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getDestination()");
            }
            this.checkClosed();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "return Destination : " + this.dest);
            }
            jmsDestinationImpl = this.dest;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block5;
                SibTr.exit(tc, "getDestination()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDestination()");
        }
        return jmsDestinationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "close()");
            }
            Object object = this.closedLock;
            synchronized (object) {
                if (!this.closed) {
                    if (this.prod != null) {
                        try {
                            this.prod.close();
                        }
                        catch (SIException sIException) {
                            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sIException, "JmsMsgProducerImpl.close"}, sIException, null, this, tc);
                        }
                    }
                    this.session.removeProducer(this);
                    this.closed = true;
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "already closed");
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "close()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "send(Message)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "message : " + message);
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "got lock");
            }
            try {
                this.checkClosed();
                this.session.checkSynchronousUsage("send");
                if (this.dest == null) {
                    throw (UnsupportedOperationException)JmsErrorUtils.newThrowable(UnsupportedOperationException.class, "NO_DEST_SPECIFIED_ON_SEND_CWSIA0065", null, tc);
                }
                if (message == null) {
                    throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"message", message}, tc);
                }
                if (this.propsOverriden) {
                    this.producerProperties.setInDeliveryMode(this.defaultDeliveryMode);
                    this.producerProperties.setInPriority(this.defaultPriority);
                    this.producerProperties.setInTTL(this.defaultTimeToLive);
                    this.propsOverriden = false;
                }
                this.sendMessage(this.producerProperties, message, this.dest);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "send(Message)");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "send(Message)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int n, int n2, long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "send(Message, int, int, long");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "message : " + message);
            SibTr.debug(tc, "deliveryMode : " + n);
            SibTr.debug(tc, "priority : " + n2);
            SibTr.debug(tc, "timeToLive : " + l);
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "got lock");
            }
            try {
                this.checkClosed();
                this.session.checkSynchronousUsage("send");
                if (this.dest == null) {
                    throw (UnsupportedOperationException)JmsErrorUtils.newThrowable(UnsupportedOperationException.class, "NO_DEST_SPECIFIED_ON_SEND_CWSIA0065", null, tc);
                }
                if (message == null) {
                    throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"message", message}, tc);
                }
                this.validatePriority(n2);
                this.validateDeliveryMode(n);
                this.validateTimeToLive(l);
                this.propsOverriden = true;
                this.producerProperties.setInDeliveryMode(n);
                this.producerProperties.setInPriority(n2);
                this.producerProperties.setInTTL(l);
                this.sendMessage(this.producerProperties, message, this.dest);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "send(Message, int, int, long");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "send(Message, int, int, long");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "send(Destination, Message)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "destination : " + destination);
            SibTr.debug(tc, "message : " + message);
        }
        try {
            this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "send(Destination, Message)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "send(Destination, Message)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "send(Destination, Message, int, int, long");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "destination : " + destination);
            SibTr.debug(tc, "message : " + message);
            SibTr.debug(tc, "deliveryMode : " + n);
            SibTr.debug(tc, "priority : " + n2);
            SibTr.debug(tc, "timeToLive : " + l);
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "got lock");
            }
            try {
                this.checkClosed();
                this.session.checkSynchronousUsage("send");
                if (this.dest != null) {
                    throw (UnsupportedOperationException)JmsErrorUtils.newThrowable(UnsupportedOperationException.class, "DEST_SPECIFIED_ON_SEND_CWSIA0066", null, tc);
                }
                JmsDestinationImpl.checkNativeInstance(destination);
                if (this.dest == null) {
                    JmsDestinationImpl.checkBlockedStatus((JmsDestinationImpl)destination);
                }
                if (message == null) {
                    throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"message", message}, tc);
                }
                this.validatePriority(n2);
                this.validateDeliveryMode(n);
                this.validateTimeToLive(l);
                ProducerProperties producerProperties = new ProducerProperties((JmsDestinationImpl)destination, this, this.session.getPassThruProps());
                producerProperties.setInDeliveryMode(n);
                producerProperties.setInPriority(n2);
                producerProperties.setInTTL(l);
                this.sendMessage(producerProperties, message, (JmsDestinationImpl)destination);
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "send(Destination, Message, int, int, long");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "send(Destination, Message, int, int, long");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClosed() throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "checkClosed()");
            }
            Object object = this.closedLock;
            synchronized (object) {
                if (this.closed) {
                    throw (JMSException)JmsErrorUtils.newThrowable(IllegalStateException.class, "PRODUCER_CLOSED_CWSIA0061", null, tcInt);
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "checkClosed()");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "checkClosed()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessage(ProducerProperties producerProperties, Message message, JmsDestinationImpl jmsDestinationImpl) throws JMSException {
        try {
            Object object;
            Object object2;
            SITransaction sITransaction;
            String string;
            Comparable<StringBuffer> comparable;
            Object object3;
            Object object4;
            Object object5;
            List list;
            JmsMessageImpl jmsMessageImpl;
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "sendMessage(ProducerProps, Message, Destination)");
            }
            JsJmsMessage jsJmsMessage = null;
            JmsMessageImpl jmsMessageImpl2 = null;
            if (message instanceof JmsMessageImpl) {
                jmsMessageImpl = (JmsMessageImpl)message;
                jsJmsMessage = jmsMessageImpl.getMsgReference();
                jmsMessageImpl.clearLocalProperties();
            } else {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Create a JS message object for foreign message");
                }
                jmsMessageImpl = jmsMessageImpl2 = JmsMessageImpl.messageToJmsMessageImpl(message);
                jsJmsMessage = jmsMessageImpl2.getMsgReference();
            }
            PersistenceType persistenceType = producerProperties.getEffectiveDeliveryMode();
            Integer n = producerProperties.getEffectivePriority();
            long l = producerProperties.getEffectiveTTL();
            jsJmsMessage.setJmsDeliveryMode(persistenceType);
            jsJmsMessage.setPriority(n);
            List list2 = producerProperties.getConvertedFRP();
            if (list2 != null) {
                jsJmsMessage.uncheckedSetForwardRoutingPath(list2);
            }
            if ((list = producerProperties.getConvertedRRP_Part()) != null) {
                List list3 = jsJmsMessage.getReverseRoutingPath();
                if (list3.size() > 0) {
                    for (int i = 0; i < list3.size(); ++i) {
                        list.add(list3.get(i));
                    }
                }
                jsJmsMessage.uncheckedSetReverseRoutingPath(list);
                object5 = producerProperties.getDiscriminator();
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Using discriminator from destination: " + (String)object5);
                }
                if (object5 != null && !((String)object5).equals(jsJmsMessage.getReplyDiscriminator())) {
                    jsJmsMessage.setReplyDiscriminator((String)object5);
                }
            }
            boolean bl = false;
            object5 = jsJmsMessage.getReverseRoutingPath();
            if (object5.size() > 0) {
                for (int i = 0; i < object5.size(); ++i) {
                    JsDestinationAddress jsDestinationAddress = (JsDestinationAddress)object5.get(i);
                    if (jsDestinationAddress.getBusName() != null) continue;
                    jsDestinationAddress.setBusName(this.busName);
                    object5.set(i, jsDestinationAddress);
                    bl = true;
                }
            }
            if (bl) {
                jsJmsMessage.uncheckedSetReverseRoutingPath((List)object5);
            }
            if ((object4 = jsJmsMessage.getObjectProperty("JMS_IBM_MsgType")) == null) {
                int n2 = message.getJMSReplyTo() == null ? 8 : 1;
                jsJmsMessage.setNonNullProperty("JMS_IBM_MsgType", new Integer(n2));
            }
            if (!jmsDestinationImpl._getInhibitJMSDestination()) {
                byte[] byArray = jmsDestinationImpl.fullEncodeToBytes();
                jsJmsMessage.setJmsDestination(byArray);
                if (message instanceof JmsMessageImpl) {
                    ((JmsMessageImpl)message).setDestReference(jmsDestinationImpl);
                }
            }
            if (!this.disableMessageID) {
                jsJmsMessage.setApiMessageIdAsBytes(this.session.createMessageID());
            }
            jsJmsMessage.setJmsxAppId(MfpConstants.WPM_JMSXAPPID);
            jsJmsMessage.setApiUserId(this.resolvedUserID);
            Object object6 = jsJmsMessage.getObjectProperty("JMSXGroupSeq");
            if (object6 != null && (object3 = jsJmsMessage.getObjectProperty("JMSXGroupID")) == null) {
                byte[] byArray = this.session.createMessageID();
                comparable = new StringBuffer("ID:");
                HexString.binToHex(byArray, 0, byArray.length, comparable);
                string = comparable.toString();
                jsJmsMessage.setObjectProperty("JMSXGroupID", string);
            }
            long l2 = 0L;
            if (l != 0L || !this.disableTimestamp) {
                l2 = System.currentTimeMillis();
            }
            if (l == 0L) {
                jsJmsMessage.setJmsExpiration(0L);
            } else {
                jsJmsMessage.setJmsExpiration(l2 + l);
            }
            jsJmsMessage.uncheckedSetTimeToLive(l);
            if (!this.disableTimestamp) {
                jsJmsMessage.setTimestamp(l2);
            }
            comparable = producerProperties.getEffectiveReliability();
            jsJmsMessage.setReliability((Reliability)comparable);
            jmsMessageImpl.updateReplyReliability(this.nonPersistentReliability, this.persistentReliability);
            string = producerProperties.getDiscriminator();
            try {
                if (tcInt.isDebugEnabled()) {
                    if (string == null) {
                        SibTr.debug(tcInt, "Setting discrim as <null>");
                    } else {
                        SibTr.debug(tcInt, "Setting discrim as '" + string + "'");
                    }
                }
                if (this.prod != null) {
                    jsJmsMessage.uncheckedSetDiscriminator(string);
                } else {
                    jsJmsMessage.setDiscriminator(string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"discriminator", string}, illegalArgumentException, null, this, tcInt);
            }
            jsJmsMessage.setRoutingDestination(null);
            switch (this.session.getAcknowledgeMode()) {
                case 0: {
                    sITransaction = this.session.getTransaction();
                    break;
                }
                case 2: {
                    sITransaction = null;
                    break;
                }
                case 3: {
                    sITransaction = null;
                    break;
                }
                case 1: {
                    sITransaction = this.session.getTransaction();
                    break;
                }
                default: {
                    sITransaction = this.session.getTransaction();
                }
            }
            jmsMessageImpl.invalidateToStringCache();
            if (this.prod != null) {
                try {
                    this.prod.send(jsJmsMessage, sITransaction);
                }
                catch (SINotAuthorizedException sINotAuthorizedException) {
                    throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "PRODUCER_AUTH_ERROR_CWSIA0069", null, sINotAuthorizedException, null, this, tcInt);
                }
                catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                    String string2 = "SEND_FAILED_CWSIA0063";
                    throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, string2, new Object[]{jmsDestinationImpl}, sINotPossibleInCurrentConfigurationException, null, this, tcInt);
                }
                catch (SIIncorrectCallException sIIncorrectCallException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sIIncorrectCallException, "JmsMsgProducerImpl.sendMessage (#4)"}, sIIncorrectCallException, "JmsMsgProducerImpl.sendMessage#4", this, tcInt);
                }
                catch (SIException sIException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sIException, "JmsMsgProducerImpl.sendMessage (#4)"}, sIException, null, this, tcInt);
                }
            }
            try {
                object2 = null;
                if (jmsDestinationImpl.isProducerTypeCheck()) {
                    if (jmsDestinationImpl instanceof Queue) {
                        object2 = DestinationType.QUEUE;
                    } else if (jmsDestinationImpl instanceof Topic) {
                        object2 = DestinationType.TOPICSPACE;
                    }
                }
                object = jmsDestinationImpl.getProducerSIDestinationAddress();
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "About to do core unidentified send;");
                    SibTr.debug(tcInt, "transaction: " + sITransaction);
                    SibTr.debug(tcInt, "   destAddr: " + object);
                    SibTr.debug(tcInt, "   destType: " + object2);
                }
                this.coreConnection.send(jsJmsMessage, sITransaction, (SIDestinationAddress)object, (DestinationType)object2, this.orderingContext, null);
            }
            catch (SINotAuthorizedException sINotAuthorizedException) {
                throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "PRODUCER_AUTH_ERROR_CWSIA0069", null, sINotAuthorizedException, null, this, tcInt);
            }
            catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                String string3 = "SEND_FAILED_CWSIA0063";
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, string3, new Object[]{jmsDestinationImpl}, sINotPossibleInCurrentConfigurationException, null, this, tcInt);
            }
            catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
                String string4 = "SEND_FAILED_CWSIA0063";
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, string4, new Object[]{jmsDestinationImpl}, sITemporaryDestinationNotFoundException, null, this, tcInt);
            }
            catch (SIIncorrectCallException sIIncorrectCallException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sIIncorrectCallException, "JmsMsgProducerImpl.sendMessage (#7)"}, sIIncorrectCallException, "JmsMsgProducerImpl.sendMessage#7", this, tcInt);
            }
            catch (SIException sIException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sIException, "JmsMsgProducerImpl.sendMessage (#7)"}, sIException, null, this, tcInt);
            }
            catch (Exception exception) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{exception, "JmsMsgProducerImpl.sendMessage (#8)"}, exception, "JmsMsgProducerImpl.sendMessage#8", this, tcInt);
            }
            if (!(message instanceof JmsMessageImpl)) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Setting properties back into foreign message");
                }
                message.setJMSDeliveryMode(jmsMessageImpl2.getJMSDeliveryMode());
                message.setJMSDestination(jmsMessageImpl2.getJMSDestination());
                message.setJMSExpiration(jmsMessageImpl2.getJMSExpiration());
                message.setJMSMessageID(jmsMessageImpl2.getJMSMessageID());
                message.setJMSPriority(jmsMessageImpl2.getJMSPriority());
                message.setJMSTimestamp(jmsMessageImpl2.getJMSTimestamp());
                object2 = jmsMessageImpl2.getPropertyNames();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (!((String)object).startsWith("JMSX") && !((String)object).startsWith("JMS_IBM")) continue;
                    Object object7 = jmsMessageImpl2.getObjectProperty((String)object);
                    try {
                        message.setObjectProperty((String)object, object7);
                    }
                    catch (JMSException jMSException) {
                        if (!tcInt.isDebugEnabled()) continue;
                        SibTr.debug(tcInt, "foreign message refused setObjProperty(" + (String)object + "): " + (Object)((Object)jMSException));
                    }
                }
            }
            Object var27_46 = null;
        }
        catch (Throwable throwable) {
            Object var27_47 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "sendMessage(ProducerProps, Message, Destination)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "sendMessage(ProducerProps, Message, Destination)");
        }
    }

    static {
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsMsgProducerImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.129");
        }
    }
}

