/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsDestination;
import com.ibm.websphere.sib.api.jms.JmsMsgConsumer;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsConnInternals;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.impl.ConsumerProperties;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import com.ibm.wsspi.sib.pacing.MessagePacingControl;
import com.ibm.wsspi.sib.pacing.MessagePacingControlFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;

public class JmsMsgConsumerImpl
implements JmsMsgConsumer,
ApiJmsConstants,
JmsInternalConstants {
    private static TraceComponent tc = SibTr.register(JmsMsgConsumerImpl.class, "SIBJms_External", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceComponent tcInt = SibTr.register(JmsMsgConsumerImpl.class, "SIBJms_Internal", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private ConsumerSession coreConsumerSession = null;
    private Consumer consumer;
    private SICoreConnection coreConn = null;
    private boolean closed = false;
    private Object closedLock = new Object();
    private JmsSessionImpl session = null;
    private final int sessionAckMode;
    private ConsumerProperties props = null;
    private final Object sessionSyncLock;
    SelectionCriteriaFactory selectionCriteriaFactory = null;
    private String defaultBusName = null;
    static /* synthetic */ Class class$javax$jms$InvalidSelectorException;
    static /* synthetic */ Class class$java$lang$IllegalStateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JmsMsgConsumerImpl(SICoreConnection sICoreConnection, JmsSessionImpl jmsSessionImpl, ConsumerProperties consumerProperties) throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "JmsMsgConsumerImpl(SICoreConnection, JmsSessionImpl, Object, ConsumerProperties)");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "coreConnection : " + sICoreConnection);
                SibTr.debug(tcInt, "theDest : " + consumerProperties.getJmsDestination());
                SibTr.debug(tcInt, "sel : " + consumerProperties.getSelector());
                SibTr.debug(tcInt, "noL : " + consumerProperties.noLocal());
                SibTr.debug(tcInt, "newSession : " + jmsSessionImpl);
            }
            this.defaultBusName = (String)jmsSessionImpl.getPassThruProps().get("busName");
            this.props = consumerProperties;
            this.coreConn = sICoreConnection;
            this.session = jmsSessionImpl;
            this.sessionSyncLock = this.session.getSessionSyncLock();
            JmsDestination jmsDestination = this.props.getJmsDestination();
            try {
                this.selectionCriteriaFactory = SelectionCriteriaFactory.getInstance();
            }
            catch (SIErrorException sIErrorException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sIErrorException, "JmsMsgConsumerImpl.constructor"}, sIErrorException, "JmsMsgConsumerImpl.constructor#1", this, tcInt);
            }
            if (jmsDestination instanceof Topic) {
                this.props.setDestinationType(DestinationType.TOPICSPACE);
                if (this.props.supportsMultipleConsumers()) {
                    this.props.setReadAhead(false);
                } else {
                    this.props.setReadAhead(true);
                }
            } else {
                this.props.setDestinationType(DestinationType.QUEUE);
                this.props.setReadAhead(false);
            }
            String string = jmsDestination.getReadAhead();
            if ("AsConnection".equals(string)) {
                Map map;
                String string2;
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Inherit readAhead from Connection");
                }
                if ("Default".equals(string2 = (String)(map = this.session.getPassThruProps()).get("readAhead"))) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Connection said keep defaults");
                    }
                } else {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Connection explicitly set readAhead: " + string);
                    }
                    if ("AlwaysOn".equals(string2)) {
                        this.props.setReadAhead(true);
                    } else {
                        this.props.setReadAhead(false);
                    }
                }
            } else {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Destination explicitly set readAhead: " + string);
                }
                if ("AlwaysOn".equals(string)) {
                    this.props.setReadAhead(true);
                } else {
                    this.props.setReadAhead(false);
                }
            }
            this.sessionAckMode = this.session.getAcknowledgeMode();
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "acknowledge mode: " + this.sessionAckMode);
            }
            this.props.setReliability(Reliability.ASSURED_PERSISTENT);
            boolean bl = true;
            if (this.sessionAckMode == 1 || this.sessionAckMode == 3) {
                bl = false;
            }
            this.props.setRecovExpress(bl);
            this.coreConsumerSession = this.createCoreConsumer(this.coreConn, this.props);
            if (this.session.getState() == 2) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Start consumer because connection was already started.");
                }
                this.start();
            } else {
                this.stop();
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "JmsMsgConsumerImpl(SICoreConnection, JmsSessionImpl, Object, ConsumerProperties)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsMsgConsumerImpl(SICoreConnection, JmsSessionImpl, Object, ConsumerProperties)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageSelector() throws JMSException {
        String string;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getMessageSelector()");
            }
            this.checkClosed();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "return String : " + this.props.getSelector());
            }
            string = this.props.getSelector();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block5;
                SibTr.exit(tc, "getMessageSelector()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMessageSelector()");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageListener getMessageListener() throws JMSException {
        MessageListener messageListener;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getMessageListener()");
            }
            this.checkClosed();
            if (this.session.isManaged()) {
                throw (javax.jms.IllegalStateException)JmsErrorUtils.newThrowable(javax.jms.IllegalStateException.class, "MGD_ENV_CWSIA0084", new Object[]{"MessageConsumer.getMessageListener"}, tc);
            }
            MessageListener messageListener2 = null;
            if (this.consumer != null) {
                messageListener2 = this.consumer.getMessageListener();
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "return MessageListener : " + messageListener2);
            }
            messageListener = messageListener2;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var4_4 = null;
                if (!tc.isEntryEnabled()) break block7;
                SibTr.exit(tc, "getMessageListener()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMessageListener()");
        }
        return messageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAsyncListener(MessageListener messageListener) throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setAsyncListener(MessageListener)");
            }
            this.consumer = new Consumer(messageListener, this.session, this.sessionAckMode);
            try {
                this.coreConsumerSession.stop();
                int n = 1;
                boolean bl = false;
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Registering async callback;");
                    SibTr.debug(tcInt, "                  consumer:" + this.consumer);
                    SibTr.debug(tcInt, "                 batchSize:" + n);
                    SibTr.debug(tcInt, "        deliverImmediately:" + bl);
                }
                this.coreConsumerSession.registerAsynchConsumerCallback(this.consumer, 0, 0L, n, this.session.getOrderingContext());
                if (this.session.getState() == 2) {
                    this.coreConsumerSession.start(bl);
                }
            }
            catch (SIIncorrectCallException sIIncorrectCallException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sIIncorrectCallException, "JmsMsgConsumerImpl.setAsyncListener"}, sIIncorrectCallException, "JmsMsgConsumerImpl.setAsyncListener#1", this, tc);
            }
            catch (SIException sIException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sIException, "JmsMsgConsumerImpl.setAsyncListener"}, sIException, null, this, tc);
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setAsyncListener(MessageListener)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setAsyncListener(MessageListener)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setMessageListener(MessageListener)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "listener: " + messageListener);
            }
            Object object = this.sessionSyncLock;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "got lock");
                }
                this.checkClosed();
                if (this.session.isManaged()) {
                    InvocationHandler invocationHandler;
                    String string;
                    boolean bl = true;
                    if (this.sessionAckMode == 1 && messageListener instanceof Proxy && (string = (invocationHandler = Proxy.getInvocationHandler(messageListener)).getClass().getName()).startsWith("com.ibm")) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "async beans, listener accepted");
                        }
                        bl = false;
                    }
                    if (bl) {
                        throw (javax.jms.IllegalStateException)JmsErrorUtils.newThrowable(javax.jms.IllegalStateException.class, "MGD_ENV_CWSIA0084", new Object[]{"MessageConsumer.setMessageListener"}, tc);
                    }
                }
                if (messageListener == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "application has asked to deregister listener");
                    }
                    this.removeAsyncListener();
                    this.session.registerSyncConsumer(this);
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "application has supplied a listener to register");
                    }
                    this.setAsyncListener(messageListener);
                    this.session.registerAsyncConsumer(this);
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setMessageListener(MessageListener)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setMessageListener(MessageListener)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receive() throws JMSException {
        Message message = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "receive()");
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            Message message2;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "got lock");
            }
            try {
                this.checkClosed();
                this.session.checkSynchronousUsage("receive");
                message = this.receiveInboundMessage(true, 0L);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return Message : " + message);
                }
                message2 = message;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit(tc, "receive()");
                throw throwable;
            }
            if (!tc.isEntryEnabled()) return message2;
            SibTr.exit(tc, "receive()");
            return message2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receive(long l) throws JMSException {
        Message message = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "receive(long)");
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            Message message2;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "got lock");
            }
            try {
                this.checkClosed();
                this.session.checkSynchronousUsage("receive");
                message = this.receiveInboundMessage(true, l);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return Message : " + message);
                }
                message2 = message;
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit(tc, "receive(long)");
                throw throwable;
            }
            if (!tc.isEntryEnabled()) return message2;
            SibTr.exit(tc, "receive(long)");
            return message2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receiveNoWait() throws JMSException {
        Message message = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "receiveNoWait()");
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            Message message2;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "got lock");
            }
            try {
                this.checkClosed();
                this.session.checkSynchronousUsage("receiveNoWait");
                if (this.session.getState() == 2) {
                    message = this.receiveInboundMessage(false, -1L);
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "consumer not started");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return: " + message);
                }
                message2 = message;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit(tc, "receiveNoWait()");
                throw throwable;
            }
            if (!tc.isEntryEnabled()) return message2;
            SibTr.exit(tc, "receiveNoWait()");
            return message2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emergencyClose() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "emergencyClose");
        }
        try {
            if (this.coreConsumerSession != null) {
                this.coreConsumerSession.close();
            }
        }
        catch (SIException sIException) {
            JmsErrorUtils.processThrowable(sIException, "JmsMsgConsumerImpl.emergencyClose#1", this, tcInt);
        }
        finally {
            this.coreConsumerSession = null;
            this.closed = true;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "emergencyClose");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "close()");
            }
            Object object = this.closedLock;
            synchronized (object) {
                if (!this.closed) {
                    this.stop();
                    if (this.coreConsumerSession != null) {
                        try {
                            this.coreConsumerSession.close();
                        }
                        catch (SIException sIException) {
                            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sIException, "JmsMsgConsumerImpl.close"}, sIException, null, this, tc);
                        }
                        this.coreConsumerSession = null;
                        this.consumer = null;
                    }
                    this.session.removeConsumer(this);
                    this.closed = true;
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "already closed");
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "close()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getDestination() throws JMSException {
        JmsDestination jmsDestination;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getDestination()");
            }
            this.checkClosed();
            JmsDestination jmsDestination2 = this.props.getJmsDestination();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "return Destination : " + jmsDestination2);
            }
            jmsDestination = jmsDestination2;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (!tc.isEntryEnabled()) break block5;
                SibTr.exit(tc, "getDestination()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDestination()");
        }
        return jmsDestination;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ConsumerSession createCoreConsumer(SICoreConnection sICoreConnection, ConsumerProperties consumerProperties) throws JMSException {
        Object object;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "createCoreConsumer()");
            }
            JmsDestinationImpl jmsDestinationImpl = (JmsDestinationImpl)consumerProperties.getJmsDestination();
            ConsumerSession consumerSession = null;
            try {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "   destName: " + jmsDestinationImpl.getConsumerDestName());
                    SibTr.debug(tcInt, "       type: " + consumerProperties.getDestinationType());
                    SibTr.debug(tcInt, "    discrim: " + jmsDestinationImpl.getDestDiscrim());
                    SibTr.debug(tcInt, "   selector: " + consumerProperties.getSelector());
                    SibTr.debug(tcInt, "reliability: " + consumerProperties.getReliability());
                    SibTr.debug(tcInt, "    noLocal: " + consumerProperties.noLocal());
                    SibTr.debug(tcInt, " unrecovRel: " + consumerProperties.getUnrecovReliability());
                }
                SelectionCriteria selectionCriteria = null;
                SIDestinationAddress sIDestinationAddress = null;
                try {
                    selectionCriteria = this.selectionCriteriaFactory.createSelectionCriteria(jmsDestinationImpl.getDestDiscrim(), consumerProperties.getSelector(), SelectorDomain.JMS);
                    object = jmsDestinationImpl.getConsumerSIDestinationAddress();
                    sIDestinationAddress = JmsMessageImpl.destAddressFactory.createSIDestinationAddress(object.getDestinationName(), object.getBusName());
                }
                catch (SIErrorException sIErrorException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sIErrorException, "JmsMsgConsumerImpl.createCoreConsumer"}, sIErrorException, "JmsMsgConsumerImpl.createCoreConsumer#1", this, tcInt);
                }
                consumerSession = sICoreConnection.createConsumerSession(sIDestinationAddress, consumerProperties.getDestinationType(), selectionCriteria, consumerProperties.getReliability(), consumerProperties.readAhead(), consumerProperties.noLocal(), consumerProperties.getUnrecovReliability(), false, null);
                object = consumerSession;
            }
            catch (SISelectorSyntaxException sISelectorSyntaxException) {
                Class clazz;
                if (class$javax$jms$InvalidSelectorException == null) {
                    clazz = class$javax$jms$InvalidSelectorException = JmsMsgConsumerImpl.class$("javax.jms.InvalidSelectorException");
                    throw (InvalidSelectorException)JmsErrorUtils.newThrowable(clazz, "INVALID_SELECTOR_CWSIA0083", null, sISelectorSyntaxException, null, this, tcInt);
                }
                clazz = class$javax$jms$InvalidSelectorException;
                throw (InvalidSelectorException)JmsErrorUtils.newThrowable(clazz, "INVALID_SELECTOR_CWSIA0083", null, sISelectorSyntaxException, null, this, tcInt);
            }
            catch (SINotAuthorizedException sINotAuthorizedException) {
                throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "CONSUMER_AUTH_ERROR_CWSIA0090", new Object[]{jmsDestinationImpl.getDestName()}, sINotAuthorizedException, null, this, tcInt);
            }
            catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                String string = "MC_CREATE_FAILED_CWSIA0086";
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, string, new Object[]{jmsDestinationImpl}, sINotPossibleInCurrentConfigurationException, null, this, tcInt);
            }
            catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
                String string = "MC_CREATE_FAILED_CWSIA0086";
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, string, new Object[]{jmsDestinationImpl}, sITemporaryDestinationNotFoundException, null, this, tcInt);
            }
            catch (SIIncorrectCallException sIIncorrectCallException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sIIncorrectCallException, "JmsMsgConsumerImpl.createCoreConsumer"}, sIIncorrectCallException, "JmsMsgConsumerImpl.createCoreConsumer#6", this, tcInt);
            }
            catch (SIException sIException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sIException, "JmsMsgConsumerImpl.createCoreConsumer"}, sIException, null, this, tcInt);
            }
            Object var9_17 = null;
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            if (!tcInt.isEntryEnabled()) throw throwable;
            SibTr.exit(tcInt, "createCoreConsumer()");
            throw throwable;
        }
        if (!tcInt.isEntryEnabled()) return object;
        SibTr.exit(tcInt, "createCoreConsumer()");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "start()");
            }
            if (this.coreConsumerSession != null) {
                try {
                    this.coreConsumerSession.start(false);
                }
                catch (SIException sIException) {
                    JMSException jMSException = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sIException, "JmsMsgConsumerImpl.start"}, sIException, null, this, tcInt);
                    throw jMSException;
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "start()");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "start()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "stop()");
            }
            if (this.coreConsumerSession != null) {
                try {
                    this.coreConsumerSession.stop();
                }
                catch (SIException sIException) {
                    JMSException jMSException = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sIException, "JmsMsgConsumerImpl.stop"}, sIException, null, this, tcInt);
                    throw jMSException;
                }
            } else if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "coreConsumerSession is null, already closed ?");
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "stop()");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "stop()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClosed() throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "checkClosed()");
            }
            Object object = this.closedLock;
            synchronized (object) {
                if (this.closed) {
                    throw (JMSException)JmsErrorUtils.newThrowable(javax.jms.IllegalStateException.class, "CONSUMER_CLOSED_CWSIA0081", null, tcInt);
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "checkClosed()");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "checkClosed()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAsyncListener() throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "removeAsyncListener()");
            }
            if (this.consumer != null) {
                try {
                    this.coreConsumerSession.stop();
                    this.coreConsumerSession.deregisterAsynchConsumerCallback();
                    if (this.session.getState() == 2) {
                        this.coreConsumerSession.start(false);
                    }
                    this.consumer = null;
                }
                catch (SIIncorrectCallException sIIncorrectCallException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sIIncorrectCallException, "JmsMsgConsumerImpl.removeAsyncListener"}, sIIncorrectCallException, "JmsMsgConsumerImpl.removeASyncListener#1", this, tcInt);
                }
                catch (SIException sIException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sIException, "JmsMsgConsumerImpl.removeAsyncListener"}, sIException, null, this, tcInt);
                }
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "removeAsyncListener()");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "removeAsyncListener()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getNolocal() throws JMSException {
        boolean bl;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "getNoLocal()");
            }
            this.checkClosed();
            boolean bl2 = this.props.noLocal();
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "return boolean : " + bl2);
            }
            bl = bl2;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (!tc.isEntryEnabled()) break block5;
                SibTr.exit(tcInt, "getNoLocal()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tcInt, "getNoLocal()");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveInboundMessage(boolean bl, long l) throws JMSException {
        Object object;
        Message message = null;
        String string = null;
        String string2 = null;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "receiveInboundMessage(boolean, long)");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "waiting : " + bl);
                SibTr.debug(tcInt, "timeout : " + l);
            }
            SITransaction sITransaction = this.session.getTransaction();
            SIBusMessage sIBusMessage = null;
            MessagePacingControl messagePacingControl = MessagePacingControlFactory.getInstance();
            if (messagePacingControl != null && messagePacingControl.isActive()) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "about to call preSynchReceive");
                }
                object = this.coreConsumerSession;
                string = this.coreConsumerSession.getDestinationAddress().getBusName();
                if (string == null) {
                    string = this.defaultBusName;
                }
                string2 = this.coreConsumerSession.getDestinationAddress().getDestinationName();
                if (bl) {
                    l = messagePacingControl.preSynchReceive(string, string2, object, l);
                } else {
                    messagePacingControl.preSynchReceive(string, string2, object, -1L);
                }
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "preSynchReceive complete");
                }
            }
            try {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "About to call receive method;");
                    SibTr.debug(tcInt, " transaction: " + sITransaction);
                    if (bl) {
                        SibTr.debug(tcInt, "     timeout: " + l);
                    }
                    if (this.session.getState() != 2) {
                        SibTr.debug(tcInt, "WARNING - APPLICATION CALLED RECEIVE BUT CONNECTION IS NOT STARTED");
                    }
                }
                if (bl) {
                    sIBusMessage = this.coreConsumerSession.receiveWithWait(sITransaction, l);
                    if (sIBusMessage == null && this.session.getState() != 2) {
                        object = new Exception();
                        StackTraceElement[] stackTraceElementArray = ((Throwable)object).getStackTrace();
                        String string3 = stackTraceElementArray.length < 3 ? "<Unknown Caller>" : stackTraceElementArray[2].toString();
                        SibTr.warning(tc, "MC_CONN_STOPPED_CWSIA0087", string3);
                    }
                } else {
                    sIBusMessage = this.coreConsumerSession.receiveNoWait(sITransaction);
                }
                if ((message = JmsInternalsFactory.getSharedUtils().inboundMessagePath(sIBusMessage, this.session)) != null && ((JmsMessageImpl)message).getMsgReference().getJmsDestination() == null && !((JmsDestinationImpl)(object = (JmsDestinationImpl)this.props.getJmsDestination()))._getInhibitJMSDestination()) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "This message was not sent by a JMS client, and so has no JmsDestination field set");
                        SibTr.debug(tcInt, "Setting JMS Destination to " + this.props.getJmsDestination().getDestName());
                    }
                    message.setJMSDestination((Destination)object);
                }
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "sessionAckMode : " + this.sessionAckMode);
                }
                if (message != null && sITransaction != null) {
                    this.session.notifyMessageConsumed(sITransaction);
                }
            }
            catch (SISessionUnavailableException sISessionUnavailableException) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "caught SISessionUnavailableException: " + sISessionUnavailableException);
                }
            }
            catch (SIException sIException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INBOUND_MSG_ERROR_CWSIA0103", new Object[]{sIException}, sIException, null, this, tcInt);
            }
            if (messagePacingControl != null && messagePacingControl.isActive()) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "about to call postSynchReceive");
                }
                object = this.coreConsumerSession;
                boolean bl2 = message != null;
                messagePacingControl.postSynchReceive(string, string2, object, bl2);
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "postSynchReceive complete");
                }
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "returns: " + message);
            }
            object = message;
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            block29: {
                Object var14_16 = null;
                if (!tcInt.isEntryEnabled()) break block29;
                SibTr.exit(tcInt, "receiveInboundMessage(boolean, long)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "receiveInboundMessage(boolean, long)");
        }
        return object;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsMsgConsumerImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.124.1.2");
        }
    }

    private class Consumer
    implements AsynchConsumerCallback {
        private MessageListener listener = null;
        private Object sessionLock = null;
        private JmsConnInternals excTarget = null;
        private JmsSessionImpl session = null;
        private int sessionAckMode = -1;

        public Consumer(MessageListener messageListener, JmsSessionImpl jmsSessionImpl, int n) {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "Consumer(MessageListener, JmsSessionImpl, int)");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "newListener : " + messageListener);
                SibTr.debug(tcInt, "theSession : " + jmsSessionImpl);
                SibTr.debug(tcInt, "theSessionAckMode : " + n);
            }
            this.listener = messageListener;
            this.sessionLock = jmsSessionImpl.getAsyncDeliveryLock();
            this.excTarget = (JmsConnInternals)jmsSessionImpl.getConnection();
            this.session = jmsSessionImpl;
            this.sessionAckMode = n;
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "sessionLock : " + this.sessionLock);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "Consumer(MessageListener, JmsSessionImpl, int)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) {
            Object object;
            int n;
            Message message;
            block69: {
                if (tcInt.isEntryEnabled()) {
                    SibTr.entry(tcInt, "Consumer.consumeMessages(LockedMessageEnumeration)");
                }
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "lme : " + lockedMessageEnumeration);
                }
                message = null;
                try {
                    n = lockedMessageEnumeration.getRemainingMessageCount();
                    if (n != 1) {
                        String string = "INTERNAL_ERROR_CWSIA0499";
                        throw (IllegalStateException)JmsErrorUtils.newThrowable(class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = JmsMsgConsumerImpl.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException, string, new Object[]{"lme.messageCount", new Integer(n)}, tcInt);
                    }
                    object = lockedMessageEnumeration.nextLocked();
                    message = JmsInternalsFactory.getSharedUtils().inboundMessagePath((SIBusMessage)object, this.session);
                }
                catch (SIException sIException) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "Exception obtaining message from ConsumerSession (async)", sIException);
                    }
                    try {
                        object = lockedMessageEnumeration.getConsumerSession();
                        if (object != null) {
                            object.unlockAll();
                        } else {
                            if (tcInt.isDebugEnabled()) {
                                SibTr.debug(tcInt, "couldn't get ConsumerSession, closing");
                            }
                            JmsMsgConsumerImpl.this.emergencyClose();
                        }
                    }
                    catch (SIException sIException2) {
                        if (tcInt.isDebugEnabled()) {
                            SibTr.debug(tcInt, "Exception trying to unlock the lme, closing", sIException2);
                        }
                        JmsMsgConsumerImpl.this.emergencyClose();
                    }
                    object = (JMSException)JmsErrorUtils.newThrowable(class$javax$jms$JMSException == null ? (class$javax$jms$JMSException = JmsMsgConsumerImpl.class$("javax.jms.JMSException")) : class$javax$jms$JMSException, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{sIException, "Consumer.consumeMessages"}, sIException, "JmsMsgConsumerImpl.Consumer.consumeMessages#1", this, tcInt);
                    if (this.excTarget != null) {
                        this.excTarget.reportException((JMSException)((Object)object));
                    }
                }
                catch (JMSException jMSException) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "exception caught ", (Object)jMSException);
                    }
                    try {
                        object = lockedMessageEnumeration.getConsumerSession();
                        if (object != null) {
                            object.unlockAll();
                        } else {
                            if (tcInt.isDebugEnabled()) {
                                SibTr.debug(tcInt, "couldn't get ConsumerSession, closing");
                            }
                            JmsMsgConsumerImpl.this.emergencyClose();
                        }
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"JmsMsgConsumerImpl.Consumer.consumeMessages", (String)"consumeMessages#2", (Object)this);
                        if (tcInt.isDebugEnabled()) {
                            SibTr.debug(tcInt, "Exception trying to unlock the lme, closing", sIException);
                        }
                        JmsMsgConsumerImpl.this.emergencyClose();
                    }
                    if (this.excTarget == null) break block69;
                    this.excTarget.reportException(jMSException);
                }
            }
            if (message != null) {
                Object object2 = this.sessionLock;
                synchronized (object2) {
                    block70: {
                        if (this.session.isManaged()) {
                            if (tcInt.isDebugEnabled()) {
                                SibTr.debug(tcInt, "async beans: using null trans");
                            }
                            object = null;
                        } else {
                            try {
                                object = this.session.getTransaction();
                            }
                            catch (JMSException jMSException) {
                                if (tcInt.isDebugEnabled()) {
                                    SibTr.debug(tcInt, "unrecoverable error, attempting to close this messageConsumer");
                                }
                                JmsMsgConsumerImpl.this.emergencyClose();
                                if (this.excTarget != null) {
                                    this.excTarget.reportException(jMSException);
                                }
                                return;
                            }
                        }
                        try {
                            if (object != null) {
                                if (tcInt.isDebugEnabled()) {
                                    SibTr.debug(tcInt, "Delete under transaction: " + object);
                                }
                                lockedMessageEnumeration.deleteCurrent((SITransaction)object);
                            }
                            this.session.notifyMessagePreConsume((SITransaction)object);
                            boolean bl = false;
                            if (tcInt.isDebugEnabled()) {
                                SibTr.debug(tcInt, "Invoke app onMessage");
                            }
                            try {
                                this.listener.onMessage(message);
                                if (tcInt.isDebugEnabled()) {
                                    SibTr.debug(tcInt, "app onMessage complete");
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                bl = true;
                                try {
                                    ConsumerSession consumerSession;
                                    if (this.sessionAckMode == 3) {
                                        this.session.rollbackTransaction();
                                    }
                                    if ((consumerSession = lockedMessageEnumeration.getConsumerSession()) != null) {
                                        consumerSession.unlockAll();
                                    } else {
                                        if (tcInt.isDebugEnabled()) {
                                            SibTr.debug(tcInt, "couldn't get ConsumerSession, closing");
                                        }
                                        JmsMsgConsumerImpl.this.close();
                                    }
                                    JMSException jMSException = (JMSException)JmsErrorUtils.newThrowable(class$javax$jms$JMSException == null ? (class$javax$jms$JMSException = JmsMsgConsumerImpl.class$("javax.jms.JMSException")) : class$javax$jms$JMSException, "ML_THREW_EXCPTN_CWSIA0089", null, runtimeException, "JmsMsgConsumerImpl.Consumer.consumeMessages#4", this, tcInt);
                                    if (this.excTarget != null) {
                                        this.excTarget.reportException(jMSException);
                                    }
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, (String)"JmsMsgConsumerImpl.Consumer.consumeMessages", (String)"consumeMessages#7", (Object)this);
                                    if (tcInt.isDebugEnabled()) {
                                        SibTr.debug(tcInt, "Exception in tidyup after failed onMessage, closing", exception);
                                    }
                                    JmsMsgConsumerImpl.this.emergencyClose();
                                }
                            }
                            if (!bl) {
                                if (this.sessionAckMode == 3) {
                                    this.session.notifyMessagePostConsume();
                                }
                                if (object == null) {
                                    int n2 = this.session.getAndResetCommitCount();
                                    if (n2 == 0) {
                                        if (tcInt.isDebugEnabled()) {
                                            SibTr.debug(tcInt, "onMessage called recover");
                                        }
                                        lockedMessageEnumeration.getConsumerSession().unlockAll();
                                    } else {
                                        if (tcInt.isDebugEnabled()) {
                                            SibTr.debug(tcInt, "Delete without transaction");
                                        }
                                        lockedMessageEnumeration.deleteCurrent(null);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            JMSException jMSException = (JMSException)JmsErrorUtils.newThrowable(class$javax$jms$JMSException == null ? (class$javax$jms$JMSException = JmsMsgConsumerImpl.class$("javax.jms.JMSException")) : class$javax$jms$JMSException, "EXCEPTION_RECEIVED_CWSIA0085", new Object[]{exception, "Consumer.consumeMessages"}, exception, "JmsMsgConsumerImpl.Consumer.consumeMessages#6", this, tcInt);
                            if (tcInt.isDebugEnabled()) {
                                SibTr.debug(tcInt, "closing");
                            }
                            JmsMsgConsumerImpl.this.emergencyClose();
                            if (this.excTarget == null) break block70;
                            this.excTarget.reportException(jMSException);
                        }
                    }
                }
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "inbound JMS message is null - not passing to onMessage");
            }
            n = this.session.getState();
            switch (n) {
                case 3: {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "session closed/closing, stopping this async consumer");
                    }
                    try {
                        JmsMsgConsumerImpl.this.stop();
                    }
                    catch (JMSException jMSException) {
                        if (!tcInt.isDebugEnabled()) break;
                        SibTr.debug(tcInt, "ignoring exception thrown by stop during close optimisation", (Object)jMSException);
                    }
                    break;
                }
                case 1: {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug(tcInt, "session stopped, so stopping this async consumer");
                    }
                    try {
                        JmsMsgConsumerImpl.this.stop();
                        break;
                    }
                    catch (JMSException jMSException) {
                        if (tcInt.isDebugEnabled()) {
                            SibTr.debug(tcInt, "Exception thrown by stop during stop optimisation", (Object)jMSException);
                        }
                        if (this.excTarget == null) break;
                        this.excTarget.reportException(jMSException);
                    }
                }
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "Consumer.consumeMessages(LockedMessageEnumeration)");
            }
        }

        public MessageListener getMessageListener() {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "Consumer.getMessageListener()");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "returns MessageListener : " + this.listener);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "Consumer.getMessageListener()");
            }
            return this.listener;
        }
    }
}

