/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.impl.JmsBytesMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMapMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsObjectMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsQueueImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsStreamMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTextMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicImpl;
import com.ibm.ws.sib.api.jms.impl.ReportMessageConverter;
import com.ibm.ws.sib.mfp.JmsBodyType;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsMessageFactory;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.PersistenceType;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.DestinationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class JmsMessageImpl
implements Message,
JmsInternalConstants,
Serializable {
    private static final long serialVersionUID = 7645122120151618834L;
    private transient Destination dest = null;
    private transient Destination replyTo = null;
    private JsJmsMessage msg;
    private transient JmsSessionImpl theSession = null;
    protected static JsJmsMessageFactory jmfact = null;
    protected static SIDestinationAddressFactory destAddressFactory = null;
    private boolean bodyReadOnly = false;
    private boolean propertiesReadOnly = false;
    private static Hashtable JMS_IBM_props = null;
    private static Set localStorePropertyNames = null;
    private Hashtable locallyStoredPropertyValues = null;
    private String localJMSMessageID = null;
    private transient String cachedToString = null;
    protected String messageClass = null;
    private transient Object sessionSyncLock;
    private static TraceComponent tc = Tr.register((Class)JmsMessageImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceComponent tcInt = Tr.register((Class)JmsMessageImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    private static void obtainMFPFactory() throws JMSException {
        if (jmfact == null) {
            try {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Retrieving reference to MFP factory.");
                }
                jmfact = JsJmsMessageFactory.getInstance();
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Retrieving reference to DestinationAddress factory.");
                }
                destAddressFactory = SIDestinationAddressFactory.getInstance();
            }
            catch (Exception exception) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Exception getting MFP factory", exception);
                }
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "JmsMessageImpl");
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INITIALIZATION_ERROR_CWSIA0002", new Object[]{exception}, exception, "JmsMessageImpl.obtainMFPFactory#1", JmsMessageImpl.class, tcInt);
            }
        }
    }

    public JmsMessageImpl() throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsMessageImpl");
        }
        JmsMessageImpl.obtainMFPFactory();
        JsJmsMessage jsJmsMessage = null;
        try {
            jsJmsMessage = this.instantiateMessage();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tcInt, "Exception creating message", exception);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "JmsMessageImpl");
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MSG_CREATE_FAILED_CWSIA0111", null, exception, "JmsMessageImpl.<init>#2", this, tcInt);
        }
        this.setMsgReference(jsJmsMessage);
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsMessageImpl");
        }
    }

    JmsMessageImpl(JsJmsMessage jsJmsMessage, JmsSessionImpl jmsSessionImpl) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsMessageImpl(JsJmsMessage, JmsSessionImpl)");
        }
        this.setMsgReference(jsJmsMessage);
        this.theSession = jmsSessionImpl;
        if (jmsSessionImpl != null) {
            this.sessionSyncLock = jmsSessionImpl.getSessionSyncLock();
        }
        this.messageClass = "jms_none";
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsMessageImpl(JsJmsMessage, JmsSessionImpl)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JmsMessageImpl(Message message) throws JMSException {
        this();
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "JmsMessageImpl(Message)");
            }
            this.setJMSCorrelationID(message.getJMSCorrelationID());
            this.setJMSReplyTo(message.getJMSReplyTo());
            this.setJMSType(message.getJMSType());
            Enumeration enumeration = message.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = message.getObjectProperty(string);
                try {
                    this.setObjectProperty(string, object);
                }
                catch (Exception exception) {}
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "JmsMessageImpl(Message)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsMessageImpl(Message)");
        }
    }

    public String getJMSMessageID() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJMSMessageID");
        }
        String string = null;
        string = this.localJMSMessageID == null ? this.msg.getApiMessageId() : this.localJMSMessageID;
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "messageID: " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJMSMessageID");
        }
        return string;
    }

    public void setJMSMessageID(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setJMSMessageID");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "newId: " + string);
        }
        this.localJMSMessageID = string;
        this.cachedToString = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setJMSMessageID");
        }
    }

    public long getJMSTimestamp() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJMSTimestamp");
        }
        Long l = this.msg.getTimestamp();
        long l2 = 0L;
        l2 = l != null ? l : 0L;
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "timestamp: " + l2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJMSTimestamp");
        }
        return l2;
    }

    public void setJMSTimestamp(long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setJMSTimestamp");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "timestamp: " + l);
        }
        this.msg.setTimestamp(l);
        this.cachedToString = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setJMSTimestamp");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJMSCorrelationIDAsBytes");
        }
        try {
            try {
                byArray = this.msg.getCorrelationIdAsBytes();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0115", new Object[]{illegalArgumentException, "JmsMessageImpl.getCorrelationIdAsBytes"}, illegalArgumentException, "JmsMessageImpl.getJMSCorrelationIDAsBytes#1", this, tc);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setJMSCorrelationID");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setJMSCorrelationID");
        }
        if (tc.isDebugEnabled()) {
            SibTr.bytes(tc, byArray);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJMSCorrelationIDAsBytes");
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setJMSCorrelationIDAsBytes");
        }
        if (tc.isDebugEnabled()) {
            SibTr.bytes(tc, byArray);
        }
        try {
            try {
                this.msg.setCorrelationIdAsBytes(byArray);
                this.cachedToString = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0116", new Object[]{"JMSCorrelationID", byArray}, illegalArgumentException, null, this, tc);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setJMSCorrelationID");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setJMSCorrelationID");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setJMSCorrelationIDAsBytes");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setJMSCorrelationID(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setJMSCorrelationID");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "correl: " + string);
        }
        try {
            try {
                this.msg.setCorrelationId(string);
                this.cachedToString = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0116", new Object[]{"JMSCorrelationID", string}, illegalArgumentException, null, this, tc);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "setJMSCorrelationID");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "setJMSCorrelationID");
    }

    public String getJMSCorrelationID() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJMSCorrelationID");
        }
        String string = this.msg.getCorrelationId();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "correl: " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJMSCorrelationID");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getJMSReplyTo() throws JMSException {
        Object object;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getJMSReplyTo()");
            }
            if (this.replyTo == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "There is no cached replyTo dest");
                }
                object = this.msg.getJmsReplyTo();
                JmsDestinationImpl jmsDestinationImpl = null;
                if (object != null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Retrieved bytes from getJmsReplyTo");
                    }
                    jmsDestinationImpl = (JmsDestinationImpl)JmsInternalsFactory.getMessageDestEncodingUtils().getDestinationFromMsgRepresentation((byte[])object);
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Null was returned by getJmsReplyTo");
                }
                if (jmsDestinationImpl == null) {
                    List list = this.msg.getReverseRoutingPath();
                    SIDestinationAddress sIDestinationAddress = null;
                    if (list.size() > 0) {
                        Object object2;
                        block20: {
                            int n = list.size() - 1;
                            sIDestinationAddress = (SIDestinationAddress)list.get(n);
                            if (this.theSession != null) {
                                try {
                                    DestinationConfiguration destinationConfiguration;
                                    DestinationType destinationType;
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug(tc, "Determine reply dest type using SICoreConnection");
                                    }
                                    jmsDestinationImpl = (destinationType = (destinationConfiguration = (object2 = this.theSession.getCoreConnection()).getDestinationConfiguration(sIDestinationAddress)).getDestinationType()) == DestinationType.TOPICSPACE ? new JmsTopicImpl() : new JmsQueueImpl();
                                }
                                catch (SIException sIException) {
                                    if (!tc.isDebugEnabled()) break block20;
                                    SibTr.debug(tc, "failed to look up dest type because of " + sIException);
                                    SibTr.debug(tc, "detail ", sIException);
                                }
                            }
                        }
                        if (jmsDestinationImpl == null) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(tc, "Guess reply dest type using reply discriminator");
                            }
                            jmsDestinationImpl = (object2 = this.msg.getReplyDiscriminator()) == null || "".equals(object2) ? new JmsQueueImpl() : new JmsTopicImpl();
                        }
                    }
                }
                if (jmsDestinationImpl != null) {
                    this.populateReplyToFromHeader(jmsDestinationImpl);
                }
                this.replyTo = jmsDestinationImpl;
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "returning replyTo : " + this.replyTo);
            }
            object = this.replyTo;
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            block21: {
                Object var10_11 = null;
                if (!tc.isEntryEnabled()) break block21;
                SibTr.exit(tc, "getJMSReplyTo()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJMSReplyTo()");
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setJMSReplyTo(Destination destination) throws JMSException {
        try {
            try {
                if (tc.isEntryEnabled()) {
                    SibTr.entry(tc, "setJMSReplyTo(Destination)");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "destination : " + destination);
                }
                this.replyTo = destination;
                if (destination instanceof JmsDestinationImpl) {
                    this.setReplyHeader((JmsDestinationImpl)this.replyTo);
                    this.msg.setJmsReplyTo(((JmsDestinationImpl)destination).partialEncodeToBytes());
                }
                this.setReplyHeader(null);
                this.msg.setJmsReplyTo(null);
            }
            catch (JMSException jMSException) {
                if (!tc.isDebugEnabled()) throw jMSException;
                SibTr.debug(tc, "passing on exception ", (Object)jMSException);
                throw jMSException;
            }
            Object var4_2 = null;
            this.cachedToString = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.cachedToString = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "setJMSReplyTo(Destination)");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "setJMSReplyTo(Destination)");
    }

    public Destination getJMSDestination() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJMSDestination()");
        }
        if (this.dest == null) {
            byte[] byArray;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "There is no cached destination");
            }
            if ((byArray = this.msg.getJmsDestination()) != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "byte[] was retrieve from getJmsDestination");
                }
                this.dest = JmsInternalsFactory.getMessageDestEncodingUtils().getDestinationFromMsgRepresentation(byArray);
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "null was returned by getJmsDestination");
                }
                this.dest = null;
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "destination : " + this.dest);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJMSDestination()");
        }
        return this.dest;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setJMSDestination(Destination)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "destination : " + destination);
        }
        this.setDestReference(destination);
        if (destination instanceof JmsDestinationImpl) {
            this.msg.setJmsDestination(((JmsDestinationImpl)destination).fullEncodeToBytes());
        } else {
            this.msg.uncheckedSetForwardRoutingPath(null);
            this.msg.setJmsDestination(null);
        }
        this.cachedToString = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setJMSDestination(Destination)");
        }
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJMSDeliveryMode");
        }
        PersistenceType persistenceType = this.msg.getJmsDeliveryMode();
        int n = 0;
        if (persistenceType == PersistenceType.PERSISTENT) {
            n = 2;
        } else if (persistenceType == PersistenceType.NON_PERSISTENT) {
            n = 1;
        } else if (persistenceType == PersistenceType.UNKNOWN) {
            n = 1;
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0499", new Object[]{"JMSDeliveryMode", persistenceType}, null, "JmsMessageImpl.getJMSDeliveryMode#1", this, tc);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "dm: " + n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJMSDeliveryMode");
        }
        return n;
    }

    public void setJMSDeliveryMode(int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setJMSDeliveryMode");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "newDM: " + n);
        }
        switch (n) {
            case 1: {
                this.msg.setJmsDeliveryMode(PersistenceType.NON_PERSISTENT);
                break;
            }
            case 2: {
                this.msg.setJmsDeliveryMode(PersistenceType.PERSISTENT);
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Invalid value");
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "setJMSDeliveryMode");
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0116", new Object[]{"JMSDeliveryMode", String.valueOf(n)}, tc);
            }
        }
        this.cachedToString = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setJMSDeliveryMode");
        }
    }

    public boolean getJMSRedelivered() throws JMSException {
        Boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJMSRedelivered");
        }
        if ((bl = this.msg.getJmsRedelivered()) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Property was not set.");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getJMSRedelivered");
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "PROPERTY_NOT_SET_CWSIA0101", new Object[]{"JMSRedelivered"}, tc);
        }
        boolean bl2 = bl;
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "redelivered: " + bl2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJMSRedelivered");
        }
        return bl2;
    }

    public void setJMSRedelivered(boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setJMSRedelivered");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "redelivered: " + bl);
        }
        if (!bl) {
            this.msg.setRedeliveredCount(0);
        } else {
            this.msg.setRedeliveredCount(1);
        }
        this.cachedToString = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setJMSRedelivered");
        }
    }

    public String getJMSType() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJMSType");
        }
        String string = this.msg.getJmsType();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "type: " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJMSType");
        }
        return string;
    }

    public void setJMSType(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setJMSType");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "type: " + string);
        }
        this.msg.setJmsType(string);
        this.cachedToString = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setJMSType");
        }
    }

    public long getJMSExpiration() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJMSExpiration");
        }
        Long l = this.msg.getJmsExpiration();
        long l2 = 0L;
        if (l == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Property was not set");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getJMSExpiration");
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "PROPERTY_NOT_SET_CWSIA0101", new Object[]{"JMSExpiration"}, tc);
        }
        l2 = l;
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "expiration: " + l2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJMSExpiration");
        }
        return l2;
    }

    public void setJMSExpiration(long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setJMSExpiration");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "expiration: " + l);
        }
        this.msg.setJmsExpiration(l);
        this.cachedToString = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setJMSExpiration");
        }
    }

    public int getJMSPriority() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJMSPriority");
        }
        Integer n = this.msg.getPriority();
        int n2 = 0;
        if (n != null) {
            n2 = n;
            if (n2 == -1) {
                n2 = 4;
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Property was not set");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getJMSPriority");
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "PROPERTY_NOT_SET_CWSIA0101", new Object[]{"JMSPriority"}, tc);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "priority: " + n2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJMSPriority");
        }
        return n2;
    }

    public void setJMSPriority(int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setJMSPriority");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "newPriority: " + n);
        }
        try {
            this.msg.setPriority(n);
            this.cachedToString = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setJMSPriority");
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0116", new Object[]{"JMSPriority", "" + n}, illegalArgumentException, null, this, tc);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setJMSPriority");
        }
    }

    public void clearProperties() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "clearProperties");
        }
        this.msg.clearProperties();
        this.propertiesReadOnly = false;
        this.cachedToString = null;
        if (this.locallyStoredPropertyValues != null) {
            this.locallyStoredPropertyValues.clear();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "clearProperties");
        }
    }

    public boolean propertyExists(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "propertyExists");
        }
        boolean bl = this.msg.propertyExists(string);
        if (this.locallyStoredPropertyValues != null) {
            boolean bl2 = bl = bl || this.locallyStoredPropertyValues.containsKey(string);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "exists: " + bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "propertyExists");
        }
        return bl;
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBooleanProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.getObjByName(string);
        boolean bl = false;
        try {
            bl = JmsMessageImpl.parseBoolean(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getBooleanProperty");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBooleanProperty");
        }
        return bl;
    }

    public byte getByteProperty(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getByteProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.getObjByName(string);
        byte by = 0;
        try {
            by = JmsMessageImpl.parseByte(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getByteProperty");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getByteProperty");
        }
        return by;
    }

    public short getShortProperty(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getShortProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.getObjByName(string);
        short s = 0;
        try {
            s = JmsMessageImpl.parseShort(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getShortProperty");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getShortProperty");
        }
        return s;
    }

    public int getIntProperty(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getIntProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.getObjByName(string);
        int n = 0;
        try {
            n = JmsMessageImpl.parseInt(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getIntProperty");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getIntProperty");
        }
        return n;
    }

    public long getLongProperty(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getLongProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.getObjByName(string);
        long l = 0L;
        try {
            l = JmsMessageImpl.parseLong(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getLongProperty");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getLongProperty");
        }
        return l;
    }

    public float getFloatProperty(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getFloatProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.getObjByName(string);
        float f = 0.0f;
        try {
            f = JmsMessageImpl.parseFloat(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getFloatProperty");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getFloatProperty");
        }
        return f;
    }

    public double getDoubleProperty(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getDoubleProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.getObjByName(string);
        double d = 0.0;
        try {
            d = JmsMessageImpl.parseDouble(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getDoubleProperty");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDoubleProperty");
        }
        return d;
    }

    public String getStringProperty(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getStringProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.getObjByName(string);
        String string2 = null;
        string2 = object instanceof String || object == null ? (String)object : object.toString();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "value: " + string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getStringProperty");
        }
        return string2;
    }

    public Object getObjectProperty(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getObjectProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.getObjByName(string);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "obj: " + object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getObjectProperty");
        }
        return object;
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getPropertyNames");
        }
        Set set = this.msg.getPropertyNameSet();
        if (this.locallyStoredPropertyValues != null) {
            set.addAll(this.locallyStoredPropertyValues.keySet());
        }
        final Iterator iterator = set.iterator();
        Enumeration enumeration = new Enumeration(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getPropertyNames");
        }
        return enumeration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setBooleanProperty(name, val)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "val=" + bl);
        }
        try {
            this.checkPropertiesWriteable("setBooleanProperty");
            this.checkPropName(string, "setBooleanProperty");
            this.checkSettablePropertyName(string, Boolean.class);
            this.msg.setNonNullProperty(string, new Boolean(bl));
            this.cachedToString = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setBooleanProperty(name, val)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setBooleanProperty(name, val)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByteProperty(String string, byte by) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setByteProperty(name, val)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "val=" + by);
        }
        try {
            this.checkPropertiesWriteable("setByteProperty");
            this.checkPropName(string, "setByteProperty");
            this.checkSettablePropertyName(string, Byte.class);
            this.msg.setNonNullProperty(string, new Byte(by));
            this.cachedToString = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setByteProperty(name, val)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setByteProperty(name, val)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShortProperty(String string, short s) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setShortProperty(name, val)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "val=" + s);
        }
        try {
            this.checkPropertiesWriteable("setShortProperty");
            this.checkPropName(string, "setShortProperty");
            this.checkSettablePropertyName(string, Short.class);
            this.msg.setNonNullProperty(string, new Short(s));
            this.cachedToString = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setShortProperty(name, val)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setShortProperty(name, val)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setIntProperty(String string, int n) throws JMSException {
        block12: {
            block11: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry(tc, "setIntProperty(name, val)");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "name=" + string);
                    SibTr.debug(tc, "val=" + n);
                }
                try {
                    this.checkPropertiesWriteable("setIntProperty");
                    this.checkPropName(string, "setIntProperty");
                    if (string.equals("JMS_IBM_Character_Set")) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "special case for charset, setting as string");
                        }
                        this.setStringProperty(string, String.valueOf(n));
                        Object var4_3 = null;
                        break block11;
                    }
                    this.checkSettablePropertyName(string, Integer.class);
                    if (localStorePropertyNames.contains(string)) {
                        if (this.locallyStoredPropertyValues == null) {
                            this.locallyStoredPropertyValues = new Hashtable();
                        }
                        this.locallyStoredPropertyValues.put(string, new Integer(n));
                    } else if (string.startsWith("JMS_IBM_Report") || string.equals("JMS_IBM_Feedback")) {
                        ReportMessageConverter.setIntegerReportOption(string, n, this.msg);
                    } else {
                        this.msg.setNonNullProperty(string, new Integer(n));
                    }
                    this.cachedToString = null;
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (!tc.isEntryEnabled()) throw throwable;
                    SibTr.exit(tc, "setIntProperty(name, val)");
                    throw throwable;
                }
            }
            if (!tc.isEntryEnabled()) return;
            SibTr.exit(tc, "setIntProperty(name, val)");
            return;
        }
        Object var4_4 = null;
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "setIntProperty(name, val)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLongProperty(String string, long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setLongProperty(name, val)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "val=" + l);
        }
        try {
            this.checkPropertiesWriteable("setLongProperty");
            this.checkPropName(string, "setLongProperty");
            this.checkSettablePropertyName(string, Long.class);
            if (localStorePropertyNames.contains(string)) {
                if (this.locallyStoredPropertyValues == null) {
                    this.locallyStoredPropertyValues = new Hashtable();
                }
                this.locallyStoredPropertyValues.put(string, new Long(l));
            } else {
                this.msg.setNonNullProperty(string, new Long(l));
            }
            this.cachedToString = null;
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setLongProperty(name, val)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setLongProperty(name, val)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloatProperty(String string, float f) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setFloatProperty(name, val)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "val=" + f);
        }
        try {
            this.checkPropertiesWriteable("setFloatProperty");
            this.checkPropName(string, "setFloatProperty");
            this.checkSettablePropertyName(string, Float.class);
            this.msg.setNonNullProperty(string, new Float(f));
            this.cachedToString = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setFloatProperty(name, val)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setFloatProperty(name, val)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDoubleProperty(String string, double d) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setDoubleProperty(name, val)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "val=" + d);
        }
        try {
            this.checkPropertiesWriteable("setDoubleProperty");
            this.checkPropName(string, "setDoubleProperty");
            this.checkSettablePropertyName(string, Double.class);
            this.msg.setNonNullProperty(string, new Double(d));
            this.cachedToString = null;
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setDoubleProperty(name, val)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setDoubleProperty(name, val)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringProperty(String string, String string2) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setStringProperty(name, val)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "val=" + string2);
        }
        try {
            this.checkPropertiesWriteable("setStringProperty");
            this.checkPropName(string, "setStringProperty");
            this.checkSettablePropertyName(string, String.class);
            if ("JMSXAppID".equals(string)) {
                this.msg.setJmsxAppId(string2);
            } else if ("JMSXUserID".equals(string)) {
                this.msg.setApiUserId(string2);
            } else if (localStorePropertyNames.contains(string)) {
                if (this.locallyStoredPropertyValues == null) {
                    this.locallyStoredPropertyValues = new Hashtable();
                }
                this.locallyStoredPropertyValues.put(string, string2);
            } else {
                this.msg.setObjectProperty(string, string2);
            }
            this.cachedToString = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setStringProperty(name, val)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setStringProperty(name, val)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectProperty(String string, Object object) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setObjectProperty(name, obj)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "obj=" + object);
        }
        try {
            Class clazz;
            this.checkPropertiesWriteable("setObjectProperty");
            this.checkPropName(string, "setObjectProperty");
            Class clazz2 = clazz = Object.class;
            if (object != null) {
                clazz = object.getClass();
            }
            this.checkSettablePropertyName(string, clazz);
            if (!(object instanceof Boolean || object instanceof Number || object instanceof String)) {
                String string2 = null;
                if (object != null) {
                    string2 = object.getClass().getName();
                }
                throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_OBJECT_TYPE_CWSIA0102", new Object[]{string2, string}, tc);
            }
            this.setObjByName(string, object);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setObjectProperty(name, obj)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setObjectProperty(name, obj)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge() throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "acknowledge()");
            }
            if (this.theSession == null) {
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "INVALID_FOR_UNCONSUMED_MSG_CWSIA0110", new Object[]{"acknowledge"}, tc);
            }
            this.theSession.checkNotClosed();
            this.theSession.checkSynchronousUsage("acknowledge");
            int n = this.theSession.getAcknowledgeMode();
            if (n == 2 || n == 3) {
                Object object = this.sessionSyncLock;
                synchronized (object) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "got lock");
                    }
                    this.theSession.commitTransaction();
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "acknowledge()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "acknowledge()");
        }
    }

    public void clearBody() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "clearBody");
        }
        this.msg.clearBody();
        this.bodyReadOnly = false;
        this.cachedToString = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "clearBody");
        }
    }

    public String toString() {
        if (this.cachedToString == null) {
            try {
                this.cachedToString = "TO_STRING_IN_PROGRESS";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\n  JMSMessage class: " + this.messageClass);
                stringBuffer.append("\n  JMSType:          " + this.getJMSType());
                stringBuffer.append("\n  JMSDeliveryMode:  " + this.getJMSDeliveryMode());
                stringBuffer.append("\n  JMSExpiration:    " + this.getJMSExpiration());
                stringBuffer.append("\n  JMSPriority:      " + this.getJMSPriority());
                stringBuffer.append("\n  JMSMessageID:     " + this.getJMSMessageID());
                stringBuffer.append("\n  JMSTimestamp:     " + this.getJMSTimestamp());
                stringBuffer.append("\n  JMSCorrelationID: " + this.getJMSCorrelationID());
                stringBuffer.append("\n  JMSDestination:   ");
                try {
                    stringBuffer.append(this.getJMSDestination());
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        SibTr.exception(tc, exception);
                    }
                    stringBuffer.append("<ERROR>");
                }
                stringBuffer.append("\n  JMSReplyTo:       ");
                try {
                    stringBuffer.append(this.getJMSReplyTo());
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        SibTr.exception(tc, exception);
                    }
                    stringBuffer.append("<ERROR>");
                }
                stringBuffer.append("\n  JMSRedelivered:   " + this.getJMSRedelivered());
                Enumeration enumeration = this.getPropertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    stringBuffer.append("\n    " + string + ": " + this.getObjectProperty(string));
                }
                this.cachedToString = stringBuffer.toString();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return this.cachedToString;
    }

    protected JsJmsMessage instantiateMessage() throws Exception {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "instantiateMessage");
        }
        JsJmsMessage jsJmsMessage = null;
        try {
            jsJmsMessage = jmfact.createJmsMessage();
            this.messageClass = "jms_none";
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "instantiateMessage");
            }
            throw messageCreateFailedException;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "instantiateMessage");
        }
        return jsJmsMessage;
    }

    protected JsJmsMessage getMsgReference() throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getMsgReference");
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getMsgReference");
        }
        return this.msg;
    }

    protected void setMsgReference(JsJmsMessage jsJmsMessage) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "setMsgReference");
        }
        this.msg = jsJmsMessage;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "setMsgReference");
        }
    }

    protected void setDestReference(Destination destination) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "setDestReference");
        }
        this.dest = destination;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "setDestReference");
        }
    }

    protected void checkBodyWriteable(String string) throws JMSException {
        if (this.bodyReadOnly) {
            throw (MessageNotWriteableException)JmsErrorUtils.newThrowable(MessageNotWriteableException.class, "READ_ONLY_MESSAGE_BODY_CWSIA0107", new Object[]{string}, tc);
        }
    }

    protected void checkBodyReadable(String string) throws MessageNotReadableException {
        if (!this.bodyReadOnly) {
            throw (MessageNotReadableException)JmsErrorUtils.newThrowable(MessageNotReadableException.class, "WRITE_ONLY_MESSAGE_BODY_CWSIA0109", new Object[]{string}, tc);
        }
    }

    protected void checkPropertiesWriteable(String string) throws JMSException {
        if (this.propertiesReadOnly) {
            throw (MessageNotWriteableException)JmsErrorUtils.newThrowable(MessageNotWriteableException.class, "READ_ONLY_MESSAGE_PROPERTY_CWSIA0108", new Object[]{string}, tc);
        }
    }

    public Reliability getReliability() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getReliablity");
        }
        Reliability reliability = this.msg.getReliability();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "reliability : " + reliability);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getReliablity");
        }
        return reliability;
    }

    public Reliability getReplyReliability() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getReplyReliability");
        }
        Reliability reliability = this.msg.getReplyReliability();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "reliability : " + reliability);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getReplyReliability");
        }
        return reliability;
    }

    static Message inboundJmsInstance(JsJmsMessage jsJmsMessage, JmsSessionImpl jmsSessionImpl) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "inboundJmsInstance");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "inbound: " + jsJmsMessage);
        }
        JmsMessageImpl jmsMessageImpl = null;
        JmsBodyType jmsBodyType = jsJmsMessage.getBodyType();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "body type: " + jmsBodyType);
        }
        int n = -2;
        if (jmsBodyType != null) {
            n = jmsBodyType.toInt();
        }
        switch (n) {
            case 0: {
                jmsMessageImpl = new JmsMessageImpl(jsJmsMessage, jmsSessionImpl);
                break;
            }
            case 5: {
                jmsMessageImpl = new JmsTextMessageImpl((JsJmsTextMessage)jsJmsMessage, jmsSessionImpl);
                break;
            }
            case 2: {
                jmsMessageImpl = new JmsMapMessageImpl((JsJmsMapMessage)jsJmsMessage, jmsSessionImpl);
                break;
            }
            case 3: {
                jmsMessageImpl = new JmsObjectMessageImpl((JsJmsObjectMessage)jsJmsMessage, jmsSessionImpl);
                break;
            }
            case 1: {
                jmsMessageImpl = new JmsBytesMessageImpl((JsJmsBytesMessage)jsJmsMessage, jmsSessionImpl);
                break;
            }
            case 4: {
                jmsMessageImpl = new JmsStreamMessageImpl((JsJmsStreamMessage)jsJmsMessage, jmsSessionImpl);
                break;
            }
            default: {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "UNKNOWN MESSAGE TYPE FOUND: " + jmsBodyType);
                }
                jmsMessageImpl = new JmsMessageImpl(jsJmsMessage, jmsSessionImpl);
            }
        }
        jmsMessageImpl.bodyReadOnly = true;
        jmsMessageImpl.propertiesReadOnly = true;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "inboundJmsInstance");
        }
        return jmsMessageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JmsMessageImpl messageToJmsMessageImpl(Message message) throws JMSException {
        JmsMessageImpl jmsMessageImpl;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "messageToJmsMessage(Message)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "message : " + message);
        }
        try {
            JmsMessageImpl jmsMessageImpl2 = null;
            if (message instanceof BytesMessage) {
                jmsMessageImpl2 = new JmsBytesMessageImpl((BytesMessage)message);
            } else if (message instanceof MapMessage) {
                jmsMessageImpl2 = new JmsMapMessageImpl((MapMessage)message);
            } else if (message instanceof ObjectMessage) {
                jmsMessageImpl2 = new JmsObjectMessageImpl((ObjectMessage)message);
            } else if (message instanceof StreamMessage) {
                jmsMessageImpl2 = new JmsStreamMessageImpl((StreamMessage)message);
            } else if (message instanceof TextMessage) {
                jmsMessageImpl2 = new JmsTextMessageImpl((TextMessage)message);
            } else if (message instanceof Message) {
                jmsMessageImpl2 = new JmsMessageImpl(message);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tcInt, "returns : " + jmsMessageImpl2);
            }
            jmsMessageImpl = jmsMessageImpl2;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block17: {
                Object var4_4 = null;
                if (!tcInt.isEntryEnabled()) break block17;
                SibTr.exit(tcInt, "messageToJmsMessage(Message)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "messageToJmsMessage(Message)");
        }
        return jmsMessageImpl;
    }

    static String getBadConvertMessage(Object object, String string, String string2) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getBadConvertMessage");
        }
        String string3 = null;
        if (!(object instanceof byte[])) {
            string3 = object.getClass().getName();
            int n = 0;
            n = string3.lastIndexOf(46);
            if (n != 0) {
                string3 = string3.substring(n + 1);
            }
        } else {
            string3 = "Byte[]";
        }
        String string4 = nls.getFormattedMessage("INVALID_TYPE_CONVERSION_CWSIA0104", new Object[]{string, string3, string2}, null);
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getBadConvertMessage");
        }
        return string4;
    }

    static MessageFormatException newBadConvertException(Object object, String string, String string2, TraceComponent traceComponent) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getBadConvertException");
        }
        String string3 = null;
        if (!(object instanceof byte[])) {
            string3 = object.getClass().getName();
            int n = 0;
            n = string3.lastIndexOf(46);
            if (n != 0) {
                string3 = string3.substring(n + 1);
            }
        } else {
            string3 = "Byte[]";
        }
        MessageFormatException messageFormatException = (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_TYPE_CONVERSION_CWSIA0104", new Object[]{string, string3, string2}, traceComponent);
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getBadConvertException");
        }
        return messageFormatException;
    }

    protected static boolean parseBoolean(Object object, String string) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "parseBoolean");
        }
        boolean bl = false;
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else if (object instanceof String) {
            bl = Boolean.valueOf((String)object);
        } else if (object == null) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "value null, generating rte");
            }
            bl = Boolean.valueOf(null);
        } else {
            MessageFormatException messageFormatException = JmsMessageImpl.newBadConvertException(object, string, "Boolean", tcInt);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "Invalid convert", messageFormatException);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "parseBoolean");
            }
            throw messageFormatException;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "value: " + bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseBoolean");
        }
        return bl;
    }

    protected static byte parseByte(Object object, String string) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "parseByte");
        }
        byte by = 0;
        if (object instanceof Byte) {
            by = (Byte)object;
        } else if (object instanceof String) {
            try {
                by = Byte.parseByte((String)object);
            }
            catch (RuntimeException runtimeException) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Error parsing byte: " + object, runtimeException);
                }
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "parseByte");
                }
                throw runtimeException;
            }
        } else if (object == null) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "retrieved object is null");
            }
            try {
                by = Byte.valueOf(null);
            }
            catch (RuntimeException runtimeException) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Generating exception for null->byte conversion");
                }
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "parseByte");
                }
                throw runtimeException;
            }
        } else {
            MessageFormatException messageFormatException = JmsMessageImpl.newBadConvertException(object, string, "Byte", tcInt);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "invalid convert", messageFormatException);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "parseByte");
            }
            throw messageFormatException;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "value: " + by);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseByte");
        }
        return by;
    }

    protected static double parseDouble(Object object, String string) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "parseDouble");
        }
        double d = 0.0;
        if (object instanceof Double) {
            d = (Double)object;
        } else if (object instanceof String) {
            try {
                d = Double.parseDouble((String)object);
            }
            catch (RuntimeException runtimeException) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Error parsing double: " + object, runtimeException);
                }
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "parseDouble");
                }
                throw runtimeException;
            }
        } else if (object instanceof Float) {
            d = ((Float)object).doubleValue();
        } else if (object == null) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "retrieved object is null, generating rte");
            }
            try {
                d = Double.valueOf(null);
            }
            catch (RuntimeException runtimeException) {
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "parseDouble");
                }
                throw runtimeException;
            }
        } else {
            MessageFormatException messageFormatException = JmsMessageImpl.newBadConvertException(object, string, "Double", tcInt);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "invalid convert", messageFormatException);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "parseDouble");
            }
            throw messageFormatException;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "value: " + d);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseDouble");
        }
        return d;
    }

    protected static float parseFloat(Object object, String string) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "parseFloat");
        }
        float f = 0.0f;
        if (object instanceof Float) {
            f = ((Float)object).floatValue();
        } else if (object instanceof String) {
            try {
                f = Float.parseFloat((String)object);
            }
            catch (RuntimeException runtimeException) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Error parsing float: " + object, runtimeException);
                }
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "parseFloat");
                }
                throw runtimeException;
            }
        } else if (object == null) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "retrieved object is null, generatin rte");
            }
            try {
                f = Float.valueOf(null).floatValue();
            }
            catch (RuntimeException runtimeException) {
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "parseFloat");
                }
                throw runtimeException;
            }
        } else {
            MessageFormatException messageFormatException = JmsMessageImpl.newBadConvertException(object, string, "Float", tcInt);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "invalid convert", messageFormatException);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "parseFloat");
            }
            throw messageFormatException;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "value: " + f);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "parseFloat");
        }
        return f;
    }

    protected static int parseInt(Object object, String string) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "parseInt");
        }
        int n = 0;
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof String) {
            try {
                n = Integer.parseInt((String)object);
            }
            catch (RuntimeException runtimeException) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Error parsing int: " + object, runtimeException);
                }
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "parseInt");
                }
                throw runtimeException;
            }
        } else if (object instanceof Byte) {
            n = ((Byte)object).intValue();
        } else if (object instanceof Short) {
            n = ((Short)object).intValue();
        } else if (object == null) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "retrieved object is null, generating rte");
            }
            try {
                n = Integer.valueOf(null);
            }
            catch (RuntimeException runtimeException) {
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "parseInt");
                }
                throw runtimeException;
            }
        } else {
            MessageFormatException messageFormatException = JmsMessageImpl.newBadConvertException(object, string, "Integer", tcInt);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "invalid convert", messageFormatException);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "parseInt");
            }
            throw messageFormatException;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "value: " + n);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "parseInt");
        }
        return n;
    }

    protected static long parseLong(Object object, String string) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "parseLong");
        }
        long l = 0L;
        if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof String) {
            try {
                l = Long.parseLong((String)object);
            }
            catch (RuntimeException runtimeException) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Error parsing long: " + object, runtimeException);
                }
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "parseLong");
                }
                throw runtimeException;
            }
        } else if (object instanceof Byte) {
            l = ((Byte)object).longValue();
        } else if (object instanceof Short) {
            l = ((Short)object).longValue();
        } else if (object instanceof Integer) {
            l = ((Integer)object).longValue();
        } else if (object == null) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "retrieved object is null, generating rte");
            }
            try {
                l = Long.valueOf(null);
            }
            catch (RuntimeException runtimeException) {
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "parseLong");
                }
                throw runtimeException;
            }
        } else {
            MessageFormatException messageFormatException = JmsMessageImpl.newBadConvertException(object, string, "Long", tcInt);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "invalid convert", messageFormatException);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "parseLong");
            }
            throw messageFormatException;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "value: " + l);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "parseLong");
        }
        return l;
    }

    protected static short parseShort(Object object, String string) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "parseShort");
        }
        short s = 0;
        if (object instanceof Short) {
            s = (Short)object;
        } else if (object instanceof String) {
            try {
                s = Short.parseShort((String)object);
            }
            catch (RuntimeException runtimeException) {
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "Error parsing short: " + object, runtimeException);
                }
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "parseShort");
                }
                throw runtimeException;
            }
        } else if (object instanceof Byte) {
            s = ((Byte)object).shortValue();
        } else if (object == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "retrieved object is null, generating rte");
            }
            try {
                s = Short.valueOf(null);
            }
            catch (RuntimeException runtimeException) {
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "parseShort");
                }
                throw runtimeException;
            }
        } else {
            MessageFormatException messageFormatException = JmsMessageImpl.newBadConvertException(object, string, "Short", tcInt);
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "invalid convert", messageFormatException);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "parseShort");
            }
            throw messageFormatException;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "value: " + s);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "parseShort");
        }
        return s;
    }

    protected boolean isBodyReadOnly() {
        return this.bodyReadOnly;
    }

    protected void setBodyReadOnly() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "setBodyReadOnly");
        }
        if (tcInt.isDebugEnabled() && !this.bodyReadOnly) {
            SibTr.debug(tcInt, "setBodyReadOnly changing bodyReadOnly");
        }
        this.bodyReadOnly = true;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "setBodyReadOnly");
        }
    }

    protected void checkPropName(String string, String string2) throws IllegalArgumentException {
        if (string == null || "".equals(string)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Invalid field name: " + string + " as parameter to " + string2);
            }
            throw (IllegalArgumentException)JmsErrorUtils.newThrowable(IllegalArgumentException.class, "INVALID_FIELD_NAME_CWSIA0106", null, tcInt);
        }
    }

    private Object getObjByName(String string) {
        Object object = null;
        if (string == null) {
            throw (IllegalArgumentException)JmsErrorUtils.newThrowable(IllegalArgumentException.class, "INVALID_PROPNAME_CWSIA0112", new Object[]{string}, tcInt);
        }
        if ("".equals(string)) {
            throw (IllegalArgumentException)JmsErrorUtils.newThrowable(IllegalArgumentException.class, "INVALID_PROPNAME_CWSIA0112", new Object[]{"\"\""}, tcInt);
        }
        if (this.locallyStoredPropertyValues != null && this.locallyStoredPropertyValues.containsKey(string)) {
            object = this.locallyStoredPropertyValues.get(string);
        } else if (string.startsWith("JMSX")) {
            int n;
            object = "JMSXDeliveryCount".equals(string) ? ((n = this.msg.getJmsxDeliveryCount()) == 0 ? null : new Integer(n)) : ("JMSXAppID".equals(string) ? this.msg.getJmsxAppId() : ("JMSXUserID".equals(string) ? this.msg.getApiUserId() : this.msg.getObjectProperty(string)));
        } else if (string.startsWith("JMS_IBM")) {
            if (string.startsWith("JMS_IBM_Report") || string.startsWith("JMS_IBM_Feedback")) {
                object = ReportMessageConverter.getReportOption(string, this.msg);
            } else if (string.equals("JMS_IBM_ExceptionReason")) {
                object = this.msg.getExceptionReason();
            } else if (string.equals("JMS_IBM_ExceptionTimestamp")) {
                object = this.msg.getExceptionTimestamp();
            } else if (string.equals("JMS_IBM_ExceptionMessage")) {
                object = this.msg.getExceptionMessage();
            } else if (string.equals("JMS_IBM_ExceptionProblemDestination")) {
                object = this.msg.getExceptionProblemDestination();
            } else if (string.equals("JMS_IBM_System_MessageID")) {
                object = this.msg.getSystemMessageId();
            } else if (string.equals("JMS_IBM_MsgType")) {
                object = ReportMessageConverter.getReportOption(string, this.msg);
                if (object == null) {
                    object = this.msg.getObjectProperty(string);
                }
            } else {
                object = this.msg.getObjectProperty(string);
            }
        } else {
            object = this.msg.getObjectProperty(string);
        }
        return object;
    }

    private void checkSettablePropertyName(String string, Class clazz) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "checkSettablePropertyName");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "params: " + string);
        }
        if (string == null || !Character.isJavaIdentifierStart(string.charAt(0))) {
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "checkSettablePropertyName");
            }
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_PROPNAME_CWSIA0112", new Object[]{string}, tcInt);
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "checkSettablePropertyName");
            }
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_PROPNAME_CWSIA0112", new Object[]{string}, tcInt);
        }
        if (string.startsWith("JMS")) {
            if (JMS_IBM_props.containsKey(string)) {
                Class clazz2 = (Class)JMS_IBM_props.get(string);
                if (clazz2 != clazz) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "JMS_IBM_INVALID_TYPE_CWSIA0114", new Object[]{string, clazz2.getName(), clazz.getName()}, tc);
                }
            } else if (string.startsWith("JMSX")) {
                if (!string.equals("JMSXGroupID") && !string.equals("JMSXGroupSeq")) {
                    ConnectionMetaData connectionMetaData = JmsFactoryFactory.getInstance().getMetaData();
                    Enumeration enumeration = connectionMetaData.getJMSXPropertyNames();
                    boolean bl = false;
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        if (!string2.equals(string)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        if (tcInt.isEntryEnabled()) {
                            SibTr.exit(tcInt, "checkSettablePropertyName");
                        }
                        throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "RESERVED_PROPNAME_CWSIA0113", new Object[]{string}, tcInt);
                    }
                }
            } else {
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit(tcInt, "checkSettablePropertyName");
                }
                throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "RESERVED_PROPNAME_CWSIA0113", new Object[]{string}, tcInt);
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "checkSettablePropertyName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReplyHeader(JmsDestinationImpl jmsDestinationImpl) throws JMSException {
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "setReplyHeader");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "replyTo: " + jmsDestinationImpl);
            }
            if (jmsDestinationImpl != null) {
                this.msg.setReplyDiscriminator(jmsDestinationImpl.getDestDiscrim());
                ArrayList<SIDestinationAddress> arrayList = new ArrayList<SIDestinationAddress>(1);
                arrayList.add(jmsDestinationImpl.getConsumerSIDestinationAddress());
                this.msg.uncheckedSetReverseRoutingPath(arrayList);
                Integer n = jmsDestinationImpl.getPriority();
                this.msg.uncheckedSetReplyPriority(n);
                Long l = jmsDestinationImpl.getTimeToLive();
                this.msg.uncheckedSetReplyTimeToLive(l);
            } else {
                this.msg.clearReplyFields();
                this.msg.uncheckedSetReverseRoutingPath(null);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "setReplyHeader");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "setReplyHeader");
        }
    }

    void updateReplyReliability(Reliability reliability, Reliability reliability2) {
        if (this.replyTo != null && this.replyTo instanceof JmsDestinationImpl) {
            String string = ((JmsDestinationImpl)this.replyTo).getDeliveryMode();
            if ("Persistent".equals(string)) {
                this.msg.uncheckedSetReplyReliability(reliability2);
            } else if ("NonPersistent".equals(string)) {
                this.msg.uncheckedSetReplyReliability(reliability);
            } else if ("Application".equals(string)) {
                this.msg.uncheckedSetReplyReliability(Reliability.NONE);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populateReplyToFromHeader(JmsDestinationImpl jmsDestinationImpl) throws JMSException {
        try {
            block7: {
                Long l;
                Integer n;
                if (tcInt.isEntryEnabled()) {
                    SibTr.entry(tcInt, "populateReplyToFromHeader");
                }
                List list = this.msg.getReverseRoutingPath();
                jmsDestinationImpl.configureDestinationFromRoutingPath(list);
                String string = this.msg.getReplyDiscriminator();
                if (string != null) {
                    jmsDestinationImpl.setDestDiscrim(string);
                }
                if ((n = this.msg.getReplyPriority()) != null) {
                    jmsDestinationImpl.setPriority(n);
                }
                if ((l = this.msg.getReplyTimeToLive()) == null) break block7;
                jmsDestinationImpl.setTimeToLive(l);
            }
            Object var7_7 = null;
            if (!tcInt.isEntryEnabled()) return;
            SibTr.exit(tcInt, "populateReplyToFromHeader");
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!tcInt.isEntryEnabled()) throw throwable;
            SibTr.exit(tcInt, "populateReplyToFromHeader");
            throw throwable;
        }
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    private void setObjByName(String string, Object object) {
        if (localStorePropertyNames.contains(string)) {
            if (this.locallyStoredPropertyValues == null) {
                this.locallyStoredPropertyValues = new Hashtable();
            }
            this.locallyStoredPropertyValues.put(string, object);
        } else {
            this.msg.setObjectProperty(string, object);
        }
        this.cachedToString = null;
    }

    void clearLocalProperties() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "clearLocalProperties");
        }
        if (this.locallyStoredPropertyValues != null) {
            this.locallyStoredPropertyValues.clear();
        }
        this.localJMSMessageID = null;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "clearLocalProperties");
        }
    }

    void invalidateToStringCache() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "invalidateToStringCache");
        }
        this.cachedToString = null;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "invalidateToStringCache");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsMessageImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.149.1.1");
        }
        JMS_IBM_props = new Hashtable(21);
        JMS_IBM_props.put("JMS_IBM_Format", String.class);
        JMS_IBM_props.put("JMS_IBM_MsgType", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Feedback", Integer.class);
        JMS_IBM_props.put("JMS_IBM_PutApplType", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Exception", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Expiration", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_COA", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_COD", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_PAN", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_NAN", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Pass_Msg_ID", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Pass_Correl_ID", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Discard_Msg", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Encoding", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Character_Set", String.class);
        JMS_IBM_props.put("JMS_IBM_Last_Msg_In_Group", Boolean.class);
        JMS_IBM_props.put("JMS_IBM_PutDate", String.class);
        JMS_IBM_props.put("JMS_IBM_PutTime", String.class);
        JMS_IBM_props.put("JMS_IBM_ExceptionReason", Integer.class);
        JMS_IBM_props.put("JMS_IBM_ExceptionTimestamp", Long.class);
        JMS_IBM_props.put("JMS_IBM_ExceptionMessage", String.class);
        JMS_IBM_props.put("JMS_IBM_ExceptionProblemDestination", String.class);
        JMS_IBM_props.put("JMS_IBM_System_MessageID", String.class);
        localStorePropertyNames = new HashSet();
        localStorePropertyNames.add("JMS_IBM_ExceptionReason");
        localStorePropertyNames.add("JMS_IBM_ExceptionTimestamp");
        localStorePropertyNames.add("JMS_IBM_ExceptionMessage");
        localStorePropertyNames.add("JMSXDeliveryCount");
        localStorePropertyNames.add("JMS_IBM_System_MessageID");
        localStorePropertyNames.add("JMS_IBM_ExceptionProblemDestination");
        try {
            JmsMessageImpl.obtainMFPFactory();
        }
        catch (JMSException jMSException) {
            throw new RuntimeException(jMSException);
        }
    }
}

